/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:hal_voicebuffer.c
 * File Mark:
 * Description: voice buffer function.
 * Others:
 * Version:
 * Author:        xxq
 * Date:          2024-07-03
 * History 1:
 *     Date: 
 *     Version:
 *     Author:
 *     Modification: edit for union version
 * History 2:
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include "drvs_general.h"
#include "drvs_volte.h"
#include "drvs_i2s.h"
#include "drvs_voiceprocess.h"
#include "hal_voiceprocess.h"
#include "drvs_voice_config.h"
//#include "hal_pcmmixer.h"
#include "NvParam_drv.h"
#include "drvs_io_voice.h"
#include "hal_ringdata.h"
#include "drvs_tdm.h"
#include "hal_dtmf_detect.h"
#include "hal_audio_data.h"
//#define TEST_WHITE_NOISE

//#define  VB_DATA_LOSS_TEST
#ifdef TEST_WHITE_NOISE
#include "Fs8000_WhiteNoise_Mon.h"
//#include "Fs8000_Sine_440Hz_Mon.h"
#endif

#include "drvs_icp.h"
#include "drvs_rpmsg.h"
//#include <linux/completion.h>
#include "hal_voicebuffer.h"

/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
//#define USE_AUDIO_RING
//#define VP_GET_TX_ALL_DATA


/****************************************************************************
* 	                                           Local Types
****************************************************************************/


/****************************************************************************
* 	                                           Local Constants
****************************************************************************/
static SINT32 vp_Get_Add_RpMsg_Vbuffer(VOID);

/****************************************************************************
* 	                                           Local Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Global Constants
****************************************************************************/


/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
//static T_zDrvVp_SpeechState *s_pSpeechState = NULL;
extern T_zDrvVp_SpeechState s_speechState;  //104 bytes
extern T_zDrvVoice_GbVar g_voiceVar;
extern T_zDrvVp_State s_vpState;


#ifdef ECALL_SUPPORT
extern int eWrErr;
extern UINT8 e_reg_flag;

#endif

//for test whiteNoise
#ifdef TEST_WHITE_NOISE
extern UINT32 tempCount;
extern UINT8 *pVoiceTempBuf;
#endif


extern T_ZDrv_VpInOutBuffer vpInOutBuffer;

extern T_HalMixerToneInfo mixerToneInfo;

static int vbuffer_init_flag = 0;

/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/
//aduvoice config code






extern SINT32 voice_ToneMixerData(UINT8 *pvdata, UINT32 size, UINT8 *pmixdata);//xiu gai chu sheng ming
extern SINT32 zDrvI2S_Read_Start(T_ZDrvI2S_Id tId, T_ZDrvI2s_Params *params, T_ZDrvI2S_Cfg *ptCfg);//xiu gai chu sheng ming
extern SINT32 zDrvI2S_Write_Start(T_ZDrvI2S_Id tId, T_ZDrvI2s_Params *params, T_ZDrvI2S_Cfg *ptCfg);//xiu gai chu sheng ming



/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/
ZOSS_TIMER_ID s_voiceTimerId ;
ZOSS_SEMAPHORE_ID s_voiceRdSema;
ZOSS_SEMAPHORE_ID s_voiceWrSema;

//#ifdef CONFIG_VOICE_BUFFER_DRV  
//#ifdef _VBUFF_IN_MULTI_CORE
//voice buffer use in multi core 
//#define RPMSG_CAP_ID 1



int timer_cb_count = 0;
int first_full_flag = 0;
int first_empty_flag = 0;

int vb_read_count = 0;
int vb_write_count = 0;



struct voice_ring_buffer *voice_buff[2] = {NULL,NULL};



static bool voice_buff_is_full(int read_pos, int write_pos)
{


	if ((write_pos - read_pos) >= 20000000) {
		write_pos = write_pos - 20000000;
		//voice_buff[UP_LINK]->write_pos = write_pos;
		voice_buff[DOWN_LINK]->write_pos = write_pos;
	}
	return ((write_pos - read_pos) == MAX_BUF_NUM);
}
static bool voice_buff_is_empty(int read_pos, int write_pos)
{
	
	return (write_pos == read_pos);
}
static int voice_buffer_write( char *buf, int count)
{
	int read_pos, write_pos;	


	read_pos = voice_buff[DOWN_LINK]->read_pos;
	write_pos = voice_buff[DOWN_LINK]->write_pos;	
	if(vb_write_count == 0){
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"%s: first read_pos=%d write_pos=%d \n",__FUNCTION__,read_pos,write_pos);
	}

	
	if(voice_buff_is_full(read_pos, write_pos)){
		//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_buffer_read readbuffer is full \n");
   		 first_full_flag++;
		VB_INT_OVERFLOW(first_full_flag);
		if(first_full_flag == 1)
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s: writebuffer is full  read_pos %d,write_pos %d,vb_write_count %d,count %d\n",__FUNCTION__,read_pos,write_pos,vb_write_count,count);
		return DRV_ERROR_FULL;
	}
	else {
		vb_write_count++;	
		
		VB_INT_OVERFLOW(vb_write_count);
		first_full_flag = 0;
		zOss_Memcpy(&(voice_buff[DOWN_LINK]->data[(write_pos%MAX_BUF_NUM)*MAX_BUF_SIZE]), buf, count);
	
		write_pos++;

		voice_buff[DOWN_LINK]->write_pos = write_pos;

	}
	
	return DRV_SUCCESS;
}
static int voice_buffer_read(char *buf, size_t count)
{
	int read_pos, write_pos;
	int* buf_int;
	int i;
	
	read_pos = voice_buff[UP_LINK]->read_pos;
	write_pos = voice_buff[UP_LINK]->write_pos;
	if(vb_read_count == 0){
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"%s: first read_pos=%d write_pos=%d \n",__FUNCTION__,read_pos,write_pos);
	}

	if ((count > 0) && (count <= MAX_BUF_SIZE))  {
		if(voice_buff_is_empty(read_pos, write_pos)){
			first_empty_flag++;
			VB_INT_OVERFLOW(first_empty_flag);
			if(first_empty_flag ==1)
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"%s: readbuffer is empty,read_pos %d,write_pos %d,vb_read_count %d,count %d\n",__FUNCTION__,read_pos,write_pos,vb_read_count,count);
			//add memset,del return . edit for  far end hear near end repreat voice pcm, FROM MBB TEST
			
		#ifndef  VB_DATA_LOSS_TEST
			zOss_Memset(&(voice_buff[UP_LINK]->data[(read_pos%MAX_BUF_NUM)*MAX_BUF_SIZE]),0, count);
			zOss_Memset(buf,0, count);
		#endif			
			//return DRV_ERROR_EMPTY;
			

		}
		else {
			
		    vb_read_count++; 			
			VB_INT_OVERFLOW(vb_read_count);		
			first_empty_flag = 0;
			
			zOss_Memcpy(buf, &(voice_buff[UP_LINK]->data[(read_pos%MAX_BUF_NUM)*MAX_BUF_SIZE]), count);
			//zOss_Memset(&(voice_buff[UP_LINK]->data[(read_pos%MAX_BUF_NUM)*MAX_BUF_SIZE]),0, count);

#ifdef VB_DATA_LOSS_TEST

			
			if(vb_read_count < 5){
				pr_info("ps :count=%d vb_read_count=%d,read_pos=%d,write_pos=%d\n",count,vb_read_count,read_pos,write_pos);

			
				buf_int =( int*) &voice_buff[UP_LINK]->data[(write_pos%MAX_BUF_NUM)*MAX_BUF_SIZE];
				
				for(i=0;i<(count/4);i++){
				   //*(buf_int+i) = i;
				   //buf_int[i] = i;
				 if(i>0x1f)  
					zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"ps: *(buf_int+%d)=%d\n",i,*(buf_int+i));
				}
			
			}
#endif
			read_pos++;
			if(read_pos == 20000000)
				read_pos = 0;
			voice_buff[UP_LINK]->read_pos = read_pos;
		}


	}
		
	
	return DRV_SUCCESS;
}


//voice buffer use in single core 
extern int voicebuffer_ulqueue_read(void *buf, unsigned int size);
extern int voicebuffer_dlqueue_write(void  *buf, unsigned int  size);
extern void voice_inform_to_app(void);
//static DECLARE_COMPLETION(s_voice_completion);
//ZOSS_TIMER_ID s_voiceTimerId ;
//ZOSS_SEMAPHORE_ID s_voiceRdSema;
//ZOSS_SEMAPHORE_ID s_voiceWrSema;
static void voiceTimerCallBack(SINT32 para)
{


	if (g_voiceVar.voiceBufferType == 1)//multi core
	{	


		T_ZDrvRpMsg_Msg icp_pMsg = {0}; 
		
		UINT8 s = 1;
		icp_pMsg.actorID = RPMSG_CAP_ID;

		icp_pMsg.chID = channel_41;
		icp_pMsg.flag |= RPMSG_WRITE_INT;
		icp_pMsg.buf = (void *)&s;
		icp_pMsg.len = 1;


		zOss_PutSemaphore(s_voiceWrSema);
		zOss_PutSemaphore(s_voiceRdSema);
		//zDrvRpMsg_Write(&icp_pMsg); 
#ifdef _USE_VEHICLE_DC	
		zDrvRpMsg_Write_Cap(&icp_pMsg);
#endif
		timer_cb_count++;
		VB_INT_OVERFLOW(timer_cb_count);
#ifdef VB_DATA_LOSS_TEST

		if((timer_cb_count%1000 ) == 0){
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s:timer_cb_count(%d)\n",__FUNCTION__,timer_cb_count);
			if(timer_cb_count> 10000000) 
				timer_cb_count=0;
		}

#endif
	

	}
	else{



	//	complete_all(&s_voice_completion);
		zOss_PutSemaphore(s_voiceWrSema);
		zOss_PutSemaphore(s_voiceRdSema);
		voice_inform_to_app();
	//	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voiceTimerCallBack timer=%u\n", cpu_clock(0)>>10);
	}


}





static SINT32 vp_rxsem_count_Init(void)
{
	UINT32 i = 0;
	UINT32 semCount = 0;
	SINT32 Count = 0;

	semCount = zOss_GetSemaphoreCount(s_voiceRdSema);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_rxsem_count_Init rxSem count=%d\n",  semCount);

	Count = semCount;
	if(Count > 0)  {
		for(i = 0; i < Count; i++) {
			zOss_GetSemaphore(s_voiceRdSema, ZOSS_NO_WAIT);
		}
	}

	return DRV_SUCCESS;
}

static SINT32 vp_txsem_count_Init(void)
{
	UINT32 i = 0;
	UINT32 semCount = 0;
	SINT32 Count = 0;

	semCount = zOss_GetSemaphoreCount(s_voiceWrSema);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_txsem_count_Init txSem count=%d \n",  semCount);

	Count = 3 - semCount;
	if(Count > 0) {
		for(i = 0; i < Count; i++) {
			zOss_PutSemaphore(s_voiceWrSema);
		}
	} else if(Count < 0) {
		Count = 0 - Count;
		for(i = 0; i < Count; i++) {
			zOss_GetSemaphore(s_voiceWrSema, ZOSS_NO_WAIT);
		}
	}
	
	return DRV_SUCCESS;
}





SINT32 vp_Open_Vbuffer(void)
{
	SINT32 ret = DRV_SUCCESS;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s:  start \n", __func__);
	if (g_voiceVar.voiceBufferType == 1)//multi core
	{
 		vp_Get_Add_RpMsg_Vbuffer();	
		
		vp_rxsem_count_Init();
		vp_txsem_count_Init();
		voice_buff[UP_LINK]->read_pos = 0;
		voice_buff[UP_LINK]->write_pos = 0; 
		voice_buff[DOWN_LINK]->read_pos = 0;
		voice_buff[DOWN_LINK]->write_pos = 0; 
		zOss_Memset(&(voice_buff[DOWN_LINK]->data[0]),0, MAX_BUF_NUM*MAX_BUF_SIZE);
		zOss_Memset(&(voice_buff[UP_LINK]->data[0]),0, MAX_BUF_NUM*MAX_BUF_SIZE);
		//for debug
		timer_cb_count = 0;
		first_full_flag = 0;
		first_empty_flag = 0;

		vb_read_count = 0;
		vb_write_count = 0;	
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_Open_Vbuffer  init voice buffer val!\n");

		
	}else{

	//	INIT_COMPLETION(s_voice_copletion);
		vp_rxsem_count_Init();
		vp_txsem_count_Init();
	}

	return DRV_SUCCESS;

}


SINT32 vp_Close_Vbuffer(void)
{
	SINT32 ret = DRV_SUCCESS;
    
	if (g_voiceVar.voiceBufferType == 1)//multi core
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s: timer_cb_count %d,first_full_flag %d,first_empty_flag %d,vb_read_count %d,vb_write_count %d!\n",__FUNCTION__,timer_cb_count,first_full_flag,first_empty_flag,vb_read_count,vb_write_count);
	}

	return DRV_SUCCESS;
}

SINT32 vp_VoiceI2sStart_Vbuffer(VOID)
{
	SINT32 ret = DRV_SUCCESS;

	UINT8 *read_buf = NULL;
	UINT8 *write_buf = NULL;
	UINT32 read_len = 0;
	UINT32 write_len = 0;


	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s: start.\n",__func__);


	ret = zDrvI2S_Read_Start(I2S_2, &s_speechState.i2sReadParam, s_vpState.pVpInnerI2sCfg);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart_Vbuffer failed ret is %d .\n", ret);
		return DRV_ERROR;
	}

	zOss_StartTimer(s_voiceTimerId, 20, voiceTimerCallBack, 0);


	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart_Vbuffer VB zOss_StartTimer\n");

	ret = zDrvI2S_Write_Start(I2S_2, &s_speechState.i2sWriteParam, s_vpState.pVpInnerI2sCfg);

	ret += zDrvI2S_GetBuf(I2S_2, &write_buf, &write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart_Vbuffer error7:zDrvI2S_GetBuf I2S_2 ret=%d", ret);
		return DRV_ERROR;
	}
	zOss_Memset(write_buf, 0, write_len);
	ret = zDrvI2S_Write(I2S_2, write_buf, write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart_Vbuffer error12:zDrvI2S_Write I2S_2 ret=%d", ret);
	}
	
	ret += zDrvI2S_GetBuf(I2S_2, &write_buf, &write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart_Vbuffer error13:zDrvI2S_GetBuf I2S_2 ret=%d", ret);
		return DRV_ERROR;
	}
	zOss_Memset(write_buf, 0, write_len);
	ret = zDrvI2S_Write(I2S_2, write_buf, write_len);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VoiceI2sStart_Vbuffer error14:zDrvI2S_Write I2S_2 ret=%d", ret);
	}
    
	if (g_voiceVar.voiceBufferType == 1)//multi core
	{

		voice_buffer_write(s_speechState.pVpTempRxOutPutBuffer, s_speechState.totalFrameBufSize);

	}else{
		voicebuffer_dlqueue_write(s_speechState.pVpTempRxOutPutBuffer, s_speechState.totalFrameBufSize);
	}
	
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s: end.\n",__func__);
	return ret;
}
VOID vp_VoiceI2sStop_Vbuffer(VOID)
{
	SINT32 ret = DRV_SUCCESS;
    return ret;
}



SINT32 zDrvVp_VoiceWorkStop_Vbuffer(VOID)
{
	SINT32  ret = DRV_SUCCESS;

	//complete_all(&s_voice_completion);
	zOss_PutSemaphore(s_voiceRdSema);
	zOss_PutSemaphore(s_voiceWrSema);
	zOss_StopTimer(s_voiceTimerId);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s: zOss_StopTimer\n",__func__);



	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s: success",__func__);
	return DRV_SUCCESS;
}


SINT32 vp_VolteReadStart_Vbuffer(VOID)
{
	SINT32 ret = DRV_SUCCESS;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteReadStart_Vbuffer start\n");
    
	zOss_StartTimer(s_voiceTimerId, 20, voiceTimerCallBack, 0);

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteReadStart_Vbuffer zOss_StartTimer start\n");

	return DRV_SUCCESS;
}
//whole replace 
SINT32 vp_VolteReadStop_Vbuffer(VOID)
{
	SINT32  ret = DRV_SUCCESS;

	if (g_voiceVar.useVoiceBuffer == 1)
	{
		zOss_PutSemaphore(s_voiceRdSema);
	
	}
	else
	{

#ifdef  CONFIG_VOICE_BUFFER_DRV  
		zOss_PutSemaphore(s_voiceRdSema);
#else

		//zDrvI2s_RxRlsSemaBeforeStop(I2S_1);
		zDrvExtAudio_RxRlsSemaBeforeStop();

#if 0//move to close lvwenhua 20150910
		ret = zDrvExtAudio_Read_Stop();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVolte_ReadStop I2S1 Stop wrong  ret=%d", ret);
		}
#endif
#endif

	}

	if (s_speechState.volteVpCfgEnFlag == 1)
	{
		ret = halVpCfg_Disable();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s: halVpCfg_Enable err ret=%x !\n",__func__, ret);
		}
		else
		{
			s_speechState.volteVpCfgEnFlag = 0;
		}
	}

	s_speechState.volteVpReadStopFlag = 1;//together control vp s_speechState
	if ((s_speechState.volteVpWriteStopFlag == 1) && (s_speechState.volteVpReadStopFlag == 1))
	{
		g_voiceVar.vpI2sStatus = VP_I2S_OPEN;
		
		if (g_voiceVar.useVoiceBuffer == 1)
		{
			zOss_StopTimer(s_voiceTimerId);
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s: zOss_StopTimer\n",__func__);
		
		}
		else
		{
#ifdef  CONFIG_VOICE_BUFFER_DRV  	
			zOss_StopTimer(s_voiceTimerId);
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteReadStop_Vbuffer zOss_StopTimer\n");
#endif
	}
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s: end\n",__func__);
	return ret;
}

SINT32 vp_VolteWriteStart_Vbuffer(VOID)
{
	SINT32 ret = DRV_SUCCESS;

	//???? for check
	if (g_voiceVar.voiceBufferType == 1)//multi core
	{
		voice_buffer_write(s_speechState.pVpTempRxOutPutBuffer, s_speechState.totalFrameBufSize);
	}
	else
	{
		voicebuffer_dlqueue_write(s_speechState.pVpTempRxOutPutBuffer, s_speechState.totalFrameBufSize);
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "%s:end \n",__func__);

	return ret;
}
//whole replace
SINT32 vp_VolteWriteStop_Vbuffer(VOID)
{
	SINT32  ret = DRV_SUCCESS;
	if (g_voiceVar.useVoiceBuffer == 1)
	{
		zOss_PutSemaphore(s_voiceWrSema);
	
	}
	else
	{

#ifdef  CONFIG_VOICE_BUFFER_DRV  
		//complete_all(&s_voice_completion);
		zOss_PutSemaphore(s_voiceWrSema);
#else
		//zDrvI2s_TxRlsSemaBeforeStop(I2S_1);
		zDrvExtAudio_TxRlsSemaBeforeStop();
#endif
	}
#if 0//move to close lvwenhua 20150910
	//wait for write drain semaphore
#ifdef VOICE_TONE_MIXER_FUNCTION
	voice_ToneMixerStop();
#endif

	ret = zDrvExtAudio_Write_Stop();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVolte_WriteStop I2S1 Stop wrong  ret=%d", ret);
	}

	//s_VolteWriteSema = 0;
#endif

	if (s_speechState.volteVpCfgEnFlag == 1)
	{
		ret = halVpCfg_Disable();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteWriteStop_Vbuffer halVpCfg_Enable err ret=%x !\n", ret);
		}
		else
		{
			s_speechState.volteVpCfgEnFlag = 0;
		}
	}

	s_speechState.volteVpWriteStopFlag = 1;//together control vp s_speechState
	if ((s_speechState.volteVpWriteStopFlag == 1) && (s_speechState.volteVpReadStopFlag == 1))
	{
		g_voiceVar.vpI2sStatus = VP_I2S_OPEN;
		
		if (g_voiceVar.useVoiceBuffer == 1)
		{

			zOss_StopTimer(s_voiceTimerId);
				
		}
		else
		{
			
#ifdef  CONFIG_VOICE_BUFFER_DRV 
			zOss_StopTimer(s_voiceTimerId);
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteWriteStop_Vbuffer zOss_StopTimer\n");
#endif
		}
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_VolteWriteStop_Vbuffer \n");
	return ret;
}


/*******************************************************************************
 * For union version
 * Others:
 ********************************************************************************/
SINT32 vp_WriteDataToCodec_Vbuffer(UINT8 *pBuf, UINT32 count)
{
	SINT32  ret = DRV_SUCCESS;
	SINT32  e_ret = DRV_SUCCESS;	
	UINT8 *write_buf = NULL;
	UINT32 write_len = 0;
	UINT8 *e_write_buf = NULL;
	UINT32 e_write_len = 0;
	UINT32 i = 0, j = 0;
#ifdef TEST_WHITE_NOISE
	// UINT32 tempCount = 0;
	//zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "test the white noise");
	//UINT8 *pVoiceTempBuf = s_voiceTempBuffer;
#endif



	if (pBuf == NULL)
	{
		return DRV_ERR_INVALID_PARAM;
	}

	if (count != s_speechState.i2sWriteParam.buffersize)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_WriteDataToCodec_Vbuffer write data length err,count=%d,writebuffersize=%d \n", count, s_speechState.i2sWriteParam.buffersize);
		return DRV_ERR_INVALID_PARAM;
	}
	#ifdef ECALL_SUPPORT	

	if(e_reg_flag == 1)
	{		
		e_ret = update_ecall_state(DIR_RX); 
		if (e_ret == DRV_ERR_NOT_SUPPORTED)
		{
			zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "vp_WriteDataToCodec_Vbuffer get__ecall_state fun not register or invalid para,e_ret=%d !\n",e_ret);
	
		}	
	}	
	#endif



	#ifdef TEST_WHITE_NOISE

	zOss_Memcpy(s_speechState.pVpTempRxInBuffer, pVoiceTempBuf, s_speechState.totalFrameBufSize);

	pVoiceTempBuf += s_speechState.totalFrameBufSize;
	tempCount += s_speechState.totalFrameBufSize;
	if (tempCount >= 0x4df80)   //307200
		//if(tempCount >= 0x4e200)   //320000
	{
		pVoiceTempBuf = s_voiceTempBuffer;
		tempCount = 0;
	}
	#endif

	#ifdef VOICE_TONE_MIXER_FUNCTION

	if (mixerToneInfo.StartMixer == TRUE) 
	{
		//voice_ToneMixerData( s_speechState.pVpTempRxInBuffer);
		if ((g_voiceVar.voiceInVolteMode == 1) && (g_voiceVar.volteIsWb == 1)) 
		{
			voice_ToneMixerData(s_speechState.pVpTempRxInBuffer, 640,  s_speechState.pVpTempRxInBuffer);
		} 
		else 
		{
			voice_ToneMixerData(s_speechState.pVpTempRxInBuffer, 320,  s_speechState.pVpTempRxInBuffer);
		}

	}

	#endif
	if (pBuf !=  s_speechState.pVpTempRxInBuffer)
	{
		zOss_Memcpy(s_speechState.pVpTempRxInBuffer, pBuf, s_speechState.totalFrameBufSize);
	}
    
	if (g_voiceVar.vProcIsNormal == TRUE)
	{
		VoiceProc_RxProcess(& s_speechState.pVpTempRxInBuffer, & s_speechState.pVpTempRxOutPutBuffer, s_speechState.frameCount);
	}
	else
	{
		zOss_Memcpy((VOID *)(s_speechState.pVpTempRxOutPutBuffer), (VOID *) s_speechState.pVpTempRxInBuffer, s_speechState.totalFrameBufSize);
	}
	//wait_for_completion_timeout(&s_voice_completion, 60);
	zOss_GetSemaphore(s_voiceWrSema,  60);
	//#ifdef _VBUFF_IN_MULTI_CORE
	if (g_voiceVar.voiceBufferType == 1)
	{
		voice_buffer_write(s_speechState.pVpTempRxOutPutBuffer, s_speechState.totalFrameBufSize);
	}
	else
	{			
		voicebuffer_dlqueue_write(s_speechState.pVpTempRxOutPutBuffer, s_speechState.totalFrameBufSize);
	}
	if (g_voiceVar.voiceInVolteMode == 1)
	{
		s_speechState.rxSaveLen += s_speechState.totalFrameBufSize;
		if (s_speechState.rxSaveLen >= s_speechState.inOutBufUseSize)
		{
			s_speechState.rxSaveLen = 0;
		}
		s_speechState.pVpTempRxInBuffer = s_vpState.pVpRxInBuffer + s_speechState.rxSaveLen;
		#ifdef _USE_VP_OUTPUT_RXOUT_DATA
        s_speechState.pVpTempRxOutPutBuffer = s_vpState.pVpRxOutPutBuffer + s_speechState.rxSaveLen;
		#else
		s_speechState.pVpTempRxOutPutBuffer = s_vpState.pVpRxOutPutBuffer;
		#endif
	}

	
	if (s_speechState.firstWriteDataFlag == FALSE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_WriteDataToCodec_Vbuffer first write ret=%d,tick=%d.\n", ret, zOss_GetTickCount());
		s_speechState.firstWriteDataFlag = TRUE;
	}

	return ret;
}



SINT32 vp_ReadDataFromCodec_Vbuffer(UINT8 *pBuf, UINT32 count)
{
	SINT32  ret = DRV_SUCCESS;
	UINT8 *read_buf = NULL;
	UINT32 read_len = 0;

	UINT32 i = 0, j = 0;
#ifdef CONFIG_ARCH_ZX297520V3_CPE_SWITCH
	UINT8 temp8bit = 0;
	UINT8 *ptemp8bit = NULL;
#endif

	if (pBuf == NULL)
	{
		return DRV_ERR_INVALID_PARAM;
	}

	if (count != s_speechState.i2sReadParam.buffersize)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s: read data length err,count=%d,readbuffersize=%d \n",__func__, count, s_speechState.i2sReadParam.buffersize);
		return DRV_ERR_INVALID_PARAM;
	}
#ifdef ECALL_SUPPORT

	if(e_reg_flag == 1)
	{		
		ret = update_ecall_state(DIR_TX); 
		if (ret == DRV_ERR_NOT_SUPPORTED)
		{
			zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "vp_ReadDataFromCodecvp_ReadDataFromCodec get__ecall_state fun not register,ret=%d !\n",ret);
	
		}	
	}	
#endif
	

//	wait_for_completion_timeout(&s_voice_completion, 60);
	zOss_GetSemaphore(s_voiceRdSema,  60);
	if (g_voiceVar.voiceBufferType == 1)
	{
		voice_buffer_read(s_speechState.pVpTempTxInBuffer,  s_speechState.totalFrameBufSize);

	}
	else
	{
		voicebuffer_ulqueue_read(s_speechState.pVpTempTxInBuffer,  s_speechState.totalFrameBufSize);
	}
	if (g_voiceVar.vProcIsNormal == TRUE)
	{
		VoiceProc_TxProcess(&s_speechState.pVpTempTxInBuffer, NULL, &s_speechState.pVpTempTxOutPutBuffer, s_speechState.frameCount);	
	}
	else
	{
		zOss_Memcpy((VOID *)(s_speechState.pVpTempTxOutPutBuffer), (VOID *) s_speechState.pVpTempTxInBuffer, s_speechState.totalFrameBufSize);
	}

	if (pBuf !=  s_speechState.pVpTempTxOutPutBuffer)
	{
		zOss_Memcpy(pBuf, s_speechState.pVpTempTxOutPutBuffer, s_speechState.totalFrameBufSize);
	}
	
	if (g_voiceVar.voiceInVolteMode == 1)
	{
		// s_speechState.txSaveLen += VP_FRAME_BUFFER_SIZE;
		s_speechState.txSaveLen += s_speechState.totalFrameBufSize;
		if (s_speechState.txSaveLen >= s_speechState.inOutBufUseSize)
		{
			s_speechState.txSaveLen = 0;
		}
		s_speechState.pVpTempTxInBuffer = s_vpState.pVpTxInBuffer + s_speechState.txSaveLen;
		s_speechState.pVpTempTxOutPutBuffer = s_vpState.pVpTxOutPutBuffer + s_speechState.txSaveLen;
	}
	
	
	if (s_speechState.firstReadDataFlag == FALSE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_ReadDataFromCodec first read tick=%d.\n", zOss_GetTickCount());
		s_speechState.firstReadDataFlag = TRUE;
	}

	return ret;
}




SINT32 vp_CreateThreadSemaph_Vbuffer(VOID)
{
	SINT32 ret = 0;
//#ifdef CONFIG_VOICE_BUFFER_DRV  	
//	init_completion(&s_voice_completion);
    /*
	if(vbuffer_init_flag == 1){
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vbuffer already init,return! \n");
		return DRV_SUCCESS;

	}
	*/
	s_voiceRdSema = zOss_CreateSemaphore("voice_rx_sem", 0);
	if(NULL == s_voiceRdSema) {
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "create voice_rx_sem err \n");
		return DRV_ERROR;
	}

	s_voiceWrSema  = zOss_CreateSemaphore("voice_tx_sem", 0);
	if(NULL == s_voiceWrSema) {
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "create voice_tx_sem err \n");
		return DRV_ERROR;
	}

	
 
	s_voiceTimerId	= zOss_CreateTimer("voice_frameTimer", voiceTimerCallBack, 0, TRUE);	 
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "s_voiceTimerId=%p\n", s_voiceTimerId);
	if(!s_voiceTimerId)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_frameTimer  failed\n");
		return DRV_ERROR;
	}




	//ret = zDrvRpMsg_CreateChannel(IPC_MSG_ACTOR_A9,channel_41,0x10);
#ifdef _USE_VEHICLE_DC		
	ret = zDrvRpMsg_CreateChannel_Cap(RPMSG_CAP_ID,channel_41,0x10);

	if(DRV_SUCCESS != ret) {
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "create rpmsg err(%d) \n",ret);
		return DRV_ERROR;
	}
/*	
	volatile T_ZDrvRpMsg_Msg icp_pMsg = {0}; 
	volatile unsigned int rpMsgBuf[2] = {0,0}; 
	//printk( "vir_buf1:0x%x, vir_buf2:0x%x, phy_buf1:0x%x, phy_buf2:0x%x,\n",voice_buff[0],voice_buff[1],rpMsgBuf[0],rpMsgBuf[1]);
	icp_pMsg.actorID = RPMSG_CAP_ID;
	icp_pMsg.chID = channel_41;
	icp_pMsg.flag &= ~RPMSG_READ_POLL;
	icp_pMsg.buf = rpMsgBuf;
	icp_pMsg.len = 8;

	
	ret = zDrvRpMsg_Read_Cap(&icp_pMsg);
	if(ret <= 0){
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice buffer  rpmsg addr read  fail,ret=%d \n",ret);
		zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "ps voice buffer  rpmsg addr read  fail,ret=%d \n",ret);
		

	}
	else{
		#if 0

		voice_buff[UP_LINK] = (struct voice_ring_buffer *)(rpMsgBuf[0]);
		voice_buff[DOWN_LINK] = (struct voice_ring_buffer *)(rpMsgBuf[1]);	
		#else

		voice_buff[UP_LINK] = (struct voice_ring_buffer *)ioremap_wc(rpMsgBuf[0], (sizeof(struct voice_ring_buffer) + MAX_BUF_SIZE*MAX_BUF_NUM));
		voice_buff[DOWN_LINK] = (struct voice_ring_buffer *)ioremap_wc(rpMsgBuf[1],(sizeof(struct voice_ring_buffer) + MAX_BUF_SIZE*MAX_BUF_NUM));	
		#endif

		zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "ps rpmsg voice buffer addr,up vir buf=0x%x,  down vir buf=0x%x ,up phy buf=0x%x,  down phy buf=0x%x,size=%d \n" \
		,voice_buff[0],voice_buff[1],rpMsgBuf[0],rpMsgBuf[1],(sizeof(struct voice_ring_buffer) + MAX_BUF_SIZE*MAX_BUF_NUM));
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice buffer addr,up vir buf=0x%x,  down vir buf=0x%x ,up phy buf=0x%x,  down phy buf=0x%x,size=%d \n" \
			,voice_buff[0],voice_buff[1],rpMsgBuf[0],rpMsgBuf[1],(sizeof(struct voice_ring_buffer) + MAX_BUF_SIZE*MAX_BUF_NUM));
	}
*/	

	
#endif
	//vbuffer_init_flag = 1;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_CreateThreadSemaph success. \r\n");
	return DRV_SUCCESS;
}




static SINT32 vp_Get_Add_RpMsg_Vbuffer(VOID)
{
	SINT32 ret = 0;
//#ifdef CONFIG_VOICE_BUFFER_DRV  	
//	init_completion(&s_voice_completion);
    
	if(vbuffer_init_flag == 1){
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vbuffer already init,return! \n");
		return DRV_SUCCESS;

	}

	//ret = zDrvRpMsg_CreateChannel(IPC_MSG_ACTOR_A9,channel_41,0x10);
#ifdef _USE_VEHICLE_DC		

	volatile T_ZDrvRpMsg_Msg icp_pMsg = {0}; 
	volatile unsigned int rpMsgBuf[2] = {0,0}; 
	//printk( "vir_buf1:0x%x, vir_buf2:0x%x, phy_buf1:0x%x, phy_buf2:0x%x,\n",voice_buff[0],voice_buff[1],rpMsgBuf[0],rpMsgBuf[1]);
	icp_pMsg.actorID = RPMSG_CAP_ID;
	icp_pMsg.chID = channel_41;
	icp_pMsg.flag &= ~RPMSG_READ_POLL;
	icp_pMsg.buf = rpMsgBuf;
	icp_pMsg.len = 8;

	
	ret = zDrvRpMsg_Read_Cap(&icp_pMsg);
	if(ret <= 0){
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice buffer  rpmsg addr read  fail,ret=%d \n",ret);
		zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "ps voice buffer  rpmsg addr read  fail,ret=%d \n",ret);
		

	}
	else{
		#if 0

		voice_buff[UP_LINK] = (struct voice_ring_buffer *)(rpMsgBuf[0]);
		voice_buff[DOWN_LINK] = (struct voice_ring_buffer *)(rpMsgBuf[1]);	
		#else

		voice_buff[UP_LINK] = (struct voice_ring_buffer *)ioremap_wc(rpMsgBuf[0], (sizeof(struct voice_ring_buffer) + MAX_BUF_SIZE*MAX_BUF_NUM));
		voice_buff[DOWN_LINK] = (struct voice_ring_buffer *)ioremap_wc(rpMsgBuf[1],(sizeof(struct voice_ring_buffer) + MAX_BUF_SIZE*MAX_BUF_NUM));	
		#endif

		zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "ps rpmsg voice buffer addr,up vir buf=0x%x,  down vir buf=0x%x ,up phy buf=0x%x,  down phy buf=0x%x,size=%d \n" \
		,voice_buff[0],voice_buff[1],rpMsgBuf[0],rpMsgBuf[1],(sizeof(struct voice_ring_buffer) + MAX_BUF_SIZE*MAX_BUF_NUM));
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice buffer addr,up vir buf=0x%x,  down vir buf=0x%x ,up phy buf=0x%x,  down phy buf=0x%x,size=%d \n" \
			,voice_buff[0],voice_buff[1],rpMsgBuf[0],rpMsgBuf[1],(sizeof(struct voice_ring_buffer) + MAX_BUF_SIZE*MAX_BUF_NUM));

		vbuffer_init_flag = 1;

	}
	

	
#endif

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s: success. \r\n",__func__);
	return DRV_SUCCESS;
}















