/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:audioRef_cfg.c
 * File Mark:
 * Description: Loop voice data from teak to arm.
                    Settings: arm iis2->top iis1(connect to ap), arm iis1 loop to teak afe.

 * Others:
 * Version:
 * Author:        xxq
 * Date:          2014-03-10
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include <linux/vmalloc.h>
#include "drvs_general.h"
#include "drvs_i2s.h"
#include "drvs_voiceprocess.h"
#include "hal_voiceprocess.h"
#include "drvs_voice_config.h"
#include "drvs_i2c.h"
#include "NvParam_drv.h"
#include "drvs_codec.h"
#include "aud_drv.h"           /* header file for this file */
#include "hal_pcmdata.h"
//#include "math.h"
#include "drvs_ref_cfg.h"
#include "drvs_tdm.h"

#include <mach/iomap.h>

/****************************************************************************
*                                             Local Macros
****************************************************************************/

//Defines for settings
#define AUD_I2S_Switch_Interface_off 0
#define AUD_I2S_Switch_MMS_mode      1
#define AUD_I2S_Switch_MMS_FB_mode  2
#define AUD_I2S_Switch_external_mode 3
#define AUD_I2S_Switch_DAI_mode      4

#define AUD_I2S_CSEL_TXCLKSEL_FROM_Fractional_devider_0_MASTER 0
#define AUD_I2S_CSEL_TXCLKSEL_FROM_CLK0_WA0_SLAVE 2
#define AUD_I2S_CSEL_TXCLKSEL_FROM_CLK1_WA1_SLAVE 1
#define AUD_I2S_CSEL_TXCLKSEL_FROM_Fractional_devider_1_MASTER 3
#define AUD_I2S_CSEL_TXCLKSEL_Bitmask 0xFFFC

#define AUD_I2S_CSEL_CLK0SEL_Fractional_devider_0 0
#define AUD_I2S_CSEL_CLK0SEL_Fractional_devider_1 1<<2
#define AUD_I2S_CSEL_CLK0SEL_external 2<<2
#define AUD_I2S_CSEL_CLK0SEL_Bitmask 0xFFF3

#define AUD_I2S_CSEL_RXCLKSEL_FROM_Fractional_devider_1_MASTER 0
#define AUD_I2S_CSEL_RXCLKSEL_FROM_CLK0_WA0_SLAVE 1<<4
#define AUD_I2S_CSEL_RXCLKSEL_FROM_CLK1_WA1_SLAVE 2<<4
#define AUD_I2S_CSEL_RXCLKSEL_FROM_Fractional_devider_0_MASTER 3<<4
#define AUD_I2S_CSEL_RXCLKSEL_Bitmask 0xFFCF

#define AUD_I2S_CSEL_CLK1SEL_Fractional_devider_0 0
#define AUD_I2S_CSEL_CLK1SEL_Fractional_devider_1 1<<6
#define AUD_I2S_CSEL_CLK1SEL_external 2<<6
#define AUD_I2S_CSEL_CLK1SEL_Bitmask 0xFF3F

#define AUD_I2S_CONF_WIDTH_16 0
#define AUD_I2S_CONF_WIDTH_18 4<<5
#define AUD_I2S_CONF_WIDTH_20 5<<5
#define AUD_I2S_CONF_WIDTH_24 6<<5
#define AUD_I2S_CONF_WIDTH_32 7<<5

#define AUD_I2S_CONF_EDGE_FALLING         0
#define AUD_I2S_CONF_EDGE_RISING          1
#define AUD_I2S_CONF_EDGE_Bitmask         1
#define AUD_I2S_CONF_DEL_NO_DELAY         0
#define AUD_I2S_CONF_DEL_1_bit_DELAY      1<<1
#define AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT 0
#define AUD_I2S_CONF_POL_WA_HIGH_IS_LEFT  1<<2
#define AUD_I2S_CONF_PERIOD_64            0
#define AUD_I2S_CONF_PERIOD_48            1<<3
#define AUD_I2S_CONF_PERIOD_32            2<<3
#define AUD_I2S_CONF_WIDTH_16             0
#define AUD_I2S_CONF_WIDTH_18             4<<5
#define AUD_I2S_CONF_WIDTH_20             5<<5
#define AUD_I2S_CONF_WIDTH_24             6<<5
#define AUD_I2S_CONF_WIDTH_32             7<<5
#define AUD_I2S_CONF_ALIGN_LEFT           0
#define AUD_I2S_CONF_ALIGN_RIGHT          1<<8

#define AUD_I2S_CONF_RX_CLK1_OUT_IS_LOW   0
#define AUD_I2S_CONF_RX_CLK1_OUT_IS_HIGH  1<<13
#define AUD_I2S_CONF_RX_CLK1_CONT_STOPS   0
#define AUD_I2S_CONF_RX_CLK1_CONT_RUNNING 1<<14
#define AUD_I2S_CONF_RX_WA1_LEN_1_CYCLE   0
#define AUD_I2S_CONF_RX_WA1_LEN_2_CYCLE   1<<15
#define AUD_I2S_CONF_RX_WAx_LEN_Bitmask   1<<15


#define AUD_I2S_CONF_TX_MUTE_L_ACTIVE     0
#define AUD_I2S_CONF_TX_MUTE_L_MUTED      1<<11
#define AUD_I2S_CONF_TX_MUTE_R_ACTIVE     0
#define AUD_I2S_CONF_TX_MUTE_R_MUTED      1<<12
#define AUD_I2S_CONF_TX_CLK0_OUT_IS_LOW   0
#define AUD_I2S_CONF_TX_CLK0_OUT_IS_HIGH  1<<13
#define AUD_I2S_CONF_TX_CLK0_CONT_STOPS   0
#define AUD_I2S_CONF_TX_CLK0_CONT_RUNNING 1<<14
#define AUD_I2S_CONF_TX_WA0_LEN_1_CYCLE   0
#define AUD_I2S_CONF_TX_WA0_LEN_2_CYCLE   1<<15
#define AUD_I2S_NUM_FREF_MODULE_CLOCK     0
#define AUD_I2S_NUM_FREF_104MHz           1<<12

#define AUD_I2S_TRANSFER_MODE_STEREO    0<<9
#define AUD_I2S_TRANSFER_MODE_RIGHT         2<<9
#define AUD_I2S_TRANSFER_MODE_LEFT       3<<9

#define AUD_I2S_HW_MODE_BURST          0
#define AUD_I2S_HW_MODE_NORMAL       1

#define AUD_I2S_CHANNEL_MODE_MONO             0  // Mono
#define AUD_I2S_CHANNEL_MODE_DUALMONOL   1 //  left channel is taken from I2S1 interface and copied to both L & R
#define AUD_I2S_CHANNEL_MODE_DUALMONOR   2 //  Right channel is taken from I2S1 interface and copied to both L & R

//#define ARM_I2S_LOOP_CFG	*((volatile UINT32 *)(0x00140000+0x60))
#define ARM_I2S_LOOP_CFG	*((volatile UINT32 *)(SOC_SYS_REG_BASE+0x60))

//#define AUDIO_USE_FIXED_ADDRESS

//#define VP_INOUT_BAK_BUFFER_SIZE 0x30000  // 0x60000
#define VP_INOUT_NOBAK_BUFSIZE  640

/**************************************************************************
 *                                  Types                                  *
 **************************************************************************/
typedef struct
{
	UINT16 I2S_mode_enum;
	UINT16 csel;
	UINT16 den0;
	UINT16 den1;
	UINT16 num0;
	UINT16 num1;
	UINT16 rxconf;
	UINT16 txconf;
	UINT16 hwmode;
	UINT16 channel_mode;
	aud_I2S_samplerate_enum sample;
} aud_dsp_dai_configuration_type;

typedef struct
{
	DOUBLE freqValue;
	DOUBLE freqAmp;

} zDrvVp_Freqfft;

/****************************************************************************
*                                             Local Function Prototypes
****************************************************************************/
#ifdef _CONFIG_DC_USE_CODEC//dual_core version
UINT32 audioGpioCodecEnHandle = 0;
UINT32 audioGpioResetHandle = 0;
UINT32 audioGpioClkHandle = 0;
UINT32 audioGpio76Handle = 0;
UINT32 audioGpio77Handle = 0;
#endif

#if defined(_USE_REF_AUDIO_ON_7520V3_MDL) || defined(_USE_REF_AUDIO_ON_7520V3_FWP)
#define AON_WIFI_BT_CLK_CFG2       *((volatile UINT32 *)(0x0013b000 + 0x94))
#endif

#ifdef AUDIO_USE_FIXED_ADDRESS
T_ZDrv_VpInOutBuffer vpInOutBuffer =
{
	(UINT8 *)(ZX_DDR_CAMERAVOICE_BASE),
	(UINT8 *)(ZX_DDR_CAMERAVOICE_BASE + 0x60000),
	(UINT8 *)(ZX_DDR_CAMERAVOICE_BASE + 0xC0000),
	(UINT8 *)(ZX_DDR_CAMERAVOICE_BASE + 0x120000)
};
#else
T_ZDrv_VpInOutBuffer vpInOutBuffer =
{
	NULL, NULL, NULL, NULL
};
#endif

SINT32 halAudioConfig_Open(T_ZDrvVp_SourceType srctype);
SINT32 halAudioConfig_Close(VOID);
SINT32 halAudioConfig_Enable(VOID);
SINT32 halAudioConfig_Disable(VOID);
SINT32 halAudioConfig_SetFs(T_ZDrv_VpFs fs);
SINT32 halAudioConfig_SetInputPath(T_ZDrv_VpPath path, BOOL enable);
SINT32 halAudioConfig_SetOutputPath(T_ZDrv_VpPath path, BOOL enable);
SINT32 halAudioConfig_SetMute(T_ZDrv_VpPath path, BOOL mute);
SINT32 halAudioConfig_SetFmPath(T_ZDrv_VpPath path, BOOL enable);
SINT32 halAudioConfig_SetLoopback(BOOL enable);
SINT32 halAudioConfig_SetInputVol(T_ZDrv_VpVol vol);
SINT32 halAudioConfig_SetOutputVol(T_ZDrv_VpVol vol);
SINT32 halAudioConfig_SetUseProtocol(T_ZDrvCodec_UseProtocol useProtocol);
SINT32 halAudioConfig_GetMixerToneInfo(T_ZDrvVp_ToneNum toneNum, T_HalMixerToneInfo *mixerToneInfo);
SINT32 halAudioConfig_GetAudioLoopInfo(T_HalAudioLoopTestInfo *audioInfo);
SINT32 halAudioConfig_GetAudioLoopResult(T_HalAudioLoopTestPra *audioPra);
//SINT32 zDrvNand_Read(UINT32 dwStart, UINT32 dwLen, UINT8* to);//xiu
UINT32 zOss_NvItemRead(UINT32 NvItemID, UINT8 *NvItemData, UINT32 NvItemLen);
SINT32 zDrvCodec_SetOut_Hpf(T_ZDrvCodec_Handle handle, T_ZDrvCodec_AudioSample fs, BOOL onoff);//xiu
SINT32 cal_freq_fft( SINT16 *data,zDrvVp_Freqfft *freqfft,UINT16 n,UINT32 fs);//xiu
SINT32 zDrvCodec_Read(UINT16 regPage,UINT16 regAddress,UINT16 *regValue);//xiu
SINT32 zDrvCodec_Write(UINT16 regPage,UINT16 regAddress,UINT16 regValue,UINT16 regMask);//xiu
SINT32 zDrvCodec_DumpReg(VOID);//xiu
SINT32 vp_SetInnerI2sMode(BOOL i2smode);
extern SINT32 zDrvAudio_Initiate(VOID);
extern VOID vp_SetTopI2sConfig(VOID);
extern VOID vp_SetTopTdmConfig(VOID);
extern VOID vp_SetTopConfig(VOID);
extern SINT32 zDrvI2S_Init(VOID);
extern VOID udelay(UINT32  us);

#ifdef _USE_EARPIECE_FUNCMOUDLE
extern SINT32 zDrvEarp_Initiate(VOID);
#endif
static T_HalVpCfg_Opt s_vpCfgObjOpt =
{
	NULL,
	NULL,
	NULL,
	halAudioConfig_Open,
	halAudioConfig_Close,
	halAudioConfig_Enable,
	halAudioConfig_Disable,
	halAudioConfig_SetFs,
	halAudioConfig_SetInputPath,
	halAudioConfig_SetOutputPath,
	halAudioConfig_SetMute,
	halAudioConfig_SetFmPath,
	halAudioConfig_SetLoopback,
	halAudioConfig_SetInputVol,
	halAudioConfig_SetOutputVol,
	halAudioConfig_SetUseProtocol,
	halAudioConfig_GetMixerToneInfo,
//	halAudioConfig_GetAudioLoopInfo,
//	halAudioConfig_GetAudioLoopResult,
};

static aud_dsp_dai_configuration_type s_dspPcmMasterCfg =
{
	/* aud_I2Sx_mode1 master mode*/
	aud_I2Sx_mode1,         /* mode allowed or not on platform */
	AUD_I2S_CSEL_TXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK0SEL_Fractional_devider_0 | \
	AUD_I2S_CSEL_RXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK1SEL_Fractional_devider_0, /* csel */
	0x0cb2, /* den0 */
	0x0cb2, /* den1 */
	0x0011 | AUD_I2S_NUM_FREF_104MHz, /* num0 */
	0x0011 | AUD_I2S_NUM_FREF_104MHz, /* num1 */
	AUD_I2S_CONF_RX_CLK1_OUT_IS_LOW | AUD_I2S_CONF_RX_CLK1_CONT_STOPS | AUD_I2S_CONF_RX_WA1_LEN_1_CYCLE, /* rxconf */
	AUD_I2S_CONF_TX_CLK0_OUT_IS_LOW | AUD_I2S_CONF_TX_CLK0_CONT_STOPS | AUD_I2S_CONF_TX_WA0_LEN_1_CYCLE, /* txconf */
	AUD_I2S_HW_MODE_BURST,
	AUD_I2S_CHANNEL_MODE_MONO,
	aud_I2S_samplerate_08000
};
static aud_dsp_dai_configuration_type s_dspPcmSlaveCfg =
{
	/* aud_I2Sx_mode2 */
	aud_I2Sx_mode2,         /* mode allowed or not on platform */
	AUD_I2S_CSEL_TXCLKSEL_FROM_CLK0_WA0_SLAVE | AUD_I2S_CSEL_CLK0SEL_external | \
	AUD_I2S_CSEL_RXCLKSEL_FROM_CLK0_WA0_SLAVE | AUD_I2S_CSEL_CLK1SEL_external, /* csel */
	0x0659, /* den0 */
	0x0659, /* den1 */
	0x0010 | AUD_I2S_NUM_FREF_104MHz, /* num0 */
	0x0010 | AUD_I2S_NUM_FREF_104MHz, /* num1 */
	AUD_I2S_CONF_RX_CLK1_OUT_IS_LOW | AUD_I2S_CONF_RX_CLK1_CONT_STOPS | AUD_I2S_CONF_RX_WA1_LEN_1_CYCLE, /* rxconf */
	AUD_I2S_CONF_TX_CLK0_OUT_IS_LOW | AUD_I2S_CONF_TX_CLK0_CONT_STOPS | AUD_I2S_CONF_TX_WA0_LEN_1_CYCLE, /* txconf */
	AUD_I2S_HW_MODE_BURST,
	AUD_I2S_CHANNEL_MODE_MONO,
	aud_I2S_samplerate_08000
};
static aud_dsp_dai_configuration_type s_dspI2sMasterCfg =
{
	/* aud_I2Sx_mode3 16 bit 8 kHz Master, Normal Mode, Mono */
	aud_I2Sx_mode3,         /* mode allowed or not on platform */
	AUD_I2S_CSEL_TXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK0SEL_Fractional_devider_0 | \
	AUD_I2S_CSEL_RXCLKSEL_FROM_Fractional_devider_0_MASTER | AUD_I2S_CSEL_CLK1SEL_Fractional_devider_1, /* csel */
	0x0659, /* den0 */
	0x0659, /* den1 */
	0x0010 | AUD_I2S_NUM_FREF_104MHz, /* num0 */
	0x0010 | AUD_I2S_NUM_FREF_104MHz, /* num1 */
	AUD_I2S_CONF_EDGE_RISING | AUD_I2S_CONF_DEL_1_bit_DELAY | AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT \
	| AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_WIDTH_16 | AUD_I2S_CONF_ALIGN_LEFT, /* rxconf */
	AUD_I2S_CONF_EDGE_FALLING | AUD_I2S_CONF_DEL_1_bit_DELAY | AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT \
	| AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_WIDTH_16 | AUD_I2S_CONF_ALIGN_LEFT \
	| AUD_I2S_TRANSFER_MODE_RIGHT | AUD_I2S_CONF_TX_MUTE_L_MUTED | AUD_I2S_CONF_TX_MUTE_R_ACTIVE,/* txconf */
	AUD_I2S_HW_MODE_NORMAL,
	AUD_I2S_CHANNEL_MODE_DUALMONOR,
	aud_I2S_samplerate_08000
};
static aud_dsp_dai_configuration_type s_dspI2sSlaveCfg =
{
	/* aud_I2Sx_mode4 16 bit 8 kHz Slave, Normal Mode, Mono */
	aud_I2Sx_mode4,         /* mode allowed or not on platform */
	AUD_I2S_CSEL_TXCLKSEL_FROM_CLK0_WA0_SLAVE | AUD_I2S_CSEL_CLK0SEL_external |
	AUD_I2S_CSEL_RXCLKSEL_FROM_CLK0_WA0_SLAVE | AUD_I2S_CSEL_CLK1SEL_external, /* csel */
	0x0002, /* den0 */
	0x0002, /* den1 */
	0x0001, /* num0 */
	0x0001, /* num1 */
	AUD_I2S_CONF_EDGE_RISING | AUD_I2S_CONF_DEL_1_bit_DELAY | AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT
	| AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_WIDTH_16 | AUD_I2S_CONF_ALIGN_LEFT, /* rxconf */
	AUD_I2S_CONF_EDGE_FALLING | AUD_I2S_CONF_DEL_1_bit_DELAY | AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT
	| AUD_I2S_CONF_PERIOD_32 | AUD_I2S_CONF_WIDTH_16 | AUD_I2S_CONF_ALIGN_LEFT
	| AUD_I2S_TRANSFER_MODE_RIGHT | AUD_I2S_CONF_TX_MUTE_L_MUTED | AUD_I2S_CONF_TX_MUTE_R_ACTIVE,/* txconf */
	AUD_I2S_HW_MODE_NORMAL,
	AUD_I2S_CHANNEL_MODE_DUALMONOR,
	aud_I2S_samplerate_08000
};


extern T_ZDrvI2S_Cfg s_vpInnerI2sCfg ;//I2S MASTER


extern T_ZDrvI2S_Cfg s_vpExtI2sNbCfg  ;//TEST FOR i2s

extern T_ZDrvI2S_Cfg s_vpExtI2sWbCfg  ;//TEST FOR i2s
extern T_ZDrvI2S_Cfg s_vpExtI2sNbCfg_slic  ;//TEST FOR i2s
extern T_ZDrvI2S_Cfg s_vpExtI2sWbCfg_slic  ;//TEST FOR i2s

//extern T_ZDrvI2S_Cfg s_vpAudioI2sCfg  ;//TEST FOR i2s
//extern T_ZDrvI2S_Cfg s_vpFmI2sCfg  ;//TEST FOR i2s
extern T_ZDrvTdm_Cfg s_vpTdmNbCfg  ;//TEST FOR tdm
extern T_ZDrvTdm_Cfg s_vpTdmWbCfg ;//TEST FOR tdm
extern T_ZDrvTdm_Cfg s_vpTdmWbCfg_codec ;//TEST FOR codec tdm


static T_ZDrvCodec_Handle gCodecHandle = 0;//xiu

#ifdef _CONFIG_USE_CODEC
static T_ZDrvCodec_InDevice s_inDev = AUDIO_INPUT_HANDSET;
static T_ZDrvCodec_OutDevice s_outDev = AUDIO_OUTPUT_RECEIVER;
BOOL codecInitFlag = FALSE;
static BOOL s_isClasskOpened = FALSE;
#endif

static BOOL s_isFmOpened = FALSE;
static T_ZDrvCodec_UseProtocol s_useProtocal;
static T_ZDrvCodec_SourceType codecSrcType = VOICE_SOURCE;
static T_ZDrvCodec_AudioSample Sample_Fs = AUDIO_SAMPLE_8K;

/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/
extern SINT32 zDrvVp_SetExtAudioCfg(T_ZDrvI2S_Cfg *pI2sNbCfg,T_ZDrvI2S_Cfg *pI2sWbCfg, 
                                  T_ZDrvTdm_Cfg *pTdmNbCfg,T_ZDrvTdm_Cfg *pTdmWbCfg);
extern SINT32 zDrvVp_SetExtI2sCfg(T_ZDrvI2S_Cfg *pI2sNbCfg, T_ZDrvI2S_Cfg *pI2sWbCfg);
extern SINT32 zDrvVp_SetInnerI2sCfg(T_ZDrvI2S_Cfg *pI2sCfg);
extern VOID zDrvVpCfg_SetOperations(T_HalVpCfg_Opt* VpCfg_ObjPtr);
extern SINT32 zDrvAud_DspCfgI2sMode(VOID *pI2sCfg);
extern SINT32 zDrvAud_DspCfgPcmMode(VOID *pPcmCfg);
extern SINT32 zDrvCodec_SetProt(T_ZDrvCodec_Handle handle, T_ZDrvCodec_UseProtocol useProtocal);
//extern VOID zCtrm_InitAudioAt(VOID);
extern UINT32 zCatAgt_Audio_Reg(UINT32 type, UINT32 size, UINT32 addr);
extern SINT32 zDrvVp_GetVoiceState(VOID *pVoiceState);
extern SINT32 zDrvAudio_SetI2sCfg(T_ZDrvI2S_Cfg *pI2sCfg);

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/
#ifdef _CONFIG_DC_USE_CODEC//dual_core version
SINT32 vp_SetInnerI2sMode(BOOL i2smode)
{
	SINT32  ret = DRV_SUCCESS;
#if defined _USE_REF_AUDIO_ON_7510
	UINT32 AmrRegBit = 0;
	AmrRegBit = ARM_I2S_LOOP_SET;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_SetInnerI2sMode start  ARM_I2S_LOOP_SET=%x\n", ARM_I2S_LOOP_SET);

	// inter loop
	AmrRegBit &= 0xfff8fff8;
	if (i2smode == TRUE)
	{

		AmrRegBit |= 0x00050002; //  teak afe--arm i2s2
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_SetInnerI2sMode i2s mode teak afe AmrRegBit=%x\n", AmrRegBit);

	}
	else
	{
		AmrRegBit |= 0x00030002; //  teak i2s1--arm i2s2
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_SetInnerI2sMode pcm mode  teak i2s1 AmrRegBit=%x\n", AmrRegBit);

	}
	ARM_I2S_LOOP_SET = AmrRegBit;
#elif defined _USE_REF_AUDIO_ON_7520V3
	UINT32 AmrRegBit = 0;
	AmrRegBit = ARM_I2S_LOOP_CFG;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_SetInnerI2sMode start  ARM_I2S_LOOP_CFG=%x\n", ARM_I2S_LOOP_CFG);

	// inter loop
	AmrRegBit &= 0xfffffe07;

	if (i2smode == TRUE)
	{

		AmrRegBit |= 0x000000a8; //  teak afe i2s
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_SetInnerI2sMode i2s mode teak afe AmrRegBit=%x\n", AmrRegBit);

	}
	else
	{
		AmrRegBit |= 0x00000098; //  teak i2s1 pcm
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "vp_SetInnerI2sMode pcm mode  teak i2s1 AmrRegBit=%x\n", AmrRegBit);

	}

	ARM_I2S_LOOP_CFG = AmrRegBit;


#endif


	return ret;
}

void halRcvAndEarpSwitch(T_ZDrv_VpPath path)
{
#ifdef _CONFIG_USE_CODEC
	zDrvGpio_SetFunc(audioGpio76Handle, GPIO76_GPIO76);
	zDrvGpio_SetDirection(audioGpio76Handle, GPIO_OUT);
	if (VP_PATH_HANDSET == path)
	{
		zDrvGpio_SetOutputValue(audioGpio76Handle, GPIO_LOW);
	}
	else if (VP_PATH_HEADSET == path)
	{
		zDrvGpio_SetOutputValue(audioGpio76Handle, GPIO_HIGH);
	}
	else if (VP_PATH_SPEAKER == path)
	{
		zDrvGpio_SetOutputValue(audioGpio76Handle, GPIO_LOW);
	}
#endif
}

void halSpkPaSwitch(T_ZDrv_VpPath path)
{
#ifdef _CONFIG_USE_CODEC
	SINT32 i = 0;
	zDrvGpio_SetFunc(audioGpio77Handle, GPIO77_GPIO77);
	zDrvGpio_SetDirection(audioGpio77Handle, GPIO_OUT);

	if (VP_PATH_SPEAKER == path)
	{
		if (s_isClasskOpened == FALSE)
		{
			for (i = 0; i < 3; i++)
			{
				zDrvGpio_SetOutputValue(audioGpio77Handle, GPIO_HIGH);
				udelay(1);

				zDrvGpio_SetOutputValue(audioGpio77Handle, GPIO_LOW);
				udelay(1);
			}
			zDrvGpio_SetOutputValue(audioGpio77Handle, GPIO_HIGH);
			s_isClasskOpened = TRUE;
		}
	}
	else
	{
		zDrvGpio_SetOutputValue(audioGpio77Handle, GPIO_LOW);
		udelay(500);
		s_isClasskOpened = FALSE;
	}
#endif

}


/******************************************************************************
 * Function: zDrvCodec_Initiate
 * Description: open codec, set parameters.
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *   0 if success, not 0 if fail
 *
 * Others:
 ******************************************************************************/
SINT32 zDrvCodec_Initiate(VOID)
{
    //UINT32 armRegBit = 0;//xiu
#ifdef _CONFIG_USE_CODEC

#if defined _USE_REF_AUDIO_ON_7520V3_PHONE

	audioGpioCodecEnHandle = zDrvGpio_Request("codec_pa_en");
	zDrvGpio_SetFunc(audioGpioCodecEnHandle, AUDIO_CODEC_EN_GPIO_FUNC_SEL);
	zDrvGpio_SetDirection(audioGpioCodecEnHandle, GPIO_OUT);
	zDrvGpio_SetOutputValue(audioGpioCodecEnHandle, GPIO_HIGH); //GPIO_LOW
	zOss_Sleep(5);

	audioGpioResetHandle = zDrvGpio_Request("codec_reset");
	zDrvGpio_SetFunc(audioGpioResetHandle, AUDIO_CODEC_RESET_GPIO_FUNC_SEL);
	zDrvGpio_SetDirection(audioGpioResetHandle, GPIO_OUT);
	zDrvGpio_SetOutputValue(audioGpioResetHandle, GPIO_LOW);
	zOss_Sleep(5);
	zDrvGpio_SetOutputValue(audioGpioResetHandle, GPIO_HIGH);
	zOss_Sleep(5);

	audioGpioClkHandle = zDrvGpio_Request("codec_refclk");
	zDrvGpio_SetFunc(audioGpioClkHandle, AUDIO_CODEC_CLK_GPIO_FUNC_SEL);//26MHZ GPIO15_CLK_OUT0
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_setCodecClk 26M!\n");
#elif defined _USE_REF_AUDIO_ON_7520V3_FWP
	audioGpioResetHandle = zDrvGpio_Request("codec_reset");
	zDrvGpio_SetFunc(audioGpioResetHandle, AUDIO_CODEC_RESET_GPIO_FUNC_SEL);
	zDrvGpio_SetDirection(audioGpioResetHandle, GPIO_OUT);
	zDrvGpio_SetOutputValue(audioGpioResetHandle, GPIO_LOW);
	zOss_Sleep(5);
	zDrvGpio_SetOutputValue(audioGpioResetHandle, GPIO_HIGH);
	zOss_Sleep(5);

	audioGpioClkHandle = zDrvGpio_Request("codec_refclk");
	zDrvGpio_SetFunc(audioGpioClkHandle, AUDIO_CODEC_CLK_GPIO_FUNC_SEL);//26MHZ GPIO15_CLK_OUT2
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "[FWP]zDrvI2S_setCodecClk 26M!\n");
#elif defined _USE_REF_AUDIO_ON_7520V3_MDL
	audioGpioClkHandle = zDrvGpio_Request("codec_refclk");
	zDrvGpio_SetFunc(audioGpioClkHandle, AUDIO_CODEC_CLK_GPIO_FUNC_SEL);//26MHZ GPIO17_CLK_OUT2
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_setCodecClk 26M!\n");

#elif defined _USE_REF_AUDIO_ON_7520V2

	audioGpioCodecEnHandle = zDrvGpio_Request("codec_en");
	zDrvGpio_SetFunc(audioGpioCodecEnHandle, AUDIO_CODEC_EN_GPIO_FUNC_SEL);
	zDrvGpio_SetDirection(audioGpioCodecEnHandle, GPIO_OUT);
	zOss_Sleep(5);
	zDrvGpio_SetOutputValue(audioGpioCodecEnHandle, GPIO_HIGH);

	audioGpioResetHandle = zDrvGpio_Request("codec_reset");
	zDrvGpio_SetFunc(audioGpioResetHandle, AUDIO_CODEC_RESET_GPIO_FUNC_SEL);
	zDrvGpio_SetDirection(audioGpioResetHandle, GPIO_OUT);
	zDrvGpio_SetOutputValue(audioGpioResetHandle, GPIO_LOW);
	zOss_Sleep(5);
	zDrvGpio_SetOutputValue(audioGpioResetHandle, GPIO_HIGH);
	zOss_Sleep(5);

	audioGpioClkHandle = zDrvGpio_Request("codec_refclk");
	zDrvGpio_SetFunc(audioGpioClkHandle, AUDIO_CODEC_CLK_GPIO_FUNC_SEL);//26MHZ
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_setCodecClk 26M!\n");
#ifdef _CONFIG_USE_CODEC_EARPIECE_DETECT
//mp3_sw
	audioGpio76Handle = zDrvGpio_Request("mp3_sw");
	halRcvAndEarpSwitch(VP_PATH_HANDSET);
//class k en
	audioGpio77Handle = zDrvGpio_Request("audio_pa_en");
	halSpkPaSwitch(VP_PATH_HANDSET);

#endif

#endif

	codecInitFlag = TRUE;
#endif
	return DRV_SUCCESS;

}
#endif
/*******************************************************************************
 * Function: zDrvVoiceConfig_Init
 * Description: This function is used to initiate voice process
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
extern	SINT32 zDrvVolte_LoopStart(VOID);

SINT32 zDrvVoiceConfig_Init(VOID)
{
	SINT32  ret = DRV_SUCCESS;
	T_Audio_NvFlag audionvflag = {0};
	aud_dsp_dai_configuration_type *p_dspPcmCfg	= NULL;
	aud_dsp_dai_configuration_type *p_dspI2sCfg = NULL;

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " zDrvVoiceConfig_Init audio nv addr=0x%x!\n", OS_FLASH_VOICE_DRV_RW_NONFAC_BASE_ADDR);

	//ret = zDrvNand_Read(OS_FLASH_VOICE_DRV_RW_NONFAC_BASE_ADDR,  sizeof(audionvflag), ((UINT8 *)(&audionvflag)));
	ret = zOss_NvItemRead(OS_FLASH_VOICE_DRV_RW_NONFAC_BASE_ADDR, ((UINT8 *)(&audionvflag)),  sizeof(audionvflag));


	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " zDrvVoiceConfig_Init zOss_NvItemRead isVpParamInNv=%d,isUseSlicCodec=%d,isUseVoiceProc=%d,isUseTdm=%d,isUseEcall=%d!\n", audionvflag.isVpParamInNv, audionvflag.isUseSlicCodec,audionvflag.isUseVoiceProc,audionvflag.isUseTdm,audionvflag.isUseEcall);
	//hal_TestTopI2sConfig();

	if (ret != DRV_SUCCESS)
	{

		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " read the audionvflag failed!\n");
		return DRV_ERROR;
	}

	if (audionvflag.isVpConfigInitOn == 1)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " zDrvVoiceConfig_Init start!\n");

		zDrvVpCfg_SetOperations(&s_vpCfgObjOpt);

		if (s_vpInnerI2sCfg.bMaster == TRUE)
		{
			p_dspPcmCfg = &s_dspPcmSlaveCfg;
			p_dspI2sCfg = &s_dspI2sSlaveCfg;
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "arm InnerI2s Master, dsp I2S Slave !\n");

		}
		else if (s_vpInnerI2sCfg.bMaster == FALSE)
		{
			p_dspPcmCfg = &s_dspPcmMasterCfg;
			p_dspI2sCfg = &s_dspI2sMasterCfg;
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "arm InnerI2s Slave, dsp I2S Master!\n");

		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " s_vpInnerI2sCfg bMaster val err!\n");
			return DRV_ERROR;

		}
#if PS_RAT_GSM
		ret = zDrvAud_DspCfgI2sMode(p_dspI2sCfg);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvAud_DspCfgI2sMode  fail, ret=%d!\n", ret);

			return DRV_ERROR;
		}

		ret = zDrvAud_DspCfgPcmMode(p_dspPcmCfg);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvAud_DspCfgPcmMode  fail, ret=%d!\n", ret);

			return DRV_ERROR;
		}
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " zDrvVoiceConfig_Init s_vpInnerI2sCfg=%p,s_vpExtI2sNbCfg addr=0x%p,s_vpExtI2sWbCfg addr=0x%p!\n", &s_vpInnerI2sCfg, &s_vpExtI2sNbCfg, &s_vpExtI2sWbCfg);
#endif
		zDrvVp_SetInnerI2sCfg(&s_vpInnerI2sCfg);
		/*klocwork 3 INVARIANT_CONDITION.UNREACH  delete if*/
		/*if (ret != DRV_SUCCESS)
		{
			return DRV_ERROR;
		}*/
		if (audionvflag.isUseSlicCodec == 1)
		{
			zDrvVp_SetExtAudioCfg(&s_vpExtI2sNbCfg_slic, &s_vpExtI2sWbCfg_slic, &s_vpTdmNbCfg, &s_vpTdmWbCfg);
		}
		else
		{
			zDrvVp_SetExtAudioCfg(&s_vpExtI2sNbCfg,&s_vpExtI2sWbCfg,&s_vpTdmNbCfg,&s_vpTdmWbCfg_codec);
			//zDrvVp_SetExtAudioCfg(&s_vpExtI2sNbCfg,&s_vpExtI2sWbCfg,&s_vpTdmNbCfg,&s_vpTdmWbCfg);
		}
		/*klocwork 3 INVARIANT_CONDITION.UNREACH  delete if*/
		/*if (ret != DRV_SUCCESS)
		{
			return DRV_ERROR;
		}*/
		if (audionvflag.isCloseVpBufferBak != 1)
		{
#ifndef AUDIO_USE_FIXED_ADDRESS
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_Init Open VpInoutData backup! \n");
/*
			vpInOutBuffer.p_voiceRxInBuffer = (UINT8*)zOss_Malloc(VP_INOUT_BAK_BUFFER_SIZE);
			vpInOutBuffer.p_voiceTxInBuffer = (UINT8*)zOss_Malloc(VP_INOUT_BAK_BUFFER_SIZE);
			vpInOutBuffer.p_voiceRxOutPutBuffer = (UINT8*)zOss_Malloc(VP_INOUT_BAK_BUFFER_SIZE);
			vpInOutBuffer.p_voiceTxOutPutBuffer = (UINT8*)zOss_Malloc(VP_INOUT_BAK_BUFFER_SIZE);
			if ((vpInOutBuffer.p_voiceRxInBuffer == NULL) || (vpInOutBuffer.p_voiceTxInBuffer == NULL) || \
			        (vpInOutBuffer.p_voiceRxOutPutBuffer == NULL) || (vpInOutBuffer.p_voiceTxOutPutBuffer == NULL))
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_Init malloc audio buffer fail ! \n");
				return DRV_ERROR;
			}
*/

			vpInOutBuffer.p_voiceRxInBuffer = (UINT8*)vmalloc(VP_INOUT_BAK_BUFFER_SIZE);
			vpInOutBuffer.p_voiceTxInBuffer = (UINT8*)vmalloc(VP_INOUT_BAK_BUFFER_SIZE);
#ifdef _USE_VP_OUTPUT_RXOUT_DATA
			vpInOutBuffer.p_voiceRxOutPutBuffer = (UINT8*)vmalloc(VP_INOUT_BAK_BUFFER_SIZE);
#else
			vpInOutBuffer.p_voiceRxOutPutBuffer = (UINT8*)vmalloc(VP_INOUT_NOBAK_BUFSIZE);
#endif
			vpInOutBuffer.p_voiceTxOutPutBuffer = (UINT8*)vmalloc(VP_INOUT_BAK_BUFFER_SIZE);
			if ((vpInOutBuffer.p_voiceRxInBuffer == NULL) || (vpInOutBuffer.p_voiceTxInBuffer == NULL) || \
			        (vpInOutBuffer.p_voiceRxOutPutBuffer == NULL) || (vpInOutBuffer.p_voiceTxOutPutBuffer == NULL))
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_Init malloc audio buffer fail ! \n");
				return DRV_ERROR;
			}
						
#endif
			zDrvVp_SetInOutBufferAddSize(&vpInOutBuffer, VP_INOUT_BAK_BUFFER_SIZE);
                     #if 0
			if (ret != DRV_SUCCESS)
			{
				return DRV_ERROR;
			}
			#endif

#if 0
            ret = zCatAgt_Audio_Reg(10,VP_INOUT_BAK_BUFFER_SIZE,(UINT32)vpInOutBuffer.p_voiceRxInBuffer);
            if(ret != DRV_SUCCESS){
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_Init RXIN register zCatAgt_Audio_Reg err\n");
            }
            
			ret = zCatAgt_Audio_Reg(12,VP_INOUT_BAK_BUFFER_SIZE,(UINT32)vpInOutBuffer.p_voiceTxInBuffer);
            if(ret != DRV_SUCCESS){
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_Init TXIN register zCatAgt_Audio_Reg err\n");
            }
            
			ret = zCatAgt_Audio_Reg(13,VP_INOUT_BAK_BUFFER_SIZE,(UINT32)vpInOutBuffer.p_voiceTxOutPutBuffer);
            if(ret != DRV_SUCCESS){
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_Init TXOUT register zCatAgt_Audio_Reg err\n");
            }
            
#ifdef _USE_VP_OUTPUT_RXOUT_DATA
			ret = zCatAgt_Audio_Reg(11, VP_INOUT_BAK_BUFFER_SIZE, (UINT32)vpInOutBuffer.p_voiceRxOutPutBuffer);
            if(ret != DRV_SUCCESS){
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_Init RXOUT register zCatAgt_Audio_Reg err\n");
            }

#else
			ret = zCatAgt_Audio_Reg(11,VP_INOUT_NOBAK_BUFSIZE,(UINT32)vpInOutBuffer.p_voiceRxOutPutBuffer);
            if(ret != DRV_SUCCESS){
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_Init RXOUT register zCatAgt_Audio_Reg err\n");
            }
#endif
#endif
		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_Init Close VpInoutData backup! \n");
#ifndef AUDIO_USE_FIXED_ADDRESS
			vpInOutBuffer.p_voiceRxInBuffer = (UINT8*)zOss_Malloc(VP_INOUT_NOBAK_BUFSIZE);
			vpInOutBuffer.p_voiceTxInBuffer = (UINT8*)zOss_Malloc(VP_INOUT_NOBAK_BUFSIZE);
			vpInOutBuffer.p_voiceRxOutPutBuffer = (UINT8*)zOss_Malloc(VP_INOUT_NOBAK_BUFSIZE);
			vpInOutBuffer.p_voiceTxOutPutBuffer = (UINT8*)zOss_Malloc(VP_INOUT_NOBAK_BUFSIZE);
			if ((vpInOutBuffer.p_voiceRxInBuffer == NULL) || (vpInOutBuffer.p_voiceTxInBuffer == NULL) || \
			        (vpInOutBuffer.p_voiceRxOutPutBuffer == NULL) || (vpInOutBuffer.p_voiceTxOutPutBuffer == NULL))
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_Init malloc audio buffer fail ! \n");
				return DRV_ERROR;
			}
#endif
			zDrvVp_SetInOutBufferAddSize(&vpInOutBuffer, VP_INOUT_NOBAK_BUFSIZE);
			#if 0
			if (ret != DRV_SUCCESS)
			{
				return DRV_ERROR;
			}
			#endif
		}
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voiceRxInBuffer=0x%p\n", vpInOutBuffer.p_voiceRxInBuffer);
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voiceTxInBuffer=0x%p\n", vpInOutBuffer.p_voiceTxInBuffer);
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voiceRxOutBuffer=0x%p\n", vpInOutBuffer.p_voiceRxOutPutBuffer);
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voiceTxOutBuffer=0x%p\n", vpInOutBuffer.p_voiceTxOutPutBuffer);

		//normal version need enable
		ret = zDrvVp_Init();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " zDrvVoiceConfig_Init zDrvVp_Init err!\n");

			return DRV_ERROR;
		}

		zDrvVp_SetInitGain(75);
/*
		ret += zDrvAudio_Initiate();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_Init error: zDrvAudio_Initiate failed ret=%d \n", ret);
			return DRV_ERROR;
		}
		ret = zDrvAudio_SetI2sCfg(&s_vpAudioI2sCfg);
		if (ret != DRV_SUCCESS)
		{
			return DRV_ERROR;
		}		

		zDrvCodec_Initiate();
*/
#ifdef _USE_EARPIECE_FUNCMOUDLE
		ret = zDrvEarp_Initiate();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_Init error: zDrvEarp_Initiate failed ret=%d \n", ret);
			return DRV_ERROR;
		}
#endif

		//testnxp_init();

		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " zDrvVoiceConfig_Init start  END!\n");
		//zDrvVolte_LoopStart();
		//zDrvVp_LoopStart(VP_PATH_SPEAKER);
		
#if 1
        if (audionvflag.isCloseVpBufferBak != 1)
        {
            ret = zCatAgt_Audio_Reg(10,VP_INOUT_BAK_BUFFER_SIZE,(UINT32)vpInOutBuffer.p_voiceRxInBuffer);
            if(ret != DRV_SUCCESS){
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_Init RXIN register zCatAgt_Audio_Reg err\n");
            }
            
            ret = zCatAgt_Audio_Reg(12,VP_INOUT_BAK_BUFFER_SIZE,(UINT32)vpInOutBuffer.p_voiceTxInBuffer);
            if(ret != DRV_SUCCESS){
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_Init TXIN register zCatAgt_Audio_Reg err\n");
            }
            
            ret = zCatAgt_Audio_Reg(13,VP_INOUT_BAK_BUFFER_SIZE,(UINT32)vpInOutBuffer.p_voiceTxOutPutBuffer);
            if(ret != DRV_SUCCESS){
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_Init TXOUT register zCatAgt_Audio_Reg err\n");
            }
            
#ifdef _USE_VP_OUTPUT_RXOUT_DATA
            ret = zCatAgt_Audio_Reg(11, VP_INOUT_BAK_BUFFER_SIZE, (UINT32)vpInOutBuffer.p_voiceRxOutPutBuffer);
            if(ret != DRV_SUCCESS){
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_Init RXOUT register zCatAgt_Audio_Reg err\n");
            }

#else
            ret = zCatAgt_Audio_Reg(11,VP_INOUT_NOBAK_BUFSIZE,(UINT32)vpInOutBuffer.p_voiceRxOutPutBuffer);
            if(ret != DRV_SUCCESS){
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVoiceConfig_Init RXOUT register zCatAgt_Audio_Reg err\n");
            }
#endif
#endif
        }

		return DRV_SUCCESS;
	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " nv close zDrvVoiceConfigInit  !\n");
		return DRV_SUCCESS;
	}

}

/*******************************************************************************
 * Function: zDrvAudioConfig_Init
 * Description: This function is mainly used to Initializing audio related configuration
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
#if 0
SINT32 zDrvAudioConfig_Init(VOID)
{
	SINT32	ret = DRV_SUCCESS;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvAudioConfig_Init \n");
	zDrvVpCfg_SetOperations(&s_vpCfgObjOpt);

	ret = zDrvI2S_Init();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S__Init error.\n");
		return DRV_ERROR;
	}
	vp_SetTopConfig();

	//vp_SetTopI2sConfig();

	zDrvCodec_Initiate();
	ret = zDrvAudio_Initiate();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_Init error: zDrvAudio_Initiate failed ret=%d \n", ret);
		return DRV_ERROR;
	}
	ret = zDrvAudio_SetI2sCfg(&s_vpAudioI2sCfg);
	if (ret != DRV_SUCCESS)
	{
		return DRV_ERROR;
	}
	return DRV_SUCCESS;

}


//output 26MHZ
SINT32 zDrvI2S_setCodecClk(VOID)
{
    //UINT32 AmrRegBit = 0;
#if defined(_USE_REF_AUDIO_ON_7520V3_PHONE)|| defined(_USE_REF_AUDIO_ON_7520V3_FWP)
	audioGpioClkHandle = zDrvGpio_Request("codec_refclk");
	zDrvGpio_SetFunc(audioGpioClkHandle, AUDIO_CODEC_CLK_GPIO_FUNC_SEL);//26MHZ GPIO15_CLK_OUT0
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvI2S_setCodecClk 26M!\n");
#endif

	return DRV_SUCCESS;

}
#endif

/*******************************************************************************
 * Function: halAudioConfig_OpenBegin
 * Description: This function is used to  voice config in the beginning voice open
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/

SINT32 halAudioConfig_Open(T_ZDrvVp_SourceType srctype)
{
	SINT32  ret = DRV_SUCCESS;

#ifdef _CONFIG_USE_CODEC
	T_zDrvVoice_GbVar *p_voiceVar = NULL;
	UINT32 armRegBit = 0;
	T_ZDrvI2S_Cfg *p_vpExtI2sCfg = NULL;
	s_useProtocal.audI2SChannel = AUDIO_I2S0;

	if (srctype == VP_VOICE_SOURCE)
	{
		codecSrcType = VOICE_SOURCE;
		//ext i2s NB and WB, always the same cfg
		p_vpExtI2sCfg = &s_vpExtI2sNbCfg;
	}
	else if (srctype == VP_AUDIO_SOURCE)
	{
		codecSrcType = AUDIO_SOURCE;
		p_vpExtI2sCfg = &s_vpAudioI2sCfg;
	}
	else if (srctype == VP_FM_SOURCE)
	{
		codecSrcType = EXTERN_AUDIO;
		p_vpExtI2sCfg = &s_vpFmI2sCfg;
	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " halAudioConfig_Open srctype=%d not support  !\n", srctype);
		return DRV_SUCCESS;
	}

	if (srctype == VP_VOICE_SOURCE)
	{
		if (s_vpInnerI2sCfg.tClkMode == I2S_TIME_MODE)
		{
			vp_SetInnerI2sMode(TRUE);
		}
		else
		{
			vp_SetInnerI2sMode(FALSE);
		}
	}

	//ext i2s NB and WB, always the same cfg
	if (p_vpExtI2sCfg->bMaster == TRUE)
	{
		s_useProtocal.masterSlave = I2S_SLAVE_MODE;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " halAudioConfig_Open cfg codec I2S_SLAVE_MODE!\n");

	}
	else
	{
		s_useProtocal.masterSlave = I2S_MASTER_MODE;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " halAudioConfig_Open cfg codec I2S_MASTER_MODE!\n");
	}

	if (p_vpExtI2sCfg->tClkMode == I2S_TIME_MODE)
	{
		s_useProtocal.busMode = CODEC_BUS_I2S;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " halAudioConfig_Open cfg codec CODEC_BUS_I2s!\n");
	}
	else if (p_vpExtI2sCfg->tClkMode == PCM_TIME_MODE)
	{
		s_useProtocal.busMode = CODEC_BUS_DSP;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " halAudioConfig_Open cfg codec CODEC_BUS_DSP!\n");
	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " halAudioConfig_Open tClkMode=%d not support!\n", p_vpExtI2sCfg->tClkMode);
	}
#if defined(_USE_REF_AUDIO_ON_7520V3_MDL) || defined(_USE_REF_AUDIO_ON_7520V3_FWP)

	armRegBit = AON_WIFI_BT_CLK_CFG2;
	armRegBit &= 0xfffffffe;
	armRegBit |= 0x1;
	AON_WIFI_BT_CLK_CFG2 = armRegBit;
#endif
	// open 26mhz CLK  for codec
	ret = zDrvI2S_setCodecClk();
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec set refclk err ret=%d !\n", ret);
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec set refclk  !\n");

	ret = zDrvCodec_Open(&gCodecHandle, codecSrcType);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_Open err ret=0x%x !\n", ret);
		//zDrvCodec_Close(&gCodecHandle);
		goto err_exit;
	}

#if !defined(_USE_REF_AUDIO_ON_7520V2) || !defined(_CONFIG_USE_CODEC_EARPIECE_DETECT)  
	ret = zDrvCodec_Reset(gCodecHandle);     // k315 not use
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_Reset err ret=%x !\n", ret);
		zDrvCodec_Close(&gCodecHandle);
		goto err_exit;
	}
#endif

	zOss_Sleep(1);

	ret = zDrvVp_GetVoiceState(&p_voiceVar);
	if ((ret != DRV_SUCCESS) || (p_voiceVar == NULL))
	{
		zDrvCodec_Close(&gCodecHandle);
		goto err_exit;
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_Open  p_voiceVar = 0x%x!\n", p_voiceVar);
	p_voiceVar->muteEn = FALSE;
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_Open  clear mute flag !\n");

	return DRV_SUCCESS;	
err_exit:
	#if defined(_USE_REF_AUDIO_ON_7520V3_MDL) || defined(_USE_REF_AUDIO_ON_7520V3_FWP)
		armRegBit = AON_WIFI_BT_CLK_CFG2;
		armRegBit &= 0xfffffffe;
		armRegBit |= 0x0;
		AON_WIFI_BT_CLK_CFG2 = armRegBit;
	#endif
#endif
	return ret;
}

/*******************************************************************************
 * Function: zDrvVoiceConfig_Close
 * Description: This function is used to  voice config Close.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
SINT32 halAudioConfig_Close(VOID)
{
	SINT32  ret = DRV_SUCCESS;

#ifdef _CONFIG_USE_CODEC
	T_zDrvVoice_GbVar *p_voiceVar = NULL;

	UINT32 armRegBit = 0;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_Close start!\n");
#if !defined(_USE_REF_AUDIO_ON_7520V2) || !defined(_CONFIG_USE_CODEC_EARPIECE_DETECT)
	ret = zDrvCodec_Reset(gCodecHandle);  // k315 not use
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_Close zDrvCodec_Reset err ret=%x !\n", ret);
	}
#endif

	ret += zDrvCodec_Close(&gCodecHandle);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_Close zDrvCodec_Close err ret=%x !\n", ret);
	}

	ret = zDrvVp_GetVoiceState(&p_voiceVar);
	if ((ret != DRV_SUCCESS) || (p_voiceVar == NULL))
	{
		return DRV_ERROR;
	}
	if (p_voiceVar->muteEn == TRUE)
	{
		p_voiceVar->muteEn = FALSE;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_Close  clear mute flag !\n");
	}

#if defined(_USE_REF_AUDIO_ON_7520V2) && defined(_CONFIG_USE_CODEC_EARPIECE_DETECT)
	halRcvAndEarpSwitch(VP_PATH_HANDSET);
	halSpkPaSwitch(VP_PATH_HANDSET);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_Close s_isClasskOpened=0x%x !\n", s_isClasskOpened);
#endif

#ifdef _USE_REF_AUDIO_ON_7520V3_PHONE
	zDrvGpio_SetFunc(audioGpioCodecEnHandle, AUDIO_CODEC_EN_GPIO_FUNC_SEL);
	zDrvGpio_SetDirection(audioGpioCodecEnHandle, GPIO_OUT);
	zDrvGpio_SetOutputValue(audioGpioCodecEnHandle, GPIO_HIGH); //GPIO_LOW
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetOutPath receiver PA close \n");
#endif
#if defined(_USE_REF_AUDIO_ON_7520V3_MDL) || defined(_USE_REF_AUDIO_ON_7520V3_FWP)

	armRegBit = AON_WIFI_BT_CLK_CFG2;
	armRegBit &= 0xfffffffe;
	armRegBit |= 0x0;
	AON_WIFI_BT_CLK_CFG2 = armRegBit;

#endif

	gCodecHandle = 0;

#endif

	return ret;

}

SINT32 halAudioConfig_SetOutputPath(T_ZDrv_VpPath path, BOOL enable)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _CONFIG_USE_CODEC
	//T_ZDrvCodec_OutDevice outdev = AUDIO_OUTPUT_HEADSET;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetOutputPath path=%d !\n", path);


	if (path == VP_PATH_HANDSET)
	{
		s_outDev = AUDIO_OUTPUT_RECEIVER;
	}
	else if (path == VP_PATH_SPEAKER)
	{
		s_outDev = AUDIO_OUTPUT_SPEAKER;
	}
	else if (path == VP_PATH_HEADSET)
	{
		s_outDev = AUDIO_OUTPUT_HEADSET;
	}
	else if (path == VP_PATH_HSANDSPK)
	{
		s_outDev = AUDIO_OUTPUT_HEADSET_SPEAKER;
	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetOutputPath the path not support path=%d !\n", path);
		return DRV_ERROR;
	}


	ret = zDrvCodec_SetOutPath(gCodecHandle, s_outDev, enable);
	if (ret !=  DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_SetOutPath err ret=%d !\n", ret);

		return DRV_ERROR;
	}
#if defined(_USE_REF_AUDIO_ON_7520V2) && defined(_CONFIG_USE_CODEC_EARPIECE_DETECT)
	if (enable == TRUE)
	{
		halRcvAndEarpSwitch(path);
		halSpkPaSwitch(path);
	}
#endif

#ifdef _USE_REF_AUDIO_ON_7520V3_PHONE
	if ((path == VP_PATH_HANDSET) && (enable == TRUE))
	{
		zDrvGpio_SetFunc(audioGpioCodecEnHandle, AUDIO_CODEC_EN_GPIO_FUNC_SEL);
		zDrvGpio_SetDirection(audioGpioCodecEnHandle, GPIO_OUT);
		zDrvGpio_SetOutputValue(audioGpioCodecEnHandle, GPIO_LOW); //GPIO_LOW
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetOutPath receiver PA open \n");
	}
	else
	{
		zDrvGpio_SetFunc(audioGpioCodecEnHandle, AUDIO_CODEC_EN_GPIO_FUNC_SEL);
		zDrvGpio_SetDirection(audioGpioCodecEnHandle, GPIO_OUT);
		zDrvGpio_SetOutputValue(audioGpioCodecEnHandle, GPIO_HIGH); //GPIO_HIGH
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetOutPath receiver PA close \n");
	}
#endif

#endif
	return DRV_SUCCESS;
}

/*******************************************************************************
 * Function: zDrvVoiceConfig_Enable
 * Description: This function is used to Enable voice config
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
SINT32 halAudioConfig_Enable(VOID)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _CONFIG_USE_CODEC

	ret = zDrvCodec_AudioEnable(gCodecHandle);

	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_Enable zDrvCodec_AudioEnable error ret=%x!\n", ret);
		zDrvCodec_Close(&gCodecHandle);
		return DRV_ERROR;
	}
#endif
	return ret;
}
/*******************************************************************************
 * Function: zDrvVoiceConfig_Disable
 * Description: This function is used to Disable voice config
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/
SINT32 halAudioConfig_Disable(VOID)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _CONFIG_USE_CODEC
	ret = zDrvCodec_AudioDisable(gCodecHandle);

	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_Disable zDrvCodec_AudioDisable error ret=%x!\n", ret);
	}
#if defined(_USE_REF_AUDIO_ON_7520V2) && defined(_CONFIG_USE_CODEC_EARPIECE_DETECT)

	ret = zDrvCodec_SetInPath(gCodecHandle, s_inDev, FALSE);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_Disable zDrvCodec_SetInPath error ret=%x!\n", ret);
	}
	ret += zDrvCodec_SetOutPath(gCodecHandle, s_outDev, FALSE);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_Disable zDrvCodec_SetOutPath error ret=%x!\n", ret);
	}
#endif

#endif

	return ret;
}

/*******************************************************************************
 * Function: zDrvVoiceConfig_SetFs
 * Description: This function is used to  Set Fs.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns: success or error code
 *
 *
 * Others:
 ********************************************************************************/

SINT32 halAudioConfig_SetFs(T_ZDrv_VpFs fs)
{

	SINT32  ret = DRV_SUCCESS;

#ifdef _CONFIG_USE_CODEC
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetFs fs=%d !\n", fs);
	if (fs == VP_FS_8000)
	{
		Sample_Fs = AUDIO_SAMPLE_8K;
	}
	else if (fs == VP_FS_16000)
	{
		Sample_Fs = AUDIO_SAMPLE_16K;
	}
	else if (fs == VP_FS_32000)
	{
		Sample_Fs = AUDIO_SAMPLE_32K;
	}
	else if (fs == VP_FS_44100)
	{
		Sample_Fs = AUDIO_SAMPLE_44_1K;
	}
	else if (fs == VP_FS_48000)
	{
		Sample_Fs = AUDIO_SAMPLE_48K;
	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetFs the fs not support  !\n");
		zDrvCodec_Close(&gCodecHandle);
		return DRV_ERROR;
	}

	ret = zDrvCodec_SetClock(gCodecHandle, Sample_Fs);

	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_SetClock err ret=0x%x !\n", ret);
		zDrvCodec_Close(&gCodecHandle);
		return DRV_ERROR;
	}

	if (codecSrcType == AUDIO_SOURCE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetFs zDrvCodec_SetOut_Hpf fs=%d !\n", fs);
		ret = zDrvCodec_SetOut_Hpf(gCodecHandle, Sample_Fs, 1);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_SetOut_Hpf err ret=0x%x !\n", ret);
			zDrvCodec_Close(&gCodecHandle);
			return DRV_ERROR;
		}
	}

	//ret += zDrvCodec_SetProtocal (gCodecHandle, AUDIO_I2S1, I2S_SLAVE_MODE);
	if (codecSrcType == VOICE_SOURCE)
	{
		ret = zDrvCodec_SetProt(gCodecHandle, s_useProtocal);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_SetProtocal err ret=0x%x !\n", ret);
			zDrvCodec_Close(&gCodecHandle);
			return ret;
		}
	}

#endif
	return ret;
}

SINT32 halAudioConfig_SetInputPath(T_ZDrv_VpPath path, BOOL enable)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _CONFIG_USE_CODEC
	//T_ZDrvCodec_InDevice indev = AUDIO_INPUT_HEADSET;

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetInputPath path=%d !\n", path);

	if (path == VP_PATH_HANDSET)
	{
		s_inDev = AUDIO_INPUT_HANDSET;
	}
	else if (path == VP_PATH_SPEAKER)
	{
		s_inDev = AUDIO_INPUT_SPEAKER;
	}
	else if (path == VP_PATH_HEADSET)
	{
		s_inDev = AUDIO_INPUT_HEADSET;
	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetInputPath the path not support path=%d !\n", path);
		return DRV_ERROR;
	}

	ret = zDrvCodec_SetInPath(gCodecHandle, s_inDev, enable);

#if !defined(_USE_REF_AUDIO_ON_7520V2) || !defined(_CONFIG_USE_CODEC_EARPIECE_DETECT)
	if (enable == TRUE)
	{
		ret += zDrvCodec_SetMicBias(gCodecHandle, MICBIAS_OUT_2_5V);    // k315 not use
	}

#endif

	if (ret !=  DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_SetInPath err ret=%d !\n", ret);

		return DRV_ERROR;
	}
#if 0
	ret = zDrvCodec_Set_Inpath_Dig_Vol(gCodecHandle, CODEC_INPATH_DIG_GAIN_PLUS_15DB);
	if (ret !=  DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_Set_Inpath_Dig_Vol err ret=%d !\n", ret);

		return DRV_ERROR;
	}
#endif

#endif
	return DRV_SUCCESS;
}

SINT32 halAudioConfig_SetMute(T_ZDrv_VpPath path, BOOL mute)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _CONFIG_USE_CODEC
	ret = zDrvCodec_SetOutpathMute(gCodecHandle, mute);
	if (ret !=	DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetMute err ret=%d !\n", ret);
	}
#endif

	return ret;
}

SINT32 halAudioConfig_SetFmPath(T_ZDrv_VpPath path, BOOL enable)
{
	SINT32  ret = DRV_SUCCESS;

#ifdef _CONFIG_USE_CODEC
    //T_ZDrvCodec_SourceType codecSrcType = EXTERN_AUDIO;//xiu
	T_ZDrvCodec_InDevice indev;
	T_ZDrvCodec_OutDevice outdev ;

	if (path == VP_PATH_HEADSET)
	{
		indev = AUDIO_INPUT_FM_ANATOANA;
		outdev = AUDIO_OUTPUT_FM_ANATOANA_HEADSET;
		//set codec  vspker ldo en

	}
	else if (path == VP_PATH_SPEAKER)
	{
		indev = AUDIO_INPUT_FM_ANATOANA;
		outdev = AUDIO_OUTPUT_FM_ANATOANA_SPEAKER;
		//set codec  vspker ldo en

	}
	else
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetFmPath the input path not support path=%d !\n", path);
		return DRV_ERROR;
	}
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " halAudioConfig_SetFmPath  !\n");
	if (enable == TRUE)
	{

		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetFmPath enable path=%d,enable=%d!\n", path, enable);
		if (s_isFmOpened == FALSE)
		{
			ret = halAudioConfig_Open(VP_FM_SOURCE);
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_Open err ret=0x%x !\n", ret);
				// zDrvCodec_Close(&gCodecHandle);

				return ret;
			}
#if 0
			ret += zDrvCodec_Reset(gCodecHandle);
			if (ret != DRV_SUCCESS)
			{
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_Reset err ret=%x !\n", ret);
				zDrvCodec_Close(&gCodecHandle);

				return ret;
			}
#endif
		}
		
#if defined(_USE_REF_AUDIO_ON_7520V2) && defined(_CONFIG_USE_CODEC_EARPIECE_DETECT)
		halRcvAndEarpSwitch(path);
		halSpkPaSwitch(path);
#endif
		ret = zDrvCodec_SetInPath(gCodecHandle, indev, enable);

		if (ret !=	DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetFmPath input path err ret=%d !\n", ret);
			zDrvCodec_Close(&gCodecHandle);

			return DRV_ERROR;
		}
		ret = zDrvCodec_SetOutPath(gCodecHandle, outdev, enable);
		if (ret !=	DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetFmPath output path err ret=%d !\n", ret);
			zDrvCodec_Close(&gCodecHandle);

			return DRV_ERROR;
		}
	}
	else if (s_isFmOpened == TRUE)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetFmPath disable !\n");
#if defined(_USE_REF_AUDIO_ON_7520V2) && defined(_CONFIG_USE_CODEC_EARPIECE_DETECT)
		ret = zDrvCodec_SetInPath(gCodecHandle, indev, enable);

		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_Disable zDrvCodec_SetInPath error ret=%x!\n", ret);
		}
		ret = zDrvCodec_SetOutPath(gCodecHandle, outdev, enable);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_Disable zDrvCodec_SetOutPath error ret=%x!\n", ret);
		}
#endif

		ret = halAudioConfig_Close();
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_Close zDrvCodec_Close err ret=%x !\n", ret);
		}

	}

	s_isFmOpened = enable;

#endif

	return DRV_SUCCESS;
}
SINT32 halAudioConfig_SetLoopback(BOOL enable)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _CONFIG_USE_CODEC
	ret = zDrvCodec_SetLoopBack(gCodecHandle, enable);
	if (ret !=  DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetLoopback err ret=%d !\n", ret);

		return DRV_ERROR;
	}
#endif
    ret = DRV_SUCCESS;//xiu warning:unused ret
    return ret;//xiu
}
SINT32 halAudioConfig_SetInputVol(T_ZDrv_VpVol vol)
{
	SINT32  ret = DRV_SUCCESS;

#ifdef _CONFIG_USE_CODEC

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetInputVol vol=%d !\n", vol);

	ret = zDrvCodec_Set_Inpath_Dig_Vol(gCodecHandle, vol);

	if (ret !=  DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_Set_Inpath_Dig_Vol err ret=%d !\n", ret);
		return DRV_ERROR;
	}


#endif
	return DRV_SUCCESS;
}


SINT32 halAudioConfig_SetOutputVol(T_ZDrv_VpVol vol)
{
	SINT32  ret = DRV_SUCCESS;

#ifdef _CONFIG_USE_CODEC

	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetOutputVol vol=%d !\n", vol);

	ret = zDrvCodec_Set_Outpath_Dig_Vol(gCodecHandle, vol);

	if (ret !=  DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_SetOutputVol err ret=%d !\n", ret);
		return DRV_ERROR;
	}

#endif

	return DRV_SUCCESS;

}

SINT32 halAudioConfig_SetUseProtocol(T_ZDrvCodec_UseProtocol useProtocol)
{
    SINT32  ret = DRV_SUCCESS;

#ifdef _CONFIG_USE_CODEC
	useProtocol.audI2SChannel = AUDIO_I2S0;
    s_useProtocal = useProtocol;

	if (codecSrcType != VOICE_SOURCE)
	{
		ret = zDrvCodec_SetProt(gCodecHandle, s_useProtocal);
		if (ret != DRV_SUCCESS)
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_SetProt err ret=0x%x !\n", ret);
			zDrvCodec_Close(&gCodecHandle);
			return ret;
		}
	}
#endif

	return ret;
}

SINT32 halAudioConfig_GetMixerToneInfo(T_ZDrvVp_ToneNum toneNum, T_HalMixerToneInfo *toneInfo)
{
	SINT32  ret = DRV_SUCCESS;
	T_zDrvVoice_GbVar *p_voiceVar = NULL;
	ret = zDrvVp_GetVoiceState(&p_voiceVar);

	if (p_voiceVar == NULL) /*klocwork 3 INVARIANT_CONDITION.UNREACH  delete (ret!=DRV_SUCCESS)*/
	{
		return DRV_ERROR;
	}

	if ((p_voiceVar->voiceInVolteMode == 1) && (p_voiceVar->volteIsWb == 1))
	{

		toneInfo->dataIsWb = TRUE;

	}
	else
	{
		toneInfo->dataIsWb = FALSE;

	}
	if (toneInfo->dataIsWb == TRUE)
	{
		if (0 == toneNum)
		{
			toneInfo->ptdata_mixer = (UINT16 *)lowPowerPcm_16k;
			//mixerToneInfo.tone_total_size=sizeof(lowPowerPcm)/sizeof(char);
			toneInfo->tone_total_size = sizeof(lowPowerPcm_16k) / sizeof(UINT16);

		}
		else if (1 == toneNum)
		{
			toneInfo->ptdata_mixer = (UINT16 *)smsPcm_16k;
			toneInfo->tone_total_size = sizeof(smsPcm_16k) / sizeof(UINT16);
		}
		else if (2 == toneNum)
		{
			toneInfo->ptdata_mixer = (UINT16 *)callStandardPcm_16k;
			toneInfo->tone_total_size = sizeof(callStandardPcm_16k) / sizeof(UINT16);
		}
		else if (3 == toneNum)
		{
			toneInfo->ptdata_mixer = (UINT16 *)alarmBeepPcm_16k;
			toneInfo->tone_total_size = sizeof(alarmBeepPcm_16k) / sizeof(UINT16);
		}
		else if (4 == toneNum)
		{
			toneInfo->ptdata_mixer = (UINT16 *)callTimePcm_16k;
			toneInfo->tone_total_size = sizeof(callTimePcm_16k) / sizeof(UINT16);
		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_ToneMixerStart para is error!");
			return DRV_ERROR;
		}
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_GetMixerToneInfo toneInfo->ptdata_mixer=%p,L(toneInfo->ptdata_mixer)=%d!\n", toneInfo->ptdata_mixer, sizeof(toneInfo->ptdata_mixer));


	}
	else
	{
		if (0 == toneNum)
		{
			toneInfo->ptdata_mixer = (UINT16 *)lowPowerPcm;
			//mixerToneInfo.tone_total_size=sizeof(lowPowerPcm)/sizeof(char);
			toneInfo->tone_total_size = sizeof(lowPowerPcm) / sizeof(UINT16);

		}
		else if (1 == toneNum)
		{
			toneInfo->ptdata_mixer = (UINT16 *)smsPcm;
			toneInfo->tone_total_size = sizeof(smsPcm) / sizeof(UINT16);
		}
		else if (2 == toneNum)
		{
			toneInfo->ptdata_mixer = (UINT16 *)callStandardPcm;
			toneInfo->tone_total_size = sizeof(callStandardPcm) / sizeof(UINT16);
		}
		else if (3 == toneNum)
		{
			toneInfo->ptdata_mixer = (UINT16 *)alarmBeepPcm;
			toneInfo->tone_total_size = sizeof(alarmBeepPcm) / sizeof(UINT16);
		}
		else if (4 == toneNum)
		{
			toneInfo->ptdata_mixer = (UINT16 *)callTimePcm;
			toneInfo->tone_total_size = sizeof(callTimePcm) / sizeof(UINT16);
		}
		else
		{
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_ToneMixerStart para is error!");
			return DRV_ERROR;
		}
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_GetMixerToneInfo toneInfo->ptdata_mixer=%p,L(toneInfo->ptdata_mixer)=%d!\n", toneInfo->ptdata_mixer, sizeof(toneInfo->ptdata_mixer));
	}


	toneInfo->inter_mixer_fcount = toneInfo->tone_total_size / toneInfo->data_mixer_oncesize;
	toneInfo->rem_mixer_count = toneInfo->tone_total_size % toneInfo->data_mixer_oncesize;

	return DRV_SUCCESS;
}



#if 0
SINT32 halAudioConfig_GetAudioLoopInfo(T_HalAudioLoopTestInfo *audioInfo)
{
	SINT32  ret = DRV_SUCCESS;
	audioInfo->fs = 2000;
	audioInfo->sampFs = 8000;
	audioInfo->ptdata = (UINT8 *)buffer2k8000; //buffer1k//xiu
	audioInfo->totalSize = 2250;
	audioInfo->outpathvol[0] = VP_VOL_8;
	audioInfo->outpathvol[1] = VP_VOL_9; //org : VP_VOL_8
	audioInfo->outpathvol[2] = VP_VOL_11;
	audioInfo->outpathvol[3] = VP_VOL_11;

	return ret;
}
SINT32 halAudioConfig_GetAudioLoopResult(T_HalAudioLoopTestPra *audioPra)
{
	SINT32  ret = DRV_ERROR, i = 0;
	UINT8 testCount = 0, testSucessCount = 0;
	zDrvVp_Freqfft temp = {0};
	DOUBLE freq[20] = {0};
	DOUBLE freqAmp[20] = {0};
	DOUBLE toneRealFreq = 2000;
	testCount = 20;
#ifdef _CONFIG_USE_CODEC
	zDrvCodec_Set_Inpath_Ana_Vol(gCodecHandle, 0);
	zDrvCodec_Set_Inpath_Dig_Vol(gCodecHandle, VP_VOL_3);
#endif
	while (testCount > 0)
	{
		//todo

		zOss_Memcpy(audioPra->dest, audioPra->src, 2048); //2048byte

		cal_freq_fft((SINT16 *)audioPra->dest,&temp,1024,audioPra->sampfs);//1024 point fft//xiu

		freq[testCount - 1] = temp.freqValue;
		freqAmp[testCount - 1] = temp.freqAmp;
		if (((fabs(freq[testCount - 1] - toneRealFreq)) < 50) && (freqAmp[testCount - 1] > 300))
		{
			testSucessCount++;
			if (testSucessCount >= 5)
			{
				zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "testSucessCount=%d!\n", testSucessCount);
				ret = DRV_SUCCESS;
				testCount--;
				break;
			}
		}
		testCount--;
		zOss_Sleep(100);
	}


	for (i = 19; i >= testCount; i--)
	{
		zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "zDrvVp_TestAudioLoopPath freq[%d]=%f freqAmp =%f!\n", i, freq[i], freqAmp[i]);
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_TestAudioLoopPath freq[%d]=%f freqAmp =%f!\n", i, freq[i], freqAmp[i]);

	}
	return ret;
}
#endif

#ifdef _CONFIG_DC_USE_CODEC//dual_core version

SINT32 halAudioConfig_ReadReg(UINT16 regPage, UINT16 regAddress, UINT16 *regValue)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _CONFIG_USE_CODEC
	ret = zDrvCodec_Read(regPage, regAddress, regValue);
	if (ret !=	DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_ReadReg err ret=%d !\n", ret);
	}
#endif
	return ret;
}

SINT32 halAudioConfig_WriteReg(UINT16 regPage, UINT16 regAddress, UINT16 regValue, UINT16 regMask)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _CONFIG_USE_CODEC
	ret = zDrvCodec_Write(regPage, regAddress, regValue, regMask);
	if (ret !=	DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "halAudioConfig_WriteReg err ret=%d !\n", ret);
	}
#endif
	return ret;
}

SINT32 halAudioConfig_DumpReg(VOID)
{
	SINT32  ret = DRV_SUCCESS;
#ifdef _CONFIG_USE_CODEC
	ret = zDrvCodec_DumpReg();
	if (ret !=	DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvCodec_DumpReg err ret=%d !\n", ret);
	}
#endif
	return ret;
}
#endif

