
#include <ctype.h>

int b64_pton(const char *src, unsigned char *dst, int dstsiz)
{
    int i, j, k;
    unsigned int val3 = 0;
    const char b64_tbl[] =
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3e\xff\xff\xff\x3f"
        "\x34\x35\x36\x37\x38\x39\x3a\x3b\x3c\x3d\xff\xff\xff\x00\xff\xff"
        "\xff\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e"
        "\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\xff\xff\xff\xff\xff"
        "\xff\x1a\x1b\x1c\x1d\x1e\x1f\x20\x21\x22\x23\x24\x25\x26\x27\x28"
        "\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30\x31\x32\x33\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff";

    for (i = j = k = 0; src[i] != '\0'; i++) {
        if (isspace(src[i]))
            continue;
        if (b64_tbl[(unsigned char)src[i]] == (char)0xff)
            return(-1);
        val3 |= b64_tbl[(unsigned char)src[i]];
        if (src[i] != '=') {
            if (dst != 0 && k >= dstsiz)
                return (-1);
            if (j % 4 == 1) {
                if (dst != 0)
                    dst[k] = val3 >> 4;
                k++;
            } else if (j % 4 == 2) {
                if (dst != 0)
                    dst[k] = val3 >> 2;
                k++;
            } else if (j % 4 == 3) {
                if (dst != 0)
                    dst[k] = val3;
                k++;
            }
        }
        val3 <<= 6;
        j++;
    }
    if (j % 4 != 0)
        return (-1);

    return (k);
}
