/*
 * Copyright (c) 2024, ASR Micro Limited. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef ASR_TEE_SIP
#define ASR_TEE_SIP

#ifndef CONFIG_CPU_ASR1901
int asr_tee_cpu_power_down(unsigned int cpu, unsigned long entry_point);
int asr_tee_system_suspend(unsigned long entry_point);
#else
int asr_tee_cpu_power_down(u32 state, unsigned long entry_point);
int asr_tee_cluster_power_down(u32 state, unsigned long entry_point);
int asr_tee_cache_disable(int last_man, int lpm_state);
int asr_tee_cpu_power_on(unsigned int cpu, unsigned int cluster,
				unsigned int entry_point);
#endif

unsigned long asr_mfpr_udr_cfg_add(unsigned long offset, unsigned long value);

unsigned long asr_mfpr_udr_cfg_init(unsigned long num);

unsigned long asr_wakeup_state_set(unsigned long state);

unsigned int asr_ciu_read(unsigned int offset);
void asr_ciu_write(unsigned int offset, unsigned int val);
unsigned long asr_wake_status_init(unsigned long status_addr);
unsigned long asr_gpio_edge_detect_add(unsigned long gpio);
unsigned long asr_gpio_edge_detect_remove(unsigned long gpio);
unsigned long asr_gpio_edge_detect_disable(unsigned long gpio);
unsigned long asr_gpio_edge_detect_enable(unsigned long gpio);
unsigned long asr_gpio_edge_detect_clear(unsigned long gpio);
unsigned long asr_irq_wake_set(unsigned long irq, unsigned long on);


#endif /* ASR_TEE_SIP */
