/* SPDX-License-Identifier: GPL-2.0 */
#ifndef __CLK_MMP_H
#define __CLK_MMP_H

#include <linux/types.h>

#define DUMMY_VL_TO_KHZ(level) (((level)+1)*1000)
#define DUMMY_VL_TO_HZ(level) (((level)+1)*1000000)

/* supported maximum core frequency type */
enum max_corefreq_type {
	CORE_1248M = 1,
	CORE_1475M,
	CORE_TYPE_MAX,
};

enum {
	CORE_1p2G = 1183,
	CORE_1p25G = 1248,
	CORE_1p5G = 1482,
};

extern unsigned long max_freq;

extern void pxa168_clk_init(phys_addr_t mpmu_phys,
			    phys_addr_t apmu_phys,
			    phys_addr_t apbc_phys);
extern void pxa910_clk_init(phys_addr_t mpmu_phys,
			    phys_addr_t apmu_phys,
			    phys_addr_t apbc_phys,
			    phys_addr_t apbcp_phys);
extern void mmp2_clk_init(phys_addr_t mpmu_phys,
			  phys_addr_t apmu_phys,
			  phys_addr_t apbc_phys);

extern int sdh_tunning_updatefreq(unsigned int dvfs_level);
extern int sdh_tunning_savefreq(void);
extern int sdh_tunning_restorefreq(void);
extern void plat_set_vl_min(u32 vl_num);
extern void plat_set_vl_max(u32 vl_num);
extern unsigned int plat_get_vl_min(void);
extern unsigned int plat_get_vl_max(void);

extern unsigned int get_chipprofile(void);
extern unsigned int get_iddq_105(void);
extern unsigned int get_iddq_130(void);
unsigned int get_ddr_op_num(void);
unsigned int get_ddr_op_rate(unsigned int index);
unsigned int __clk_periph_get_opnum(struct clk *clk);
unsigned long __clk_periph_get_oprate(struct clk *clk, unsigned int index);

#endif
