/*
 * Marvell 88PM80x Interface
 *
 * Copyright (C) 2012 Marvell International Ltd.
 * Qiao Zhou <zhouqiao@marvell.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __LINUX_MFD_88PM801_H
#define __LINUX_MFD_88PM801_H

enum {
	PM801_ID_BUCK1 = 0,
	PM801_ID_BUCK2,
	PM801_ID_BUCK3,
	PM801_ID_BUCK4,
	PM801_ID_BUCK5,

	PM801_ID_LDO1,
	PM801_ID_LDO2,
	PM801_ID_LDO3,
	PM801_ID_LDO4,
	PM801_ID_LDO5,
	PM801_ID_LDO6,

	PM801_ID_VOUTSW,

	PM801_ID_RG_MAX,
};

enum {
	PM801_NO_GPIO = -1,
	PM801_GPIO0 = 0,
	PM801_GPIO1,
	PM801_GPIO2,
	PM801_GPIO3,
	PM801_GPIO4,
};

enum {
	PM801_NO_GPADC = -1,
	PM801_GPADC0 = 0,
	PM801_GPADC1,
};

/* page 0 basic: slave adder 0x60 */
#define PM801_STATUS_1			(0x01)
#define PM801_ONKEY_STS1		(1 << 0)
#define PM801_EXTON1_STS1		(1 << 1)
#define PM801_EXTON2_STS1			(1 << 2)
#define PM801_BAT_STS1			(1 << 3)
#define PM801_LDO_PGOOD_STS1	(1 << 5)
#define PM801_BUCK_PGOOD_STS1	(1 << 6)

#define PM801_STATUS_2			(0x02)
#define PM801_RTC_ALARM_STS2	(1 << 0)

/* Wakeup Registers */
#define PM801_WAKEUP1		(0x0D)
#define PM801_SW_PDOWN			(1 << 5)

#define PM801_WAKEUP2		(0x0E)
#define PM801_WAKEUP2_INV_INT		(1 << 0)
#define PM801_WAKEUP2_INT_CLEAR		(1 << 1)
#define PM801_WAKEUP2_INT_MASK		(1 << 2)

#define PM801_POWER_UP_LOG	(0x10)

/* RTC Registers */
#define PM801_RTC_CONTROL		(0xD0)
#define PM801_RTC_COUNTER1		(0xD1)
#define PM801_RTC_COUNTER2		(0xD2)
#define PM801_RTC_COUNTER3		(0xD3)
#define PM801_RTC_COUNTER4		(0xD4)
#define PM801_RTC_EXPIRE1_1		(0xD5)
#define PM801_RTC_EXPIRE1_2		(0xD6)
#define PM801_RTC_EXPIRE1_3		(0xD7)
#define PM801_RTC_EXPIRE1_4		(0xD8)
//#define PM801_RTC_TRIM1			(0xD9)
//#define PM801_RTC_TRIM2			(0xDA)
//#define PM801_RTC_TRIM3			(0xDB)
//#define PM801_RTC_TRIM4			(0xDC)
#define PM801_RTC_EXPIRE2_1		(0xDD)
#define PM801_RTC_EXPIRE2_2		(0xDE)
#define PM801_RTC_EXPIRE2_3		(0xDF)
#define PM801_RTC_EXPIRE2_4		(0xE0)
#define PM801_RTC_MISC1			(0xE1)
#define PM801_RTC_MISC2			(0xE2)
#define PM801_RTC_MISC3			(0xE3)
#define PM801_RTC_MISC4			(0xE4)
#define PM801_RTC_MISC5			(0xE7)

#define PM801_PD_LOG_REG1			(0xE5)
#define PM801_PD_LOG_REG2			(0xE6)

/* bit definitions of RTC Register 1 (0xD0) */
#define PM801_ALARM1_EN			(1 << 0)
#define PM801_ALARM_WAKEUP		(1 << 4)
#define PM801_ALARM			(1 << 5)
#define PM801_RTC1_USE_XO		(1 << 7)

#define PM801_RTC_MISC6			(0xE8)
#define PM801_RTC_MISC7			(0xE9)

/*for save RTC offset*/
#define PM801_USER_DATA1		(0xEA)
#define PM801_USER_DATA2		(0xEB)
#define PM801_USER_DATA3		(0xEC)
#define PM801_USER_DATA4		(0xED)
#define PM801_USER_DATA5		(0xEE)
#define PM801_USER_DATA6		(0xEF)

#define PM801_POWER_DOWN_LOG1	(0xE5)
#define PM801_POWER_DOWN_LOG2	(0xE6)

/* page 2 GPADC: slave adder 0x02 */
#define PM801_GPADC_MEAS_EN1		(0x01)
#define PM801_MEAS_EN1_VLDOIN         (1 << 2)
#define PM801_MEAS_EN1_VBBAT         (1 << 0)
#define PM801_GPADC_MEAS_EN2		(0x02)
#define PM801_MEAS_EN2_RFTMP        (1 << 0)
#define PM801_MEAS_PMODE_EN			(1 << 1)
#define PM801_MEAS_GP0_EN			(1 << 2)
#define PM801_MEAS_GP1_EN			(1 << 3)

#define PM801_GPADC_MISC_CONFIG2	(0x06)
#define PM801_GPADC_MISC_GPFSM_EN	(1 << 0)
#define PM801_GPADC_SLOW_MODE(x)	(x << 3)

#define PM801_GPADC_MEASURE_OFF1	(0x07)
#define PM801_GPADC_MEASURE_OFF2	(0x08)
#define PM801_BD_PREBIAS		(1 << 4)
#define PM801_BD_EN			(1 << 5)
#define PM801_BD_GP1_EN			(1 << 6)

#define PM801_GPADC_BIAS1			(0x0B)
#define PM801_GPADC_BIAS2			(0x0C)

#define GP_BIAS_SET(x)				(x << 0)
#define GP_PREBIAS(x)				(x << 4)

#define PM801_GPADC_PREBIAS1			(0x0F)
#define PM801_GPADC0_GP_PREBIAS_TIME(x)	(x << 0)
#define PM801_GPADC_PREBIAS2			(0x10)

#define PM801_GP_BIAS_ENA1				(0x14)
#define PM801_GPADC_GP_BIAS_EN0			(1 << 0)
#define PM801_GPADC_GP_BIAS_EN1			(1 << 1)

#define PM801_GPADC_GP_BIAS_OUT0		(1 << 4)
#define PM801_GPADC_GP_BIAS_OUT1		(1 << 5)


#define PM801_VLDOIN_LOW_TH		0x19
#define PM801_TINT_LOW_TH		0x1B

#define PM801_GPADC0_LOW_TH		0x20
#define PM801_GPADC1_LOW_TH		0x21

#define PM801_VLDOIN_HIGH_TH	0x29
#define PM801_TINT_HIGH_TH		0x2B

#define PM801_GPADC0_HIGH_TH	0x30
#define PM801_GPADC1_HIGH_TH	0x31

#define PM801_VSYS_MEAS1		0x44
#define PM801_VSYS_MEAS2		0x45
#define PM801_TINT_MEAS1		0x50
#define PM801_TINT_MEAS2		0x51

#define PM801_GPADC0_MEAS1		0x54
#define PM801_GPADC0_MEAS2		0x55
#define PM801_GPADC1_MEAS1		0x56
#define PM801_GPADC1_MEAS2		0x57

#define PM801_VLDOIN_AVG1		0xA2
#define PM801_VLDOIN_AVG2		0xA3

/* BUCK Sleep Mode Register 1: BUCK[1..4] */
#define PM801_BUCK_SLP1		(0x5A)
#define PM801_BUCK1_SLP1_SHIFT	0
#define PM801_BUCK1_SLP1_MASK	(0x3 << PM800_BUCK1_SLP1_SHIFT)
#define PM801_BUCK2_SLP1_SHIFT	2
#define PM801_BUCK2_SLP1_MASK	(0x3 << PM800_BUCK2_SLP1_SHIFT)

#define PM801_BUCK_SLP_PWR_OFF	0x0	/* power off */
#define PM801_BUCK_SLP_PWR_ACT1	0x1	/* auto & VBUCK_SET_SLP */
#define PM801_BUCK_SLP_PWR_LOW	0x2	/* VBUCK_SET_SLP */
#define PM801_BUCK_SLP_PWR_ACT2	0x3	/* auto & VBUCK_SET */

/* BUCK Sleep Mode Register 2: BUCK5 */
#define PM801_BUCK_SLP2		(0x5B)
#define PM801_BUCK5_SLP2_SHIFT	0
#define PM801_BUCK5_SLP2_MASK	(0x3 << PM800_BUCK5_SLP2_SHIFT)

/* LDO Sleep Mode Register */
#define PM801_LDO_SLP1		(0x5c)
#define PM801_LDO_SLP2		(0x5d)
#define PM801_LDO_SLP3		(0x5e)
#define PM801_LDO_SLP4		(0x5f)
#define PM801_LDO_SLP5		(0x60)

#ifdef CONFIG_MFD_88PM801
extern int pm801_extern_read(int page, int reg);
extern int pm801_extern_write(int page, int reg, unsigned char val);
extern int pm801_extern_setbits(int page, int reg,
			 unsigned char mask, unsigned char val);
#endif
extern int dvc_flag;
#endif /* __LINUX_MFD_88PM80X_H */
