/*
 * ASR 88PM802 Interface
 *
 * Copyright 2018 ASR Microelectronics (Shanghai) Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __LINUX_MFD_88PM802_H
#define __LINUX_MFD_88PM802_H

#define	PM802_BASE_PAGE		1
#define	PM802_POWER_PAGE	2
#define	PM802_GPADC_PAGE	3

enum {
	PM802_ID_BUCK1 = 0,
	PM802_ID_BUCK2,
	PM802_ID_BUCK3,
	PM802_ID_BUCK4,
	PM802_ID_BUCK5,

	PM802_ID_LDO1,
	PM802_ID_LDO2,
	PM802_ID_LDO3,
	PM802_ID_LDO4,
	PM802_ID_LDO5,
	PM802_ID_LDO6,

	PM802_ID_VOUTSW,

	PM802_ID_RG_MAX,
};

enum {
	PM802_NO_GPIO = -1,
	PM802_GPIO0 = 0,
	PM802_GPIO1,
	PM802_GPIO2,
	PM802_GPIO3,
	PM802_GPIO4,
};

enum {
	PM802_NO_GPADC = -1,
	PM802_GPADC0 = 0,
	PM802_GPADC1,
};

/* page 0 basic: slave adder 0x60 */
#define PM802_STATUS_1			(0x01)
#define PM802_ONKEY_STS1		(1 << 0)
#define PM802_EXTON1_STS1		(1 << 1)
#define PM802_EXTON2_STS1		(1 << 2)
#define PM802_BAT_STS1			(1 << 3)
#define PM802_LDO_PGOOD_STS1	(1 << 5)
#define PM802_BUCK_PGOOD_STS1	(1 << 6)

#define PM802_STATUS_2			(0x02)
#define PM802_RTC_ALARM_STS2	(1 << 0)

/* Wakeup Registers */
#define PM802_WAKEUP1		(0x0D)
#define PM802_SW_PDOWN			(1 << 5)

#define PM802_WAKEUP2		(0x0E)
#define PM802_WAKEUP2_INV_INT		(1 << 0)
#define PM802_WAKEUP2_INT_CLEAR		(1 << 1)
#define PM802_WAKEUP2_INT_MASK		(1 << 2)

#define PM802_POWER_UP_LOG	(0x10)

#define PM802_DUMMY_REG0	(0x15)
#define PM802_DUMMY_REG1	(0x16)
#define PM802_DUMMY_REG2	(0x17)

#define PM802_PWM_CTRL1		(0x40)
#define PM802_PWM_CTRL2		(0x41)
#define PM802_PWM_CTRL3		(0x42)
#define PM802_PWM_CTRL4		(0x43)

#define PM802S_RTC_SPARE0		(0xC0)
#define PM802S_RTC_SPARE1		(0xC1)
#define PM802S_RTC_SPARE2		(0xC2)
#define PM802S_RTC_SPARE3		(0xC3)
#define PM802S_RTC_SPARE4		(0xC4)
#define PM802S_RTC_SPARE5		(0xC5)
#define PM802S_RTC_SPARE6		(0xC6)
#define PM802S_RTC_SPARE7		(0xC7)
#define PM802S_RTC_SPARE8		(0xC8)
#define PM802S_RTC_SPARE9		(0xC9)
#define PM802S_RTC_SPAREA		(0xCA)
#define PM802S_RTC_SPAREB		(0xCB)
#define PM802S_RTC_SPAREC		(0xCC)
#define PM802S_RTC_SPARED		(0xCD)
#define PM802S_RTC_SPAREE		(0xCE)
#define PM802S_RTC_SPAREF		(0xCF)

/* RTC Registers */
#define PM802_RTC_CONTROL		(0xD0)
#define PM802_RTC_COUNTER1		(0xD1)
#define PM802_RTC_COUNTER2		(0xD2)
#define PM802_RTC_COUNTER3		(0xD3)
#define PM802_RTC_COUNTER4		(0xD4)
#define PM802_RTC_EXPIRE1_1		(0xD5)
#define PM802_RTC_EXPIRE1_2		(0xD6)
#define PM802_RTC_EXPIRE1_3		(0xD7)
#define PM802_RTC_EXPIRE1_4		(0xD8)
#define PM802_RTC_TRIM1			(0xD9)
#define PM802_RTC_TRIM2			(0xDA)
#define PM802_RTC_TRIM3			(0xDB)
#define PM802_RTC_TRIM4			(0xDC)
#define PM802_RTC_EXPIRE2_1		(0xDD)
#define PM802_RTC_EXPIRE2_2		(0xDE)
#define PM802_RTC_EXPIRE2_3		(0xDF)
#define PM802_RTC_EXPIRE2_4		(0xE0)
#define PM802_RTC_MISC1			(0xE1)
#define PM802_RTC_MISC2			(0xE2)
#define PM802_RTC_MISC3			(0xE3)
#define PM802_RTC_MISC4			(0xE4)
#define PM802_RTC_MISC5			(0xE7)
#define PM802_RTC_MISC6			(0xE8)
#define PM802_RTC_MISC7			(0xE9)
#define PM802_RTC_MISC8			(0xEA)
#define PM802_RTC_MISC9			(0xEB)
#define PM802_RTC_MISC10		(0xEC)
#define PM802_RTC_MISC11		(0xED)
#define PM802_RTC_MISC12		(0xEF)
#define PM802_RTC_MISC13		(0xF0)
#define PM802_RTC_MISC14		(0xF1)

#define PM802_PD_LOG_REG1			(0xE5)
#define PM802_PD_LOG_REG2			(0xE6)

/* bit definitions of RTC Register 1 (0xD0) */
#define PM802_ALARM1_EN			(1 << 0)
#define PM802_ALARM_WAKEUP		(1 << 4)
#define PM802_ALARM				(1 << 5)
#define PM802_RTC1_USE_XO		(1 << 7)
#define PM802_ALARM_WAKEUP		(1 << 4)

#define PM802_POWER_DOWN_LOG1	(0xE5)
#define PM802_POWER_DOWN_LOG2	(0xE6)

/* page 2 GPADC: slave adder 0x02 */
#define PM802_GPADC_MEAS_EN1		(0x01)
#define PM802_GPADC_MEAS_EN2		(0x02)

#define PM802_MEAS_GP0_EN			(1 << 6)
#define PM802_MEAS_GP1_EN			(1 << 7)
#define PM802_MEAS_VINLDO_EN		(1 << 6)

#define PM802_GPADC_MISC_CONFIG2	(0x06)
#define PM802_GPADC_MISC_GPFSM_EN	(3 << 0)

#define PM802_GPADC_MISC_CONFIG3	(0x0A)

#define PM802_GPADC_BIAS1			(0x0C)
#define PM802_GPADC_BIAS2			(0x0C)

#define GP1_BIAS_SET(x)				(x << 0)
#define GP2_BIAS_SET(x)				(x << 4)

#define PM802_GPADC_BIAS_MASK0			(0x0F)
#define PM802_GPADC_BIAS_MASK1			(0xF0)

#define PM802_GP_BIAS_ENA1				(0x0D)
#define PM802_GPADC_GP_BIAS_EN0			(1 << 0)
#define PM802_GPADC_GP_BIAS_EN1			(1 << 1)

#define PM802_VLDOIN_LOW_TH		0x1F
#define PM802_VLDOIN_HIGH_TH	0x21

#define PM802_GPADC0_LOW_TH		0x17
#define PM802_GPADC1_LOW_TH		0x1B

#define PM802_GPADC0_HIGH_TH	0x19
#define PM802_GPADC1_HIGH_TH	0x1D

#define PM802_GPADC_CFG1	(0x39)
#define PM802_GPADC_CFG2	(0x3A)
#define PM802_GPADC_CFG3	(0x3B)

#define PM802_GPADC0_MEAS1		0x4C
#define PM802_GPADC0_MEAS2		0x4D
#define PM802_GPADC1_MEAS1		0x4E
#define PM802_GPADC1_MEAS2		0x4F
#define PM802_VLDOIN_MEAS1		0x62
#define PM802_VLDOIN_MEAS2		0x63
#define PM802_VLDOIN_AVG1		0x68
#define PM802_VLDOIN_AVG2		0x69
#define PM802_VLDOIN_SLP_AVG1	0x6A
#define PM802_VLDOIN_SLP_AVG2	0x6B

/* BUCK Sleep Mode Register 1: BUCK[1..5] */
#define PM802_BUCK_SLP1		(0x22)
#define PM802_BUCK_SLP2		(0x32)
#define PM802_BUCK_SLP3		(0x42)
#define PM802_BUCK_SLP4		(0x52)
#define PM802_BUCK_SLP5		(0x62)

#define PM802_BUCK_SLP_SHIFT	3
#define PM802_BUCK_SLP_MASK	(0x3 << PM802_BUCK_SLP_SHIFT)
#define PM802_BUCK_SLP_PWR_OFF	0x0	/* power off */
#define PM802_BUCK_SLP_PWR_ACT1	0x1	/* auto & VBUCK_SET_SLP */
#define PM802_BUCK_SLP_PWR_LOW	0x2	/* VBUCK_SET_SLP */
#define PM802_BUCK_SLP_PWR_ACT2	0x3	/* auto & VBUCK_SET */

#define PM802_BUCK_SLP1_VOLT		(0x21)
#define PM802_BUCK_SLP2_VOLT		(0x31)
#define PM802_BUCK_SLP3_VOLT		(0x41)
#define PM802_BUCK_SLP4_VOLT		(0x51)
#define PM802_BUCK_SLP5_VOLT		(0x61)


/* LDO Sleep Mode Register */
#define PM802_LDO_SLP1		(0x08)
#define PM802_LDO_SLP2		(0x0B)
#define PM802_LDO_SLP3		(0x0E)
#define PM802_LDO_SLP4		(0x11)
#define PM802_LDO_SLP5		(0x14)
#define PM802_LDO_SLP6		(0x17)

extern int pm802_extern_read(int page, int reg);
extern int pm802_extern_write(int page, int reg, unsigned char val);
extern int pm802_extern_setbits(int page, int reg,
			 unsigned char mask, unsigned char val);

extern int dvc_flag;
#endif /* __LINUX_MFD_88PM80X_H */
