/*
 * ASR 88PM803 Interface
 *
 * Copyright 2020 ASR Microelectronics (Shanghai) Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __LINUX_MFD_88PM803_H
#define __LINUX_MFD_88PM803_H

#define	PM803_BASE_PAGE		1
#define	PM803_POWER_PAGE	2

enum {
	PM803_ID_BUCK1 = 0,

	PM803_ID_LDO1,
	PM803_ID_LDO2,
	PM803_ID_LDO3,
	PM803_ID_LDO4,
	PM803_ID_LDO5,
	PM803_ID_LDO6,
	PM803_ID_LDO7,
	PM803_ID_LDO8,

	PM803_ID_RG_MAX,
};

enum {
	PM803_NO_GPIO = -1,
	PM803_GPIO0 = 0,
	PM803_GPIO1,
	PM803_GPIO2,
	PM803_GPIO3,
	PM803_GPIO4,
};

/* page 0 basic: slave adder 0x60 */
#define PM803_STATUS_1			(0x01)
#define PM803_ONKEY_STS1		(1 << 0)
#define PM803_EXTON1_STS1		(1 << 1)
#define PM803_RTC_ALARM_STS1	(1 << 2)
#define PM803_BAT_STS1			(1 << 3)

/* Wakeup Registers */
#define PM803_WAKEUP1		(0x0D)
#define PM803_SW_PDOWN			(1 << 5)

#define PM803_WAKEUP2		(0x0E)
#define PM803_WAKEUP2_INV_INT		(1 << 0)
#define PM803_WAKEUP2_INT_CLEAR		(1 << 1)
#define PM803_WAKEUP2_INT_MASK		(1 << 2)

#define PM803_POWER_UP_LOG	(0x10)

#define PM803_DUMMY_REG0	(0x15)
#define PM803_DUMMY_REG1	(0x16)
#define PM803_DUMMY_REG2	(0x17)

/* RTC Registers */
#define PM803_RTC_CONTROL		(0xD0)
#define PM803_RTC_USER_DATA1	(0xD1)
#define PM803_RTC_USER_DATA2	(0xD2)
#define PM803_RTC_USER_DATA3	(0xD3)
#define PM803_RTC_USER_DATA4	(0xD4)
#define PM803_RTC_USER_DATA5	(0xD5)
#define PM803_RTC_USER_DATA6	(0xD6)
#define PM803_RTC_USER_DATA7	(0xD7)
#define PM803_RTC_USER_DATA8	(0xD8)

#define PM803_RTC_MISC1			(0xE1)
#define PM803_RTC_MISC2			(0xE2)
#define PM803_RTC_MISC3			(0xE3)
#define PM803_RTC_MISC4			(0xE4)
#define PM803_RTC_MISC5			(0xE7)
#define PM803_RTC_MISC6			(0xE8)
#define PM803_RTC_MISC7			(0xE9)
#define PM803_RTC_MISC8			(0xEA)
#define PM803_RTC_MISC9			(0xEB)
#define PM803_RTC_MISC10		(0xEC)
#define PM803_RTC_MISC11		(0xED)
#define PM803_RTC_MISC12		(0xEF)
#define PM803_RTC_MISC13		(0xF0)
#define PM803_RTC_MISC14		(0xF1)
#define PM803_RTC_MISC15		(0xF2)
#define PM803_RTC_MISC16		(0xF3)
#define PM803_RTC_MISC17		(0xF4)
#define PM803_RTC_MISC18		(0xF5)
#define PM803_RTC_MISC19		(0xF6)
#define PM803_RTC_MISC20		(0xF7)


#define PM803_RTC_SPARE1		(0xD1)
#define PM803_RTC_SPARE2		(0xD2)
#define PM803_RTC_SPARE3		(0xD3)
#define PM803_RTC_SPARE4		(0xD4)
#define PM803_RTC_SPARE5		(0xD5)
#define PM803_RTC_SPARE6		(0xD6)
#define PM803_RTC_SPARE7		(0xD7)
#define PM803_RTC_SPARE8		(0xD8)

#define PM803_PD_LOG_REG1			(0xE5)
#define PM803_PD_LOG_REG2			(0xE6)

/* bit definitions of RTC Register 1 (0xD0) */
#define PM803_ALARM1_EN			(1 << 0)
#define PM803_ALARM_WAKEUP		(1 << 4)
#define PM803_ALARM				(1 << 5)
#define PM803_RTC1_USE_XO		(1 << 7)
#define PM803_ALARM_WAKEUP		(1 << 4)

#define PM803_POWER_DOWN_LOG1	(0xE5)
#define PM803_POWER_DOWN_LOG2	(0xE6)

/* BUCK Sleep Mode Register 1: BUCK[1..5] */
#define PM803_BUCK_SLP1		(0x22)


#define PM803_BUCK_SLP_SHIFT	3
#define PM803_BUCK_SLP_MASK	(0x3 << PM802_BUCK_SLP_SHIFT)
#define PM803_BUCK_SLP_PWR_OFF	0x0	/* power off */
#define PM803_BUCK_SLP_PWR_ACT1	0x1	/* auto & VBUCK_SET_SLP */
#define PM803_BUCK_SLP_PWR_LOW	0x2	/* VBUCK_SET_SLP */
#define PM803_BUCK_SLP_PWR_ACT2	0x3	/* auto & VBUCK_SET */

#define PM803_BUCK_SLP1_VOLT		(0x21)


/* LDO Sleep Mode Register */
#define PM803_LDO_SLP1		(0x70)
#define PM803_LDO_SLP2		(0x73)
#define PM803_LDO_SLP3		(0x76)
#define PM803_LDO_SLP4		(0x79)
#define PM803_LDO_SLP5		(0x7C)
#define PM803_LDO_SLP6		(0x7F)
#define PM803_LDO_SLP7		(0x82)
#define PM803_LDO_SLP8		(0x85)

extern int pm802_extern_read(int page, int reg);
extern int pm802_extern_write(int page, int reg, unsigned char val);
extern int pm802_extern_setbits(int page, int reg,
			 unsigned char mask, unsigned char val);

extern int dvc_flag;
#endif /* __LINUX_MFD_88PM80X_H */
