/*
 *  include/linux/mmc/asr_dvfs.h
 *
 *  Copyright 2014 Jialing Fu jlfu@marvell.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 */

#ifndef LINUX_MMC_ASR_DVFS_H
#define LINUX_MMC_ASR_DVFS_H

struct sdhci_host;

extern int asr_sdh_create_dvfs(struct sdhci_host *host);
extern int asr_sdh_get_highest_dvfs_level(struct sdhci_host *host);
extern int asr_sdh_get_lowest_dvfs_level(struct sdhci_host *host);
extern int asr_sdh_request_dvfs_level(struct sdhci_host *host, int level);
extern int asr_sdh_release_dvfs(struct sdhci_host *host);
extern int asr_sdh_enable_dvfs(struct sdhci_host *host);
extern int asr_sdh_disable_dvfs(struct sdhci_host *host);
extern int asr_sdh_destory_dvfs(struct sdhci_host *host);
extern int asr_sdh_dvfs_timing_prepare(struct sdhci_host *host, unsigned char timing);

#endif /* LINUX_MMC_PXA_DVFS_H */
