#ifndef	__ASR_BBT_H__
#define	__ASR_BBT_H__

#define PXA_RELOC_HEADER	0x524e
#define PXA_BEGIN_SLOT		2
#define ABBT_BLK_NUM		2

/* New BBM scheme */
#define BOOT_PRAT_MAX		10
#define PXA_NEW_BBM_HEADER	0x4D424254
#define PXA_PART_IDET_1		0x4D52564C
#define PXA_PART_IDET_2		0x204D5054
#define BBM_FULL_MASK		0xffffffff
#define BBM_HALF_MASK		0x0000ffff
#define BBT_TYPE_FACT		0x46616374
#define BBT_TYPE_RUNT		0x52756E74
#define BBT_TYPE_ASR		0x41424254
#define PART_PHYS		0x50687973
#define PART_LOGI		0x4C6F6769
#define RP_UPWD			0x55505744
#define RP_DNWD			0x444E5755

enum bbm_type {
	BBM_NONE = 0,
	BBM_LEGACY,
	BBM_NEW,
};

enum bbm_order {
	ORDER_REVERSE = 0,
	ORDER_POSITIVE,
};

enum bbt_state {
	BBT_NOINIT = 0,
	BBT_INITED,
	BBT_FORCE_NOINIT,
};

/* Block state for bitflips */
enum bbt_entry_state {
	BLK_RECYCLED = 0xFFF1,
	BLK_WAIT_RECYCLE = 0xFFF2,
	BLK_RECYCLE_FAIL = 0xFFF3,
	BLK_RELOCATED = 0xFFF4,
	BLK_FLIP_COUNT = 0xFFFE,
	BLK_BAD = 0xFFFF,
};

enum bbt_table_state {
	BBT_CHANGED = (1<<0),
	ABBT_CHANGED = (1<<1),
	ABBT_MAIN_SCRUB = (1<<2),
	ABBT_MIRROR_SCRUB = (1<<3),
};

enum abbt_scrub_flag {
	ABBT_SCRUB_NONE = 0,
	ABBT_SCRUB_ANY,
	ABBT_SCRUB_BACK,
};

enum reloc_flag {
	DEST_NOT_USE_RELOC = (1<<0),
	DEST_SKIP_ALL_FF_PAGE = (1<<1),
};

struct reloc_item {
	unsigned short from;
	unsigned short to;
};

struct reloc_table {
	unsigned short header;
	unsigned short total;
};

#define ABBT_VERSION 0x31303031
#define ABBT_VERSION_1102 0x31303032
#define ABBT_VERSION_2001 (~0x32303031)

enum {
	BBT_NONE = 0,
	BBT_OBM = 1,
	BBT_UBOOT = 2,
	BBT_KERNEL = 3,
};

struct asr_abbt {
	uint32_t ident;
	uint32_t ver;
	uint32_t owner:2;
	uint32_t reserved:14;
	uint32_t crc:16;
	uint32_t refcnt;
	uint32_t entry_num;
	uint32_t backup_bbt_loc; /* reserved for old ABBT_VERSION */
	uint32_t recycled_num;
	uint32_t wait_recycle_num;
	struct reloc_item reloc[0];
};

struct asr_bbt {
	uint32_t ident;
	uint32_t ver;
	uint32_t type;
	uint32_t reserved_1;
	uint32_t reserved_2;
	uint32_t entry_num;
	uint32_t bbt_loc;
	uint32_t reserved_3;
	uint32_t reserved_4;
	uint32_t reserved_5;
	union {
		struct reloc_item *reloc;
		uint32_t *fact_bad;
	};
};

struct asr_partinfo {
 	uint32_t	type;		/* Logi or Phys */
 	uint32_t	usage;		/* Partition name */
 	uint32_t	identifier;	/* for distinguish same name */
 	uint32_t	attrs;		/* r/w and permisson control */
 	uint64_t	start_addr;	/* addr of LSB of start block */
 	uint64_t	end_addr;	/* addr of MSB of end block */
	uint64_t	rp_start;
	uint64_t	rp_size;
	uint32_t	rp_algo;
	uint32_t	rbbt_type;
	uint64_t	rbbt_start;
	uint64_t	rbbt_start_back;
	uint64_t	reserved;
};

struct asr_part {
	uint64_t		identifier;
	uint32_t		version;
	uint32_t		part_num;
	uint64_t		reserved;
};

/*
 * abbm as an extension of legacy bbm. abbm is a second level bbt, and
 * original bbt is a first level bbt, which is designed to be compatable
 * with legacy_bbm and also add new features such as dealing with read
 * disturb and larger/safer bbm.
 */
struct asr_scrub_entry {
	struct list_head list;
	int scrub_blk;
};

struct asr_legacy_abbm {
	int			cur_slot;
	int			order;
	int			max_entry;
	int			main_blk;
	int			mirror_blk;
	struct asr_abbt	*abbt;
	int			scrub_cnt;
	int			scrubbing;
	spinlock_t		scrub_lock;
	struct list_head	scrub_list;
	struct work_struct	scrub_work;
	struct mtd_info		*mtd;
};

struct asr_legacy_bbm {
	struct asr_legacy_abbm	abbm;
	int			bbt_blk;
	int			current_slot;
	int                     order;
	int			max_reloc_entry;
	int			reserved_blks;
	int 			status;

	struct reloc_item	reloc_cache;
	struct reloc_table	*table;
	struct reloc_item	*reloc;
};

struct asr_bbm {
	int	bbm_type;
	int	is_init;
	int	no_sync;
	int	begin_slot;
	void	*data_buf;
	char	*rel_dist;
	int	bypass; /* access assume physical flash address */
	int	not_reloc; /* not relocate during mark bad */

	void    (*uninit)(struct mtd_info *mtd);
	loff_t	(*search)(struct mtd_info *mtd,	loff_t ofs);
	int	(*scrub_read_disturb)(struct mtd_info *mtd, loff_t ofs);
	struct mtd_partition * (*check_partition)
		(struct mtd_info *mtd, const struct mtd_partition *part, int *num);
	struct proc_dir_entry *bbm_root;
};

int asr_scan_bbt(struct mtd_info *mtd);
int asr_block_bad(struct mtd_info *mtd, loff_t ofs, int allowbbt);
int asr_update_bbt(struct mtd_info *mtd, loff_t offs);
int asr_block_markbad(struct mtd_info *mtd, loff_t ofs);
int asr_bbm_recovery(struct mtd_info *mtd, struct reloc_item *item,
			int num, int reserve_last_page);
int page_search(struct mtd_info *mtd, int start_page, int end_page,
	int direction, unsigned int indicator, void *buf, unsigned int mask);
int asr_search_bbm_table(struct mtd_info *mtd, int addr);
int asr_handle_read_disturb(struct mtd_info *mtd, loff_t ofs, int corrected);

#endif

