/*
 * rfkill power contorl for ASR PCIe.
 *
 * Copyright (C) 2021 ASR Ltd
 *
 */

#ifndef _LINUX_PCIE8X_RFKILL_H
#define _LINUX_PCIE8X_RFKILL_H

#include <linux/rfkill.h>
#include <linux/interrupt.h>
#include <linux/platform_device.h>
#include <linux/module.h>

struct pcie_rfkill_plat_data;

typedef void (*rfkill_plat_set_power) (unsigned int);

typedef int (*rfkill_pwr_ctrl) (struct pcie_rfkill_plat_data *, int);

struct pcie_rfkill_plat_data {
	int gpio_power_down;
	int gpio_reset;
	int gpio_reset2;
	int gpio_edge_wakeup;
	int gpio_3v3_en;
	int gpio_1v8_en;
	int gpio2_3v3_en;
	int gpio2_1v8_en;
	int edge_requested;

	struct rfkill *wlan_rfkill;
	struct rfkill *bt_rfkill;
	struct rfkill *fm_rfkill;

	/* for platform specific power on sequence */
	rfkill_plat_set_power set_power;
	rfkill_pwr_ctrl pwr_ctrl;
	struct platform_device *host_pdev;

	struct regulator *wib_3v3;
	struct regulator *wib_3v3_2;
	struct regulator *wib_1v8;

	struct pinctrl *pinctrl;
	struct pinctrl_state *pin_off;
	struct pinctrl_state *pin_on;

	/* power status */
	int is_on;
	int is_on2;
};


#endif
