/*
 * include/linux/platform_data/asr_sdhci.h
 *
 * Copyright 2018 ASR
 *
 * ASR Platform - SDHCI platform data definitions
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef _ASR_SDHCI_H_
#define _ASR_SDHCI_H_

/*
 * asr_sdhci_dtr_data: sdhc data transfer rate table
 * @timing: the specification used timing
 * @preset_rate: the clock could set by the SOC
 * @src_rate: send to the clock subsystem
 * related to APMU on SOC
 * @tx_delay: use this value for TX DDLL
 * @rx_delay: use this value for RX DDLL
 * @rx_sdclk_sel0: select RX DDLL clock source
 * @rx_sdclk_sel1: select RX DDLL or internal clock
 */
struct asr_sdhci_dtr_data {
	unsigned char timing;
	unsigned long preset_rate;
	unsigned long src_rate;
	unsigned int tx_delay;
	unsigned int rx_delay;
	unsigned char tx_dline_reg;
	unsigned char rx_dline_reg;
	unsigned char fakeclk_tuned_level;
	unsigned char fakeclk_fixed_en;
};

/* Tuning mode define */
#define PXA_SDH_TUNING_DEFAULT 0
#define PXA_SDH_TUNING_DVFS 1

/* Disable bus clock hardware auto-gating */
#define PXA_FLAG_DISABLE_CLOCK_AUTO_GATING (1<<8)

/*
 * sdhci_pretuned_data: tuning data that is stored in emmc
 */
#define SDHCI_PRETUNED_MAGIC1	0x53444800 /* "SDH\0" */
#define SDHCI_PRETUNED_MAGIC2	0x44664653 /* "DVFS" */
struct sdhci_pretuned_data {
	u32	crc32;		/* checksum */
	int	magic1;		/* magic number */
	unsigned long	src_rate;	/* the scr_rate */
	int	rx_delay;	/* -1 for invalid */
	int	dvfs_level;	/* -1 for invalid */
	u32	card_cid[4];
	u32	card_csd[4];
	u32	card_scr[2];
	int	magic2;		/* magic number */
	u8	reserved[28];	/* not used */
};

#include <linux/pm_qos.h>

/*
 * struct asr_sdhci_platdata() - Platform device data for ASR SDHCI
 * @flags: flags for platform requirement
 * @ext_cd_gpio: gpio pin used for external CD line
 * @ext_cd_gpio_invert: invert values for external CD gpio line
 * @max_speed: the maximum speed supported
 * @host_caps: Standard MMC host capabilities bit field.
 * @quirks: quirks of platfrom
 * @quirks2: quirks2 of platfrom
 * @pm_caps: pm_caps of platfrom
 * @signal_vol_change: signaling voltage change
 */
struct asr_sdhci_platdata {
	unsigned int	flags;
	unsigned int	max_speed;
	u32		host_caps;
	u32		host_caps2;
	unsigned int    host_caps_disable;
	unsigned int    host_caps2_disable;
	unsigned int	quirks;
	unsigned int	quirks2;
	unsigned int	pm_caps;
	struct asr_sdhci_dtr_data *dtr_data;
	struct  pm_qos_request  qos_idle;
	u32	lpm_qos;
	void (*reset_wakeup_event)(void);
	void (*clear_wakeup_event)(void);
	int (*check_sdh_wakeup_event)(void);
	void (*signal_vol_change)(unsigned int set);
	struct pinctrl *pinctrl;
	struct pinctrl_state *pin_default;
	struct pinctrl_state *pin_slow;
	struct pinctrl_state *pin_fast;
	struct pinctrl_state *pin_sleep;
	struct clk *fakeclk_tuned;
	struct clk *fakeclk_fixed;

	int	tuning_mode;
	u32	tuning_win_limit; /* min requirement for tuning window size */
	int	dvfs_level_min;
	int	dvfs_level_max;
	int	dvfs_level_sel;
	struct sdhci_pretuned_data *pretuned;
};

#endif /* _ASR_SDHCI_H_ */
