/*
 * Copyright (C) 2011 Marvell International Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 */

#ifndef __MV_PLATFORM_USB_H
#define __MV_PLATFORM_USB_H

#include <linux/notifier.h>

enum pxa_ehci_type {
	EHCI_UNDEFINED = 0,
	PXA_U2OEHCI,	/* pxa 168, 9xx */
	PXA_SPH,	/* pxa 168, 9xx SPH */
	MMP3_HSIC,	/* mmp3 hsic */
	MMP3_FSIC,	/* mmp3 fsic */
	PXA_HSIC,	/* pxa hsic */
};

/* for usb middle layer support */
enum {
	PXA_USB_DEV_OTG,
	PXA_USB_DEV_SPH1,
	PXA_USB_DEV_SPH2,
	PXA_USB_DEV_SPH3,
#if defined(CONFIG_CPU_ASR18XX) && defined(CONFIG_USB_MVC2)
	PXA_USB_DEV_MVC2,
#endif
	PXA_USB_DEV_MAX,
};

enum {
	EVENT_VBUS,
	EVENT_ID,
#if defined(CONFIG_CPU_ASR18XX) && defined(CONFIG_USB_MVC2)
	EVENT_MVC2_SET_CONFIG,
	EVENT_MVC2_CONNECT,
	EVENT_MVC2_DISCONNECT,
#endif
};

struct pxa_usb_vbus_ops {
	int (*get_vbus)(unsigned int *level);
	int (*set_vbus)(unsigned int level);
	int (*init)(void);
};

enum {
	MV_USB_MODE_UDC,
	MV_USB_MODE_OTG,
	MV_USB_MODE_HOST,
};

enum {
	VBUS_LOW	= 0,
	VBUS_HIGH	= 1 << 0,
};

enum charger_type {
	NULL_CHARGER	= 0,
	DEFAULT_CHARGER,
	DCP_CHARGER,		/* standard wall charger */
	CDP_CHARGER,		/* Charging Downstream Port */
	SDP_CHARGER,		/* standard PC charger */
	NONE_STANDARD_CHARGER,	/* none-standard charger */
	MAX_CHARGER
};

enum udc_typec_status {
	USB_TYPEC_DIR_CC1	= 0,
	USB_TYPEC_DIR_CC2,
};

#if defined(CONFIG_CPU_ASR18XX) && defined(CONFIG_USB_MVC2)
enum udc_status_type {
	DEFAULT_STATUS	= 0,
	RESET_STATUS,
	SUSPEND_STATUS,
};
#endif

extern int mv_udc_register_client(struct notifier_block *nb);
extern int mv_udc_unregister_client(struct notifier_block *nb);

struct pxa_usb_typec_ops {
	int (*get_typec_dir)(unsigned int *dir);
};

struct pxa_usb_idpin_ops {
	int (*get_idpin)(unsigned int *level);
	int (*init)(void);
 };

#if defined(CONFIG_CPU_ASR18XX) && defined(CONFIG_USB_MVC2)
struct pxa_mvc2_idpin_ops {
	int (*get_idpin)(unsigned int *level);
};
#endif

struct pxa_usb_extern_ops {
	struct pxa_usb_vbus_ops		vbus;
	struct pxa_usb_idpin_ops	idpin;
#if defined(CONFIG_CPU_ASR18XX) && defined(CONFIG_USB_MVC2)
	struct pxa_mvc2_idpin_ops   mvc2_idpin;
#endif
	struct pxa_usb_typec_ops	typec;
};

#define pxa_usb_has_extern_call(id, o, f, arg...)	( \
{ \
	struct pxa_usb_extern_ops *ops;			\
	int ret;					\
	ops  = pxa_usb_get_extern_ops(id);		\
	ret = (!ops ? 0 : ((ops->o.f) ?			\
		1 : 0));				\
	ret;						\
} \
)

#define pxa_usb_extern_call(id, o, f, args...)	( \
{ \
	struct pxa_usb_extern_ops *ops;			\
	int ret;					\
	ops  = pxa_usb_get_extern_ops(id);		\
	ret = (!ops ? -ENODEV : ((ops->o.f) ?		\
		ops->o.f(args) : -ENOIOCTLCMD));	\
	ret;						\
} \
)

#define pxa_usb_set_extern_call(id, o, f, p) ( \
{ \
	struct pxa_usb_extern_ops *ops;		\
	int ret;				\
	ops = pxa_usb_get_extern_ops(id);	\
	ret = !ops ? -ENODEV : ((ops->o.f) ?	\
		-EINVAL : ({ops->o.f = p; 0; }));\
	ret;					\
} \
)

#define MV_USB_HAS_VBUS_DETECTION	(1 << 0)
#define MV_USB_HAS_IDPIN_DETECTION	(1 << 1)

extern struct pxa_usb_extern_ops *pxa_usb_get_extern_ops(unsigned int id);
extern int pxa_usb_register_notifier(unsigned int id,
					struct notifier_block *nb);
extern int pxa_usb_unregister_notifier(unsigned int id,
					struct notifier_block *nb);
extern int pxa_usb_notify(unsigned int id, unsigned long val, void *v);
/* end of usb middle layer support */

extern int mv_udc_register_client(struct notifier_block *nb);
extern int mv_udc_unregister_client(struct notifier_block *nb);
extern void mvc2_release_pm_qos(void);

struct mv_usb_platform_data {
	unsigned int		clknum;
	char			**clkname;
	/*
	 * select from PXA_USB_DEV_OTG to PXA_USB_DEV_MAX.
	 * It indicates the index of usb device.
	 */
	unsigned int		id;
	unsigned int		extern_attr;

	/* only valid for HCD. OTG or Host only*/
	unsigned int		mode;

	/* This flag is used for that needs id pin checked by otg */
	unsigned int    disable_otg_clock_gating:1;
	/* Force a_bus_req to be asserted */
	 unsigned int    otg_force_a_bus_req:1;

};
#endif
