#ifndef __88PM80X_PAPI_H
#define __88PM80X_PAPI_H

struct pm80x_papi_info {
	struct pm80x_chip		*chip;
	struct device			*dev;
#ifdef CONFIG_THERMAL
	struct thermal_zone_device *tzd;
	unsigned int volt_table_size;
	int *volt_temp_table;
	int temp_offset;
	int temp_step;
#endif
	u32 bias_en_val;
	u32 gp0_bias_val;
	u32 gp1_bias_val;
	u32 bat_ntc_gpadc;
	u32 vbat_mult_val;
	u32 en_pm803_adc;
};

struct pm80x_papi_pdata {
	u32 bias_en_val;
	u32 gp0_bias_val;
	u32 gp1_bias_val;
	u32 bat_ntc_gpadc;
	u32 vbat_mult_val;
	u32 en_pm803_adc;
#ifdef CONFIG_THERMAL
	unsigned int volt_table_size;
	int *volt_temp_table;
	int temp_offset;
	int temp_step;
#endif
};

enum sys_boot_up_reason {
	SYS_BR_POWER_OFF,
	SYS_BR_ONKEY,
	SYS_BR_CHARGE,
	SYS_BR_RTC_ALARM,
	SYS_BR_FAULT_WAKEUP,
	SYS_BR_BAT_WAKEUP,
	SYS_BR_REBOOT,
	SYS_BR_MAX,
};

#if 0
enum charger_type {
	POWER_SUPPLY_TYPE_UNKOWN,
    POWER_SUPPLY_TYPE_USB,
    POWER_SUPPLY_TYPE_DC,
}
#endif
extern int udc_get_charger_type(void);

int get_vsys_vol(void);
int get_vbat_vol(void);
int get_ntc_vol(void);
int get_boot_reason(void);
int get_charger_type(void);
u32 pm80x_rtc_raw_read(void);
#endif
