/*
 * bq2419x charger driver
 *
 * Copyright (C) 2014-2015  Xuhong Gao <gaoxhong@marvell.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef BQ2419X_CHARGER_H
#define BQ2419X_CHARGER_H

struct bq2419x_charger_pdata {
	int gpio;
	unsigned int usb_input_current;
	unsigned int ac_input_current;
	unsigned int input_voltage;
	unsigned int prechg_current;
	unsigned int prechg_voltage;
	unsigned int fastchg_current;
	unsigned int fastchg_voltage;
	unsigned int fastchg_timeout;
	unsigned int sys_voltage;
	unsigned int eoc_current;
	unsigned int rechg_thresh;
	unsigned int thermal_reg_thr;
	unsigned int jeita_hot_volt;
	unsigned int jeita_cold_percent;
	unsigned int boost_ilim;
	unsigned int watchdog_timeout;
	unsigned int safety_timer;
	unsigned int charger_control_interface;
};

enum bq2419x_version {
	BQ24190 = 0,
	BQ24192,
	BQ24193,
	BQ24192I,
};
#endif
