#ifndef FAN540X_CHARGER_H
#define FAN540X_CHARGER_H

struct fan540x_chg_pdata {
	unsigned int limit_cur;
	unsigned int fastchg_eoc;	/* fastcharge end current */
	unsigned int fastchg_vol[3];	/* fastcharge voltage */
	unsigned int fastchg_cur[3];	/* fastcharge current */
	unsigned int over_vol;
	int ext_storage;

	bool charger_control_interface;
	bool support_otg;
	bool use_stat_irq;

	char **supplied_to;
	size_t num_supplicants;
	struct i2c_client *client;

	struct pinctrl *pinctrl;
	struct pinctrl_state *pin_on;
};

enum {
	JEITA_INV = -1,
	JEITA_STR = 0,
	JEITA_LTR,
	JEITA_HTR,
	JEITA_MAX,
};

#endif
