#ifndef __SKBRB_H__
#define __SKBRB_H__
/*
 * asr netdevice skb ring buffer driver
 *
 * Copyright (C) 2020 ASR Micro Limited
 *
 */

enum {
	SKBRB_TYPE_EMAC = 0,
	SKBRB_TYPE_WIFI,
	SKBRB_TYPE_MAX
};

struct skbrb_slot {
	int index;
	bool inuse;
	char *offset;
	int type;
};

struct skbrb {
	spinlock_t lock;
	atomic_t free_cnt;
	int curr_slot;
	char *addr;
	int slot_size;
	int slot_cnt;
	struct skbrb_slot *rx_slots;
};

/* put this private struct at the end of the skb->cb.
 * to indicate whether this skb is allocated from
 * the skb ring buffer.
 * if set this flag to 1, it will NOT do skb copy(pskb_expand_head)
 * in fastpath & pipe.
 */
#define SKB_FROM_RB_BIT			(1 << 0)
#define SKB_BYPASS_CAPTURE_BIT 	(1 << 1)
struct skbrb_cb {
	unsigned char flag;
};

#define GET_SKBRB_CB(skb) \
	((struct skbrb_cb *)(&skb->cb[sizeof(skb->cb) - sizeof(struct skbrb_cb)]))
#define IS_SKBRB_SKB(skb) (GET_SKBRB_CB(skb)->flag & SKB_FROM_RB_BIT)
#define IS_SKB_BYPASS_CAPTURE(skb)	(GET_SKBRB_CB(skb)->flag & SKB_BYPASS_CAPTURE_BIT)
#define SKB_BYPASS_CAPTURE(skb, x)	do {\
	if (x)\
		GET_SKBRB_CB(skb)->flag |= SKB_BYPASS_CAPTURE_BIT;\
	else\
		GET_SKBRB_CB(skb)->flag &= ~SKB_BYPASS_CAPTURE_BIT;\
} while (0)

/* for emac */
int emac_skbrb_init(int slot_size, int slot_cnt);
void emac_skbrb_release(void);
struct sk_buff *emac_skbrb_alloc_skb(unsigned int length);

/* for wifi */
int wifi_skbrb_init(int slot_size, int slot_cnt);
void wifi_skbrb_release(void);
struct sk_buff *wifi_skbrb_alloc_skb(unsigned int length);

#endif
