#include "lynq-adc.h"
#include "mbtk_type.h"
#include "mbtk_adc.h"
#include "mbtk_log.h"

int qser_adc_show(ADC_CHANNEL_E qadc)
{
    UNUSED(qadc);

    mbtk_adc_enum adc = MBTK_ADC0;
    switch(qadc) {
        case QADC_NONE:
        {
            return 0;
        }
        case ADC0:
            adc = MBTK_ADC0;
            break;
        case ADC1:
            adc = MBTK_ADC1;
            break;
        case ADC2:
            adc = MBTK_ADC2;
            break;
        default:
            LOGE("Unsupport adc : %d", qadc);
            return -1;
    }

    return mbtk_adc_get(ADC_DEVICE_AUX, adc);
}

