#include "lynq-qser-audio.h"
#include "mbtk_type.h"
#include "mbtk_log.h"
#include "mbtk_audio2.h"

#define AUDIO_DEV_PLAY "device1"
#define AUDIO_DEV_RECORDER "device2"
#define AUDIO_HDL_DEFAULT 0

static _cb_onPlayer play_cb = NULL;
static int play_hdl = -1;

static _cb_onPlayer recv_cb = NULL;
static int recv_hdl = -1;

int qser_AudPlayer_Open(char* device, _cb_onPlayer cb_fun)
{
    UNUSED(device);
    UNUSED(cb_fun);
    if(device == NULL || strcmp(device, AUDIO_DEV_PLAY)) {
        LOGE("device must be %s for play.", AUDIO_DEV_PLAY);
        return -1;
    }

    if(mbtk_audio_wav_init()) {
        LOGE("mbtk_audio_wav_init() fail.");
        return -1;
    }

    play_cb = cb_fun;

    return 0;
}

int qser_AudPlayer_PlayFrmFile(int hdl, const char *fd, int offset)
{
    UNUSED(hdl);
    UNUSED(fd);
    UNUSED(offset);
    if(play_hdl >= 0) {
        LOGE("Play busy.");
        if(play_cb) {
            play_cb(-1);
        }
        return -1;
    }

    if(mbtk_audio_wav_play_start(fd)) {
        LOGE("mbtk_audio_wav_play_start() fail.");
        if(play_cb) {
            play_cb(-2);
        }
        return -1;
    }

    play_hdl = hdl;

    if(play_cb) {
        play_cb(0);
    }

    return 0;
}

int qser_AudPlayer_PlayPcmBuf(const unsigned char *pcm_data, int data_size, int period_size,
                                int period_count, int num_channels, int sample_rate, int ownerid)
{

    if(play_hdl >= 0) {
        LOGE("Play busy.");
        if(play_cb) {
            play_cb(-1);
        }
        return -1;
    }

    if(mbtk_audio_wav_stream_play_start(pcm_data, data_size, sample_rate, num_channels)) {
        LOGE("mbtk_audio_wav_stream_play_start() fail.");
        if(play_cb) {
            play_cb(-2);
        }
        return -1;
    }

    play_hdl = AUDIO_HDL_DEFAULT;
    if(play_cb) {
        play_cb(0);
    }
    return 0;
}

int qser_AudPlayer_Pause(int hdl)
{
    UNUSED(hdl);
    if((play_hdl != AUDIO_HDL_DEFAULT && hdl != play_hdl) || play_hdl < 0) {
        LOGE("Play busy or hdl error.");
        return -1;
    }

    if(mbtk_audio_wav_play_pause()) {
        LOGE("mbtk_audio_wav_play_pause() fail.");
        return -1;
    }

    return 0;
}

int qser_AudPlayer_Resume(int hdl)
{
    UNUSED(hdl);
    if((play_hdl != AUDIO_HDL_DEFAULT && hdl != play_hdl) || play_hdl < 0) {
        LOGE("Play busy or hdl error.");
        return -1;
    }

    if(mbtk_audio_wav_play_resume()) {
        LOGE("mbtk_audio_wav_play_resume() fail.");
        return -1;
    }

    return 0;
}

void qser_AudPlayer_Stop(int hdl)
{
    UNUSED(hdl);
    if((play_hdl != AUDIO_HDL_DEFAULT && hdl != play_hdl) || play_hdl < 0) {
        LOGE("Play busy or hdl error.");
        return;
    }

    if(mbtk_audio_wav_play_stop()) {
        LOGE("mbtk_audio_wav_play_stop() fail.");
        return;
    }

    play_hdl = -1;
}


void qser_AudPlayer_Close(int hdl)
{
    UNUSED(hdl);

    if(play_hdl >= 0) {
        qser_AudPlayer_Stop(hdl);
    }

    if(mbtk_audio_wav_deinit()) {
        LOGE("mbtk_audio_wav_deinit() fail.");
        return;
    }

    play_cb = NULL;
}

int qser_AudRecorder_Open(char* device, _cb_onPlayer cb_fun)
{
    UNUSED(device);
    UNUSED(cb_fun);
    if(device == NULL || strcmp(device, AUDIO_DEV_RECORDER)) {
        LOGE("device must be %s for recv.", AUDIO_DEV_RECORDER);
        return -1;
    }

    if(mbtk_audio_wav_init()) {
        LOGE("mbtk_audio_wav_init() fail.");
        return -1;
    }

    recv_cb = cb_fun;

    return 0;
}

int qser_AudRecorder_StartRecord(int hdl, const char *fd, int offset)
{
    UNUSED(hdl);
    UNUSED(fd);
    UNUSED(offset);
    if(recv_hdl >= 0) {
        LOGE("Recv busy.");
        if(recv_cb) {
            recv_cb(-1);
        }
        return -1;
    }

    if(mbtk_audio_wav_recorder_start(fd, MBTK_AUDIO_SAMPLE_RATE_8000)) {
        LOGE("mbtk_audio_wav_recorder_start() fail.");
        if(recv_cb) {
            recv_cb(-2);
        }
        return -1;
    }

    recv_hdl = hdl;
    if(recv_cb) {
        recv_cb(0);
    }
    return 0;
}

int qser_AudRecorder_StartRecord_Custom(char *file, int period_size, int period_count,
            int num_channels, int sample_rate)
{
    return qser_AudRecorder_StartRecord(0, file, 0);
}

int qser_AudRecorder_Pause(void)
{
    if(recv_hdl < 0) {
        LOGE("Recv busy or hdl error.");
        return -1;
    }

    if(mbtk_audio_wav_recorder_pause()) {
        LOGE("mbtk_audio_wav_recorder_pause() fail.");
        return -1;
    }
    return 0;
}

int qser_AudRecorder_Resume(void)
{
    if(recv_hdl < 0) {
        LOGE("Recv busy or hdl error.");
        return -1;
    }

    if(mbtk_audio_wav_recorder_resume()) {
        LOGE("mbtk_audio_wav_recorder_resume() fail.");
        return -1;
    }
    return 0;
}

void qser_AudRecorder_Stop(void)
{
    if(recv_hdl < 0) {
        LOGE("Recv busy or hdl error.");
        return;
    }

    if(mbtk_audio_wav_recorder_stop()) {
        LOGE("mbtk_audio_wav_recorder_stop() fail.");
        return;
    }

    recv_hdl = -1;
}

void qser_AudRecorder_Close(void)
{
    if(recv_hdl >= 0) {
        qser_AudRecorder_Stop();
    }

    if(mbtk_audio_wav_deinit()) {
        LOGE("mbtk_audio_wav_deinit() fail.");
        return;
    }

    recv_cb = NULL;
}

void qser_Audio_Deinit(void)
{
    // Do nothing...
}

