#include <stdarg.h>
#include <sys/un.h>
#include <sys/socket.h>
#include "json-c/json.h"
#include "lynq_deflog.h"
#include "mbtk_type.h"
#include <signal.h>
#include "mbtk_utils.h"

#define LOG_CONFIG_PATH     "/etc/mbtk/mbtk_log.json"
#define SYSLOG_PATCH "syslog"
#define SYSLOG_NAME "syslog"
#define SYSLOG_INDEX 0

#define RADIOLOG_NAME "radio"
#define RADIO_INDEX 1

void lynq_log_configuration_init(const char *log_name)
{
    //UNUSED(log_name);
    mbtk_log_init(SYSLOG_PATCH, (char*)log_name);
}

void lynq_log_global_output(log_level_enum Level,const char *format,...)
{
    va_list args;
    va_start(args,format);
    mbtk_log(Level, format, args);
    va_end(args);
}

const char* lynq_read_log_version()
{
    return "LOG-V1.0";
}

int lynq_syslog_set_file_size(int value)
{
//    UNUSED(value);
    json_object* jsonobj = NULL;
    json_object* tmpjson = NULL;
    json_object* datajson = NULL;
    json_object* listjson = NULL;

    int tmp_int;
    const char* tmp_string = NULL;

    if(value < 1)
    {
        value = 1;
    }
    else if(value > 100)
    {
        value = 100;
    }
    value = value*1024;

    jsonobj = json_object_from_file(LOG_CONFIG_PATH);
    if (NULL == jsonobj) {
        printf("Can't open config file: %s\n", LOG_CONFIG_PATH);
        mbtk_system("echo Can't open config file > /dev/console");
        return -1;
    }
    /***获取data***/
    json_object_object_get_ex(jsonobj, "buffer_list", &tmpjson);
    datajson = json_object_array_get_idx(tmpjson, SYSLOG_INDEX);
    if (NULL == datajson) {
        json_object_to_file(LOG_CONFIG_PATH, jsonobj);
        json_object_put(jsonobj);
        printf("NULL == datajson\n");
        mbtk_system("echo NULL == datajson > /dev/console");
        return -1;
    }

    json_object_object_get_ex(datajson, "name", &listjson);
    tmp_string = json_object_get_string(listjson);

    json_object_object_get_ex(datajson, "enable", &listjson);
    tmp_int = json_object_get_int(listjson);

    if(strcmp(tmp_string, SYSLOG_NAME) != 0 || tmp_int != 1)
    {
        json_object_to_file(LOG_CONFIG_PATH, jsonobj);
        json_object_put(jsonobj);
        printf("SYSLOG_NAME error, tmp_int != 1\n");
        mbtk_system("echo SYSLOG_NAME error, tmp_int != 1 > /dev/console");
        return -1;
    }

    json_object_object_add(datajson, "rotate_file_size", json_object_new_int(value));

    /***释放json对象***/
    json_object_to_file(LOG_CONFIG_PATH, jsonobj);
    json_object_put(jsonobj);
    return 0;
}

int lynq_syslog_get_file_size(void)
{
    json_object* jsonobj = NULL;
    json_object* tmpjson = NULL;
    json_object* datajson = NULL;
    json_object* listjson = NULL;

    int tmp_int;
    const char* tmp_string = NULL;

    jsonobj = json_object_from_file(LOG_CONFIG_PATH);
    if (NULL == jsonobj) {
        printf("Can't open config file: %s\n", LOG_CONFIG_PATH);
        return -1;
    }
    /***获取data***/
    json_object_object_get_ex(jsonobj, "buffer_list", &tmpjson);
    datajson = json_object_array_get_idx(tmpjson, SYSLOG_INDEX);
    if (NULL == datajson) {
        json_object_put(jsonobj);
        return -1;
    }

    json_object_object_get_ex(datajson, "name", &listjson);
    tmp_string = json_object_get_string(listjson);

    json_object_object_get_ex(datajson, "enable", &listjson);
    tmp_int = json_object_get_int(listjson);

    if(strcmp(tmp_string, SYSLOG_NAME) != 0 || tmp_int != 1)
    {
        json_object_put(jsonobj);
        return -1;
    }

    json_object_object_get_ex(datajson, "rotate_file_size", &listjson);
    tmp_int = json_object_get_int(listjson);

    /***释放json对象***/
    json_object_put(jsonobj);

    return tmp_int/1024;
//    return tmp_int;
}

int lynq_syslog_set_file_rotate(int value)
{
    //UNUSED(value);

    json_object* jsonobj = NULL;
    json_object* tmpjson = NULL;
    json_object* datajson = NULL;
    json_object* listjson = NULL;

    int tmp_int;
    const char* tmp_string = NULL;

    if(value < 0)
    {
        value = 0;
    }
    else if(value > 99)
    {
        value = 99;
    }

    jsonobj = json_object_from_file(LOG_CONFIG_PATH);
    if (NULL == jsonobj) {
        printf("Can't open config file: %s\n", LOG_CONFIG_PATH);
        return -1;
    }
    /***获取data***/
    json_object_object_get_ex(jsonobj, "buffer_list", &tmpjson);
    datajson = json_object_array_get_idx(tmpjson, SYSLOG_INDEX);
    if (NULL == datajson) {
        json_object_to_file(LOG_CONFIG_PATH, jsonobj);
        json_object_put(jsonobj);
        return -1;
    }

    json_object_object_get_ex(datajson, "name", &listjson);
    tmp_string = json_object_get_string(listjson);

    json_object_object_get_ex(datajson, "enable", &listjson);
    tmp_int = json_object_get_int(listjson);

    if(strcmp(tmp_string, SYSLOG_NAME) != 0 || tmp_int != 1)
    {
        json_object_to_file(LOG_CONFIG_PATH, jsonobj);
        json_object_put(jsonobj);
        return -1;
    }

    json_object_object_add(datajson, "rotate_file_count", json_object_new_int(value));

    /***释放json对象***/
    json_object_to_file(LOG_CONFIG_PATH, jsonobj);
    json_object_put(jsonobj);
    return 0;
}

int lynq_syslog_get_file_rotate(void)
{
    json_object* jsonobj = NULL;
    json_object* tmpjson = NULL;
    json_object* datajson = NULL;
    json_object* listjson = NULL;

    int tmp_int;
    const char* tmp_string = NULL;

    jsonobj = json_object_from_file(LOG_CONFIG_PATH);
    if (NULL == jsonobj) {
        printf("Can't open config file: %s\n", LOG_CONFIG_PATH);
        return -1;
    }
    /***获取data***/
    json_object_object_get_ex(jsonobj, "buffer_list", &tmpjson);
    datajson = json_object_array_get_idx(tmpjson, SYSLOG_INDEX);
    if (NULL == datajson) {
        json_object_put(jsonobj);
        return -1;
    }

    json_object_object_get_ex(datajson, "name", &listjson);
    tmp_string = json_object_get_string(listjson);

    json_object_object_get_ex(datajson, "enable", &listjson);
    tmp_int = json_object_get_int(listjson);

    if(strcmp(tmp_string, SYSLOG_NAME) != 0 || tmp_int != 1)
    {
        json_object_put(jsonobj);
        return -1;
    }

    json_object_object_get_ex(datajson, "rotate_file_count", &listjson);
    tmp_int = json_object_get_int(listjson);

    /***释放json对象***/
    json_object_put(jsonobj);

    return tmp_int;
}

log_level_enum filter_char_to_pri(char c)
{
    switch (c) {
        case 'v':
            return LOG_VERBOSE;
        case 'd':
            return LOG_DEBUG;
        case 'i':
            return LOG_INFO;
        case 'w':
            return LOG_WARNING;
        case 'e':
            return LOG_ERROR;
        case '*':
        default:
            return LOG_LEVEL_MAX;
    }
}

char filter_pri_to_char(log_level_enum level)
{
    char char_level;
    switch (level) {
        case LOG_VERBOSE:
            char_level = 'v';
            break;
        case LOG_DEBUG:
            char_level = 'd';
            break;
        case LOG_UNSET:
        case LOG_INFO:
            char_level = 'i';
            break;
        case LOG_WARNING:
            char_level = 'w';
            break;
        case LOG_ERROR:
            char_level = 'e';
            break;
        case LOG_LEVEL_MAX:
        default:
            char_level = '*';
            break;
    }
    return char_level;
}

int lynq_set_log_level(const char * module_name, log_level_enum level)
{
    json_object* jsonobj = NULL;
    json_object* tmpjson = NULL;
    json_object* datajson = NULL;
    json_object* listjson = NULL;
    json_object* fileterjson = NULL;
    json_object* fileter_listjson = NULL;
    json_object* new_fileter = NULL;

    int n = 0, array_length = 0;
    char* tmp_string = NULL;
    char level_string[5] = {'\0'};

    jsonobj = json_object_from_file(LOG_CONFIG_PATH);
    if (NULL == jsonobj) {
        printf("Can't open config file: %s\n", LOG_CONFIG_PATH);
        return -1;
    }
    /***获取data***/
    json_object_object_get_ex(jsonobj, "buffer_list", &tmpjson);
    datajson = json_object_array_get_idx(tmpjson, SYSLOG_INDEX);
    if (NULL == datajson) {
        json_object_put(jsonobj);
        return -1;
    }

    json_object_object_get_ex(datajson, "filter_list", &listjson);
    if (NULL == listjson) {
        printf("%s %d: object failure!\n", __FUNCTION__, __LINE__);
        json_object_put(listjson);
        return -1;
    }
    array_length = json_object_array_length(listjson);
    for (n = 0; n <= array_length; n++) {
        fileterjson = json_object_array_get_idx(listjson, n);
        if (NULL == fileterjson) {
            new_fileter = json_object_new_object();
            sprintf(level_string, "%c", filter_pri_to_char(level));
            json_object_object_add(new_fileter, "priority", json_object_new_string(level_string));
            json_object_object_add(new_fileter, "tag", json_object_new_string(module_name));
            json_object_array_add(listjson, new_fileter);
            break;
        }

        json_object_object_get_ex(fileterjson, "tag", &fileter_listjson);
        const char *str = json_object_get_string(fileter_listjson);
        if (str) {
            tmp_string = strdup(str);
            if(strcmp(module_name, tmp_string) == 0)
            {
                sprintf(level_string, "%c", filter_pri_to_char(level));
                json_object_object_add(fileterjson, "priority", json_object_new_string(level_string));
                json_object_to_file(LOG_CONFIG_PATH, jsonobj);
                json_object_put(jsonobj);
                return 0;
            }
        }
        else
        {
            continue;
        }
    }
    /***释放json对象***/
    json_object_to_file(LOG_CONFIG_PATH, jsonobj);
    json_object_put(jsonobj);

    return 0;
}

int lynq_get_log_level(const char * module_name, log_level_enum *level)
{
    json_object* jsonobj = NULL;
    json_object* tmpjson = NULL;
    json_object* datajson = NULL;
    json_object* listjson = NULL;
    json_object* fileterjson = NULL;
    json_object* fileter_listjson = NULL;

    int n;
    char* tmp_string = NULL;

    jsonobj = json_object_from_file(LOG_CONFIG_PATH);
    if (NULL == jsonobj) {
        printf("Can't open config file: %s\n", LOG_CONFIG_PATH);
        return -1;
    }
    /***获取data***/
    json_object_object_get_ex(jsonobj, "buffer_list", &tmpjson);
    datajson = json_object_array_get_idx(tmpjson, SYSLOG_INDEX);
    if (NULL == datajson) {
        json_object_put(jsonobj);
        return -1;
    }

    json_object_object_get_ex(datajson, "filter_list", &listjson);
    if (NULL == listjson) {
        printf("%s %d: object failure!\n", __FUNCTION__, __LINE__);
        json_object_put(listjson);
        return -1;
    }

    for (n = 0 ; n < 5; n++) {
        fileterjson = json_object_array_get_idx(listjson, n);
        if (NULL == fileterjson) {
            printf("the fileterjson exit\n");
            break;
        }

        json_object_object_get_ex(fileterjson, "tag", &fileter_listjson);
        const char *str = json_object_get_string(fileter_listjson);
        if (str) {
            tmp_string = strdup(str);
            printf("tag is %s\n", tmp_string);
            if(strcmp(module_name, tmp_string) == 0)
            {
                json_object_object_get_ex(fileterjson, "priority", &fileter_listjson);
                str = json_object_get_string(fileter_listjson);
                if (str) {
                    *tmp_string = str[0];
                    printf("fileter_listjson: %c\n", *tmp_string);
                    *level = filter_char_to_pri(*tmp_string);
                    //get the log level
                    json_object_put(jsonobj);
                    return 0;
                }
                else
                {
                    break;
                }
            }
        }
        else
        {
            continue;
        }
    }
    *level = LOG_UNSET;
    /***释放json对象***/
    json_object_put(jsonobj);

    return 0;
}

int lynq_set_special_log_level(const char * exe_name, const char * module_name, log_level_enum level)
{
    UNUSED(exe_name);
    UNUSED(module_name);
    UNUSED(level);


    return 0;
}

int lynq_get_special_log_level(const char * exe_name, const char * module_name, log_level_enum *level)
{
    UNUSED(exe_name);
    UNUSED(module_name);
    UNUSED(level);


    return 0;
}

int lynq_notify_recalc_log_level(pid_t pid)
{
    UNUSED(pid);
    char sendBuff[100]={'\0'};
    int clientFd,nwrite;
    struct sockaddr_un serverAddr,clientAddr;

    unlink("/var/log_client.socket");   /* in case it already exists */

    memset(&clientAddr,0,sizeof(clientAddr));
    memset(&serverAddr,0,sizeof(serverAddr));
    clientAddr.sun_family = AF_UNIX;
    sprintf(clientAddr.sun_path,"%s","/var/log_client.socket");

    if ((clientFd = socket(AF_UNIX,SOCK_STREAM,0)) < 0)
    {
        printf("err -1\n");
        return -1;
    }

    if (bind(clientFd, (struct sockaddr *)&clientAddr, sizeof(clientAddr)) < 0)
    {
        printf("err -2\n");
        close(clientFd);
        return -2;
    }

    serverAddr.sun_family = AF_UNIX;
    sprintf(serverAddr.sun_path, "/var/log_server.socket");
    if (connect(clientFd, (struct sockaddr *)&serverAddr, sizeof(serverAddr)) < 0)
    {
        printf("err -3\n");
        close(clientFd);
        return -3;
    }

    sprintf(sendBuff,"%s","update");
    if ((nwrite = write(clientFd, sendBuff, 100)) < 0)
    {
        printf("err -4\n");
        close(clientFd);
        return -4;
    }

    close(clientFd);
    return 0;
}

int lynq_write_log_to_file_now()
{
    FILE *fp;
    char command[256];
    char buffer[256];
    int pid = -1;
    const char *process_name = "mbtk_logd";


    snprintf(command, sizeof(command), "pgrep %s", process_name);
    fp = popen(command, "r");
    if (fp == NULL)
    {
        perror("error comman");
        return -1;
    }

    if (fgets(buffer, sizeof(buffer), fp) != NULL)
    {
        pid = atoi(buffer);
    }
     pclose(fp);

    if (pid != -1)
    {
        printf("mbtk %s  PID: %d\n", process_name, pid);
        if (kill(pid, SIGTERM) == -1)
        {
            perror("send SIGTERM signal failed");
            return -1;
        }
        printf("send %d  SIGTERM signal\n", pid);
    }
    else
    {
        printf("no find %s\n", process_name);
    }

    //lynq_log_configuration_init("log_end");
    //lynq_log_global_output(LOG_DEBUG,"mbtk_logd_out");
    return 0;

}

int lynq_stop_record_log(int value)
{

    json_object* jsonobj = NULL;
    json_object* tmpjson = NULL;
    json_object* datajson = NULL;
    json_object* listjson = NULL;

//    int tmp_int;
    const char* tmp_string = NULL;

    if(value != 0 && value != 1)
    {
        printf("invalid value ");
        return -1;
    }

    jsonobj = json_object_from_file(LOG_CONFIG_PATH);
    if (NULL == jsonobj)
    {
        printf("Can't open config file: %s\n", LOG_CONFIG_PATH);
        mbtk_system("echo Can't open config file > /dev/console");
        return -1;
    }


    json_object_object_get_ex(jsonobj, "buffer_list", &tmpjson);

    /***获取syslog json data***/
    datajson = json_object_array_get_idx(tmpjson, SYSLOG_INDEX);
    if (NULL == datajson)
    {
        json_object_to_file(LOG_CONFIG_PATH, jsonobj);
        json_object_put(jsonobj);
        printf("NULL == datajson\n");
        mbtk_system("echo NULL == datajson > /dev/console");
        return -1;
    }

    json_object_object_get_ex(datajson, "name", &listjson);
    tmp_string = json_object_get_string(listjson);

    json_object_object_get_ex(datajson, "enable", &listjson);
    json_object_get_int(listjson);

    if(strcmp(tmp_string, SYSLOG_NAME) != 0)
    {
        json_object_to_file(LOG_CONFIG_PATH, jsonobj);
        json_object_put(jsonobj);
        printf("SYSLOG_NAME error, \n");
        mbtk_system("echo SYSLOG_NAME error,  > /dev/console");
        return -1;
    }
    else
    {
        //set 0 to syslog
        json_object_object_add(datajson, "enable", json_object_new_int(value));
    }

    /***获取radiolog json data***/
    datajson = json_object_array_get_idx(tmpjson, RADIO_INDEX);
    if (NULL == datajson)
    {
        json_object_to_file(LOG_CONFIG_PATH, jsonobj);
        json_object_put(jsonobj);
        printf("NULL == datajson\n");
        mbtk_system("echo NULL == datajson > /dev/console");
        return -1;
    }

    json_object_object_get_ex(datajson, "name", &listjson);
    tmp_string = json_object_get_string(listjson);

    json_object_object_get_ex(datajson, "enable", &listjson);
    json_object_get_int(listjson);

    if(strcmp(tmp_string, RADIOLOG_NAME) != 0)
    {
        json_object_to_file(LOG_CONFIG_PATH, jsonobj);
        json_object_put(jsonobj);
        printf("RADIO_NAME error or \n");
        mbtk_system("echo RADIO_NAME error,  > /dev/console");
        return -1;
    }
    else
    {
        //set 0 to radio_log
        json_object_object_add(datajson, "enable", json_object_new_int(value));
    }

    /***释放json对象***/
    json_object_to_file(LOG_CONFIG_PATH, jsonobj);
    json_object_put(jsonobj);
    return 0;
}



int lynq_syslog_control(CONTROL_TYPE value)
{
    FILE *fp = NULL;
    const char *filePath = "/etc/syslog_close";
    if(value !=SYSLOG_OPEN && value !=SYSLOG_CLOSE)
    {
        return -1;
    }

    if(value == SYSLOG_CLOSE)
    {
        fp = fopen(filePath, "w");
        if (fp == NULL) 
        {
            perror("Error creating file");
            return -1;
        }
        fclose(fp);
    
    }

    if(value == SYSLOG_OPEN)
    {
        if(access(filePath,F_OK) == 0)
        {
            if(remove(filePath) == 0) 
            {
                return 0;
            } 
            else
            {
                perror("Error deleting file");
                return -1;
            }
        }
        else
        {
            return 0;
        }
    
    }

    return 0;

}

int lynq_kernel_log_control(CONTROL_TYPE value)
{
    FILE *fp = NULL;
    const char *filePath = "/etc/kernel_log_close";
    
    if(value != KERNEL_LOG_OPEN && value != KERNEL_LOG_CLOSE)
    {
        return -1;
    }

    if(value == KERNEL_LOG_CLOSE)
    {
        fp = fopen(filePath, "w");
        if (fp == NULL) 
        {
            perror("Error creating file");
            return -1;
        }
        fclose(fp);
    
    }

    if(value == KERNEL_LOG_OPEN)
    {
        if(access(filePath,F_OK) == 0)
        {
            if(remove(filePath) == 0) 
            {
                return 0;
            } 
            else
            {
                perror("Error deleting kernel_log_close  file");
                return -1;
            }
        }
        else
        {
            return 0;
        }
    
    }

    return 0;

}

