#include "lynq_qser_network.h"
#include "mbtk_type.h"
#include "mbtk_info_api.h"
#include "mbtk_log.h"

#include <stdio.h>
#include <stdlib.h>


mbtk_info_handle_t* lynq_nw_info_handle = NULL;
uint64_t tmp_mode = 0xFF;

nw_client_handle_type g_nw_val = -1;

typedef struct
{
    QSER_NW_RxMsgHandlerFunc_t handlerPtr;
    void* contextPtr;
} lynq_cust_cb_func;

static lynq_cust_cb_func lynq_func_cb_handle;

static int roaming_pref = 1;  // Open roaming for default.

typedef enum {
    RADIO_TECH_3GPP = 1, /* 3GPP Technologies - GSM, WCDMA */
    RADIO_TECH_3GPP2 = 2 /* 3GPP2 Technologies - CDMA */
} RIL_RadioTechnologyFamily;


typedef struct
{
    uint8 *lynq_operator_l;
    uint8 *lynq_operator_s;
    uint32 lynq_mcc_mnc;
} lynq_operator_mcc_mnc_t;

static lynq_operator_mcc_mnc_t lynq_operator_mcc_mnc[] =
{
    {(uint8*)"China Mobile",(uint8*)"CMCC",46000},
    {(uint8*)"China Unicom",(uint8*)"CU",46001},
    {(uint8*)"China Mobile",(uint8*)"CMCC",46002},
    {(uint8*)"China Telecom",(uint8*)"CT",46003},
    {(uint8*)"China Mobile",(uint8*)"CMCC",46004},
    {(uint8*)"China Telecom",(uint8*)"CT",46005},
    {(uint8*)"China Unicom",(uint8*)"CU",46006},
    {(uint8*)"China Mobile",(uint8*)"CMCC",46007},
    {(uint8*)"China Mobile",(uint8*)"CMCC",46008},
    {(uint8*)"China Unicom",(uint8*)"CU",46009},
    {(uint8*)"China Telecom",(uint8*)"CT",46011}
};

#if 0
//T106的实现
/*Used to wait for an update signal*/
int lynq_wait_signalchanges(int *handle)
{
    LYDBGLOG("start wait signalchanges info");
    if(NULL == handle)
    {
        LYERRLOG("illegal input");
        return LYNQ_E_PARAMETER_ANONALY;
    }
    wait_urc_signal_changes();
    LYDBGLOG("get signalchanges");
    *handle = s_module_wait_urc_id;
    return RESULT_OK;
}

bool is_support_urc(int urc_id)
{
    switch(urc_id)
    {
        case RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED:
        case RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED:
        case RIL_UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED:
        case RIL_UNSOL_SIGNAL_STRENGTH:
            return true;
        default:
            return false;
    }
}

/*Used to get urc info*/
int lynq_get_urc_info(const int handle,signalStrength_t *solSigStren,int *slot_id)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return -1;
    }
    LYDBGLOG("start get urc info");
    if(is_support_urc(handle)==false)
    {
        LYINFLOG("invalid handle!!!");
        return -1;
    }
    if((handle ==RIL_UNSOL_SIGNAL_STRENGTH && NULL == solSigStren) ||
        (handle !=RIL_UNSOL_SIGNAL_STRENGTH && NULL == slot_id))
    {
        LYINFLOG("incoming solSigStren or slot_id is NULL!!!");
        return -1;
    }
    switch(handle)
    {
        case RIL_UNSOL_SIGNAL_STRENGTH: //1009
        {
            LYDBGLOG("get state update to signal info");
            solSigStren->gw_sig_valid = s_network_urc_solSigStren.gw_sig_valid;
            solSigStren->rssi = s_network_urc_solSigStren.rssi;
            solSigStren->wcdma_signalstrength = s_network_urc_solSigStren.wcdma_signalstrength;
            solSigStren->wcdma_sig_valid = s_network_urc_solSigStren.wcdma_sig_valid;
            solSigStren->rscp = s_network_urc_solSigStren.rscp;
            solSigStren->ecno = s_network_urc_solSigStren.ecno;
            solSigStren->lte_signalstrength = s_network_urc_solSigStren.lte_signalstrength;
            solSigStren->lte_sig_valid = s_network_urc_solSigStren.lte_sig_valid;
            solSigStren->rsrp = s_network_urc_solSigStren.rsrp;
            solSigStren->rsrq = s_network_urc_solSigStren.rsrq;
            solSigStren->rssnr = s_network_urc_solSigStren.rssnr;
            solSigStren->nr_sig_valid = s_network_urc_solSigStren.nr_sig_valid;
            solSigStren->ssRsrp = s_network_urc_solSigStren.ssRsrp;
            solSigStren->ssRsrq = s_network_urc_solSigStren.ssRsrq;
            solSigStren->ssSinr = s_network_urc_solSigStren.ssSinr;
            solSigStren->csiRsrp = s_network_urc_solSigStren.csiRsrp;
            solSigStren->csiRsrq = s_network_urc_solSigStren.csiRsrq;
            solSigStren->csiSinr = s_network_urc_solSigStren.csiSinr;
            break;
        }
        default:
        {
            *slot_id = s_module_urc_slot_id;
            LYINFLOG("slot_id = %d",s_module_urc_slot_id);
        }
    }
    return 0;
}


void urc_msg_process_voice_reg()
{
    if(s_handlerPtr != NULL)
    {
        s_handlerPtr(g_nw_val,NW_IND_VOICE_REG_EVENT_IND_FLAG,NULL,0,s_contextPtr);
    }
}

void urc_msg_process_data_reg()
{
    if(s_handlerPtr != NULL)
    {
        s_handlerPtr(g_nw_val,NW_IND_DATA_REG_EVENT_IND_FLAG,NULL,0,s_contextPtr);
    }
}

void urc_msg_process_ims_reg()
{
    if(s_handlerPtr != NULL)
    {
        s_handlerPtr(g_nw_val,NW_IND_IMS_REG_EVENT_IND_FLAG,NULL,0,s_contextPtr);
    }
}

void *new_network_thread_recv(void *context)
{
    int handle = -1;
    uint32_t ind_flag = 0;

    while (1)
    {
        lynq_wait_signalchanges(&handle);

        switch(handle)
        {
            case 1002: //RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED:
            {
                urc_msg_process_voice_reg();

                break;
            }
            case 3015://RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED:
            {
                urc_msg_process_data_reg();
                break;
            }
            case 1009://RIL_UNSOL_SIGNAL_STRENGTH:
            {
                urc_msg_process_signal_strength();
                break;
            }
            case 1037://RIL_UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED:
            {
                urc_msg_process_ims_reg();
                break;
            }
        }
    }
    return NULL;
}

void urc_msg_process_signal_strength()
{
    signalStrength_t signalstrength;
    int slot_id;

    int ret = lynq_get_urc_info(1009,&signalstrength,&slot_id);
    if (ret == 0)
    {
        QSER_NW_SINGNAL_EVENT_IND_T msg_buf;
        msg_buf.gsm_sig_info_valid = signalstrength.gw_sig_valid;
        msg_buf.gsm_sig_info.rssi = signalstrength.rssi;
        msg_buf.wcdma_sig_info_valid = signalstrength.wcdma_sig_valid;
        msg_buf.wcdma_sig_info.rssi = signalstrength.rscp;
        msg_buf.wcdma_sig_info.ecio = signalstrength.ecno;
        msg_buf.tdscdma_sig_info_valid = 0;
        msg_buf.lte_sig_info_valid = signalstrength.lte_sig_valid;
        msg_buf.lte_sig_info.rssi = -125;
        msg_buf.lte_sig_info.rsrp = signalstrength.rsrp;
        msg_buf.lte_sig_info.rsrq = signalstrength.rsrq;
        msg_buf.lte_sig_info.snr = signalstrength.rssnr;
        msg_buf.cdma_sig_info_valid = 0;
        msg_buf.hdr_sig_info_valid = 0;
        msg_buf.nr_sig_info_valid = signalstrength.nr_sig_valid;
        msg_buf.nr_sig_info.ssRsrp = signalstrength.ssRsrp;
        msg_buf.nr_sig_info.ssRsrq = signalstrength.ssRsrq;
        msg_buf.nr_sig_info.ssSinr = signalstrength.ssSinr;
        msg_buf.nr_sig_info.csiRsrp = signalstrength.csiRsrp;
        msg_buf.nr_sig_info.csiRsrq = signalstrength.csiRsrq;
        msg_buf.nr_sig_info.csiSinr = signalstrength.csiSinr;
        void *ind_msg_buf= &msg_buf;
        if(s_handlerPtr!=NULL)
        {
            s_handlerPtr(g_nw_val,NW_IND_SIGNAL_STRENGTH_EVENT_IND_FLAG,ind_msg_buf,sizeof (msg_buf) ,s_contextPtr);
        }
   }
}

#endif

static int8_t rssi_convert_to_dBm(uint8 rssi)
{
    if(rssi <= 31)
    {
        return rssi * 2 - 113;
    }
    else
    {
        return -125;
    }
}

static int16_t rsrp_convert_to_dBm(uint8 rsrp)
{
    if(rsrp <= 96)
    {
        return rsrp - 140;
    }
    else
    {
        return -44;
    }
}

static int16_t rsrq_convert_to_dB(uint8 rsrq)
{
    if(rsrq >= 1 && rsrq <= 34)
    {
        return (rsrq + 1) / 2 - 20;
    }
    else
    {
        return  -20;
    }
}

static int16_t ecno_convert_to_dB(uint8 ecno)
{
    if(ecno >= 48)
    {
        return 0;
    }
    else if(ecno == 255)
    {
        return 255;
    }
    else
    {
        return 48 - ecno;
    }
}

void qser_signal_state_change_cb(const void* data, int data_len)
{
    /*
    data_signal[0] = signal.type;
    data_signal[1] = signal.rssi;
    data_signal[2] = signal.rxlev;
    data_signal[3] = signal.ber;
    data_signal[4] = signal.rscp;
    data_signal[5] = signal.ecno;
    data_signal[6] = signal.rsrq;
    data_signal[7] = signal.rsrp;
    */
    if(data && data_len == 8)
    {
        uint8 *net_data = (uint8*)data;
        mbtk_radio_technology_enum type = (mbtk_radio_technology_enum)net_data[0];

        QSER_NW_SINGNAL_EVENT_IND_T signal_msg_buf;
        memset(&signal_msg_buf, 0x0, sizeof(QSER_NW_SINGNAL_EVENT_IND_T));

        signal_msg_buf.gsm_sig_info_valid     = FALSE;
        signal_msg_buf.lte_sig_info_valid     = FALSE;
        signal_msg_buf.wcdma_sig_info_valid   = FALSE;
        signal_msg_buf.tdscdma_sig_info_valid = FALSE;
        signal_msg_buf.cdma_sig_info_valid    = FALSE;
        signal_msg_buf.hdr_sig_info_valid     = FALSE;
        signal_msg_buf.nr_sig_info_valid      = FALSE;

        if(type == MBTK_RADIO_TECH_GSM || type == MBTK_RADIO_TECH_GSM_COMPACT || \
           type == MBTK_RADIO_TECH_GSM_EGPRS)              //GSM
        {
            signal_msg_buf.gsm_sig_info_valid = TRUE;
            signal_msg_buf.gsm_sig_info.rssi = rssi_convert_to_dBm(net_data[1]);
        }
        else if(type == MBTK_RADIO_TECH_E_UTRAN)     //LTE
        {
            signal_msg_buf.lte_sig_info_valid = TRUE;
            signal_msg_buf.lte_sig_info.rssi = rssi_convert_to_dBm(net_data[1]);
            signal_msg_buf.lte_sig_info.rsrp = rsrp_convert_to_dBm(net_data[7]);
            signal_msg_buf.lte_sig_info.rsrq = rsrq_convert_to_dB(net_data[6]);
            signal_msg_buf.lte_sig_info.snr = 0x7FFF;//(当前mbtk没有该参数)
        }
        else if (type == MBTK_RADIO_TECH_UTRAN || type == MBTK_RADIO_TECH_UTRAN_HSDPA || \
                 type == MBTK_RADIO_TECH_UTRAN_HSUPA || type == MBTK_RADIO_TECH_UTRAN_HSDPA_HSUPA ||  \
                 type == MBTK_RADIO_TECH_UTRAN_HSPA )//WCDMA
        {
            signal_msg_buf.wcdma_sig_info_valid = TRUE;
            signal_msg_buf.wcdma_sig_info.rssi = rssi_convert_to_dBm(net_data[1]);
            signal_msg_buf.wcdma_sig_info.ecio = ecno_convert_to_dB(net_data[5]);
        }

        if(lynq_func_cb_handle.handlerPtr != NULL)
        {
            lynq_func_cb_handle.handlerPtr(g_nw_val, NW_IND_SIGNAL_STRENGTH_EVENT_IND_FLAG, (void *)&signal_msg_buf, sizeof(QSER_NW_SINGNAL_EVENT_IND_T), lynq_func_cb_handle.contextPtr);
            lynq_func_cb_handle.handlerPtr(g_nw_val, NW_IND_VOICE_REG_EVENT_IND_FLAG, NULL, 0, lynq_func_cb_handle.contextPtr);
            lynq_func_cb_handle.handlerPtr(g_nw_val, NW_IND_DATA_REG_EVENT_IND_FLAG, NULL, 0, lynq_func_cb_handle.contextPtr);
            lynq_func_cb_handle.handlerPtr(g_nw_val, NW_IND_IMS_REG_EVENT_IND_FLAG, NULL, 0, lynq_func_cb_handle.contextPtr);
        }
    }
    else
    {
        LOGD("qser_nw_state_change_cb : NULL");
    }

}

static uint8 lynq_net_pre_change(bool mbtk_2_lynq,int net_mode)
{
    uint8 mbtk_net_pre = 0xFF;

#if 0
    此参数表在别处使用
    E_QSER_NW_RADIO_TECH_TD_SCDMA = 1,                                       Y3     1
    E_QSER_NW_RADIO_TECH_GSM      = 2,    /**<  GSM; only supports voice. */ YL2    0
    E_QSER_NW_RADIO_TECH_HSPAP    = 3,    /**<  HSPA+. */                      3    1
    E_QSER_NW_RADIO_TECH_LTE      = 4,    /**<  LTE. */                        4    5
    E_QSER_NW_RADIO_TECH_EHRPD    = 5,    /**<  EHRPD. */                      3    1
    E_QSER_NW_RADIO_TECH_EVDO_B   = 6,    /**<  EVDO B. */                   D3     1
    E_QSER_NW_RADIO_TECH_HSPA     = 7,    /**<  HSPA. */                      3     1
    E_QSER_NW_RADIO_TECH_HSUPA    = 8,    /**<  HSUPA. */                     3.5   1
    E_QSER_NW_RADIO_TECH_HSDPA    = 9,    /**<  HSDPA. */                     3.5   1
    E_QSER_NW_RADIO_TECH_EVDO_A   = 10,   /**<  EVDO A. */                   D3     1
    E_QSER_NW_RADIO_TECH_EVDO_0   = 11,   /**<  EVDO 0. */                   D3     1
    E_QSER_NW_RADIO_TECH_1xRTT    = 12,   /**<  1xRTT. */                       2   0
    E_QSER_NW_RADIO_TECH_IS95B    = 13,   /**<  IS95B. */                       3   0
    E_QSER_NW_RADIO_TECH_IS95A    = 14,   /**<  IS95A. */                       3   0
    E_QSER_NW_RADIO_TECH_UMTS     = 15,   /**<  UMTS. */                     L3     1
    E_QSER_NW_RADIO_TECH_EDGE     = 16,   /**<  EDGE. */                      2.75  0
    E_QSER_NW_RADIO_TECH_GPRS     = 17,   /**<  GPRS. */                      2.5   0
    E_QSER_NW_RADIO_TECH_NONE     = 18    /**<  No technology selected. */
#endif
    /*
    0 : GSM only
    1 : UMTS only
    2 : GSM/UMTS(auto)
    3 : GSM/UMTS(GSM preferred)
    4 : GSM/UMTS(UMTS preferred)
    5 : LTE only
    6 : GSM/LTE(auto)
    7 : GSM/LTE(GSM preferred)
    8 : GSM/LTE(LTE preferred)
    9 : UMTS/LTE(auto)
    10 : UMTS/LTE(UMTS preferred)
    11 : UMTS/LTE(LTE preferred)
    12 : GSM/UMTS/LTE(auto)
    13 : GSM/UMTS/LTE(GSM preferred)
    14 : GSM/UMTS/LTE(UMTS preferred)
    15 : GSM/UMTS/LTE(LTE preferred)
    */

    if(mbtk_2_lynq)
    {
        switch(net_mode)
        {
            //使用之前set的tmp_mode的值来进行回显get
            case QSER_NW_MODE_GSM:
                mbtk_net_pre = QSER_NW_MODE_GSM;
                break;
            case QSER_NW_MODE_WCDMA:
                mbtk_net_pre = QSER_NW_MODE_WCDMA;
                break;
            case QSER_NW_MODE_CDMA:
                mbtk_net_pre = QSER_NW_MODE_CDMA;
                break;
            case QSER_NW_MODE_EVDO:
                mbtk_net_pre = QSER_NW_MODE_EVDO;
                break;
            case QSER_NW_MODE_LTE:
                mbtk_net_pre = QSER_NW_MODE_LTE;
                break;
            case QSER_NW_MODE_TDSCDMA:
                mbtk_net_pre = QSER_NW_MODE_TDSCDMA;
                break;
            default:
                mbtk_net_pre = 0xFF;
                break;
        }
    }
    else
   {
        if(QSER_NW_MODE_GSM == net_mode)
        {
            mbtk_net_pre = MBTK_NET_PREF_GSM_ONLY;
        }
        else if(QSER_NW_MODE_WCDMA == net_mode)
        {
            mbtk_net_pre = MBTK_NET_PREF_UMTS_ONLY;
        }
        else if(QSER_NW_MODE_LTE == net_mode)
        {
            mbtk_net_pre = MBTK_NET_PREF_LTE_ONLY;
        }
        else if((QSER_NW_MODE_GSM | QSER_NW_MODE_WCDMA) == net_mode)
        {
            mbtk_net_pre = MBTK_NET_PREF_GSM_UMTS_UMTS_PREF;
        }
        else if((QSER_NW_MODE_WCDMA | QSER_NW_MODE_LTE) == net_mode)
        {
            mbtk_net_pre = MBTK_NET_PREF_UMTS_LTE_LTE_PREF;
        }
        else if((QSER_NW_MODE_GSM | QSER_NW_MODE_LTE) == net_mode)
        {
            mbtk_net_pre = MBTK_NET_PREF_GSM_LTE_LTE_PREF;
        }
        else if((QSER_NW_MODE_GSM | QSER_NW_MODE_WCDMA | QSER_NW_MODE_LTE) == net_mode)
        {
            mbtk_net_pre = MBTK_NET_PREF_GSM_UMTS_LTE_LTE_PREF;
        }
        else
        {
            mbtk_net_pre = 0xFF;
        }
    }
    return mbtk_net_pre;
}

int qser_nw_client_init(nw_client_handle_type *ph_nw)
{
    //UNUSED(ph_nw);

    if(lynq_nw_info_handle == NULL)
    {
        lynq_nw_info_handle = mbtk_info_handle_get();
        if(lynq_nw_info_handle)
        {
            LOGI("creat lynq_nw_info_handle is success");
            *ph_nw = lynq_nw_info_handle->client_fd;
            g_nw_val = lynq_nw_info_handle->client_fd;
        }
        else
        {
            LOGE("creat lynq_nw_info_handle is fail");
            return -1;
        }
    }

    return 0;
}

int qser_nw_client_deinit(nw_client_handle_type h_nw)
{
    //UNUSED(h_nw);
    if (h_nw != g_nw_val || g_nw_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    mbtk_signal_state_change_cb_reg(lynq_nw_info_handle, NULL);

    if(lynq_nw_info_handle)
    {
        mbtk_info_handle_free(&lynq_nw_info_handle);
    }
    else
    {
        LOGE("deinit lynq_nw_info_handle is fail");
        return -1;
    }

    return 0;
}

int qser_nw_set_config(nw_client_handle_type h_nw,QSER_NW_CONFIG_INFO_T *pt_info)
{
    //UNUSED(h_nw);
    //UNUSED(pt_info);
    if (h_nw != g_nw_val || g_nw_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(lynq_nw_info_handle == NULL)
    {
        LOGE("lynq_nw_info_handle == NULL.");
        return -1;
    }

    if(pt_info == NULL)
    {
        LOGE("pt_info == NULL.");
        return -1;
    }

    roaming_pref = pt_info->roaming_pref;

    mbtk_band_info_t band;
    memset(&band, 0, sizeof(mbtk_band_info_t));
    tmp_mode = pt_info->preferred_nw_mode;//临时保存一下原本的mode

    //printf("tmp_mode = [%llu]",tmp_mode);
    band.net_pref = lynq_net_pre_change(FALSE, pt_info->preferred_nw_mode);
    LOGI("band.net_pref = [%d] ",band.net_pref);

    if(band.net_pref == 0xFF)
    {
        LOGE("lynq_net_pre_change() fail.");
        return -1;
    }

    if(mbtk_current_band_set(lynq_nw_info_handle, &band))
    {
        return -1;
    }

    return 0;
}

int qser_nw_get_operator_name(nw_client_handle_type h_nw, QSER_NW_OPERATOR_NAME_INFO_T *pt_info)
{
    //UNUSED(h_nw);
    //UNUSED(pt_info);
    if (h_nw != g_nw_val || g_nw_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(lynq_nw_info_handle == NULL)
    {
        LOGE("lynq_nw_info_handle == NULL.");
        return -1;
    }

    if(pt_info == NULL)
    {
        LOGE("pt_info == NULL.");
        return -1;
    }

    char OperatorFN[128];
    char OperatorSH[128];
    char MccMnc[128];
    mbtk_net_info_t net;
    if(!mbtk_net_sel_mode_get(lynq_nw_info_handle, &net) && net.plmn > 0)
    {
        // printf("Net : %d, %d, %d\n", net.net_sel_mode, net.net_type, net.plmn);
        int i = 0;
        while(i < ARRAY_SIZE(lynq_operator_mcc_mnc))
        {
            if(lynq_operator_mcc_mnc[i].lynq_mcc_mnc == net.plmn)
                break;
            i++;
        }

        if(i == ARRAY_SIZE(lynq_operator_mcc_mnc))   // No found mcc&mnc
        {
            strcpy(OperatorFN, "UNKNOWN");
            strcpy(OperatorSH, "UNKNOWN");
            sprintf(MccMnc, "%d", net.plmn);
        }
        else
        {
            strcpy(OperatorFN, (char*)lynq_operator_mcc_mnc[i].lynq_operator_l);
            strcpy(OperatorSH, (char*)lynq_operator_mcc_mnc[i].lynq_operator_s);
            sprintf(MccMnc, "%d", lynq_operator_mcc_mnc[i].lynq_mcc_mnc);
        }
        memset(pt_info->long_eons,0,128);
        memcpy(pt_info->long_eons,lynq_operator_mcc_mnc[i].lynq_operator_l,strlen((char*)lynq_operator_mcc_mnc[i].lynq_operator_l));
        memset(pt_info->short_eons,0,128);
        memcpy(pt_info->short_eons,lynq_operator_mcc_mnc[i].lynq_operator_s,strlen((char*)lynq_operator_mcc_mnc[i].lynq_operator_s));
        memset(pt_info->mcc,0,4);
        memset(pt_info->mnc,0,4);
        sprintf(pt_info->mcc, "%d", (lynq_operator_mcc_mnc[i].lynq_mcc_mnc)/100);
        sprintf(pt_info->mnc, "%d", (lynq_operator_mcc_mnc[i].lynq_mcc_mnc)%100);
        //pt_info->act;
        return 0;
    }

    return -1;
}

int qser_nw_get_reg_status(nw_client_handle_type h_nw, QSER_NW_REG_STATUS_INFO_T *pt_info)
{
    //UNUSED(h_nw);
    //UNUSED(pt_info);
    if (h_nw != g_nw_val || g_nw_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(lynq_nw_info_handle == NULL)
    {
        LOGE("lynq_nw_info_handle == NULL.");
        return -1;
    }

    if(pt_info == NULL)
    {
        LOGE("pt_info == NULL.");
        return -1;
    }

    /*VOICE/DATA/IMS*/
    mbtk_net_reg_info_t reg;
    int err = mbtk_net_reg_get(lynq_nw_info_handle, &reg);
    if(err)
    {
        LOGE("mbtk_net_reg_get fail.");
        return -1;
    }
    else
    {
        memset(pt_info, 0x0, sizeof(QSER_NW_REG_STATUS_INFO_T));


        char OperatorFN[128];
        char OperatorSH[128];
        char MccMnc[128];
        mbtk_net_info_t net;
        if(!mbtk_net_sel_mode_get(lynq_nw_info_handle, &net) && net.plmn > 0)
        {
            // printf("Net : %d, %d, %d\n", net.net_sel_mode, net.net_type, net.plmn);
            int i = 0;
            while(i < ARRAY_SIZE(lynq_operator_mcc_mnc))
            {
                if(lynq_operator_mcc_mnc[i].lynq_mcc_mnc == net.plmn)
                    break;
                i++;
            }

            if(i == ARRAY_SIZE(lynq_operator_mcc_mnc))   // No found mcc&mnc
            {
                strcpy(OperatorFN, "UNKNOWN");
                strcpy(OperatorSH, "UNKNOWN");
                sprintf(MccMnc, "%d", net.plmn);
            }
            else
            {
                sprintf(MccMnc, "%d", lynq_operator_mcc_mnc[i].lynq_mcc_mnc);
            }
            sprintf(pt_info->data_registration_details_3gpp.mcc, "%d", (lynq_operator_mcc_mnc[i].lynq_mcc_mnc)/100);
            sprintf(pt_info->data_registration_details_3gpp.mnc, "%d", (lynq_operator_mcc_mnc[i].lynq_mcc_mnc)%100);
            sprintf(pt_info->voice_registration_details_3gpp.mcc, "%d", (lynq_operator_mcc_mnc[i].lynq_mcc_mnc)/100);
            sprintf(pt_info->voice_registration_details_3gpp.mnc, "%d", (lynq_operator_mcc_mnc[i].lynq_mcc_mnc)%100);
            //pt_info->act;
        }

        //暂时未知是否其他也被使用，现根据ql模块的传输情况，
        //只配置3gpp,涉及call，data状态没有对应的匹配的就没有赋值

        pt_info->voice_registration_valid = TRUE;
        pt_info->voice_registration.deny_reason = 0;
        pt_info->voice_registration.roaming = 0;
        pt_info->voice_registration.tech_domain = 0;


        pt_info->data_registration_valid = TRUE;
        pt_info->data_registration.deny_reason = 0;
        pt_info->data_registration.roaming = 0;
        pt_info->data_registration.tech_domain = 0;

        if (reg.call_state == 1 || reg.call_state == 5)
        {
            pt_info->voice_registration.registration_state = E_QSER_NW_SERVICE_FULL;
        }
        else if (reg.call_state == 0 || reg.call_state == 2 || reg.call_state == 3 || reg.call_state == 4)
        {
            pt_info->voice_registration.registration_state = E_QSER_NW_SERVICE_NONE;
        }

        if (reg.data_state == 1 || reg.data_state == 5)
        {
            pt_info->data_registration.registration_state = E_QSER_NW_SERVICE_FULL;
        }
        else if (reg.data_state == 0 || reg.data_state == 2 || reg.data_state == 3 || reg.data_state == 4)
        {
            pt_info->data_registration.registration_state = E_QSER_NW_SERVICE_NONE;
        }


        pt_info->voice_registration_details_3gpp_valid = TRUE;
        pt_info->voice_registration_details_3gpp.lac = reg.lac;
        pt_info->voice_registration_details_3gpp.cid = reg.ci;
        //补位填0 or 1
        pt_info->voice_registration_details_3gpp.tech_domain = 1;
        pt_info->voice_registration_details_3gpp.roaming = 0;
        pt_info->voice_registration_details_3gpp.forbidden = 0;
        pt_info->voice_registration_details_3gpp.psc = 0;
        pt_info->voice_registration_details_3gpp.tac = 0;

        pt_info->data_registration_details_3gpp_valid = TRUE;
        pt_info->data_registration_details_3gpp.lac = reg.lac;
        pt_info->data_registration_details_3gpp.cid = reg.ci;
        //补位填0 or 1
        pt_info->data_registration_details_3gpp.tech_domain = 1;
        pt_info->data_registration_details_3gpp.roaming = 0;
        pt_info->data_registration_details_3gpp.forbidden = 0;
        pt_info->data_registration_details_3gpp.psc = 0;
        pt_info->data_registration_details_3gpp.tac = 0;


        pt_info->voice_registration_details_3gpp2_valid = FALSE;
        //pt_info->voice_registration_details_3gpp2

        pt_info->data_registration_details_3gpp2_valid = FALSE;
        //pt_info->data_registration_details_3gpp2


        switch(reg.type)
        {
            case MBTK_RADIO_TECH_GSM:
            case MBTK_RADIO_TECH_GSM_COMPACT:
            case MBTK_RADIO_TECH_GSM_EGPRS:
            case MBTK_RADIO_TECH_UTRAN_HSPA:
            {
                pt_info->data_registration_details_3gpp.radio_tech = E_QSER_NW_RADIO_TECH_GPRS;
                pt_info->voice_registration_details_3gpp.radio_tech = E_QSER_NW_RADIO_TECH_GSM;
                pt_info->data_registration.radio_tech = E_QSER_NW_RADIO_TECH_GPRS;
                pt_info->voice_registration.radio_tech = E_QSER_NW_RADIO_TECH_GSM;
                break;
            }
            case MBTK_RADIO_TECH_UTRAN:
            case MBTK_RADIO_TECH_UTRAN_HSDPA:
            case MBTK_RADIO_TECH_UTRAN_HSUPA:
            case MBTK_RADIO_TECH_UTRAN_HSDPA_HSUPA:
            {
                pt_info->data_registration_details_3gpp.radio_tech = E_QSER_NW_RADIO_TECH_UMTS;
                pt_info->voice_registration_details_3gpp.radio_tech = E_QSER_NW_RADIO_TECH_UMTS;
                pt_info->data_registration.radio_tech = E_QSER_NW_RADIO_TECH_UMTS;
                pt_info->voice_registration.radio_tech = E_QSER_NW_RADIO_TECH_UMTS;
                break;
            }
            case MBTK_RADIO_TECH_E_UTRAN:
            {
                pt_info->data_registration_details_3gpp.radio_tech = E_QSER_NW_RADIO_TECH_LTE;
                pt_info->voice_registration_details_3gpp.radio_tech = E_QSER_NW_RADIO_TECH_LTE;
                pt_info->data_registration.radio_tech = E_QSER_NW_RADIO_TECH_LTE;
                pt_info->voice_registration.radio_tech = E_QSER_NW_RADIO_TECH_LTE;
                break;
            }
            default:
            {
                pt_info->data_registration_details_3gpp.radio_tech = E_QSER_NW_RADIO_TECH_NONE;
                pt_info->voice_registration_details_3gpp.radio_tech = E_QSER_NW_RADIO_TECH_NONE;
                pt_info->data_registration.radio_tech = E_QSER_NW_RADIO_TECH_NONE;
                pt_info->voice_registration.radio_tech = E_QSER_NW_RADIO_TECH_NONE;
                pt_info->data_registration.registration_state = E_QSER_NW_SERVICE_NONE;
                pt_info->voice_registration.registration_state = E_QSER_NW_SERVICE_NONE;
                break;
            }
        }
    }

    return 0;
}

int qser_nw_get_signal_strength(nw_client_handle_type h_nw,QSER_NW_SIGNAL_STRENGTH_INFO_T *pt_info)
{
    //UNUSED(h_nw);
    //UNUSED(pt_info);
    if (h_nw != g_nw_val || g_nw_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(lynq_nw_info_handle == NULL)
    {
        LOGE("lynq_nw_info_handle == NULL.");
        return -1;
    }

    if(pt_info == NULL)
    {
        LOGE("pt_info == NULL.");
        return -1;
    }

    int ret;
    mbtk_signal_info_t signal;
    ret = mbtk_net_signal_get(lynq_nw_info_handle, &signal);
    if(ret != 0) {
        LOGE("mbtk_net_signal_get fail.");
        return -1;
    }
    else
    {
        memset(pt_info, 0x0, sizeof(QSER_NW_SIGNAL_STRENGTH_INFO_T));
        if(signal.type == MBTK_RADIO_TECH_GSM || signal.type == MBTK_RADIO_TECH_GSM_COMPACT || \
           signal.type == MBTK_RADIO_TECH_GSM_EGPRS)              //GSM
        {
            pt_info->gsm_sig_info_valid = TRUE;
            pt_info->gsm_sig_info.rssi = rssi_convert_to_dBm(signal.rssi);
        }
        else if(signal.type == MBTK_RADIO_TECH_E_UTRAN)     //LTE
        {
            pt_info->lte_sig_info_valid = TRUE;
            pt_info->lte_sig_info.rsrp = rsrp_convert_to_dBm(signal.rsrp);
            pt_info->lte_sig_info.rsrq = rsrq_convert_to_dB(signal.rsrq);
            pt_info->lte_sig_info.snr = 0x7FFF;//->MBTK接口无该参数(对应参数为rssnr，该值INT_MAX：0x7FFFFFFFF表示无效值)，写死值为0x7FFFFFFFF
            pt_info->lte_sig_info.rssi = rssi_convert_to_dBm(signal.rssi);
        }
        else if (signal.type == MBTK_RADIO_TECH_UTRAN || signal.type == MBTK_RADIO_TECH_UTRAN_HSDPA || \
                 signal.type == MBTK_RADIO_TECH_UTRAN_HSUPA || signal.type == MBTK_RADIO_TECH_UTRAN_HSDPA_HSUPA ||  \
                 signal.type == MBTK_RADIO_TECH_UTRAN_HSPA )//WCDMA
        {
            pt_info->wcdma_sig_info_valid = TRUE;
            pt_info->wcdma_sig_info.rssi = rssi_convert_to_dBm(signal.rssi);
            pt_info->wcdma_sig_info.ecio = ecno_convert_to_dB(signal.ecno);
        }
        else
        {
            return -1;
        }
        /*
        pt_info->gsm_sig_info_valid = 1//signal.gw_sig_valid;
        pt_info->gsm_sig_info.rssi = signal.rssi;//signal.rssi-110;
        pt_info->wcdma_sig_info_valid = 1//signal.wcdma_sig_valid;
        pt_info->wcdma_sig_info.rssi = signal.rscp;//signal.wcdma_signalstrength-110;
        pt_info->wcdma_sig_info.ecio = //signal.ecno/5;
        pt_info->tdscdma_sig_info_valid = 0;
        pt_info->lte_sig_info_valid = 1//signal.lte_sig_valid;
        pt_info->lte_sig_info.rssi = -125;//signal.lte_signalstrength-110;
        pt_info->lte_sig_info.rsrp = signal.rsrp;//signal.rsrp*(-1);
        pt_info->lte_sig_info.rsrq = signal.rsrq;//signal.rsrq*(-1);
        pt_info->lte_sig_info.snr = 0x7FFFFFFFF;//signal.rssnr;
        pt_info->cdma_sig_info_valid = 0;
        pt_info->hdr_sig_info_valid = 0;
        //mbtk 无nr
        pt_info->nr_sig_info_valid = 0//signal.nr_sig_valid;
        pt_info->nr_sig_info.ssRsrp = 0//signal.ssRsrp;
        pt_info->nr_sig_info.ssRsrq = 0//signal.ssRsrq;
        pt_info->nr_sig_info.ssSinr = 0//signal.ssSinr;
        pt_info->nr_sig_info.csiRsrp = 0//signal.csiRsrp;
        pt_info->nr_sig_info.csiRsrq = 0//signal.csiRsrq;
        pt_info->nr_sig_info.csiSinr = 0//signal.csiSinr;
        */
    }

    return 0;
}

int qser_nw_add_rx_msg_handler (nw_client_handle_type h_nw, QSER_NW_RxMsgHandlerFunc_t handlerPtr, void* contextPtr)
{
    //UNUSED(h_nw);
    //UNUSED(handlerPtr);
    //UNUSED(contextPtr);

    if (h_nw != g_nw_val || g_nw_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(lynq_nw_info_handle == NULL)
    {
        LOGE("lynq_nw_info_handle == NULL.");
        return -1;
    }

    lynq_func_cb_handle.handlerPtr = handlerPtr;
    lynq_func_cb_handle.contextPtr = contextPtr;

    mbtk_signal_state_change_cb_reg(lynq_nw_info_handle, qser_signal_state_change_cb);

    return 0;
}

int qser_nw_set_oos_config (nw_client_handle_type h_nw, QSER_NW_OOS_CONFIG_INFO_T *pt_info)
{
    //UNUSED(h_nw);
    //UNUSED(pt_info);
    if (h_nw != g_nw_val || g_nw_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if (pt_info == NULL)
    {
        LOGE("QSER_NW_OOS_CONFIG_INFO_T NULL");
        return -1;
    }

    uint32 oosPhase_0, oosPhase_1, oosPhase_2;
    char tmp_type;
    mbtk_oos_info oos_info;

    memset(&oos_info, 0x00, sizeof(mbtk_oos_info));


    tmp_type = pt_info->type;

    if (tmp_type == QSER_NW_OOS_CFG_TYPE_FULL_BAND_SCAN)
    {//如果没有配置对应的值，例如，10，20
     //oosPhase_2这个位置没有配置，则使用默认值20，既不限制次数的5s进行一次扫描
     //同理oosPhase_0，oosPhase_1这个位置没有配置，则使用默认值5，10，既限制次数5次的5s，10s进行一次扫描
     //输入多少配置多少，可以缺省使用默认值
        if (pt_info->u.full_band_scan_info.t_min < 0 || pt_info->u.full_band_scan_info.t_step < 0 || pt_info->u.full_band_scan_info.t_max < 0)
        {
            LOGE("qser_nw_set_oos_config set time < 0 ");
            return -1;
        }
        else if ((pt_info->u.full_band_scan_info.t_min > 0 && pt_info->u.full_band_scan_info.t_min <= 255) && pt_info->u.full_band_scan_info.t_step == 0 && pt_info->u.full_band_scan_info.t_max == 0)
        {
            oosPhase_0 = pt_info->u.full_band_scan_info.t_min;
            oos_info.mode = 1;
            oos_info.oosPhase[0] = oosPhase_0;
        }
        else if ((pt_info->u.full_band_scan_info.t_min > 0 && pt_info->u.full_band_scan_info.t_min <= 255) && (pt_info->u.full_band_scan_info.t_step > 0 && pt_info->u.full_band_scan_info.t_step <= 255) && pt_info->u.full_band_scan_info.t_max == 0)
        {
            oosPhase_0 = pt_info->u.full_band_scan_info.t_min;
            oosPhase_1 = pt_info->u.full_band_scan_info.t_step;
            oos_info.mode = 1;
            oos_info.oosPhase[0] = oosPhase_0;
            oos_info.oosPhase[1] = oosPhase_1;
        }
        else if ((pt_info->u.full_band_scan_info.t_min > 0 && pt_info->u.full_band_scan_info.t_min <= 255) && (pt_info->u.full_band_scan_info.t_step > 0 && pt_info->u.full_band_scan_info.t_step <= 255) && (pt_info->u.full_band_scan_info.t_max > 0 && pt_info->u.full_band_scan_info.t_max <= 255))
        {
            oosPhase_0 = pt_info->u.full_band_scan_info.t_min;
            oosPhase_1 = pt_info->u.full_band_scan_info.t_step;
            oosPhase_2 = pt_info->u.full_band_scan_info.t_max;
            oos_info.mode = 1;
            oos_info.oosPhase[0] = oosPhase_0;
            oos_info.oosPhase[1] = oosPhase_1;
            oos_info.oosPhase[2] = oosPhase_2;
        }
        else if (pt_info->u.full_band_scan_info.t_min == 0 && pt_info->u.full_band_scan_info.t_step == 0 && pt_info->u.full_band_scan_info.t_max == 0)
        {
            oos_info.mode = 0;
        }
        else
        {
            LOGE("qser_nw_set_oos_config set Format err");
            return -1;
        }

        int err = mbtk_oos_set(lynq_nw_info_handle, &oos_info);
        if (err != 0)
        {
            LOGE("qser_nw_set_oos_config mbtk_oos_set err");
            return -1;
        }
    }
    else if (tmp_type == QSER_NW_OOS_CFG_TYPE_FAST_SCAN)
    {
        LOGE("Not currently supported");
        return -1;
    }
    else
    {
        LOGE("type is error");
        return -1;
    }

    return 0;
}

int qser_nw_get_oos_config (nw_client_handle_type h_nw, QSER_NW_OOS_CONFIG_INFO_T *pt_info)
{
    //UNUSED(h_nw);
    //UNUSED(pt_info);
    if (h_nw != g_nw_val || g_nw_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    mbtk_oos_info oos_info;
//    uint32 oosPhase_0, oosPhase_1, oosPhase_2;
//    char cmd[100] = {0};

    memset(&oos_info, 0x00, sizeof(mbtk_oos_info));

    int err = mbtk_oos_get(lynq_nw_info_handle, &oos_info);
    if (err != 0)
    {
        LOGE("qser_nw_get_oos_config mbtk_oos_get err ");
        return -1;
    }
/*
    printf("oos_info.mode =[%d] \n",oos_info.mode);
    printf("oos_info.1 =[%d] \n",oos_info.oosPhase[0]);
    printf("oos_info.2 =[%d] \n",oos_info.oosPhase[1]);
    printf("oos_info.3 =[%d] \n",oos_info.oosPhase[2]);
*/
    if(oos_info.mode == 0)//关闭状态
    {
        pt_info->u.full_band_scan_info.t_min = 0;
        pt_info->u.full_band_scan_info.t_step = 0;
        pt_info->u.full_band_scan_info.t_max = 0;
    }
    else
    {
        pt_info->u.full_band_scan_info.t_min = (int)oos_info.oosPhase[0];
        pt_info->u.full_band_scan_info.t_step = (int)oos_info.oosPhase[1];
        pt_info->u.full_band_scan_info.t_max = (int)oos_info.oosPhase[2];
    }
    pt_info->type = QSER_NW_OOS_CFG_TYPE_FULL_BAND_SCAN;


    if (pt_info == NULL)
    {
        LOGE("qser_nw_get_oos_config pt_info is null ");
        return -1;
    }

    return 0;
}

int qser_nw_set_rf_mode (nw_client_handle_type h_nw, E_QSER_NW_RF_MODE_TYPE_T rf_mode)
{
    //UNUSED(h_nw);
    //UNUSED(rf_mode);
    int ret;
    mbtk_modem_info_t info;

    if (h_nw != g_nw_val || g_nw_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(lynq_nw_info_handle == NULL)
    {
        LOGE("lynq_nw_info_handle == NULL.");
        return -1;
    }

/*
    if (rf_mode == 4)
    {
        printf("Flight Mode no Support Now\n");
        return -1;
    }
*/
    if (rf_mode != 4 && rf_mode != 0 && rf_mode != 1)
    {
        LOGE("mode is error!");
        return -1;
    }

    info.fun = rf_mode;
    info.rst = 0;
    ret = mbtk_set_modem_fun(lynq_nw_info_handle, &info);

    //ret = mbtk_radio_state_set(lynq_nw_info_handle, rf_mode);
    if (ret != 0)
    {
        LOGE("mbtk_radio_state_set fail.");
        return -1;
    }
    else
    {
        LOGI("qser_nw_set_rf_mode is success\n");
    }

    return 0;
}

int qser_nw_get_rf_mode (nw_client_handle_type h_nw, E_QSER_NW_RF_MODE_TYPE_T *rf_mode)
{
    //UNUSED(h_nw);
    //UNUSED(rf_mode);
    int ret;
    int tmp_rf;

    if (h_nw != g_nw_val || g_nw_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(lynq_nw_info_handle == NULL)
    {
        LOGE("lynq_nw_info_handle == NULL.");
        return -1;
    }

    ret = mbtk_get_modem_fun(lynq_nw_info_handle, &tmp_rf);

    //ret = mbtk_radio_state_get(lynq_nw_info_handle, &tmp_rf);
    if (ret != 0)
    {
        LOGE("mbtk_radio_state_get fail.");
        return -1;
    }
    else
    {
        LOGI("qser_nw_get_rf_mode is success\n");
        *rf_mode = tmp_rf;
    }


    return 0;
}

int qser_nw_set_ims_enable(nw_client_handle_type        h_nw, E_QSER_NW_IMS_MODE_TYPE_T ims_mode)
{
    int ret = 0;

    if (h_nw != g_nw_val || g_nw_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(lynq_nw_info_handle == NULL)
    {
        LOGE("lynq_nw_info_handle == NULL.");
        return -1;
    }

    ret = mbtk_net_ims_set(lynq_nw_info_handle, ims_mode);
    if (ret != 0)
    {
        LOGE("mbtk_net_ims_set fail.");
        return -1;
    }

    return 0;
}

int qser_nw_get_ims_reg_status(nw_client_handle_type h_nw, QSER_NW_IMS_REG_STATUS_INFO_T *pt_info)
{
    int ret = 0;
    int tmp_pt;

    if (h_nw != g_nw_val || g_nw_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(lynq_nw_info_handle == NULL)
    {
        LOGE("lynq_nw_info_handle == NULL.");
        return -1;
    }

    ret = mbtk_net_ims_reg_state_get(lynq_nw_info_handle, &tmp_pt);
    if (ret != 0)
    {
        LOGE("mbtk_net_ims_get fail.");
        return -1;
    }

    if (tmp_pt == 0)
        pt_info->registration_state = E_QSER_NW_IMS_SERVICE_NONE;
    else if (tmp_pt == 1)
        pt_info->registration_state = E_QSER_NW_IMS_SERVICE_REGISTERED;
    else
    {
        LOGE("mbtk_net_ims_get value error fail.");
        return -1;
    }

    return 0;
}


