#include "lynq_qser_sms.h"
#include "mbtk_type.h"
#include "mbtk_pdu_sms.h"
#include "mbtk_info_api.h"
#include "lynq_sms.h"
#include "mbtk_log.h"


#include <stdio.h>
#include <stdlib.h>


#define TELEPHONE_NUM_MAX 16
#define MSM_NUMBER_MAX 2048+1
#define RES_NUM_MIN 128


#define DSC_to_msg(DSC) (DSC == 0 ? "Bit7" : (DSC == 1 ? "Bit8" : "UCS2"))

static mbtk_info_handle_t* sms_info_handle = NULL;
static char sms_center_address[128] = {0};

typedef struct
{
    QSER_SMS_RxMsgHandlerFunc_t handlerPtr;
    void* contextPtr;
} lynq_sms_cb_func;

static lynq_sms_cb_func lynq_sms_func_cb_handle;

sms_client_handle_type g_sms_val = -1;


void lynq_sms_state_change_cb(const void* data, int data_len)
{
    LOGV("sms_state_change_cb()----------start\n");
    uint8 *ptr = (uint8*)data;
        //printf("3sms_state_change_cb() : %s\n", ptr);

    if (!strncmp("+CMT:", (char*)ptr, 5))//丢弃无用消息
        return ;

    struct SMS_Struct s = PDUDecoding((char*)ptr);
    /*
    printf("服务中心地址: %s\n", s.SCA);
    printf("发送方地址: %s\n", s.OA);
    printf("服务中心时间戳: %s\n", s.SCTS);
    printf("消息内容: %s\n", s.UD);
    printf("数据编码方案： %s\n", DSC_to_msg(s.DCS));
    */
    QSER_SMS_Msg_t* tmp_data = NULL;

    tmp_data = (QSER_SMS_Msg_t*)malloc(sizeof(QSER_SMS_Msg_t));
    memset(tmp_data,0x00, sizeof(QSER_SMS_Msg_t));

    tmp_data->format = s.DCS;
    //printf("t数据编码方案： %d\n", tmp_data->format);
    memcpy(tmp_data->src_addr, s.OA, strlen(s.OA));
    //printf("t发送方地址: %s\n", tmp_data->src_addr);
    memcpy(tmp_data->timestamp, s.SCTS, strlen(s.SCTS));
    //printf("t服务中心时间戳: %s\n", tmp_data->timestamp);
    tmp_data->sms_data_len = strlen(s.UD);
    //printf("t消息内容长度: %d\n", tmp_data->sms_data_len);
    memcpy(tmp_data->sms_data, s.UD, strlen(s.UD));
    //printf("t消息内容: %s\n", tmp_data->sms_data);

    lynq_sms_func_cb_handle.handlerPtr(tmp_data, NULL);

    free(tmp_data);

}


int qser_sms_client_init(sms_client_handle_type *ph_sms)//out
{
    //UNUSED(ph_sms);

    if(sms_info_handle == NULL)
    {
        sms_info_handle = mbtk_info_handle_get();
        if(sms_info_handle)
        {
            LOGI("creat sms_info_handle is success");
            *ph_sms = sms_info_handle->client_fd;
            g_sms_val = sms_info_handle->client_fd;
        }
        else
        {
            LOGE("creat sms_info_handle is fail");
            return -1;
        }
    }

    return 0;
}

int qser_sms_client_deinit(sms_client_handle_type h_sms)//in
{
    //UNUSED(h_sms);
    if (h_sms != g_sms_val || g_sms_val == -1)
    {
        LOGE("handle NULL\n");
        return -1;
    }

    mbtk_sms_state_change_cb_reg(sms_info_handle, NULL);

    if(sms_info_handle)
    {
        mbtk_info_handle_free(&sms_info_handle);
        LOGI("deinit sms_info_handle is succuess");
    }
    else
    {
        LOGE("deinit sms_info_handle is fail");
        return -1;
    }

    return 0;
}

int qser_sms_send_sms(sms_client_handle_type h_sms, QSER_sms_info_t *pt_sms_info)//in in 发送短信的内容、目的号码
{
    //UNUSED(h_sms);
    //UNUSED(pt_sms_info);
    if (h_sms != g_sms_val || g_sms_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if (pt_sms_info == NULL)
    {
        LOGE("QSER_sms_info_t NULL");
        return -1;
    }

    if(sms_info_handle == NULL)
    {
        LOGE("qser_sms_send_sms sms_info_handle NULL");
        return -1;
    }

    uint8_t *phone_num = NULL, *data = NULL;

    char cmgs[MSM_NUMBER_MAX] = {0};
    char resp[RES_NUM_MIN] = {0};
    char pdu_data[512] = {0};
//    char phone_lenth[10] = {0};
//    char mem[10] = {0};
    char *p = pdu_data;
    int mode = 0;
    int err = 0;
    int i = 0;

    data = (uint8_t*)pt_sms_info->sms_data;

    phone_num = (uint8_t*)pt_sms_info->src_addr;

    if (pt_sms_info->format == 0)//7
        mode = 1;
    else if (pt_sms_info->format == 1)//8
        return SMS_ERR;
    else if (pt_sms_info->format == 2)//USC2
        mode = 0;
    else
        return -1;

    //长短信配置当前仅支持text 
    if (pt_sms_info->user_data_head_valid == TRUE)
    {
         if (mode != 1)
         {
            LOGE("qser_sms_send_sms user_data_head_valid is TRUE for text only");
            return -1;
         }
    }


    //设置存储器
/*
    if (pt_sms_info->storage == 0)
    {
        strcpy(mem, "SM");
    }
    else if (pt_sms_info->storage == 1)
    {
        strcpy(mem, "ME");
    }
    else
    {
        LOGE("qser_sms_deletefromstorage storage is no Support");
        return -1;
    }

    memset(resp, 0, sizeof(resp));
    err = mbtk_sms_cpms_set(sms_info_handle, mem, resp);
    if(err) {
        LOGE("Error : %d", err);
    } else {
        LOGI("cpms set success. resp:%s", resp);
    }
*/
    if(data == NULL)
    {
        LOGE("qser_sms_send_sms data NULL");
        return -1;
    }

    if(phone_num == NULL)
    {
        LOGE("qser_sms_send_sms phone_num NULL");
        return -1;
    }

    if(strlen((char*)data) > 512 || strlen((char*)data) == 0 || strlen((char*)phone_num) == 0)
    {
        LOGE("strlen(telephony_num):%d", strlen((char*)phone_num));
        LOGE("strlen(msg):%d", strlen((char*)data));
        return -1;
    }

    if (mode == 0)// PDU
    {
#if 1
        if (sms_center_address[0] == '\0')
        {
            memset(sms_center_address, 0, sizeof(sms_center_address));
            memcpy(sms_center_address, "+8613800280500", strlen("+8613800280500"));
        }

        //printf("phone_num:%s\n", phone_num);
        //printf("sms_center_address:%s\n", sms_center_address);
        //printf("data:%s\n", data);

        char* pdu = NULL;
        char* smsc = SCAEncoding(sms_center_address);
        struct PDUS *pdus = PDUEncoding(sms_center_address, (char*)phone_num, (char*)data, NULL);

        for (i = 0; i < pdus->count; i++)
        {
             LOGI("第 %d 条:", i + 1);
             LOGI("%s\n", pdus->PDU[i]);
             pdu = pdus->PDU[i];
        }

        sprintf(p, "%s",smsc);
        LOGI("pdu_data:%s", pdu_data);
        int sc = strlen(pdu_data);
        sprintf(p+strlen(p), "%s", pdu);
        LOGI("pdu_data:%s",pdu_data);

        //sprintf(cmgs,"%d,%s",strlen(pdu_data), pdu_data);
        int t = strlen(pdu_data);
        sprintf(cmgs,"%d,%s",(t-sc)/2, pdu_data);
        LOGI("cmgs:%s", cmgs);
#else
        char *tmp_t = "0891683108200805F011000D91688189914026F3000800044F60597D";
        sprintf(cmgs,"%d,%s",19,tmp_t);
        printf("cmgs:%s\n", cmgs);
#endif

        memset(resp, 0, sizeof(resp));

        err = mbtk_sms_cmgf_set(sms_info_handle, mode);
        if(err)
        {
           LOGE("cmgf set error : %d", err);
        }
        else
        {
           LOGI("cmgf set success");
        }

        err = mbtk_sms_cmgs_set(sms_info_handle, cmgs, resp);
        if(err)
        {
            LOGE("Error : %d", err);
            return -1;
        }
        else
        {
            LOGI("cmgs set success . resp:%s", resp);
        }
    }
    else if (mode == 1)   // text
    {
        err = mbtk_sms_cmgf_set(sms_info_handle, mode);
        if(err)
        {
           LOGE("cmgf set error : %d", err);
        }
        else
        {
           LOGD("cmgf set success");
        }

        sprintf(cmgs,"%s,%s", (char*)phone_num, (char*)data);
        LOGD("cmgs:%s", cmgs);

        memset(resp, 0, sizeof(resp));

        err = mbtk_sms_cmgs_set(sms_info_handle, cmgs, resp);
        if(err)
        {
            LOGE("Error : %d", err);
            return -1;
        }
        else
        {
            LOGD("cmgs set success . resp:%s", resp);
        }
    }
    else
    {
        LOGE("Error : mode");
        return -1;
    }

    return 0;
}

//注册接收新短信
int qser_sms_addrxmsghandler(QSER_SMS_RxMsgHandlerFunc_t handlerPtr, void* contextPtr)//in sms电话状态回调函数 in 主要是获取 上报 的内容
{
    //UNUSED(handlerPtr);
    //UNUSED(contextPtr);

    if(sms_info_handle == NULL)
    {
        LOGE("qser_sms_addrxmsghandler sms_info_handle NULL");
        return -1;
    }

    int err = mbtk_sms_cnmi_set(sms_info_handle);
    if(err)
    {
        LOGE("set cnmi fail");
        return -1;
    }

    lynq_sms_func_cb_handle.handlerPtr = handlerPtr;
    lynq_sms_func_cb_handle.contextPtr = contextPtr;

    mbtk_sms_state_change_cb_reg(sms_info_handle, lynq_sms_state_change_cb);

    return 0;
}

//删除短信
int qser_sms_deletefromstorage(sms_client_handle_type h_sms, QSER_sms_storage_info_t *pt_sms_storage)//in in 删除短信的信息
{
    //UNUSED(h_sms);
    //UNUSED(pt_sms_storage);
    char cmgd[128] = {0};
    int err = 0;

//    int t_storage = 0;
//    char mem[10] = {0};
//    char resp[RES_NUM_MIN] = {0};

    if (h_sms != g_sms_val || g_sms_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(pt_sms_storage == NULL)
    {
        LOGE("qser_sms_deletefromstorage pt_sms_storage NULL");
        return -1;
    }

    if(sms_info_handle == NULL)
    {
        LOGE("qser_sms_deletefromstorage sms_info_handle NULL");
        return -1;
    }
/*
    t_storage = pt_sms_storage->storage; //设置存储器

    if (t_storage == 0)
    {
        strncpy(mem, "SM", 2);
    }
    else if (t_storage == 1)
    {
        strncpy(mem, "ME", 2);
    }
    else
    {
        LOGE("qser_sms_deletefromstorage storage is no Support");
        return -1;
    }

    memset(resp, 0, sizeof(resp));
    err = mbtk_sms_cpms_set(sms_info_handle, mem, resp);
    if(err) {
        LOGE("Error : %d", err);
    } else {
        LOGI("cpms set success. resp:%s", resp);
    }
*/
    uint32_t id_x = 0; //若后面其他产品是int类型则用宏控制
    id_x = pt_sms_storage->storage_idx;//获取idx的值

    if(id_x == -1)      //delete all
    {
        memcpy(cmgd, "0,4", strlen("0,4"));
    }
    else
    {
        sprintf(cmgd,"%d",id_x);
    }

    LOGI("cmgd:%s", cmgd);

    err = mbtk_sms_cmgd_set(sms_info_handle, cmgd);
    if(err)
    {
        LOGE("qser_sms_deletefromstorage Error : %d", err);
        return -1;
    }
    else
    {
        LOGI("qser_sms_deletefromstorage set success");
    }

    return 0;
}

//获取短信中心号码
int qser_sms_getsmscenteraddress( sms_client_handle_type h_sms,QSER_sms_service_center_cfg_t *set_sca_cfg)//in out
{
    //UNUSED(h_sms);
    //UNUSED(set_sca_cfg);
    char sms_center_addree[254] = {0};
    int len_t;
    char *p1, *p2 ,*substr;

    if (h_sms != g_sms_val || g_sms_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if (set_sca_cfg == NULL)
    {
        LOGE("QSER_sms_service_center_cfg_t NULL");
        return -1;
    }

    if(sms_info_handle == NULL)
    {
        LOGE("qser_sms_getsmscenteraddress sms_info_handle NULL");
        return -1;
    }

    int err = mbtk_sms_csca_get(sms_info_handle, sms_center_addree);
    if(sms_center_addree[0] == '\0')
    {
        LOGE("qser_sms_getsmscenteraddress Error : %d", err);
        return -1;
    }
    else
    {
        p1 = strchr(sms_center_addree, '\"');
        p2 = strrchr(sms_center_addree, '\"');
        if (p1 && p2 && p2 > p1)
        {
            len_t = p2 - p1 - 1;
            char substr_t[len_t + 1];
            strncpy(substr_t, p1 + 1, len_t);
            substr_t[len_t] = '\0';

            substr = substr_t;

            memcpy(set_sca_cfg->service_center_addr, substr, strlen(substr));
            memcpy(sms_center_address, substr, strlen(substr));

            LOGI("qser_sms_getsmscenteraddress success");
        }
        else
        {
            LOGE("String inside double quotes not found");
            return -1;
        }
    }

    return 0;
}

//设置短信中心号码
int qser_sms_setsmscenteraddress( sms_client_handle_type h_sms, QSER_sms_service_center_cfg_t *get_sca_cfg)//in in
{
    //UNUSED(h_sms);
    //UNUSED(get_sca_cfg);
    char *destNum = NULL;

    if (h_sms != g_sms_val || g_sms_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(sms_info_handle == NULL)
    {
        LOGE("qser_sms_setsmscenteraddress sms_info_handle NULL");
        return -1;
    }

    if(get_sca_cfg == NULL)
    {
        LOGE("qser_sms_setsmscenteraddress get_sca_cfg NULL");
        return -1;
    }

    destNum = get_sca_cfg->service_center_addr;

    //printf("1destNum:%s\n", destNum);
    memset(sms_center_address, 0, sizeof(sms_center_address));
    memcpy(sms_center_address, destNum, strlen(destNum));

    if (destNum == NULL)
    {
        LOGE("qser_sms_setsmscenteraddress destNum NULL");
        return -1;
    }

    int err = mbtk_sms_csca_set(sms_info_handle, destNum);
    if(err)
    {
        LOGE("Error : %d", err);
        return -1;
    }
    else
    {
    //    memset(sms_center_address, 0, sizeof(sms_center_address));
    //    memcpy(sms_center_address, destNum, strlen(destNum));
        //printf("destNum:%s\n", destNum);
        LOGI("qser_sms_setsmscenteraddress success");
    }

    return 0;
}


//显示删除列表
int qser_sms_deletefromstoragelist( sms_client_handle_type h_sms, char* del_list)//in out
{
    //UNUSED(h_sms);
    //UNUSED(get_sca_cfg);

    if (h_sms != g_sms_val || g_sms_val == -1)
    {
        LOGE("handle NULL");
        return -1;
    }

    if(sms_info_handle == NULL)
    {
        LOGE("qser_sms_deletefromstoragelist sms_info_handle NULL");
        return -1;
    }

    int err = mbtk_sms_cmgd_get(sms_info_handle, del_list);
    if(err > 0  && err != 300)//MBTK_INFO_ERR_SUCCESS
    {
        LOGE("Error : %d", err);
        return -1;
    }

    return 0;
}

