#include "sta_cli.h"
#include "lynq_wifi.h"
#include "mbtk_log.h"


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mbtk_utils.h"



#define STA_BUF_SIZE 2048
lynq_wifi_event_handle_sta g_event_handle_sta_cb = NULL;


int qser_wifi_enable(void)
{
    static char sta_cli_buf[STA_BUF_SIZE] = "OPEN";
    char reply[STA_BUF_SIZE];
    if(sta_cli_cmd_parse(sta_cli_buf, reply, STA_BUF_SIZE)){
		if(strlen(reply) > 0)
		{
           LOGE("reply data(%s).\n",reply);
		}else{
			LOGE("No reply data(%s).\n",sta_cli_buf);
		}
    }else{
        LOGE("Parse cmd fail.\n");
    }

    return 0;
}


int qser_wifi_disable(void)
{
    static char sta_cli_buf[STA_BUF_SIZE] = "CLOSE";
    char reply[STA_BUF_SIZE];
    if(sta_cli_cmd_parse(sta_cli_buf, reply, STA_BUF_SIZE)){
		if(strlen(reply) > 0)
		{
           LOGE("reply data(%s).\n",reply);
		}else{
			LOGE("No reply data(%s).\n",sta_cli_buf);
		}
    }else{
        LOGE("Parse cmd fail.\n");
    }
    return 0;
}

int qser_wifi_sta_param_set(lynq_wifi_sta_param_t *param_stat)
{

    sta_cli_ssid_set(param_stat->ssid);
    sta_cli_psk_set(param_stat->passwd);
    return 0;
}


int qser_wifi_sta_param_get(lynq_wifi_sta_param_t *param_stat)
{
    int len = 0;
    sta_cli_ssid_get(param_stat->ssid);
    len = strlen(param_stat->ssid);
    param_stat->ssid[len - 1] = '\0';
    sta_cli_psk_get(param_stat->passwd);
    len = strlen(param_stat->passwd);
    param_stat->passwd[len - 1] = '\0';

    LOGE("ssid: %s, passwd: %s", param_stat->ssid, param_stat->passwd);

    return 0;
}

int qser_wifi_sta_start(void)
{
    char reply[STA_BUF_SIZE];

    if(sta_cli_cmd_parse("ADD_NETWORK", reply, STA_BUF_SIZE))
    {
		if(strlen(reply) > 0)
		{
           LOGE("reply data(%s).\n",reply);
		}else
        {
			LOGE("No reply data\n");
		}
    }
    else
    {
        LOGE("Parse cmd fail.\n");
    }


    if(sta_cli_cmd_parse("SELECT_NETWORK", reply, STA_BUF_SIZE))
    {
		if(strlen(reply) > 0)
		{
           LOGE("reply data(%s).\n",reply);
		}else
        {
			LOGE("No reply data\n");
		}
    }
    else
    {
        LOGE("Parse cmd fail.\n");
    }

      if(sta_cli_cmd_parse("ENABLE_NETWORK", reply, STA_BUF_SIZE))
    {
		if(strlen(reply) > 0)
		{
           LOGE("reply data(%s).\n",reply);
		}else
        {
			LOGE("No reply data\n");
		}
    }
    else
    {
        LOGE("Parse cmd fail.\n");
    }

    mbtk_system("udhcpc -i wlan0");


    return 0;
}

int qser_wifi_sta_stop(void)
{
    char reply[STA_BUF_SIZE];

    if(sta_cli_cmd_parse("DISABLE_NETWORK", reply, STA_BUF_SIZE))
    {
		if(strlen(reply) > 0)
		{
           LOGE("reply data(%s).\n",reply);
		}else
        {
			LOGE("No reply data\n");
		}
    }
    else
    {
        LOGE("Parse cmd fail.\n");
    }

      if(sta_cli_cmd_parse("REMOVE_NETWORK", reply, STA_BUF_SIZE))
    {
		if(strlen(reply) > 0)
		{
           LOGE("reply data(%s).\n",reply);
		}else
        {
			LOGE("No reply data\n");
		}
    }
    else
    {
        LOGE("Parse cmd fail.\n");
    }

   return 0;
}

int  qser_wifi_sta_get_status(lynq_wifi_sta_status_t *status_stat)
{
    char reply[STA_BUF_SIZE];
    int i = 0, j = 0;
    int status_flag = 0;

      if(sta_cli_cmd_parse("STATUS", reply, STA_BUF_SIZE))
    {
		if(strlen(reply) > 0)
		{
           LOGE("reply data(%s).\n",reply);
		}else
        {
			LOGE("No reply data\n");
		}
    }
    else
    {
        LOGE("Parse cmd fail.\n");
    }


    for(i = 0; i < strlen(reply); i++)
    {
        if(',' == reply[i])
        {
            j = 0;
            status_flag++;
            continue;
        }

        if(0 == status_flag)
        {
            status_stat->status = 4;
            j++;
        }
        else if(1 == status_flag)
        {
            status_stat->ap_bssid[j] = reply[i];
            j++;
        }
        else if(2 == status_flag)
        {
            status_stat->ifname[j] = reply[i];
            j++;
        }
        else if(8 == status_flag)
        {
            status_stat->has_addr = '1';
            status_stat->addr[0].addr[j] = reply[i];
            j++;
        }



    }
    LOGE("state:%d, ap_bssid:%s, ifname:%s, has_addr:%c, addr:%s\n", status_stat->status, status_stat->ap_bssid, status_stat->ifname, status_stat->has_addr,
                status_stat->addr[0].addr);

    return 0;

}



int qser_wifi_register_handle(lynq_wifi_event_handle event_handle, lynq_wifi_event_handle_sta event_handle_sta, void *arg)
{


    if(NULL != event_handle_sta)
    {
        g_event_handle_sta_cb = event_handle_sta;

    }

    return 0;
}


int qser_wifi_sta_start_scan(void)
{
    char reply[STA_BUF_SIZE] = {0};
    lynq_wifi_sta_scan_list_t scan_list = {0};
    int i = 0, j = 0;
    int status_flag = 0;

    if(sta_cli_cmd_parse("SCAN", reply, STA_BUF_SIZE))
    {
		if(strlen(reply) > 0)
		{
           LOGE("reply data(%s).\n",reply);
		}else
        {
			LOGE("No reply data\n");
		}
    }
    else
    {
        LOGE("Parse cmd fail.\n");
    }



    scan_list.cnt = 1;

    for(i = 0; i < strlen(reply); i++)
    {
        if(',' == reply[i])
        {
            j = 0;
            status_flag++;
            continue;
        }

        if(0 == status_flag)
        {
            scan_list.info[0].bssid[j] = reply[i];
            j++;
        }
        else if(1 == status_flag)
        {
            //scan_list.info[0].bssid = reply[i];
            j++;
        }
        else if(2 == status_flag)
        {
            //scan_list.info[0].signal = atoi(reply[i]);
            j++;
        }
        else if(4 == status_flag)
        {
            scan_list.info[0].essid[j] = reply[i];
            j++;
        }



    }



    g_event_handle_sta_cb(&scan_list);
    return 0;
}

/*
 void lynq_wifi_event_handle_demo(lynq_wifi_event_s *event, void *arg)
 {
    if(event->id == LYNQ_WIFI_EVENT_AP_STATION)
        LOGE("[lynq-wifi-demo] %s:event-id = %d- %d\n", __func__, event->id, event->status);
    else if(event->id == LYNQ_WIFI_EVENT_AP_STA_STATUS)
        LOGE("[lynq-wifi-demo] %s:event-id = %d,%d,%s,%s\n", __func__, event->id,
        event->ap_sta_info.connected, event->ap_sta_info.mac,event->ap_sta_info.hostname);
    if(event->id == LYNQ_WIFI_EVENT_STA_STATUS)
        LOGE("[lynq-wifi-demo] %s:event-id = %d- %d\n", __func__, event->id, event->status);
    else
    return;
 }
 */

 void lynq_wifi_event_handle_sta_demo(lynq_wifi_sta_scan_list_t *event)
 {
     int i = 0;
     for (i = 0; i < event->cnt; i++)
     {
         LOGE("[lynq-wifi-demo] %s : ap[%d]:%s,%d,%d,%d,%s,%d,%d,%d\n", __func__, i,
         event->info[i].essid, event->info[i].auth,
         event->info[i].cipher, event->info[i].channel, event->info[i].bssid,
         event->info[i].signal_level,event->info[i].frequency,event->info[i].signal);
     }
 }





/*

int qser_wifi_work_mode_set(lynq_wifi_work_mode_e type)
{

}


int qser_wifi_work_mode_get(lynq_wifi_work_mode_e *type)
{

}

int qser_wifi_register_handle(lynq_wifi_event_handle event_handle, lynq_wifi_event_handle_staevent_handle_sta, void *arg)
{

}


int qser_wifi_get_sta_pkt_stats(lynq_wifi_pkt_stats_t *pkt_stat)
{

}

int qser_wifi_sta_start_scan(void)
{

}

*/



