#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "ql_absys_api.h"
#include "mbtk_type.h"
#include "mbtk_fota.h"
#include "mbtk_log.h"
#include "mbtk_utils.h"

int ql_absys_get_cur_active_part(absystem_t *cur_system)
{

    FILE *file = NULL;
    char cmdline[1024] = {0}; 
    
    file = fopen("/proc/cmdline", "r");
    if(file == NULL)
    {
        LOGE("Failed to open /proc/cmdline");
        return -1; 
    }

    if(fgets(cmdline, sizeof(cmdline), file) != NULL)
    {
        if(strstr(cmdline, "system=a") != NULL) 
        {
            *cur_system = SYSTEM_A;
        }
        else
        {
            *cur_system = SYSTEM_B;
        }
    }

    fclose(file); 
    return 0;

}

int ql_absys_switch(void)
{
    int absys_t, active, tmp_active, reboot_cnt;

    active = mbtk_fota_get_active_absys_type();
    tmp_active = mbtk_fota_get_tmp_absys_type();
    absys_t = mbtk_fota_get_sync_absys_type();
    reboot_cnt = mbtk_fota_get_asr_reboot_cnt_flag();
    LOGI("ql_absys_get_cur_active_part active=%d,tmp_active=%d,absys_t=%d,reboot_cnt=%d",active,tmp_active,absys_t,reboot_cnt);

    if (reboot_cnt == 0 && (active == tmp_active))
    {
        return 0;
    }

    if ((active == tmp_active) && absys_t == 0)
    {
        return -2;
    }

    if ((active != tmp_active) && absys_t == 0)
    {
        return -3;
    }

    return -1;
}

int ql_absys_getstatus(sysstatus_t *sys_state)
{
    int active, tmp_active, mtd_check;
    char tmp_ac, ac;
    char out[8]={0};

    active = mbtk_fota_get_active_absys_type();
    tmp_active = mbtk_fota_get_tmp_absys_type();
    mtd_check = mbtk_fota_get_mtd_check_type();
    LOGI("ql_absys_get_cur_active_part tmp_active=%d active=%d mtd_check=%d",tmp_active,active,mtd_check);

    if (mtd_check == 0)
    {
        sys_state->is_damaged = 0;
    }
    else
    {
        if (tmp_active == 0)
            tmp_ac = 'A';
        else
            tmp_ac = 'B';

        if (active == 0)
            ac = 'A';
        else
            ac = 'B';

        sys_state->is_damaged = 1;
        sprintf(out, "%c to %c",tmp_ac, ac);
        memcpy(sys_state->damaged_partname, out, strlen(out));
    }

    return 0;
}

int ql_absys_sync(void)
{
    mbtk_system("sync");

    return 0;
}


