#include "ql_adc.h"
#include "mbtk_adc.h"


/*========================================================================
  FUNCTION:  ql_adc_show
=========================================================================*/
/** @brief
    This function retrieves the ADC voltage value with the specified
    ADC channel.
    Support input vol value:
    ADC0 : 0V-VBAT_BB
    ADC1 : 0V-VBAT_BB

    @param[in] qadc, adc channel definitions, one value of ADC_CHANNEL_E.

    @return
    adc value(mv) on success
    on failure, the return value is -1;
*/
/*=======================================================================*/
int ql_adc_show(ADC_CHANNEL_E qadc)
{
    if(qadc >= ADC0 && qadc <= ADC2) {
        int result = mbtk_adc_get(ADC_DEVICE_AUX, (mbtk_adc_enum)(qadc - 1));
        if(result < 0) {
            return -1;
        } else {
            return result;
        }
    } else {
        return -1;
    }
}

