#include "ql_atc.h"
#include "ql_type.h"

#include "mbtk_at.h"

/*-----------------------------------------------------------------------------------------------*/
/**
  @brief Initialize ATC service.
  @note You must call this function before other functions can be used in this module.
  @return Whether the ATC service was successfully intialized.
  @retval QL_ERR_OK successful.
  @retval QL_ERR_SERVICE_NOT_READY service is not ready, need to retry.
  @retval Other error code defined by ql_type.h.
  */
/*-----------------------------------------------------------------------------------------------*/
int ql_atc_init(void)
{
	return mbtk_at_init();
}


/*-----------------------------------------------------------------------------------------------*/
/**
  @brief send at command async.
  @param[in] req_buf At command request content
  @param[out] async_index Async AT command index
  @param[in] async_cb Async callback function
  @return Whether to successfully send the AT command asynchronously
  @retval QL_ERR_OK successful
  @retval QL_ERR_NOT_INIT uninitialized
  @retval QL_ERR_SERVICE_NOT_READY service is not ready
  @retval Other error code defined by ql_type.h
  */
/*-----------------------------------------------------------------------------------------------*/
int ql_atc_send_async(char *req_buf, int *async_index, void *async_cb)
{
	return QL_ERR_UNSUPPORTED;
}


/*-----------------------------------------------------------------------------------------------*/
/**
  @brief send AT command.
  @param[in] req_buf At command request content
  @param[in] rsp_buf At command response content
  @param[in] rsp_len The length of rsp_buf
  @return Whether to successfully send AT command
  @retval QL_ERR_OK successful
  @retval QL_ERR_NOT_INIT uninitialized
  @retval QL_ERR_SERVICE_NOT_READY service is not ready
  @retval Other error code defined by ql_type.h
  */
/*-----------------------------------------------------------------------------------------------*/
int ql_atc_send(char *req_buf, char *rsp_buf, int rsp_len)
{
	return mbtk_at_send(req_buf, rsp_buf, rsp_len);
}

/*-----------------------------------------------------------------------------------------------*/
/**
  @brief Deinitialize ATC service.
  @return Whether the DM service was successfully deintialized.
  @retval QL_ERR_OK successful.
  @retval Other error code defined by ql_type.h.
  */
/*-----------------------------------------------------------------------------------------------*/
int ql_atc_deinit(void)
{
	return mbtk_at_deinit();
}

