/*-----------------------------------------------------------------------------------------------*/
/**
  @file  ql_cell_locator.h
  @brief cell_locator service API
*/
/*-----------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------------
  Copyright (c) 2018 Quectel Wireless Solution, Co., Ltd. All Rights Reserved.
  Quectel Wireless Solution Proprietary and Confidential.
-------------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------------
  EDIT HISTORY
  This section contains comments describing changes made to the file.
  Notice that changes are listed in reverse chronological order.
  $Header: $
  when       who          what, where, why
  --------   ---          ----------------------------------------------------------
  20220810    sunshine     Created .
-------------------------------------------------------------------------------------------------*/

#ifndef __QL_CELL_LOCATOR_H__
#define __QL_CELL_LOCATOR_H__
#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned short uint16_t;


typedef struct 
{
    char *ptr;
    //size_t len;
} curl_rsp_msg_t;



typedef struct
{
    double   latitude;
    double   longitude;
    double   altitude;
} ql_inject_location_t;

typedef struct
{
    /*longtitude*/
    double lon;
    /*latitude*/
    double lat;
    /*accuracy*/
    unsigned short accuracy;

    char err_msg[256];
} ql_perform_rsp;

typedef void (*ql_cell_locator_ind_cb_f)(void *msg);

typedef void (*ql_cell_locator_error_cb_f)(int error);


/*-----------------------------------------------------------------------------------------------*/
/**
  @brief Initialize the cell_locator client
  @return
  QL_ERR_OK - successful
  QL_ERR_INVALID_ARG - as defined
  QL_ERR_SERVICE_NOT_READY - service is not ready, need to retry
  Other - error code defined by ql_type.h
  */
/*-----------------------------------------------------------------------------------------------*/
int ql_cell_locator_init(void);



/*-----------------------------------------------------------------------------------------------*/
/**
  @brief set locator query server and port, server length must be less than 255 bytes.
  @return
  QL_ERR_OK - successful
  QL_ERR_INVALID_ARG - as defined
  QL_ERR_SERVICE_NOT_READY - service is not ready, need to retry
  Other - error code defined by ql_type.h
  */
/*-----------------------------------------------------------------------------------------------*/
int ql_cell_locator_set_server(char *server, uint16_t port);



/*-----------------------------------------------------------------------------------------------*/
/**
  @brief set locator query timeout, the value must between 1-300 [seconds]
  @return
  QL_ERR_OK - successful
  QL_ERR_INVALID_ARG - as defined
  QL_ERR_SERVICE_NOT_READY - service is not ready, need to retry
  Other - error code defined by ql_type.h
  */
/*-----------------------------------------------------------------------------------------------*/
int ql_cell_locator_set_timeout(uint16_t timeout);



/*-----------------------------------------------------------------------------------------------*/
/**
  @brief set locator query token, token length must be 16 bytes. the token Used to verify that 
         the client accessing the service is valid.
  @return
  QL_ERR_OK - successful
  QL_ERR_INVALID_ARG - as defined
  QL_ERR_SERVICE_NOT_READY - service is not ready, need to retry
  Other - error code defined by ql_type.h
  */
/*-----------------------------------------------------------------------------------------------*/
int ql_cell_locator_set_token(char *token);


/*-----------------------------------------------------------------------------------------------*/
/**
  @brief Register cell_locator callback
  @param[in] cb
  @return
  QL_ERR_OK - successful
  QL_ERR_NOT_INIT - uninitialized
  QL_ERR_SERVICE_NOT_READY - service is not ready
  QL_ERR_INVALID_ARG - Invalid arguments
  Other - error code defined by ql_type.h
  */
/*-----------------------------------------------------------------------------------------------*/
int ql_cell_locator_set_ind_cb(ql_cell_locator_ind_cb_f cb);




/*-----------------------------------------------------------------------------------------------*/
/**
  @brief  Registration server error callback. Currently, only if the server exits abnormally, 
  the callback function will be executed, and the error code is QL_ERR_ABORTED;
  @param[in] cb  Callback function 
  @return
  QL_ERR_OK - successful
  Other - error code defined by ql_type.h
  */
/*-----------------------------------------------------------------------------------------------*/
int ql_cell_locator_set_service_error_cb(ql_cell_locator_error_cb_f cb);



/*-----------------------------------------------------------------------------------------------*/
/**
  @brief Deinitialize the  cell_locator client
  @return
  QL_ERR_OK - successful
  Other - error code defined by ql_type.h
  */
/*-----------------------------------------------------------------------------------------------*/
int ql_cell_locator_deinit(void);

/*-----------------------------------------------------------------------------------------------*/
/**
  @brief cell_locator start
  @return
  QL_ERR_OK - successful
  Other - error code defined by ql_type.h
  */
/*-----------------------------------------------------------------------------------------------*/
int ql_cell_locator_start(void);

/*-----------------------------------------------------------------------------------------------*/
/**
  @brief cell_locator stop
  @return
  QL_ERR_OK - successful
  Other - error code defined by ql_type.h
  */
/*-----------------------------------------------------------------------------------------------*/
int ql_cell_locator_stop(void);

int ql_cell_locator_perform(ql_perform_rsp *rsp_ptr);

#ifdef __cplusplus
}
#endif

#endif

