/**  
  @file
  ql_fota.h

  @brief
  This file provides the definitions for device, and declares the 
  API functions.

*/
/*============================================================================
  Copyright (c) 2017 Quectel Wireless Solution, Co., Ltd.  All Rights Reserved.
  Quectel Wireless Solution Proprietary and Confidential.
 =============================================================================*/
/*===========================================================================

                        EDIT HISTORY FOR MODULE

This section contains comments describing changes made to the module.
Notice that changes are listed in reverse chronological order.


WHEN        WHO            WHAT, WHERE, WHY
----------  ------------   ----------------------------------------------------
25/11/2021  jessie.lei      create
=============================================================================*/
#ifndef __QL_FOTA_H__
#define __QL_FOTA_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "fota_info.h"

/*
 * callback function define, used to get upgrade state and rate of process
 */
typedef int(*ql_fota_cb_f)(int state, int percent);


/*******************************************************************************
* @brief fota initialize
  @param 
  @return 
        if success return 0, else return -1
 *******************************************************************************/
int ql_fota_init(void);


/*******************************************************************************
* @brief fota de-initialize
  @param 
  @return 
        if success return 0, else return -1
 *******************************************************************************/
int ql_fota_deinit(void);


/*******************************************************************************
* @brief set fota callback
  @param 
    cb: callback function
  @return 
        if success return 0, else return -1
 *******************************************************************************/
int ql_fota_set_cb(ql_fota_cb_f cb);


/*******************************************************************************
* @brief fota initialize
  @param 
    otasize: The OTA firmware size
  @return 
        if success return 0, else return -1
 *******************************************************************************/
int ql_fota_start(unsigned int otasize);


/*******************************************************************************
* @brief write fota firmware data
  @param 
    buffer: The buffer 
    size  : Data length in buffer
  @return 
        if success return 0, else return -1
 *******************************************************************************/
int ql_fota_write(unsigned char *buffer, unsigned int size);


/*******************************************************************************
* @brief get fota state
  @param 
    state: fota state, refer to fota_state_t
  @return 
        if success return 0, else return -1
 *******************************************************************************/
int ql_fota_get_state(fota_state_t *state);


/*******************************************************************************
* @brief set fota state
  @param 
    state: fota state, refer to fota_state_t
  @return 
        if success return 0, else return -1
 *******************************************************************************/
int ql_fota_set_state(fota_state_t state);


/*******************************************************************************
* @brief finish fota process
  @param 
  @return 
        if success return 0, else return -1
 *******************************************************************************/
int ql_fota_done(void);


#ifdef __cplusplus
}
#endif

#endif //__QL_FOTA_H__
