#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "ql_fota_api.h"
#include "mbtk_type.h"
#include "mbtk_fota.h"
#include "mbtk_log.h"
#include "mbtk_utils.h"

unsigned int Process_flag = 0;
char addr_buf[128]={0};
int segment_size =0;

#define StatFunc(x,y) stat(x,y)

static int s_ota_flag = -1;
int funstat(  char *filename)
{
    int ret = 0;
    struct stat tmep_s;

    memset(&tmep_s, 0, sizeof(stat));
    ret = StatFunc(filename, &tmep_s);

    if (ret)
    {
        LOGE("stat %s failed! error_code: %s", filename ,strerror(errno));
        return -1;
    }

    if (tmep_s.st_size > 0)
    {
        segment_size = tmep_s.st_size;
    }

    return 0;
}


int ql_fota_cb(int status, int percent)
{
    LOGE("%d: percent: %d%%\n", percent/10, percent);
    Process_flag = percent;
    return 0;
}

int ql_abfota_start_update(const char *package_path)
{
    LOGI("%s, %d", __FUNCTION__, __LINE__);
    int ret = 0;
    int len = 0;

    if(s_ota_flag == -1)
    {
        ret = mbtk_fota_init(ql_fota_cb);
        if (ret)
        {
            LOGE("ql_abfota_start_update init fail");
            return -1;
        }
        else
        {
            s_ota_flag = 0;
        }
    }

    memset(addr_buf, 0, sizeof(addr_buf));
    sprintf(addr_buf, "%supdata.bin", package_path);
    len = strlen(addr_buf);
    if (len > 127)
    {
        LOGE("ql_abfota_start_update get package_path fail");
        return -1;
    }

    if(strncmp(addr_buf, "http", 4) == 0)
    {
        segment_size = 62914560;
        ret = mbtk_fota_fw_write_by_url(addr_buf, segment_size,10, 600);
    }
    else
    {
        /*获取升级文件的大小*/
        ret = funstat(addr_buf);
        if (ret)
        {
            LOGE("ql_abfota_start_update get segment_size fail");
            return -1;
        }

        LOGI("addr_buf:%s, segment_size:%d", addr_buf, segment_size);
        ret = mbtk_fota_fw_write(addr_buf, segment_size);
    }

    if (ret)
    {
        LOGE("ql_abfota_start_update fail");
        return -1;
    }

    mbtk_system("sync");

    return 0;
}

int ql_abfota_get_update_status(update_info_t * update_info)
{
    int fota_t;

    fota_t = mbtk_fota_status();

    if (fota_t == 3)
    {
        update_info->ota_state = UPDATE;
        update_info->percentage = Process_flag;
        update_info->exit_code = E_UPDATE_PACKAGE_NOEXIST;
    }
    else if (fota_t == 4)
    {
        update_info->ota_state = WRITEDONE;
        update_info->percentage = Process_flag;
        update_info->exit_code = E_NO_ERROR;
    }
    else if (fota_t == 5)
    {
        update_info->ota_state = FAILED;
        update_info->percentage = Process_flag;
        update_info->exit_code = E_WRITE_SEG_FAILED;
    }
    else if (fota_t == -1)
    {
        LOGE("ql_abfota_get_update_status fail");
        return -1;
    }

    return 0;
}

