
/**
  @file
  ql_fota_common.h

  @brief
  This file provides the definitions for common functions, and declares the
  common functions.

*/
/*============================================================================
  Copyright (c) 2017 Quectel Wireless Solution, Co., Ltd.  All Rights Reserved.
  Quectel Wireless Solution Proprietary and Confidential.
 =============================================================================*/
/*===========================================================================

                        EDIT HISTORY FOR MODULE

This section contains comments describing changes made to the module.
Notice that changes are listed in reverse chronological order.


WHEN        WHO            WHAT, WHERE, WHY
----------  ------------   ----------------------------------------------------
23/08/2019  Nebula.li      create
=============================================================================*/

#ifndef __QL_FOTA_COMMON_H
#define __QL_FOTA_COMMON_H

#include <stdint.h>

#define QL_OTAD_CLIENT_INIT_CNT_MAX  20

#define QL_OTAD_SEND_MSG_TIMEOUT     (3 * 1000)

typedef void (*ql_otad_service_error_cb_f)(int error);

int ql_otad_client_init(void);
int ql_otad_client_release(void);
int ql_otad_send_msg_sync(int32_t msg_id, 
                          void *p_req_msg_data,
                          uint32_t req_msg_data_len,
                          void *p_resp_msg_data,
                          uint32_t resp_msg_data_len,
                          uint32_t timeout);

#endif  /* __QL_FOTA_COMMON_H */
