#include "ql_gpio.h"
#include "mbtk_gpio.h"
#include "mbtk_log.h"
#include "mbtk_type.h"

#include <errno.h>

int ql_gpio_init(ENUM_PINNAME       pin_name, 
                 ENUM_PIN_DIRECTION  dir, 
                 ENUM_PIN_LEVEL      level, 
                 ENUM_PIN_PULLSEL    pull_sel
                 )
{
    if(pull_sel != PINPULLSEL_DISABLE)
    {
        LOGE("[ql_gpio_init] pull_sel fail.");
        return RES_BAD_PARAMETER;
    }

    if(dir == PINDIRECTION_IN)
    {
        dir = MBTK_GPIO_DIRECT_IN;
    }
    else if(dir == PINDIRECTION_OUT)
    {
        dir = MBTK_GPIO_DIRECT_OUT;
    }
    else
    {
        dir = MBTK_GPIO_DIRECT_UNKNOWN;
        LOGE("[ql_gpio_init] direction fail.");
        return RES_BAD_PARAMETER;
    }

    if(level != PINLEVEL_LOW && level != PINLEVEL_HIGH)
    {
        LOGE("[ql_gpio_init] level fail.");
        return RES_BAD_PARAMETER;
    }

    if(mbtk_gpio_export(pin_name))
    {
        LOGE("[ql_gpio_init]gpio_export fail.");
        return RES_IO_ERROR;
    }

    if(mbtk_gpio_direct_set(pin_name, dir))
    {
        LOGE("[ql_gpio_init]gpio_direct_set fail.");
        return RES_IO_ERROR;
    }

    if(mbtk_gpio_value_set_2(pin_name, level))
    {
        LOGE("[ql_gpio_init]gpio_value_set fail.");
        return RES_IO_ERROR;
    }

    return RES_OK;
}

int ql_gpio_set_level(ENUM_PINNAME pin_name, ENUM_PIN_LEVEL level)
{
    if(level != PINLEVEL_LOW && level != PINLEVEL_HIGH)
    {
        LOGE("[ql_gpio_set_level] level fail.");
        return RES_BAD_PARAMETER;
    }

    if(mbtk_gpio_value_set_2(pin_name, level) != 0)
    {
        LOGE("[ql_gpio_set_level]gpio_value_set fail.");
        return RES_IO_ERROR;
    }

    return RES_OK;
}

int ql_gpio_get_level(ENUM_PINNAME pin_name)
{
    int ret;

    ret = mbtk_gpio_value_get(pin_name);
    if (ret == -1)
    {
        LOGE("[ql_gpio_set_level]gpio_value_set fail.");
        return RES_IO_ERROR;
    }

    return ret;
}

int ql_gpio_set_direction(ENUM_PINNAME pin_name, ENUM_PIN_DIRECTION dir)
{
    if(dir == PINDIRECTION_IN)
    {
        dir = MBTK_GPIO_DIRECT_IN;
    }
    else if(dir == PINDIRECTION_OUT)
    {
        dir = MBTK_GPIO_DIRECT_OUT;
    }
    else
    {
        dir = MBTK_GPIO_DIRECT_UNKNOWN;
        LOGE("[ql_gpio_init] direction fail.");
        return RES_BAD_PARAMETER;
    }

    if(mbtk_gpio_direct_set(pin_name, dir))
    {
        LOGE("[ql_gpio_set_direction]gpio_direct_set fail.");
        return RES_IO_ERROR;
    }

    return RES_OK;
}

int ql_gpio_uninit(ENUM_PINNAME pin_name)
{
    if(mbtk_gpio_unexport(pin_name))
    {
        LOGE("[ql_gpio_uninit]gpio_unexport fail.");
        return RES_IO_ERROR;
    }

    return RES_OK;
}

