#include <stddef.h>
#include "ql_sleep_wakelock.h"
#include "mbtk_sleep.h"
#include "mbtk_log.h"

/*
 * create wakelock, return the file description of the wakelock
 */
int ql_slp_wakelock_create(const char *name, size_t len)
{
    int ret;

    ret = mbtk_wakelock_create(name, len);
    if (ret == -1)
    {
        LOGE("mbtk_wakelock_create is error");
    }

    return ret;
}

/*
 * lock the wakelock by the file description of the wakelock
 */
int ql_slp_wakelock_lock(int fd)
{
    int ret;

    ret = mbtk_wakelock_lock(fd);
    if (ret == -1)
    {
        LOGE("ql_slp_wakelock_lock is error");
    }

    return ret;
}

/*
 * unlock the wakelock by the file description of the wakelock
 */
int ql_slp_wakelock_unlock(int fd)
{
    int ret;

    ret = mbtk_wakelock_unlock(fd);
    if (ret == -1)
    {
        LOGE("ql_slp_wakelock_unlock is error");
    }

    return ret;
}

/*
 * destroy the wakelock by the file description of the wakelock
 */
int ql_slp_wakelock_destroy(int fd)
{
    int ret;

    ret = mbtk_wakelock_destroy(fd);
    if (ret == -1)
    {
        LOGE("ql_slp_wakelock_destroy is error");
    }

    return ret;
}

/*
 * Enable/Disable autosleep function
 */
int ql_autosleep_enable(char enable)
{
    int ret;

    ret = mbtk_autosuspend_enable(enable);
    if (ret == -1)
    {
        LOGE("ql_autosleep_enable is error");
    }

    return ret;
}


