/*-----------------------------------------------------------------------------------------------*/
/**
  @file test_utils.c 
  @brief Test related interface definition
*/
/*-----------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------------
  Copyright (c) 2018 Quectel Wireless Solution, Co., Ltd. All Rights Reserved.
  Quectel Wireless Solution Proprietary and Confidential.
-------------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------------
  EDIT HISTORY
  This section contains comments describing changes made to the file.
  Notice that changes are listed in reverse chronological order.
  $Header: $
  when       who          what, where, why
  --------   ---          ----------------------------------------------------------
  20190508   tyler.kuang  Created .
-------------------------------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ql_test_utils.h"

/*-----------------------------------------------------------------------------------------------*/
/** 
  @brief Read a int value from stdin 
  @param[out] val, Return read data
  @return 
  0 - successful
  1 - read an enter 
  -1 - invalid input
  */
/*-----------------------------------------------------------------------------------------------*/
int t_get_int(int *val)
{
    int dat;
    char *ptr_end = NULL;
    char buf[256] = {0};

    if(NULL == fgets(buf, sizeof(buf)-1, stdin))
    {
        return -1;
    }
    
    if(0 == buf[0])
    {
        return -1;
    }

    if(buf[0] == '\n')
    {
        return 1;
    }

    dat = strtol(buf, &ptr_end, 10);
    if(ptr_end!=NULL && ptr_end[0]!='\n')
    {
        return -1;
    }

    if(val)
    {
        val[0] = dat;
    }

    return 0;
}

/*-----------------------------------------------------------------------------------------------*/
/** 
  @brief Read a uint32 value from stdin 
  @param[out] val, Return read data
  @return 
  0 - successful
  1 - read an enter 
  -1 - invalid input
  */
/*-----------------------------------------------------------------------------------------------*/
int t_get_hex(uint32_t *val)
{
    int dat;
    char *ptr_end = NULL;
    char buf[256] = {0};

    if(fgets(buf, sizeof(buf)-1, stdin) == NULL)
    {
        return -1;
    }
    
    if(0 == buf[0])
    {
        return -1;
    }

    if(buf[0] == '\n')
    {
        return 1;
    }

    dat = strtol(buf, &ptr_end, 16);
    if(ptr_end!=NULL && ptr_end[0]!='\n')
    {
        return -1;
    }

    if(val)
    {
        val[0] = dat;
    }

    return 0;
}

/*-----------------------------------------------------------------------------------------------*/
/** 
  @brief Read a char value from stdin 
  @param[out] val, Return read data
  @return 
  0 - successful
  1 - read an enter 
  -1 - invalid input
  */
/*-----------------------------------------------------------------------------------------------*/
int t_get_char(int *val)
{
    char buf[256] = {0};

    if(fgets(buf, sizeof(buf)-1, stdin) == NULL)
    {
        return -1;
    }
    
    if(0 == buf[0])
    {
        return -1;
    }

    if(buf[0] == '\n')
    {
        return 1;
    }

    if(buf[1]!='\n')
    {
        return -1;
    }

    if(val)
    {
        val[0] = buf[0];
    }

    return 0;
}

/*-----------------------------------------------------------------------------------------------*/
/** 
  @brief Read a string value from stdin 
  @param[out] val, Return read data
  @return 
  0 - successful
  1 - read an enter 
  -1 - invalid input
  */
/*-----------------------------------------------------------------------------------------------*/
int t_get_string(char *str_buf, int str_len)
{
    char *ptr;
    char buf[256] = {0};

    if(fgets(buf, sizeof(buf)-1, stdin) == NULL)
    {
        return -1;
    }
    
    if(0 == buf[0])
    {
        return -1;
    }

    if(buf[0] == '\n')
    {
        return 1;
    }
    
    ptr = strchr(buf, '\n');
    if(ptr)
    {
        ptr[0] = 0;
    }
    
    strncpy(str_buf, buf, str_len-1);
    
    return 0;
}

/*-----------------------------------------------------------------------------------------------*/
/** 
  @brief Read a list of int values from stdin 
  @param[out] val, Return read datas
  @param[out&in] val, Input buffer length, output the number of read
  @return 
  0 - successful
  1 - read an enter 
  -1 - invalid input
  */
/*-----------------------------------------------------------------------------------------------*/
int t_get_int_list(int *dat_buf, int *dat_len)
{
    int idx = 0;
    int len;
    int dat;
    char *ptr, *ptr_save;
    char *ptr_end;
    char buf[256] = {0};

    if(!dat_buf || !dat_len)
    {
        return -1;
    }

    len = dat_len[0];

    if(fgets(buf, sizeof(buf)-1, stdin) == NULL)
    {
        return -1;
    }

    if(0 == buf[0])
    {
        return -1;
    }

    if(buf[0] == '\n')
    {
        return 1;
    }

    for(ptr=strtok_r(buf, ",.: \t\r\n", &ptr_save); 
            ptr!=NULL;
            ptr=strtok_r(NULL, ",.: \t\r\n", &ptr_save))
    {
        dat = strtol(ptr, &ptr_end, 10);
        if(ptr_end!=NULL && ptr_end[0]!=0)
        {
            return -1;
        }
        if(idx >= len)
        {
            return 0;
        }

        dat_buf[idx] = dat;
        idx++;
    }
    
    dat_len[0] = idx;
    return 0;
}

/*-----------------------------------------------------------------------------------------------*/
/** 
  @brief Read a list of float values from stdin 
  @param[out] val, Return read datas
  @param[out&in] val, Input buffer length, output the number of read
  @return 
  0 - successful
  1 - read an enter 
  -1 - invalid input
  */
/*-----------------------------------------------------------------------------------------------*/
int t_get_float_list(float *dat_buf, int *dat_len)
{
    int idx = 0;
    int len;
    float dat;
    char *ptr, *ptr_save;
    char *ptr_end;
    char buf[256] = {0};

    if(!dat_buf || !dat_len)
    {
        return -1;
    }

    len = dat_len[0];

    if(fgets(buf, sizeof(buf)-1, stdin) == NULL)
    {
        return -1;
    }

    if(0 == buf[0])
    {
        return -1;
    }

    if(buf[0] == '\n')
    {
        return 1;
    }

    for(ptr=strtok_r(buf, ",: \t\r\n", &ptr_save); 
            ptr!=NULL;
            ptr=strtok_r(NULL, ",: \t\r\n", &ptr_save))
    {
        dat = strtof(ptr, &ptr_end);
        if(ptr_end!=NULL && ptr_end[0]!=0)
        {
            return -1;
        }
        if(idx >= len)
        {
            return 0;
        }

        dat_buf[idx] = dat;
        idx++;
    }
    
    dat_len[0] = idx;
    return 0;
}


