#include <stdio.h>
#include <string.h>
#include "ql_type.h"
#include "ql_data_call.h"
#include "ql_nslookup.h"
#include "mbtk_utils.h"

typedef void (*item_handler_f)(void);

typedef struct
{
    const char *name;
    item_handler_f handle;
} t_item_t;

const char *ql_data_call_state_str(int state)
{
    switch(state)
    {
        case QL_NET_DATA_CALL_STATUS_NONE:
            return "NONE";
        case QL_NET_DATA_CALL_STATUS_CREATED:
            return "CREATE";
        case  QL_NET_DATA_CALL_STATUS_IDLE:
            return "IDLE";
        case  QL_NET_DATA_CALL_STATUS_CONNECTING:
            return "CONNECTING";
        case QL_NET_DATA_CALL_STATUS_PARTIAL_V4_CONNECTED:
            return "PARTIAL_V4_CONNECTED";
        case  QL_NET_DATA_CALL_STATUS_PARTIAL_V6_CONNECTED:
            return "PARTIAL_V6_CONNECTED";
        case QL_NET_DATA_CALL_STATUS_CONNECTED:
            return "CONNECTED";
        case  QL_NET_DATA_CALL_STATUS_DISCONNECTED:
            return "DISCONNECTED";
        case  QL_NET_DATA_CALL_STATUS_ERROR:
            return "ERROR";
        case  QL_NET_DATA_CALL_STATUS_DELETED:
            return "DELETE";
        default:
            break;
    };

    return "UNKNOW";
}


void data_call_status_ind_cb(int call_id,
        QL_NET_DATA_CALL_STATUS_E pre_call_status,
        ql_data_call_status_t *p_msg)
{
    printf("----DATA CALL STATUS CHANGE EVENT:\n");
    printf("\tcall_id=%d\n", call_id);
    printf("\tpre_call_status=%s\n", ql_data_call_state_str(pre_call_status));
    printf("\tcall_name=%s\n", p_msg->call_name);
    printf("\tcall_status=%s\n", ql_data_call_state_str(p_msg->call_status));
    if(p_msg->device[0])
    {
        printf("\tdevice=%s\n", p_msg->device);
    }
    if(p_msg->has_addr)
    {
        printf("\tIP4 : addr=%s\n", p_msg->addr.addr);
        printf("\tIP4 : netmask=%s\n", p_msg->addr.netmask);
        printf("\tIP4 : subnet_bits=%d\n", p_msg->addr.subnet_bits);
        printf("\tIP4 : gateway=%s\n", p_msg->addr.gateway);
        printf("\tIP4 : dnsp=%s\n", p_msg->addr.dnsp);
        printf("\tIP4 : dnss=%s\n", p_msg->addr.dnss);
    }

    if(p_msg->has_addr6)
    {
        printf("\tIP6 : addr=%s\n", p_msg->addr6.addr);
        printf("\tIP6 : prefix=%s\n", p_msg->addr6.prefix);
        printf("\tIP6 : prefix_bits=%d\n", p_msg->addr6.prefix_bits);
        printf("\tIP6 : gateway=%s\n", p_msg->addr6.gateway);
        printf("\tIP6 : dnsp=%s\n", p_msg->addr6.dnsp);
        printf("\tIP6 : dnss=%s\n", p_msg->addr6.dnss);
    }

    printf("\tcall_end_reason_type=%d\n", p_msg->call_end_reason_type);
    printf("\tcall_end_reason_code=0x%X\n", p_msg->call_end_reason_code);
}

void data_call_service_error_cb(int error)
{
    printf("===== DATACALL Service Abort =====\n");
}

void item_ql_data_call_init(void)
{
    int ret = 0;
    printf("Start to ql_data_call_init\n");
    ret = ql_data_call_init();
    if(ret == QL_ERR_OK)
    {
        printf("Successful\n");
    }
    else
    {
        printf("Failed to ql_data_call_init, ret=%d\n", ret);
    }
}

void item_ql_data_call_set_service_error_cb(void)
{
    int ret = 0;
    printf("Start to ql_data_call_set_service_error_cb\n");
    ret = ql_data_call_set_service_error_cb(data_call_service_error_cb);
    if(ret == QL_ERR_OK)
    {
        printf("Successful\n");
    }
    else
    {
        printf("Failed to ql_data_call_set_service_error_cb, ret=%d\n", ret);
    }

}

void item_ql_data_call_deinit(void)
{
    int ret = 0;
    printf("Start to ql_data_call_deinit\n");
    ret = ql_data_call_deinit();
    if(ret == QL_ERR_OK)
    {
        printf("Successful\n");
    }
    else
    {
        printf("Failed to ql_data_call_deinit, ret=%d\n", ret);
    }
}

void item_ql_data_call_create(void)
{
    int ret = 0;
    int call_id = -1;
    char call_name[64] = {0};
    int is_background = 0;

    printf("Please input call_id :");
    ret = t_get_int(&call_id);
    if(ret != 0)
    {
       printf("Invalid input\n");
       return;
    }

    printf("Please input call name :");
    ret = t_get_string(call_name, sizeof(call_name));
    if(ret != 0)
    {
        printf("Invalid input\n");
        return;
    }

    printf("Working in background ?[0|1] :");
    ret = t_get_int(&is_background);
    if(ret != 0)
    {
        printf("Invalid input\n");
        return;
    }

    printf("call_id=%d\n", call_id);
    printf("call_name=%s\n", call_name);
    printf("is_background=%d\n", is_background);
    printf("Start to ql_data_call_create\n");
    ret = ql_data_call_create(call_id, call_name, is_background);

    if(ret == QL_ERR_OK)
    {
        printf("Successful\n");
    }
    else
    {
        printf("Failed to ql_data_call_create, ret=%d\n", ret);
    }
}

void dump_data_call_config(ql_data_call_param_t *pcfg)
{
    int ret;
    int dat;
    int i;
    int dat_list[128];
    int dat_len;

    ret = ql_data_call_param_get_apn_id(pcfg, &dat);
    if(ret != QL_ERR_OK)
    {
        printf("Failed to get apn_id\n");
        return;
    }

    printf("apn_id  : %d\n", dat);

    ret = ql_data_call_param_get_ip_version(pcfg, &dat);
    if(ret != QL_ERR_OK)
    {
        printf("Failed to get ip_version\n");
        return;
    }
    printf("ip_version : %d\n", dat);

    ret = ql_data_call_param_get_reconnect_mode(pcfg, &dat);
    if(ret != QL_ERR_OK)
    {
        printf("Failed to get reconnect_mode\n");
        return;
    }
    printf("reconnect_mode : %d\n", dat);

    dat_len = sizeof(dat_list)/sizeof(dat_list[0]);
    ret = ql_data_call_param_get_reconnect_interval(pcfg, dat_list, &dat_len);
    if(ret != QL_ERR_OK)
    {
        printf("Failed to get reconnect interval\n");
        return;
    }

    printf("interval : ");
    for(i=0; i<dat_len; i++)
    {
        if(dat_list[i]==0)
        {
            break;
        }
        if(i!=0)
        {
            printf("%c", ',');
        }
        printf("%d", dat_list[i]);
    }
    printf("\n");
}

void item_ql_data_call_config(void)
{
    int ret = 0;
    int call_id;
    int apn_id;
    int dat = 0;
    ql_data_call_param_t *pcfg;
    int dat_buf[128];
    int dat_len = sizeof(dat_buf)/sizeof(dat_buf[0]);

    pcfg = ql_data_call_param_alloc();
    if(pcfg == NULL)
    {

        printf("Failed to ql_data_call_param_alloc");
        return;
    }

    do
    {
        printf("Please input call_id :");
        ret = t_get_int(&call_id);
        if(ret != 0)
        {
            printf("Invalid input\n");
            ret = -1;
            break;
        }

        printf("Please input apn_id :");
        ret = t_get_int(&apn_id);
        if(ret != 0)
        {
            printf("Invalid input\n");
            ret = -1;
            break;
        }

        if(apn_id<1 || apn_id>QL_NET_MAX_APN_ID)
        {
            printf("Invalid apn_id\n");
            ret = -1;
            break;
        }

        ql_data_call_param_set_apn_id(pcfg, apn_id);

        printf("Please input ip_version [1-IPV4,2-IPV6,3-IPV4V6] :");
        ret = t_get_int(&dat);
        if(ret < 0)
        {
            printf("Invalid input\n");
            ret = -1;
            break;
        }

        if(ret == 0)
        {
            if(!IS_QL_NET_IP_VER_VALID(dat))
            {
                printf("Unsupport ip_version : %d\n", dat);
                ret = -1;
                break;
            }

            ql_data_call_param_set_ip_version(pcfg, dat);
        }

        printf("Please input reconnect_mode [0-disable,1-normal,2-mode1,3-mode2] :\n");
        ret = t_get_int(&dat);
        if(ret < 0)
        {
            printf("Invalid input\n");
            ret = -1;
            break;
        }

        if(ret == 0)
        {
            if(!IS_QL_NET_DATA_CALL_RECONNECT_MODE_VALID(dat))
            {
                printf("Unsupport mode : %d\n", dat);
                ret = -1;
                break;
            }
           ql_data_call_param_set_reconnect_mode(pcfg, dat);
        }


        printf("Please input interval_list [split by ,.:] :\n");
        dat_len = sizeof(dat_buf)/sizeof(dat_buf[0]);
        ret = t_get_int_list(dat_buf, &dat_len);
        if(ret < 0)
        {
            printf("Invalid input\n");
            ret = -1;
            break;
        }

        if(ret == 0)
        {
            ql_data_call_param_set_reconnect_interval(pcfg, dat_buf, dat_len);
        }

        ret = 0;
    }
    while(0);

    if(ret == 0)
    {
        dump_data_call_config(pcfg);
        printf("Accept ? [Y|N] :");
        ret = t_get_char(&dat);
        if(ret < 0)
        {
            printf("Invalid input\n");
        }
        else
        {
            if(ret==1 || dat=='Y' || dat=='y')
            {
                printf("Start to ql_data_call_config\n");
                ret = ql_data_call_config(call_id, pcfg);
                if(ret != QL_ERR_OK)
                {
                    printf("Failed to ql_data_call_config, ret=%d\n", ret);
                }
                else
                {
                    printf("Successful\n");
                }
            }
            else
            {
                printf("Skip ql_data_call_config");
            }
        }
    }

    ql_data_call_param_free(pcfg);
}


void item_ql_data_call_get_config(void)
{
    int ret = 0;
    int call_id;
    ql_data_call_param_t *pcfg;

    pcfg = ql_data_call_param_alloc();
    if(pcfg == NULL)
    {

        printf("Failed to ql_data_call_param_alloc");
        return;
    }

    do
    {
        printf("Please input call_id :");
        ret = t_get_int(&call_id);
        if(ret != 0)
        {
            printf("Invalid input\n");
            ret = -1;
            break;
        }

        ret = ql_data_call_get_config(call_id, pcfg);
        if(ret != QL_ERR_OK)
        {
            printf("Failed to ql_data_call_get_config, ret=%d\n", ret);
            ret = -1;
            break;
        }

        printf("Successful\n");

        dump_data_call_config(pcfg);
    } while(0);

    ql_data_call_param_free(pcfg);
}

void item_ql_data_call_start(void)
{
    int ret = 0;
    int call_id = -1;

    printf("Please input call_id :");
    ret = t_get_int(&call_id);
    if(ret != 0)
    {
       printf("Invalid input\n");
       return;
    }

    printf("Start to ql_data_call_start, data_call=%d\n", call_id);
    ret = ql_data_call_start(call_id);
    if(ret != QL_ERR_OK)
    {
        printf("Failed to ql_data_call_start, ret=%d\n", ret);
    }
    else
    {
        printf("Successful\n");
    }
}

void item_ql_data_call_stop(void)
{
    int ret = 0;
    int call_id = -1;

    printf("Please input call_id :");
    ret = t_get_int(&call_id);
    if(ret != 0)
    {
       printf("Invalid input\n");
       return;
    }

    printf("Start to ql_data_call_stop, data_call=%d\n", call_id);
    ret = ql_data_call_stop(call_id);
    if(ret != QL_ERR_OK)
    {
        printf("Failed to ql_data_call_stop, ret=%d\n", ret);
    }
    else
    {
        printf("Successful\n");
    }
}

void item_ql_data_call_delete(void)
{
    int ret = 0;
    int call_id = -1;

    printf("Please input call_id :");
    ret = t_get_int(&call_id);
    if(ret != 0)
    {
       printf("Invalid input\n");
       return;
    }

    printf("Start to ql_data_call_delete, data_call=%d\n", call_id);
    ret = ql_data_call_delete(call_id);
    if(ret != QL_ERR_OK)
    {
        printf("Failed to ql_data_call_delete, ret=%d\n", ret);
    }
    else
    {
        printf("Successful\n");
    }
}

void item_ql_data_call_get_list(void)
{
    int i;
    int ret = 0;
    ql_data_call_item_t item_list[20];
    int list_len = ARRAY_SIZE(item_list);

    memset(item_list,0,sizeof(ql_data_call_item_t)*20);
    printf("Start to ql_data_call_get_list\n");
    ret = ql_data_call_get_list(item_list, &list_len);
    if(ret != QL_ERR_OK)
    {
        printf("Failed to ql_data_call_get_list, ret=%d\n", ret);
    }
    else
    {
        printf("Successful, instance_num=%d\n", list_len);
        for(i=0; i<list_len; i++)
        {
            printf("%d\t%d\t%s\n", i, item_list[i].call_id, item_list[i].call_name);
        }
    }
}

void  item_ql_data_call_get_status(void)
{
    int ret = 0;
    int call_id;
    ql_data_call_status_t sta = {0};

    printf("Please input call_id :");
    ret = t_get_int(&call_id);
    if(ret != 0)
    {
       printf("Invalid input\n");
       return;
    }

    printf("Start to ql_data_call_get_status\n");
    ret = ql_data_call_get_status(call_id, &sta);
    if(ret != QL_ERR_OK)
    {
        printf("Failed to ql_data_call_get_status, ret=%d\n", ret);
        return;
    }

    printf("Successful\n");
    printf("call_id : %d\n", sta.call_id);
    printf("call_name : %s\n", sta.call_name);
    printf("call_status : %s\n", ql_data_call_state_str(sta.call_status));

    if(sta.device[0])
    {
        printf("device : %s\n", sta.device);
    }

    if(sta.has_addr)
    {
        printf("\tip4 ip      : %s\n", sta.addr.addr);
        printf("\tip4 netmask : %s\n", sta.addr.netmask);
        printf("\tip4 subnet_bits : %d\n", sta.addr.subnet_bits);
        printf("\tip4 gateway : %s\n", sta.addr.gateway);
        printf("\tip4_dnsp    : %s\n", sta.addr.dnsp);
        printf("\tip4_dnss    : %s\n", sta.addr.dnss);
    }

    if(sta.has_addr6)
    {
        printf("\tip6 ip      : %s\n", sta.addr6.addr);
        printf("\tip6 prefix  : %s\n", sta.addr6.prefix);
        printf("\tip6 prefix_bits : %d\n", sta.addr6.prefix_bits);
        printf("\tip6 gatway      : %s\n", sta.addr6.gateway);
        printf("\tip6 dnsp    : %s\n", sta.addr6.dnsp);
        printf("\tip6 dnss    : %s\n", sta.addr6.dnss);
    }

    printf("call_end_reason_type : %d\n", sta.call_end_reason_type);
    printf("call_end_reason_code : 0x%X\n", sta.call_end_reason_code);
}

void item_ql_data_call_set_status_ind_cb(void)
{
    int ret;

    printf("Start to ql_data_call_set_status_ind_cb\n");
    ret = ql_data_call_set_status_ind_cb(data_call_status_ind_cb);
    if(ret != QL_ERR_OK)
    {
        printf("Failed to ql_data_call_set_status_ind_cb, ret=%d\n", ret);
    }
    else
    {
        printf("Successful\n");
    }
}

void dump_apn_cfg(ql_data_call_apn_config_t *p_cfg)
{
    printf("ip_version : %d\n", p_cfg->ip_ver);
    printf("auth_pref : %d\n", p_cfg->auth_pref);
    printf("apn_name  : %s\n", p_cfg->apn_name);
    printf("username  : %s\n", p_cfg->username);
    printf("password  : %s\n", p_cfg->password);
}

void item_ql_data_call_set_apn_config(void)
{
    int ret;
    int dat;
    int apn_id = 0;
    ql_data_call_apn_config_t cfg = {0};

    printf("Start to item_ql_data_call_set_apn_config\n");

    printf("Please input apn_id :");
    ret = t_get_int(&apn_id);
    if(ret != 0)
    {
        printf("Invalid input\n");
        return;
    }

    if(apn_id<1 || apn_id>16)
    {
        printf("Invalid apn_id : %d\n", apn_id);
        return;
    }

    printf("Please input auth_pref [0-NONE,1-PAP,2-CHAP,3-PAP&CHAP] :\n");
    ret = t_get_int(&dat);
    if(ret < 0)
    {
        printf("Invalid input\n");
        return;
    }

    if(ret == 0)
    {
        if(!IS_QL_NET_AUTH_PREF_VALID(dat))
        {
            printf("Unspport auth_pref : %d\n", dat);
            return;
        }

        cfg.auth_pref = dat;
    }

    printf("Please input ip_version [1-IPV4,2-IPV6,3-IPV4V6] :\n");
    ret = t_get_int(&dat);
    if(ret < 0)
    {
        printf("Invalid input\n");
        return;
    }

    if(ret == 0)
    {
        if(!IS_QL_NET_IP_VER_VALID(dat))
        {
            printf("Unsupport ip_version : %d\n", dat);
            return;
        }

        cfg.ip_ver = dat;
    }

    printf("Please input apn_name :");
    ret = t_get_string(cfg.apn_name, sizeof(cfg.apn_name));
    if(ret < 0)
    {
        printf("Invalid input\n");
        return;
    }

    printf("Please input username :");
    ret = t_get_string(cfg.username, sizeof(cfg.username));
    if(ret < 0)
    {
        printf("Invalid input\n");
        return;
    }

    printf("Please input password :");
    ret = t_get_string(cfg.password, sizeof(cfg.password));
    if(ret < 0)
    {
        printf("Invalid input\n");
        return;
    }

    printf("apn_id : %d", apn_id);
    dump_apn_cfg(&cfg);

    ret = ql_data_call_set_apn_config(apn_id, &cfg);

    if(ret != QL_ERR_OK)
    {
        printf("Failed to ql_data_call_set_apn_config, ret=%d\n", ret);
    }
    else
    {
        printf("Successful\n");
    }
}

void item_ql_data_call_get_apn_config(void)
{
    int ret;
    int apn_id = 0;
    ql_data_call_apn_config_t cfg = {0};

    printf("Start to item_ql_data_call_get_apn_config\n");

    printf("Please input apn_id :");
    ret = t_get_int(&apn_id);
    if(ret != 0)
    {
        printf("Invalid input\n");
        return;
    }

    if(apn_id<1 || apn_id>16)
    {
        printf("Invalid apn_id : %d\n", apn_id);
        return;
    }

    ret = ql_data_call_get_apn_config(apn_id, &cfg);

    if(ret != QL_ERR_OK)
    {
        printf("Failed to ql_data_call_set_apn_config, ret=%d\n", ret);
    }
    else
    {
        printf("Successful\n");
        printf("apn_id : %d\n", apn_id);
        dump_apn_cfg(&cfg);
    }
}

void item_ql_set_data_slot(void)
{
    int ret = -1;
    int choice = -1;
    printf("1:sim card 1, 2:sim card 2\n");
    while (1)
    {
        if (scanf("%d", &choice) == 1) 
        {  
            if (choice == 1 || choice == 2) 
            {
                break;  
            }
            else
            {
                printf("invlid input \n");
            }
        }
        else
        {
            int c;
            while ((c = getchar()) != '\n' && c != EOF);
            printf("invalid input \n");
        }
                    
    }
    if (choice == 1)
    {
        ret = ql_set_data_slot(QL_SIM_SLOT_1);
        printf("ret is %d\n",ret);
    } 
    else if (choice == 2)
    {
       ret = ql_set_data_slot(QL_SIM_SLOT_1);
       printf("ret is %d\n",ret);
    }

}

#if 0
void item_ql_nslookup(void)
{
    printf("start ql_nslookup\n");
    int i;
    int ret = 0;
    char ip_str[128];
    char ip_family[5];
    char hostname[64];
    char dns_server_ip[20];
    QUERY_IP_TYPE ip_type;
    hostaddr_info_u resolved_addr;

    memset(ip_str, 0, sizeof(ip_str));
    memset(ip_family, 0, sizeof(ip_family));
    memset(hostname, 0, sizeof(hostname));
    memset(dns_server_ip, 0, sizeof(dns_server_ip));

    printf("please input domain name: ");
    ret = t_get_string(hostname, sizeof(hostname));
    if(ret != 0)
    {
        printf("Invalid input\n");
        return;
    }

    printf("please input dns ip address: ");
    ret = t_get_string(dns_server_ip, sizeof(dns_server_ip));
    if(ret != 0)
    {
        printf("Invalid input\n");
        return;
    }

    printf("please input ipfamily(v4/v6): ");
    ret = t_get_string(ip_family, sizeof(ip_family));
    if(ret != 0)
    {
        printf("Invalid input\n");
        return;
    }

    if(0 == strcmp(ip_family, "v4"))
    {
        ip_type = QUERY_IPV4_E;
    }
    else if(0 == strcmp(ip_family, "v6"))
    {
        ip_type = QUERY_IPV6_E;
    }
    else
    {
        printf("Invalid ip type\n");
        return;
    }


    ql_nslookup(hostname, dns_server_ip, ip_type, &resolved_addr);

    //printf resolved addr
    for (i = 0; i < resolved_addr.addr_cnt; i++) {
         inet_ntop(AF_INET, &resolved_addr.addr[i].s_addr, ip_str, sizeof(ip_str));
         printf("%s has IPv4 address : %s\n", hostname, ip_str);
    }

    for (i = 0; i < resolved_addr.addr6_cnt; i++) {
         inet_ntop(AF_INET6, &resolved_addr.addr6[i].s6_addr, ip_str, sizeof(ip_str));
         printf("%s has IPv6 address : %s\n", hostname, ip_str);
    }

    return;
}
#endif

void item_ql_data_call_set_attach_apn_config(void)
{
    int ret;
    int dat;
    ql_data_call_apn_config_t cfg = {0};

    printf("Start to item_ql_data_call_set_attach_apn_config,apn id is 1\n");
    printf("Please input auth_pref [0-NONE,1-PAP,2-CHAP,3-PAP&CHAP] :\n");
    ret = t_get_int(&dat);
    if(ret < 0)
    {
        printf("Invalid input\n");
        return;
    }

    if(ret == 0)
    {
        if(!IS_QL_NET_AUTH_PREF_VALID(dat))
        {
            printf("Unspport auth_pref : %d\n", dat);
            return;
        }

        cfg.auth_pref = dat;
    }

    printf("Please input ip_version [1-IPV4,2-IPV6,3-IPV4V6] :\n");
    ret = t_get_int(&dat);
    if(ret < 0)
    {
        printf("Invalid input\n");
        return;
    }

    if(ret == 0)
    {
        if(!IS_QL_NET_IP_VER_VALID(dat))
        {
            printf("Unsupport ip_version : %d\n", dat);
            return;
        }

        cfg.ip_ver = dat;
    }

    printf("Please input apn_name :");
    ret = t_get_string(cfg.apn_name, sizeof(cfg.apn_name));
    if(ret < 0)
    {
        printf("Invalid input\n");
        return;
    }

    printf("Please input username :");
    ret = t_get_string(cfg.username, sizeof(cfg.username));
    if(ret < 0)
    {
        printf("Invalid input\n");
        return;
    }

    printf("Please input password :");
    ret = t_get_string(cfg.password, sizeof(cfg.password));
    if(ret < 0)
    {
        printf("Invalid input\n");
        return;
    }
    dump_apn_cfg(&cfg);

    ret = ql_data_call_set_attach_apn_config(&cfg);

    if(ret != QL_ERR_OK)
    {
        printf("Failed to ql_data_call_set_apn_config, ret=%d\n", ret);
    }
    else
    {
        printf("Successful\n");
    }
}

static t_item_t ql_data_call_items[] =
{
    {"ql_data_call_init", item_ql_data_call_init},
    {"ql_data_call_create", item_ql_data_call_create},
    {"ql_data_call_config",item_ql_data_call_config},
    {"ql_data_call_get_config",item_ql_data_call_get_config},
    {"ql_data_call_start", item_ql_data_call_start},
    {"ql_data_call_stop", item_ql_data_call_stop},
    {"ql_data_call_delete", item_ql_data_call_delete},
    {"ql_data_call_get_list", item_ql_data_call_get_list},
    {"ql_data_call_get_status", item_ql_data_call_get_status},
    {"ql_data_call_set_status_ind_cb", item_ql_data_call_set_status_ind_cb},
    {"ql_data_call_set_apn_config", item_ql_data_call_set_apn_config},
    {"ql_data_call_get_apn_config", item_ql_data_call_get_apn_config},
    {"ql_data_call_set_service_error_cb", item_ql_data_call_set_service_error_cb},
    {"ql_data_call_deinit", item_ql_data_call_deinit},
//    {"ql_nslookup",item_ql_nslookup},
    {"ql_data_call_set_attach_apn_config", item_ql_data_call_set_attach_apn_config},
    {"ql_set_data_slot", item_ql_set_data_slot}
};

static void help()
{
    int i = 0;
    printf("Test Items:\n");
    while(i < ARRAY_SIZE(ql_data_call_items)) {
        printf("%d : %s\n", i, ql_data_call_items[i].name);
        i++;
    }
    printf(":");
}

int main(int argc, char *argv[])
{
    char cmd[1024];
    help();
    while(1)
    {
        memset(cmd, 0, sizeof(cmd));
        if(fgets(cmd, sizeof(cmd), stdin))
        {
            char *ptr = cmd + strlen(cmd) - 1;
            while(ptr >= cmd && (*ptr == '\r' || *ptr == '\n'))
            {
                *ptr-- = '\0';
            }

            if(strlen(cmd) > 0) {
                if(isdigit(cmd[0])) {
                    int item = atoi(cmd);
                    if(item >= 0 && item < ARRAY_SIZE(ql_data_call_items)) {
                        ql_data_call_items[item].handle();
                    }
                }
                else if(!strcasecmp(cmd, "h")) {
                    help();
                }
                else if(!strcasecmp(cmd, "q")) {
                    break;
                }
            }
            else {
                printf("\n");
            }
        }
    }
    return 0;
}



