
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <stdio.h>
#include <sys/time.h>

#include "ql_v2/ql_type.h"
#include "ql_dm.h"



#define T_ARRAY_SIZE(items) (sizeof(items)/sizeof(items[0]))

typedef void (*item_handler_f)(void);
typedef int (*init_handler_f)(void);
typedef int (*deinit_handler_f)(void);



typedef struct
{
    const char *name;
    item_handler_f handle;
} t_item_t;

typedef struct
{
    const char *name;
    int item_len;
    t_item_t *item_list;
} t_module_t;

typedef struct
{
    const char *name;
    init_handler_f init_handle;
    deinit_handler_f deinit_handle;
} t_init_t;

int t_get_int(int *val)
{
    int dat;
    char *ptr_end = NULL;
    char buf[256] = {0};

    if(NULL == fgets(buf, sizeof(buf)-1, stdin))
    {
        return -1;
    }

    if(0 == buf[0])
    {
        return -1;
    }

    if(buf[0] == '\n')
    {
        return 1;
    }

    dat = strtol(buf, &ptr_end, 10);
    if(ptr_end!=NULL && ptr_end[0]!='\n')
    {
        return -1;
    }

    if(val)
    {
        val[0] = dat;
    }

    return 0;
}


static int internal_dm_get_air_plane_mode(QL_DM_AIR_PLANE_MODE_TYPE_E mode, char* buf, int buf_len);


void dm_air_plane_mode_event_ind_cb(QL_DM_AIR_PLANE_MODE_TYPE_E air_plane_mode)
{
    char mode_info[16] = {0};

    printf("Recv event indication : air plane mode changed event\n");

    if(internal_dm_get_air_plane_mode(air_plane_mode, mode_info, sizeof(mode_info)) == 0)
    {
        printf("unrecognized air plane mode:%d\n", air_plane_mode);
    }
    else
    {
        printf("current air plane mode is %s\n", mode_info);
    }
}

void dm_modem_state_change_ind_cb(int modem_state)
{
    printf("Recv event indication : modem status changed event\n");
    if(QL_DM_MODEM_STATE_ONLINE == modem_state)
    {
        printf("current modem status is ONLINE\n");
    }
    else if(QL_DM_MODEM_STATE_OFFLINE == modem_state)
    {
        printf("current modem status is OFFLINE\n");
    }
    else
    {
        printf("current modem status is UNKNOWN\n");
    }
}

void dm_service_error_cb(int error)
{
    printf("===== DM Service Abort =====\n");
}

void item_ql_dm_init(void)
{
    int ret = 0;

    printf("Start to ql_dm_init: ");
    ret = ql_dm_init();
    if(ret == QL_ERR_OK)
    {
        printf("dm init ok\n");
    }
    else
    {
        printf("failed, ret=%d\n", ret);
    }
}

void item_ql_dm_set_service_error_cb(void)
{
    int ret = 0;

    printf("Start to item_ql_dm_set_service_error_cb : ");
    ret = ql_dm_set_service_error_cb(dm_service_error_cb);
    if(ret != QL_ERR_OK)
    {
        printf("failed, ret=%d\n", ret);
    }
    else
    {
        printf("successful\n");
    }
}

void item_ql_dm_deinit(void)
{
    int ret = 0;

    printf("Start to ql_dm_deinit: ");
    ret = ql_dm_deinit();
    if(ret == QL_ERR_OK)
    {
        printf("dm deinit ok\n");
    }
    else
    {
        printf("failed, ret=%d\n", ret);
    }
}

void item_ql_dm_set_air_plane_mode_ind_cb(void)
{
    int ret = 0;
    int reg_flag = 0;

    printf("please input air plane mode reg option: (0: unreg, other: reg): ");
    ret = t_get_int(&reg_flag);
    if(ret != 0)
    {
        printf("Invalid input\n");
        return;
    }

    if(reg_flag)
    {
        ret = ql_dm_set_air_plane_mode_ind_cb(dm_air_plane_mode_event_ind_cb);
    }
    else
    {
        ret = ql_dm_set_air_plane_mode_ind_cb(NULL);
    }
    printf("ql_dm_set_air_plane_mode_ind_cb ret = %d\n", ret);
}

void item_ql_dm_get_software_version(void)
{
    int ret;
    char soft_ver[128] = {0};

    ret = ql_dm_get_software_version(soft_ver, sizeof(soft_ver));

    printf("ql_dm_get_software_version ret = %d, software version is %s\n", ret, soft_ver);
}

void item_ql_dm_set_modem_state_change_ind_cb(void)
{
    int ret = 0;
    int reg_flag = 0;

    printf("please input modem state reg option: (0: unreg, other: reg): ");
    ret = t_get_int(&reg_flag);
    if(ret != 0)
    {
        printf("Invalid input\n");
        return;
    }

    if(reg_flag)
    {
        ret = ql_dm_set_modem_state_change_ind_cb(dm_modem_state_change_ind_cb);
    }
    else
    {
        ret = ql_dm_set_modem_state_change_ind_cb(NULL);
    }
    printf("ql_dm_set_modem_state_change_ind_cb ret = %d\n", ret);
}

void item_ql_dm_get_device_serial_numbers(void)
{
    int ret;
    ql_dm_device_serial_numbers_info_t t_info;
    memset(&t_info, 0, sizeof(ql_dm_device_serial_numbers_info_t));

    ret = ql_dm_get_device_serial_numbers(&t_info);
    printf("ql_dm_get_device_serial_number ret = %d", ret);
    if(t_info.imei_valid)
    {
        printf(", imei is %s", t_info.imei);
    }
    if(t_info.imei2_valid)
    {
        printf(", imei2 is %s", t_info.imei2);
    }
    if(t_info.meid_valid)
    {
        printf(", meid is %s ", t_info.meid);
    }
    printf("\n");
}

void item_ql_dm_get_device_firmware_rev_id(void)
{
    int ret;
    char firmware_rev_id[QL_DM_FIRMWARE_REV_MAX_LEN + 1] = {0};

    ret = ql_dm_get_device_firmware_rev_id(firmware_rev_id, sizeof(firmware_rev_id));
    printf("ql_dm_get_device_firmware_rev_id ret = %d, device revision id is %s\n",
            ret, firmware_rev_id);
}

void item_ql_dm_get_air_plane_mode(void)
{
    int ret;
    char mode_info[16] = {0};
    QL_DM_AIR_PLANE_MODE_TYPE_E air_plane_mode;

    ret = ql_dm_get_air_plane_mode(&air_plane_mode);

    printf("ql_dm_get_air_plane_mode ret = %d, ", ret);
    if(internal_dm_get_air_plane_mode(air_plane_mode, mode_info, sizeof(mode_info)) == 0)
    {
        printf("unrecognized air plane mode:%d\n", air_plane_mode);
    }
    else
    {
        printf("current air plane mode is %s\n", mode_info);
    }
}

void item_ql_dm_set_air_plane_mode(void)
{
    int ret;
    int mode;
    QL_DM_AIR_PLANE_MODE_TYPE_E air_plane_mode;

    printf("please input air plane mode(1: ON, 2: OFF): \n");
    ret = t_get_int(&mode);
    if(ret != 0)
    {
        printf("Invalid input\n");
        return;
    }
    air_plane_mode = mode;
    if(air_plane_mode != QL_DM_AIR_PLANE_MODE_ON && air_plane_mode != QL_DM_AIR_PLANE_MODE_OFF)
    {
        printf("please input 1 or 2\n");
        return;
    }

    ret = ql_dm_set_air_plane_mode(air_plane_mode);
    printf("ql_dm_set_air_plane_mode ret = %d\n", ret);
}

static int internal_dm_get_air_plane_mode(QL_DM_AIR_PLANE_MODE_TYPE_E mode, char* buf, int buf_len)
{
    int ret_val = 1;

    if(buf == NULL || buf_len < 2)
    {
        printf("param is valid\n");
        return 0;
    }

    memset(buf, 0, buf_len);

    switch(mode)
    {
        case QL_DM_AIR_PLANE_MODE_UNKNOWN:
            strncpy(buf, "UNKNOWN", buf_len - 1);
            buf[buf_len - 1] = '\0';
            break;
        case QL_DM_AIR_PLANE_MODE_ON:
            strncpy(buf, "ON", buf_len - 1);
            buf[buf_len - 1] = '\0';
            break;
        case QL_DM_AIR_PLANE_MODE_OFF:
            strncpy(buf, "OFF", buf_len - 1);
            buf[buf_len - 1] = '\0';
            break;
        case QL_DM_AIR_PLANE_MODE_NA:
            strncpy(buf, "UNAVAILABLE", buf_len - 1);
            buf[buf_len - 1] = '\0';
            break;
        default:
            ret_val = 0;
            break;
    }
    return ret_val;
}


void item_ql_dm_get_modem_state(void)
{
    int ret;
    QL_DM_MODEM_STATE_TYPE_E modem_state = QL_DM_MODEM_STATE_UNKNOWN;
    
    ret = ql_dm_get_modem_state(&modem_state);
    if(QL_DM_MODEM_STATE_ONLINE == modem_state)
    {
        printf("ql_dm_get_modem_state ret = %d, modem state is ONLINE\n", ret);
    }
    else if(QL_DM_MODEM_STATE_OFFLINE == modem_state)
    {
        printf("ql_dm_get_modem_state ret = %d, modem state is OFFLINE\n", ret);
    }
    else
    {
        printf("ql_dm_get_modem_state ret = %d, modem state UNKNOWN\n", ret);
    }
}


static t_item_t ql_dm_items[] =
{
    {"ql_dm_init", item_ql_dm_init},
    {"ql_dm_set_air_plane_mode_ind_cb", item_ql_dm_set_air_plane_mode_ind_cb},
    {"ql_dm_get_software_version", item_ql_dm_get_software_version},
    {"ql_dm_set_modem_state_change_ind_cb", item_ql_dm_set_modem_state_change_ind_cb},
    {"ql_dm_get_device_serial_numbers", item_ql_dm_get_device_serial_numbers},
    {"ql_dm_get_device_firmware_rev_id", item_ql_dm_get_device_firmware_rev_id},
    {"ql_dm_get_air_plane_mode", item_ql_dm_get_air_plane_mode},
    {"ql_dm_set_air_plane_mode", item_ql_dm_set_air_plane_mode},
    {"ql_dm_get_modem_state", item_ql_dm_get_modem_state},
    {"ql_dm_set_service_error_cb", item_ql_dm_set_service_error_cb},
    {"ql_dm_deinit",         item_ql_dm_deinit}
};

t_module_t ql_dm_module =
{
    "dm",
    T_ARRAY_SIZE(ql_dm_items),
    ql_dm_items
};


t_module_t *test_modules[] =
{
    &ql_dm_module,

};

void dump_modules(void)
{
    int i;

    printf("\n");
    for(i=0; i<T_ARRAY_SIZE(test_modules); i++)
    {
        printf("%d\t%s\n", i, test_modules[i]->name);
    }
    printf("-1\texit\n");
}

void dump_items(t_module_t *m)
{
    int i;

    printf("\n");
    printf("The current module is: \n");

    for(i=0; i<m->item_len; i++)
    {
        printf("%d\t%s\n", i, m->item_list[i].name);
    }
    printf("-1\texit\n");
}

void enter_modules(t_module_t *m)
{
    int ret;
    int idx;

    dump_items(m);

    while(1)
    {
        printf("Please enter your choice: ");
        ret = t_get_int(&idx);
        printf("\n");
        if(ret < 0)
        {
            printf("Invalid input\n");
            continue;
        }
        else if(ret == 1)
        {
            dump_items(m);
            continue;
        }

        if(idx == -1)
        {
            break;
        }

        if(idx<0 || idx>=m->item_len)
        {
            printf("Not support idx: %d\n", idx);
            continue;
        }

        printf("->Item : %s\n", m->item_list[idx].name);
        m->item_list[idx].handle();
    }
}

 static t_init_t init_func[] = {
     {"ql_dm_init",ql_dm_init,ql_dm_deinit},


};


void test_init(int retry)
{

    int i = 0,j = 0;
    for(i=0; i<T_ARRAY_SIZE(init_func); i++)
    {
        printf("Exec %s time = \n", init_func[i].name);
        //clock_t start,end;
        struct timeval start,end;

        double cost_time = 0;
        int ret = QL_ERR_OK;
        for(j = 0;j < retry; j++)
        {
            if(QL_ERR_OK == ret )
            {
                //start = clock();
                gettimeofday(&start, NULL);
            }

            ret = -1;
            ret = init_func[i].init_handle();
            if(QL_ERR_OK == ret)
            {
                //end = clock();
                gettimeofday(&end, NULL);
                long timeuse = 1000000*(end.tv_sec - start.tv_sec) + end.tv_usec-start.tv_usec;
                //printf("%6.0f ",(double)(end-start));
                printf("%ld ",timeuse/1000);
                //cost_time = cost_time > (end-start) ?cost_time:(end-start);
                cost_time = cost_time > (timeuse/1000) ?cost_time:(timeuse/1000);

                init_func[i].deinit_handle();
            }


        }
        printf("\n");
        printf("Finish test. %s  max cost time = %6.0f ms\n",init_func[i].name, cost_time);

    }


}


int main(int argc, char *argv[])
{
    int ret;
    int idx;

    if(argc > 1)
    {
      int c = -1;
      int retry = -1;

      while((c = getopt(argc, argv, "i:")) != -1)
      {
          if(-1 == c)
          {
              break;
          }

          switch(c)
          {
              case 'i':
                  retry = atoi(optarg);
                  test_init(retry);
                  return 0;

              default:
                  printf("usage: ql_sdk_api_test -i  <retry count> to test init func\n");
                  printf("       ql_sdk_api_test  to test sdk api\n");
                  return -1;
          }
      }
    }


    dump_modules();

    while(1)
    {
        printf("Please enter your choice: ");
        ret = t_get_int(&idx);
        printf("\n");
        if(ret < 0)
        {
            printf("Invalid input\n");
            continue;
        }
        else if(ret == 1)
        {
            dump_modules();
            continue;
        }

        if(idx == -1)
        {
            break;
        }

        if(idx<0 || idx>=T_ARRAY_SIZE(test_modules))
        {
            printf("Not support idx: %d\n", idx);
            continue;
        }

        enter_modules(test_modules[idx]);
    }

    return 0;
}

