#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdint.h>
#include <ctype.h>

#include "ql_type.h"
#include "ql_ms_voice.h"
#include "ql_ecall.h"
#include "mbtk_utils.h"

typedef void (*item_handler_f)(void);

typedef struct
{
    const char *name;
    item_handler_f handle;
} t_item_t;

void item_ql_ecall_set_test_number(void)
{
    int ret = 0;
    int sim_id;

    char test_number[QL_VOICE_MAX_PHONE_NUMBER];

    printf("test ql_voice_ecall_set_test_number: ");

    printf("please enter test number: ");
    char* find = NULL;

    if(NULL == fgets(test_number, QL_VOICE_MAX_PHONE_NUMBER-1, stdin))
        return;
    find = strchr(test_number, '\n');
    if(find)
    {
        *find = '\0';
    }

    printf("please enter the sim_id: ");

    if(1 != scanf("%u", &sim_id))
        return;
    getchar();
    printf("sim_id is %u\n", sim_id);

    ret = ql_ecall_set_test_number(sim_id, test_number);

    if (ret == QL_ERR_OK)
    {
        printf("ok\n");
    }
    else
    {
        printf("failed, ret = %d\n", ret);
    }
}

void item_ql_ecall_reset_ivs(void)
{
    int ret = 0;
    int sim_id;

    printf("please enter the sim_id: ");

    if(1 != scanf("%u", &sim_id))
        return;
    getchar();
    printf("sim_id is %u\n", sim_id);

    ret = ql_ecall_reset_ivs(sim_id);
    if (ret == QL_ERR_OK)
    {
        printf("ok\n");
    }
    else
    {
        printf("failed, ret = %d\n", ret);
    }
}

void fast_ecall_dial(void){
    int ret = 0, v = 0;
    ql_voice_ecall_info_t *p_info = NULL;
    char *find = NULL;
    uint32_t id;
    int sim_id;

    p_info = (ql_voice_ecall_info_t *)calloc(1, sizeof(*p_info));
    if (NULL  == p_info)
    {
        printf("run out of memory\n");
        return;
    }

    printf("please enter the sim_id: ");
    if(1 != scanf("%d", &sim_id))
        return;
    getchar();

    if(!QL_IS_SIM_VALID(sim_id))
    {
        printf("invalid sim_id\n");
        free(p_info);
        p_info = NULL;
        return;
    }

    printf("sim_id is %d\n", sim_id);

    printf("example MSD: 01 04 a9 81 d5 49 70 d6 5c 35 97 ca 04 20 c4 14 60 "
        "0b be 5f 7e b1 4b a6 ee 10 4f c5 27 03 c1 80 q\n");
    printf("please enter MSD(at most 140 hex), end with 'q': ");
    while (1 == scanf("%x", &v))
    {
        p_info->msd[p_info->msd_len++] = v;
    }
    getchar();  // read `q'
    getchar();  // read '\n'

    printf("MSD ========[");
    for(v = 0; v < p_info->msd_len; v ++)
    {
        printf("%02x ", p_info->msd[v]);
    }
    printf("]\n");

    if (p_info->msd_len > QL_VOICE_MAX_ECALL_MSD)
    {
        printf("MSD too long\n");
        free(p_info);
        p_info = NULL;
        return;
    }

    printf("please enter eCall type(1 - test, 2 - emergency,  3 - reconfig): ");
    if(1 != scanf("%d", (int *)&p_info->type))
        return;
    getchar();

    printf("please enter test number(emergency ecall should be empty): ");
    find = NULL;
    if(NULL == fgets(p_info->test_number, sizeof(p_info->test_number)-1, stdin))
        return;
    find = strchr(p_info->test_number, '\n');
    if(find)
    {
        *find = '\0';
    }

    printf("how to trigger eCall(0 - manual, 1 - auto): ");
    if(1 != scanf("%d", &p_info->auto_trigger))
        return;
    getchar();

    ret = ql_ecall_dial(sim_id, p_info, &id);
    if (ret == QL_ERR_OK)
    {
        printf("ok, call_id is %u\n", id);
    }
    else
    {
        printf("failed, ret = %d\n", ret);
    }

    free(p_info);
    p_info = NULL;
}

void item_ql_ecall_dial(void)
{
    printf("test ql_voice_ecall_dial: \n");
    printf("Is fast ecall? (1 - yes, other - wrong): ");
    int is_fast;
    scanf("%d", &is_fast);
    getchar();

    if(is_fast == 1){
        printf("Dialling fast ecall\n");
        fast_ecall_dial();
    }else{
        printf("Wrong arguments\n");
    }
}

void item_ql_ecall_hangup(void)
{
    int ret = 0;
//    int sim_id;

    printf("test ql_voice_ecall_hangup: \n");
    ret = ql_ecall_hangup();
    if (ret == QL_ERR_OK)
    {
        printf("ok\n");
    }
    else
    {
        printf("failed, ret = %d\n", ret);
    }
}

void item_ql_ecall_update_msd_raw(void)
{
    int ret = 0, v = 0;
    uint32_t msd_len = 0;
    char msd[QL_VOICE_MAX_ECALL_MSD] = {0};

    printf("test ql_voice_ecall_update_msd: \n");
    printf("example MSD: 01 04 a9 81 d5 49 70 d6 5c 35 97 ca 04 20 c4 14 60 "
        "0b be 5f 7e b1 4b a6 ee 10 4f c5 27 03 c1 80 q\n");
    printf("please enter MSD(at most 140 hex), end with 'q': ");
    while (1 == scanf("%x", &v))
    {
        if(msd_len >= QL_VOICE_MAX_ECALL_MSD)
        {
            printf("MSD too long\n");
            int c;
            while ((c = getchar()) != '\n' && c != EOF) { }
            return;
        }
        else
        {
            msd[msd_len++] = v;
        }
    }
    getchar();  // read `q'
    getchar();  // read '\n'

    ret = ql_ecall_update_msd_raw((uint8_t *)msd, msd_len);
    if (ret == QL_ERR_OK)
    {
        printf("ok\n");
    }
    else
    {
        printf("failed, ret = %d\n", ret);
    }
}

void item_ql_ecall_push_msd(void)
{
    int ret = 0;

    printf("test ql_voice_ecall_push_msd: \n");
    ret = ql_ecall_push_msd();
    if (ret == QL_ERR_OK)
    {
        printf("sql_ecall_push_msd OK\n");
    }
    else
    {
        printf("failed, ret = %d\n", ret);
    }
}

static void ecall_user_ind_callback(int ind, void *userdata)
{
    printf("\n****** eCall indication Received ******\n");
    printf("ecall_indication: %d - ", ind);

    switch(ind){
        case QL_ECALL_EVENT_SENDING_START:
            printf("QL_ECALL_EVENT_SENDING_START\n");
            break;
        case QL_ECALL_EVENT_SENDING_MSD:
            printf("QL_ECALL_EVENT_SENDING_MSD\n");
            break;
        case QL_ECALL_EVENT_LLACK_RECEIVED:
            printf("QL_ECALL_EVENT_LLACK_RECEIVED\n");
            break;
        case QL_ECALL_EVENT_ALLACK_POSITIVE_RECEIVED:
            printf("QL_ECALL_EVENT_ALLACK_POSITIVE_RECEIVED\n");
            break;
        case QL_ECALL_EVENT_ALLACK_CLEARDOWN_RECEIVED:
            printf("QL_ECALL_EVENT_ALLACK_CLEARDOWN_RECEIVED\n");
            break;
        case QL_ECALL_EVENT_ACTIVE:
            printf("QL_ECALL_EVENT_ACTIVE\n");
            break;
        case QL_ECALL_EVENT_DISCONNECTED:
            printf("QL_ECALL_EVENT_DISCONNECTED\n");
            break;
        case QL_ECALL_EVENT_ABNORMAL_HANGUP:
            printf("QL_ECALL_EVENT_ABNORMAL_HANGUP\n");
            break;
        case QL_ECALL_EVENT_ONLY_DEREGISTRATION:
            printf("QL_ECALL_EVENT_ONLY_DEREGISTRATION\n");
            break;
        case QL_ECALL_EVENT_MAY_DEREGISTRATION:
            printf("QL_ECALL_EVENT_MAY_DEREGISTRATION\n");
            break;
        case QL_ECALL_EVENT_PSAP_CALLBACK_START:
            printf("QL_ECALL_EVENT_PSAP_CALLBACK_START\n");
            break;
        case QL_ECALL_EVENT_T2_TIMEOUT:
            printf("QL_ECALL_EVENT_T2_TIMEOUT\n");
            break;
        case QL_ECALL_EVENT_T5_TIMEOUT:
            printf("QL_ECALL_EVENT_T5_TIMEOUT\n");
            break;
        case QL_ECALL_EVENT_T6_TIMEOUT:
            printf("QL_ECALL_EVENT_T6_TIMEOUT\n");
            break;
        case QL_ECALL_EVENT_T7_TIMEOUT:
            printf("QL_ECALL_EVENT_T7_TIMEOUT\n");
            break;
        case QL_ECALL_EVENT_ECALL_STARTED:
            printf("QL_ECALL_EVENT_ECALL_STARTED\n");
            break;
        case QL_ECALL_EVENT_INCOMING_CALL:
            printf("QL_ECALL_EVENT_INCOMING_CALL\n");
            break;
        case QL_ECALL_EVENT_DIAL_DURATION_TIMEOUT:
            printf("QL_ECALL_EVENT_DIAL_DURATION_TIMEOUT\n");
            break;
        case QL_ECALL_EVENT_INTERVAL_TIMEOUT:
            printf("QL_ECALL_EVENT_INTERVAL_TIMEOUT\n");
            break;
        case QL_ECALL_EVENT_AUTO_ANSWER_TIMEOUT:
            printf("QL_ECALL_EVENT_AUTO_ANSWER_TIMEOUT\n");
            break;
        default:
            printf("UNKNOWN\n");
            break;
    }
}

void item_ql_ecall_init(void)
{
    int ret = 0;

    printf("test ql_ecall_init: ");
    ret = ql_ecall_init();
    if(ret == QL_ERR_OK)
    {
        printf("ok\n");
    }
    else
    {
        printf("failed, ret = %d\n", ret);
    }
}

void item_ql_ecall_deinit(void)
{
    int ret = 0;

    printf("test ql_ecall_deinit: ");
    ret = ql_ecall_deinit();
    if (ret == QL_ERR_OK)
    {
        printf("ok\n");
    }
    else
    {
        printf("failed, ret = %d\n", ret);
    }
}

void item_ql_ecall_set_user_ind_cb(void)
{
    ql_ecall_set_user_ind_cb(ecall_user_ind_callback, NULL);
}

void item_ql_ecall_set_msd_version(void)
{
    int ret = 0;
    uint8_t index=0;

    printf("ecall MSD version(1-ASN1_ECALL_MSD_VERSION_1;  2-ASN1_ECALL_MSD_VERSION_2): \n");
    scanf("%hhd", &index);
    getchar();

    if (1 == index)
    {
        ret = ql_ecall_set_msd_version(ASN1_ECALL_MSD_VERSION_1);
        printf(" ql_ecall_get_msd_version ret = %d\n", ret);
    }
    else if(2 == index)
    {
        ret = ql_ecall_set_msd_version(ASN1_ECALL_MSD_VERSION_2);
        printf(" ql_ecall_get_msd_version ret = %d\n", ret);
    }
    else
    {
        printf(" This version is not surport.\n");
    }

}

void item_ql_ecall_get_msd_version(void)
{
    uint8_t msdVersion = 0;

    ql_ecall_get_msd_version(&msdVersion);

    if(msdVersion == ASN1_ECALL_MSD_VERSION_1)//unsupported
    {
        printf("MSD version is set to ASN1_ECALL_MSD_VERSION_1.\n");
    }
    else if (msdVersion == ASN1_ECALL_MSD_VERSION_2)//supported
    {
        printf("MSD version is set to ASN1_ECALL_MSD_VERSION_2.\n");
    }
    else
    {
        printf(" This version is not surport.\n");
    }

}

void item_ql_ecall_set_system_type(void)
{
    int ret = 0;
    uint8_t index=0;

    printf("ecall system type(0-ECALL_SYSTEM_STD_PAN_EUROPEAN;  1-ECALL_SYSTEM_STD_ERA_GLONASS): \n");
    scanf("%hhd", &index);
    getchar();

    if (0 == index)
    {
        ret = ql_ecall_set_system_std(ECALL_SYSTEM_STD_PAN_EUROPEAN);
        printf(" ql_ecall_set_system_std ret = %d\n", ret);
    }
    else if(1 == index)
    {
        ret = ql_ecall_set_system_std(ECALL_SYSTEM_STD_ERA_GLONASS);
        printf(" ql_ecall_set_system_std ret = %d\n", ret);
    }
    else
    {
        printf(" This version is not surport.\n");
    }
}

void item_ql_ecall_get_system_type(void)
{
    ECALL_SYSTEM_STD_E system_std;
    ql_ecall_get_system_std(&system_std);
    if(system_std == ECALL_SYSTEM_STD_PAN_EUROPEAN)
    {
        printf("Ecall system type set to ECALL_SYSTEM_STD_PAN_EUROPEAN.\n");
    }
    else if (system_std == ECALL_SYSTEM_STD_ERA_GLONASS)
    {
        printf("Ecall system type set to ECALL_SYSTEM_STD_ERA_GLONASS.\n");
    }
    else
    {
        printf("Ecall system type set to unsupported value.\n");
    }
}

void item_ql_ecall_set_msd_vehicle_type(void)
{
    int ret = 0;
    uint8_t index=0;

    printf("Please input VehicleType:\n");
    printf("MSD_VEHICLE_PASSENGER_M1=1\n");
    printf("MSD_VEHICLE_BUS_M2=2\n");
    printf("MSD_VEHICLE_BUS_M3=3\n");
    printf("MSD_VEHICLE_COMMERCIAL_N1=4\n");
    printf("MSD_VEHICLE_HEAVY_N2=5\n");
    printf("MSD_VEHICLE_HEAVY_N3=6\n");
    printf("MSD_VEHICLE_MOTORCYCLE_L1E=7\n");
    printf("MSD_VEHICLE_MOTORCYCLE_L2E=8\n");
    printf("MSD_VEHICLE_MOTORCYCLE_L3E=9\n");
    printf("MSD_VEHICLE_MOTORCYCLE_L4E=10\n");
    printf("MSD_VEHICLE_MOTORCYCLE_L5E=11\n");
    printf("MSD_VEHICLE_MOTORCYCLE_L6E=12\n");
    printf("MSD_VEHICLE_MOTORCYCLE_L7E=13\n");

    scanf("%hhd", &index);
    getchar();

    ret = ql_ecall_set_msd_vehicle_type(index);
    printf(" ql_ecall_set_msd_vehicle_type ret = %d\n", ret);

}

void item_ql_ecall_get_msd_vehicle_type(void)
{
    uint8_t vehicleType = 0;
    ql_ecall_get_msd_vehicle_type(&vehicleType);
    printf("VehicalType is set to: %u\n", vehicleType);

}

void item_ql_ecall_set_msd_position(void)
{
    int ret = 0;
    int32_t latitude, longitude, direction = 0;

    printf("Please input latitude(example:+48898064):\n");
    scanf("%d", &latitude);
    getchar();

    printf("Please input longitude(example:+2218092):\n");
    scanf("%d", &longitude);
    getchar();

    printf("Please input direction(example:0):\n");
    scanf("%d", &direction);
    getchar();

    ret = ql_ecall_set_msd_position(true, latitude, longitude, direction);
    printf(" ql_ecall_set_msd_position ret = %d\n", ret);
}

void item_ql_ecall_set_msd_position1(void)
{
    int ret = 0;
    int32_t latitudeDeltaN1, longitudeDeltaN1 = 0;

    printf("Please input latitudeDeltaN1(-512 ~ 511):\n");
    scanf("%d", &latitudeDeltaN1);
    getchar();

    printf("Please input longitudeDeltaN1(-512 ~ 511):\n");
    scanf("%d", &longitudeDeltaN1);
    getchar();

    ret = ql_ecall_set_msd_position_n1(latitudeDeltaN1, longitudeDeltaN1);
    printf(" ql_ecall_set_msd_position_n1 ret = %d\n", ret);
}

void item_ql_ecall_set_msd_position2(void)
{
    int ret = 0;
    int32_t latitudeDeltaN2, longitudeDeltaN2 = 0;

    printf("Please input latitudeDeltaN2(-512 ~ 511):\n");
    scanf("%d", &latitudeDeltaN2);
    getchar();

    printf("Please input longitudeDeltaN2(-512 ~ 511):\n");
    scanf("%d", &longitudeDeltaN2);
    getchar();

    ret = ql_ecall_set_msd_position_n2(latitudeDeltaN2, longitudeDeltaN2);
    printf(" ql_ecall_set_msd_position_n2 ret = %d\n", ret);
}

void item_ql_ecall_set_number_of_passengers(void)
{
//    int ret = 0;
    uint8_t numberOfPassengers=0;

    printf("Please input msd numberOfPassengers:\n");
    if(1 != scanf("%hhd", &numberOfPassengers))
        return;
    getchar();

    ql_ecall_set_msd_passengers_count(numberOfPassengers);
}

void item_ql_ecall_set_msd_propulsion_type(void)
{
//    int ret = 0;
    uint8_t propulsionType = 0;

    printf("Please input vehicle propulsion type:\n");
    printf("ECALL_MSD_PROPULSION_TYPE_GASOLINE=0x1\n");
    printf("ECALL_MSD_PROPULSION_TYPE_DIESEL=0x2\n");
    printf("ECALL_MSD_PROPULSION_TYPE_NATURALGAS=0x4\n");
    printf("ECALL_MSD_PROPULSION_TYPE_PROPANE=0x8\n");
    printf("ECALL_MSD_PROPULSION_TYPE_ELECTRIC=0x10\n");
    printf("ECALL_MSD_PROPULSION_TYPE_HYDROGEN=0x20\n");
    printf("ECALL_MSD_PROPULSION_TYPE_OTHER=0x40\n");

    scanf("%hhx", &propulsionType);
    getchar();

    ql_ecall_set_msd_propulsion_type(propulsionType);
}

void item_ql_ecall_get_msd_propulsion_type(void)
{
    uint8_t propulsionType = 0;

    ql_ecall_get_msd_propulsion_type(&propulsionType);

    printf("PropulsionType set to: 0x%x\n", propulsionType);

}

void item_ql_ecall_get_msd_call_type(void)
{

    bool type;
    ql_ecall_get_msd_call_type(&type);

    printf(" item_ql_ecall_get_msd_call_type type = %s\n", type ? "Test" : "Emergency" );
}

void item_ql_ecall_set_msd_call_type(void)
{
    uint8_t index = 0;
    printf("Input call type: Test(0) Emergency(1)\n");
    scanf("%hhd", &index);
    getchar();

    ql_ecall_set_msd_call_type(index == 0);

    printf(" ql_ecall_set_msd_call_type type = %d\n", index);
}


void item_ql_ecall_set_msd_vin(void)
{
    int ret = 0;
    uint8_t index = 0;
    msd_Vin_t vin = {0};
    char* find = NULL;
    char vin_str[QL_ECALL_MAX_VIN];

    printf("Input: default(0) other(1)\n");
    scanf("%hhd", &index);
    getchar();
    if(index)
    {
        printf("Please insert VIN:\n");
        fgets(vin_str, QL_ECALL_MAX_VIN-1, stdin);
        find = strchr(vin_str, '\n');
        if(find)
        {
            *find = '\0';
        }
        // example 1: WM9VDSVDSYA123456
        // example 2: 4Y1SL65848Z411439
        // example 3: VF37BRFVE12345678
        memcpy(&vin.isowmi, vin_str,3);
        memcpy(&vin.isovds, (vin_str+3),6);
        memcpy(&vin.isovisModelyear, (vin_str+9) ,1);
        memcpy(&vin.isovisSeqPlant,  (vin_str+10) ,7);
        printf("isowmi:%s isovds:%s isovisModelyear:%s,isovisSeqPlant:%s\n",vin.isowmi,vin.isovds,vin.isovisModelyear,vin.isovisSeqPlant);
    }
    else
    {
        memcpy(&vin.isowmi,"WM9",3);
        memcpy(&vin.isovds,"VDSVDS",6);
        memcpy(&vin.isovisModelyear,"Y",1);
        memcpy(&vin.isovisSeqPlant,"A123456",7);
        printf("isowmi:%s isovds:%s isovisModelyear:%s,isovisSeqPlant:%s\n",vin.isowmi,vin.isovds,vin.isovisModelyear,vin.isovisSeqPlant);
    }

    ret = ql_ecall_set_msd_vin(vin);
    printf(" ql_ecall_set_msd_vin ret = %d\n", ret);
}

void item_ql_ecall_get_msd_vin(void)
{
    int ret = 0;
    msd_Vin_t vin;
    char vin_str[QL_ECALL_MAX_VIN];

    ret = ql_ecall_get_msd_vin(&vin);
    if(0<strlen(vin.isowmi)&&0<strlen(vin.isovds)&&0<strlen(vin.isovisModelyear)&&0<strlen(vin.isovisSeqPlant))
    {
        sprintf(vin_str,"%s%s%s%s",vin.isowmi,vin.isovds,vin.isovisModelyear,vin.isovisSeqPlant);
    }
    else
    {
        printf(" vin is NULL\n");
        return;
    }
    printf(" ql_ecall_get_msd_vin ret = %d\n", ret);

    printf("VIN=%s\n",vin_str);
}

void item_ql_ecall_set_msd_tx_mode(void)
{
    int ret = 0;
    uint8_t index = 0;

    printf("Please choose MSD Tx Mode: PULL(0) PUSH(1)\n");
    scanf("%hhd", &index);
    getchar();

    if(index == 0)
    {
        ret = ql_ecall_set_msd_tx_mode(QL_ECALL_TX_MODE_PULL);
        printf(" ql_ecall_set_msd_tx_mode ret = %d\n", ret);
    }
    else if(index == 1)
    {
        ret = ql_ecall_set_msd_tx_mode(QL_ECALL_TX_MODE_PUSH);
        printf(" ql_ecall_set_msd_tx_mode ret = %d\n", ret);
    }
    else
    {
        printf("Unsupported MSD transmission mode.\n");
    }
}

void item_ql_ecall_get_msd_tx_mode(void)
{
    QL_ECALL_MSD_TX_MODE_E tx_mode;

    ql_ecall_get_msd_tx_mode(&tx_mode);
    if(tx_mode == QL_ECALL_TX_MODE_PULL)
    {
        printf("MSD Transmission mode is set to QL_ECALL_TX_MODE_PULL\n");
    }
    else if (tx_mode == QL_ECALL_TX_MODE_PUSH)
    {
        printf("MSD Transmission mode is set to QL_ECALL_TX_MODE_PUSH\n");
    }
}

void item_ql_ecall_start_test(void)
{
    int ret = 0;
    int sim_id;

    printf("please enter the sim_id: ");
    ret = scanf("%d", &sim_id);
    getchar();

    if(!QL_IS_SIM_VALID(sim_id))
    {
        printf("invalid sim_id\n");
        return;
    }

    ret = ql_ecall_start_test(sim_id);
    printf(" ql_ecall_start_test ret = %d\n", ret);
}

void item_ql_ecall_start_manual(void)
{
    int ret = 0;
    int sim_id;

    printf("please enter the sim_id: ");
    ret = scanf("%d", &sim_id);
    getchar();

    if(!QL_IS_SIM_VALID(sim_id))
    {
        printf("invalid sim_id\n");
        return;
    }

    ret = ql_ecall_start_manual(sim_id);
    printf(" ql_ecall_start_manual ret = %d\n", ret);
}

void item_ql_ecall_start_automatic(void)
{
    int ret = 0;
    int sim_id;

    printf("please enter the sim_id: ");
    ret = scanf("%d", &sim_id);
    getchar();

    if(!QL_IS_SIM_VALID(sim_id))
    {
        printf("invalid sim_id\n");
        return;
    }

    ret = ql_ecall_start_automatic(sim_id);
    printf(" ql_ecall_start_automatic ret = %d\n", ret);
}

void item_ql_ecall_terminate_nw_registration(void)
{
    int ret;

    ret = ql_ecall_terminate_nw_registration();
    if(ret == QL_ERR_OK)
    {
        printf("ok\n");
    }
    else
    {
        printf("failed, ret = %d\n", ret);
    }
}

void item_ql_ecall_set_interval_between_attempts(void)
{
    uint16_t interval = 0;

    printf("Please input interval between attempts in seconds:\n");
    scanf("%hd", &interval);
    getchar();

    ql_ecall_set_interval_between_dial_attempts(interval);
}

void item_ql_ecall_get_interval_between_attempts(void)
{
    uint16_t interval = 0;
    ql_ecall_get_interval_between_dial_attempts(&interval);

    printf("Interval between attempts is set to %hd seconds:\n", interval);

}

void item_ql_ecall_update_msd (void)
{
    int ret = 0;
    ret = ql_ecall_update_msd();
    if (ret == QL_ERR_OK)
    {
        printf("ok\n");
    }
    else
    {
        printf("failed, ret = %d\n", ret);
    }
}

void item_ql_ecall_set_config_info(void)
{
    ql_ecall_config_t ecall_context_info;
    memset(&ecall_context_info, 0, sizeof(ql_ecall_config_t));

    printf("Whether the time of T5 timer is valid(0:no, 1:yes):\n");
    scanf("%hhd", &ecall_context_info.t5_timeout_ms_valid);
    getchar();
    if(ecall_context_info.t5_timeout_ms_valid)
    {
        printf("please input the time of T5 timer(example:5000ms):\n");
        scanf("%hd", &ecall_context_info.t5_timeout_ms);
        getchar();
    }

    printf("Whether the time of T6 timer is valid(0:no, 1:yes):\n");
    scanf("%hhd", &ecall_context_info.t6_timeout_ms_valid);
    getchar();
    if(ecall_context_info.t6_timeout_ms_valid)
    {
        printf("please input the time of T6 timer(example:5000ms):\n");
        scanf("%hd", &ecall_context_info.t6_timeout_ms);
        getchar();
    }

    printf("Whether the time of T7 timer is valid(0:no, 1:yes):\n");
    scanf("%hhd", &ecall_context_info.t7_timeout_ms_valid);
    getchar();
    if(ecall_context_info.t7_timeout_ms_valid)
    {
        printf("please input the time of T7 timer(example:20000ms):\n");
        scanf("%hd", &ecall_context_info.t7_timeout_ms);
        getchar();
    }

    printf("Whether the time of auto answer timer is valid(0:no, 1:yes):\n");
    scanf("%hhd", &ecall_context_info.autoAnswer_timeout_ms_valid);
    getchar();
    if(ecall_context_info.autoAnswer_timeout_ms_valid)
    {
        printf("please input the time of auto answer  timer(example:3600000ms):\n");
        scanf("%d", &ecall_context_info.autoAnswer_timeout_ms);
        getchar();
    }

    printf("Whether the time of dialDurationTimer is valid(0:no, 1:yes):\n");
    scanf("%hhd", &ecall_context_info.dialDurationTimer_timout_ms_valid);
    getchar();
    if(ecall_context_info.dialDurationTimer_timout_ms_valid)
    {
        printf("please input the time of dialDurationTimer(example:120000ms):\n");
        scanf("%d", &ecall_context_info.dialDurationTimer_timout_ms);
        getchar();
    }

    printf("(Not supported)Whether the maxDialAttempts is valid(0:no, 1:yes):\n");
    scanf("%hhd", &ecall_context_info.maxDialAttempts_valid);
    getchar();
    if(ecall_context_info.maxDialAttempts_valid)
    {
        printf("please input maxDialAttempts:\n");
        scanf("%d", &ecall_context_info.maxDialAttempts);
        getchar();
    }

    printf("(Not supported)Whether the intervalBetweenAttempts is valid(0:no, 1:yes):\n");
    scanf("%hhd", &ecall_context_info.intervalBetweenAttempts_valid);
    getchar();
    if(ecall_context_info.intervalBetweenAttempts_valid)
    {
        printf("please input intervalBetweenAttempts(example:30s):\n");
        scanf("%hd", &ecall_context_info.intervalBetweenAttempts);
        getchar();
    }

    printf("(Not supported)Whether the resetEcallSessionMode is valid(0:no, 1:yes):\n");
    scanf("%hhd", &ecall_context_info.resetEcallSessionMode_valid);
    getchar();
    if(ecall_context_info.resetEcallSessionMode_valid)
    {
        printf("please input resetEcallSessionMode(example: 1,autoanswer):\n");
        scanf("%hhd", &ecall_context_info.resetEcallSessionMode);
        getchar();
    }

    ql_ecall_set_config_info(ecall_context_info);
    printf("ok!\n");
}

void item_ql_ecall_get_config_info(void)
{
    ql_ecall_config_t ecall_context_info;

    ql_ecall_get_config_info(&ecall_context_info);

    printf("ok!\n");
    printf("the time of T5 timer is %hd\n", ecall_context_info.t5_timeout_ms);
    printf("the time of T6 timer is %hd\n", ecall_context_info.t6_timeout_ms);
    printf("the time of T7 timer is %hd\n", ecall_context_info.t7_timeout_ms);
    printf("the time of dialDurationTimer is %d\n", ecall_context_info.dialDurationTimer_timout_ms);
    printf("the maximum redial attempts is %d\n", ecall_context_info.maxDialAttempts);
    //printf("the interval value between dial attempts is %hd\n", ecall_context_info.intervalBetweenAttempts);
}

void item_ql_ecall_set_ecall_only_mode(void)
{
    int ret = 0;
    int ecall_only_value = 0;

    printf("ecall set ecall only mode(0:disable,1:enable): \n");
    scanf("%d", &ecall_only_value);
    getchar();

    ret = ql_ecall_set_ecall_only_mode(ecall_only_value);
    printf(" ql_ecall_set_ecall_only_mode ret = %d\n", ret);
}

static t_item_t ql_ecall_items[] =
{
    {"ql_ecall_init", item_ql_ecall_init},
    {"ql_ecall_dial", item_ql_ecall_dial},
    {"ql_ecall_start_test", item_ql_ecall_start_test},
    {"ql_ecall_start_manual", item_ql_ecall_start_manual},
    {"ql_ecall_start_automatic", item_ql_ecall_start_automatic},
    {"ql_ecall_hangup", item_ql_ecall_hangup},
    {"ql_ecall_set_user_ind_cb", item_ql_ecall_set_user_ind_cb},
    {"ql_voice_ecall_set_test_number", item_ql_ecall_set_test_number},
    {"ql_ecall_set_system_type", item_ql_ecall_set_system_type},
    {"ql_ecall_get_system_type", item_ql_ecall_get_system_type},
    {"ql_ecall_update_msd_raw", item_ql_ecall_update_msd_raw},
    {"ql_ecall_push_msd", item_ql_ecall_push_msd},
    {"ql_voice_ecall_reset_ivs", item_ql_ecall_reset_ivs},
    {"ql_ecall_set_msd_call_type", item_ql_ecall_set_msd_call_type},
    {"ql_ecall_get_msd_call_type", item_ql_ecall_get_msd_call_type},
    {"ql_ecall_set_msd_vin", item_ql_ecall_set_msd_vin},
    {"ql_ecall_get_msd_vin", item_ql_ecall_get_msd_vin},
    {"ql_ecall_set_msd_version", item_ql_ecall_set_msd_version},
    {"ql_ecall_get_msd_version", item_ql_ecall_get_msd_version},
    {"ql_ecall_set_msd_tx_mode", item_ql_ecall_set_msd_tx_mode},
    {"ql_ecall_get_msd_tx_mode", item_ql_ecall_get_msd_tx_mode},
    {"ql_ecall_set_msd_position", item_ql_ecall_set_msd_position},
    {"ql_ecall_set_msd_position1", item_ql_ecall_set_msd_position1},
    {"ql_ecall_set_msd_position2", item_ql_ecall_set_msd_position2},
    {"ql_ecall_set_msd_vehicle_type", item_ql_ecall_set_msd_vehicle_type},
    {"ql_ecall_get_msd_vehicle_type", item_ql_ecall_get_msd_vehicle_type},
    {"ql_ecall_set_number_of_passengers", item_ql_ecall_set_number_of_passengers},
    {"ql_ecall_set_msd_propulsion_type", item_ql_ecall_set_msd_propulsion_type},
    {"ql_ecall_get_msd_propulsion_type", item_ql_ecall_get_msd_propulsion_type},
    {"ql_ecall_terminate_nw_registration", item_ql_ecall_terminate_nw_registration},
    {"ql_ecall_set_interval_between_attempts", item_ql_ecall_set_interval_between_attempts},
    {"ql_ecall_get_interval_between_attempts", item_ql_ecall_get_interval_between_attempts},
    {"ql_ecall_update_msd", item_ql_ecall_update_msd},
    {"ql_ecall_set_config_info", item_ql_ecall_set_config_info},
    {"ql_ecall_get_config_info", item_ql_ecall_get_config_info},
    {"ql_ecall_set_ecall_only_mode", item_ql_ecall_set_ecall_only_mode},
    {"ql_ecall_deinit", item_ql_ecall_deinit}
};

static void help()
{
    int i = 0;
    printf("Test Items:\n");
    while(i < ARRAY_SIZE(ql_ecall_items)) {
        printf("%d : %s\n", i, ql_ecall_items[i].name);
        i++;
    }
    printf(":");
}

int main(int argc, char *argv[])
{
    char cmd[1024];
    help();
    while(1)
    {
        memset(cmd, 0, sizeof(cmd));
        if(fgets(cmd, sizeof(cmd), stdin))
        {
            char *ptr = cmd + strlen(cmd) - 1;
            while(ptr >= cmd && (*ptr == '\r' || *ptr == '\n'))
            {
                *ptr-- = '\0';
            }

            if(strlen(cmd) > 0) {
                if(isdigit(cmd[0])) {
                    int item = atoi(cmd);
                    if(item >= 0 && item < ARRAY_SIZE(ql_ecall_items)) {
                        ql_ecall_items[item].handle();
                    }
                }
                else if(!strcasecmp(cmd, "h")) {
                    help();
                }
                else if(!strcasecmp(cmd, "q")) {
                    break;
                }
            }
            else {
                printf("\n");
            }
        }
    }
    return 0;
}

