#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <pthread.h>
#include <unistd.h>
#include <stdlib.h>
#include "ql_gpio.h"

static ENUM_PINNAME m_gpio_pin_gpio = PINNAME_GPIO_120;

void callback_onAlarm(int param)
{
	int lvl = ql_gpio_get_level(m_gpio_pin_gpio);
	if (lvl < 0)
	{
		printf("< fail to read pin level >\n");
		return;
	}
	if (1 == lvl)
	{
		ql_gpio_set_level(m_gpio_pin_gpio, PINLEVEL_LOW);
		printf("< Pull pin level to low >\n");
	}else{
		ql_gpio_set_level(m_gpio_pin_gpio, PINLEVEL_HIGH);
		printf("< Pull pin level to high >\n");
	}

	alarm(1);
}

void exit_sig(int param)
{
   //Exit to release gpio
   ql_gpio_uninit(m_gpio_pin_gpio);

   exit(1);
}

int main(int argc, char* argv[])
{
	int iRet;

	printf("< OpenLinux: GPIO example >\n");
#if 0
	/*
	 *Note:
	 * When using gpio configure, you need to determine whether the function of pin is gpio function.
	 * If it is not gpio function, the following gpio configure are invalid.
	 * You can use the ql_set_gpio_function to setting.
	 */
	iRet = ql_check_pin_function_status(m_gpio_pin_gpio);
	if(iRet == 0){
		iRet = ql_set_gpio_function(m_gpio_pin_gpio,1);
		printf("< Set gpio(%d) function iRet=%d status=%d>\n", m_gpio_pin_gpio,iRet,ql_check_pin_function_status(m_gpio_pin_gpio));
	}
#endif
	/*
	* Before using gpio init the application layer,you first need to determine whether it is used in the driver.
	*/
	iRet = ql_gpio_init(m_gpio_pin_gpio, PINDIRECTION_OUT, PINLEVEL_HIGH, PINPULLSEL_DISABLE);
	printf("< Init GPIO: pin=%d, dir=%d, level=%d, iRet=%d >\n", m_gpio_pin_gpio, PINDIRECTION_OUT, PINLEVEL_HIGH, iRet);

	signal(SIGALRM, callback_onAlarm);
	alarm(2);

    signal(SIGINT, exit_sig);
    while (1)
	{
		sleep(1);
	}

    return 0;
}
