#include "ql_sleep_wakelock.h"
#include "ql_lpm.h"

#include <stdio.h>
#include <unistd.h>
#include <stddef.h>
#include "mbtk_type.h"
#include "mbtk_log.h"

static void ql_lpm_handler(ql_lpm_edge_t edge_state)
{
    printf("this is ql_lpm_handler, edge_state=%d\n", edge_state);
}

int main(int argc, char *argv[])
{
    char operator[10];
    int opt;
    int lv_voll = 0;
    int fd_t;
    mbtk_log_init("radio", "SLEEP_TEST");

    printf("=========ql sleep main=========\n"
        "\t0 exit\n"
        "\t1 autosuspend enable\n"
        "\t2 wakelock create\n"
        "\t3 wakelock lock\n"
        "\t4 wakelock unlock\n"
        "\t5 wakelock destroy\n"
	    "\t6 lpm init\n"
        "\t7 lpm deinit\n"	
        "operator: >> \n");

    while(1)
    {
        fgets(operator, sizeof(operator), stdin);
        fflush(stdin);
        opt = atoi(operator);
        switch (opt)
        {
        case 0:
            printf("main exit\n");
            return 0;
        case 1:
            {
                printf(">>>>>Input 0 or 1<<<<<\n");
                char tmp_en[4]={0};
                memset(tmp_en, 0x00, sizeof(tmp_en));
                fgets(tmp_en, sizeof(tmp_en)-1, stdin);
                fflush(stdin);

                if (tmp_en[0] == '0' || tmp_en[0] == '1')
                    ql_autosleep_enable(tmp_en[0]);
                else
                    printf(">>>>>re Input 0 or 1 error<<<<<\n");
            }
            break;
        case 2:
            {
                printf(">>>>>Input name<<<<<\n");
                char t_name[64]={0};
                int len_name;
                char tmp_c[64]={0};
                memset(tmp_c, 0x00, sizeof(tmp_c));
                fgets(tmp_c, sizeof(tmp_c)-1, stdin);
                fflush(stdin);
                len_name = strlen(tmp_c)-1;
                strncpy(t_name, tmp_c, len_name);
                printf(">>>>>name=[%s] name_len=[%d]<<<<<\n",t_name, len_name);

                fd_t = ql_slp_wakelock_create(t_name, len_name);
                if (fd_t == -1)
                {
                    printf(">>>>>Output error =[%d]<<<<<\n",fd_t);
                }
                else
                {
                    printf(">>>>>Output ID NUM =[%d]<<<<<\n",fd_t);
                }
            }
            break;
        case 3:
            {
                printf(">>>>>Input ID NUM<<<<<\n");
                char tmp_l[127]={0};
                fgets(tmp_l, sizeof(tmp_l), stdin);
                fflush(stdin);
                fd_t = atoi(tmp_l);
                fd_t = ql_slp_wakelock_lock(fd_t);
                if (fd_t == -1)
                {
                    printf(">>>>>Output error =[%d]<<<<<\n",fd_t);
                }
                else
                {
                    printf(">>>>>Output succuess<<<<<\n");
                }
            }
            break;
        case 4:
            {
                printf(">>>>>Input ID NUM<<<<<\n");
                char tmp_ul[127]={0};
                memset(tmp_ul, 0x00, sizeof(tmp_ul));
                fgets(tmp_ul, sizeof(tmp_ul)-1, stdin);
                fflush(stdin);
                fd_t = atoi(tmp_ul);
                fd_t = ql_slp_wakelock_unlock(fd_t);
                if (fd_t == -1)
                {
                    printf(">>>>>Output error =[%d]<<<<<\n",fd_t);
                }
                else
                {
                    printf(">>>>>Output succuess<<<<<\n");
                }
            }
            break;
        case 5:
            {
                printf(">>>>>Input ID NUM<<<<<\n");
                char tmp_d[127]={0};
                memset(tmp_d, 0x00, sizeof(tmp_d));
                fgets(tmp_d, sizeof(tmp_d)-1, stdin);
                fflush(stdin);
                fd_t = atoi(tmp_d);
                fd_t = ql_slp_wakelock_destroy(fd_t);
                if (fd_t == -1)
                {
                    printf(">>>>>Output error =[%d]<<<<<\n",fd_t);
                }
                else
                {
                    printf(">>>>>Output succuess<<<<<\n");
                }
            }
            break;
        case 6:
            {
				int ret;
				ret = ql_lpm_init(ql_lpm_handler);
				printf("ql lpm init, ret: %d\n", ret);		
            }
            break;
        case 7:
            ql_lpm_deinit();
            break;
			
        default:
            break;
        }

    }

    return 0;
}

