#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include "ql_sms.h"
#include "mbtk_log.h"



void sms_msg_recv_cb(ql_sms_msg_t *p_msg, ql_sms_timestamp_t *timestamp,
                                             ql_sms_user_data_head_t *head)
{
    printf("sms_msg_recv_cb succeess!\n");
    printf("format: %d, addr:%s, content_size:%d, content:%s\n", p_msg->format, p_msg->addr, p_msg->content_size, p_msg->content);
    printf("timestamp: %d-%d-%d %d:%d:%d\n", timestamp->year, timestamp->month, timestamp->day, timestamp->hours, timestamp->minutes, timestamp->seconds);
}

void sms_servicie_error_cb(int error)
{
    printf("===== SMS Service Abort =====\n");
}

void sms_msg_async_cb_f(int id, int result)
{
    printf("===== sms_msg_recv_cb =====\n");
}




int main(int argc, char *argv[])
{
    //char operator[10];
    int opt;
    int ret;
//    int sms;
//    int direction;
//    int value;
//    int pullsel;

	mbtk_log_init("radio", "SMS_TEST");

    printf("=========ql sms main=========\n"
        "\t0 exit\n"
        "\t1 sms init\n"
		"\t2 sms deinit\n"
        "\t3 sms set msg recv cb\n"
        "\t4 sms set ser error cb\n"
        "\t5 sms send msg async\n"
        "\t6 sms set slot to send msg\n"
        "operator: >> \n");

    while(1)
    {
		scanf("%d",&opt);
        switch (opt)
        {
        case 0:
            printf("main exit\n");
            return 0;
        case 1:
            {
                printf(">>>>>sms init\n");
				ret = ql_sms_init();
				if(ret != 0)
				{
					printf("ql_sms_init fail\n");
				}
				else
				{
					printf("ql_sms_init success\n");
				}
            }
            break;
        case 2:
            {
				printf(">>>>>sms uninit\n");

				ret = ql_sms_deinit();
				if(ret != 0)
				{
					printf("ql_sms_uninit fail\n");
					printf("ret=%d\n", ret);
				}
				else
				{
					printf("ql_sms_uninit success\n");

				}
            }
            break;
        case 3:
            {
                printf(">>>>>Input set recv cb<<<<<\n");

				ret = ql_sms_set_msg_recv_cb(sms_msg_recv_cb);
				if(ret != 0)
				{
					printf("ql_sms_set_msg_recv_cb fail\n");
				}
				else
				{
					printf("ql_sms_set_msg_recv_cb success\n");
				}

            }
            break;
        case 4:
            {
                printf(">>>>>Input set ser cb<<<<<\n");

			    ret = ql_sms_set_service_error_cb(sms_servicie_error_cb);
				if(ret < 0)
				{
					printf("ql_sms_set_service_error_cb fail\n");
				}
				else
				{
					printf("ql_sms_set_service_error_cb success\n");
				}

            }
            break;
        case 5:
            {
                printf(">>>>>Input send msg<<<<<\n");

                ql_sms_msg_t    sms_msg = {0};
                int id = 0;
                char addr[128] = "19130850401";
                char content[128] = "hello";
                sms_msg.format = 1;
                memcpy(sms_msg.addr, addr, strlen(addr));
                sms_msg.content_size = strlen(content);
                memcpy(sms_msg.content, content, strlen(content));


                ret = ql_sms_send_msg_async(&sms_msg, &id, sms_msg_async_cb_f);
				if(ret < 0)
				{
					printf("ql_sms_send_msg_async fail\n");
				}
				else
				{
					printf("ql_sms_send_msg_async success\n");
				}
            }
            break;
        case 6:
            {
                int ret = -1;
                int choice = -1;
                printf("1:sim card 1, 2:sim card 2\n");
                while (1)
                {
                    if (scanf("%d", &choice) == 1) 
                    {  
                        if (choice == 1 || choice == 2) 
                        {
                            break;  
                        }
                        else
                        {
                            printf("invlid input \n");
                        }
                    }
                    else
                    {
                        
                        int c;
                        while ((c = getchar()) != '\n' && c != EOF);
                        printf("invalid input \n");
                    }
                    
                }
                
                if (choice == 1)
                {
                    ret=ql_set_sms_slot(QL_SIM_SLOT_1);
                    if(ret != 0)
                    {
                        printf("ql_set_sms_slot failed %d\n",ret);
                    }
                    else
                    {
                        printf("ql_set_sms_slot success \n");
                    }
                } 
                else if (choice == 2)
                {
                    ret = ql_set_sms_slot(QL_SIM_SLOT_2);
                    if(ret != 0)
                    {
                        printf("ql_set_sms_slot failed %d\n",ret);
                    }
                    else
                    {
                        printf("ql_set_sms_slot success \n");
                    }
                }
                break;
            }

        default:
            break;
        }

    }

    return 0;

}
