#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include "ql_tee_service.h"


#define TEST_OBJECT_SIZE	128

int main(void)
{
    int ret;
    unsigned int len;
    char obj1_id[] = "object#1";
    char obj1_data[] = "123456789";
    char read_data[TEST_OBJECT_SIZE];
    uint32_t object;
    uint32_t count;


    printf("ql_ss_initialize start\n");
    ret =  ql_ss_initialize();
    if(ret != 0)
    {
        printf("ql_ss_initialize fail\n");
    }

    ret = ql_ss_open(obj1_id, sizeof(obj1_id), &object);
    if(ret != 0)
    {
        printf("ql_ss_open fail\n");
	return 0;
    }

    ret = ql_ss_write(object, obj1_data, sizeof(obj1_data));
    if(ret != 0)
    {
        printf("ql_ss_write fail\n");
        return 0;
    }

    ret = ql_ss_read(object, read_data, sizeof(obj1_data), &count);
    if(ret != 0)
    {
        printf("ql_ss_read fail\n");
        return 0;
    }
    printf("read_data: %s\n", read_data);
    

    ret = ql_ss_unlink(object);
    if(ret != 0)
    {
        printf("ql_ss_unlink fail\n");
        return 0;
    }

    ql_ss_close(object);
    ql_ss_deinitialize();

    return 0;


}



