/*-----------------------------------------------------------------------------------------------*/
/**
  @file ql_test_utils.h 
  @brief Test related interface definition
*/
/*-----------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------------
  Copyright (c) 2018 Quectel Wireless Solution, Co., Ltd. All Rights Reserved.
  Quectel Wireless Solution Proprietary and Confidential.
-------------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------------
  EDIT HISTORY
  This section contains comments describing changes made to the file.
  Notice that changes are listed in reverse chronological order.
  $Header: $
  when       who          what, where, why
  --------   ---          ----------------------------------------------------------
  20190508   tyler.kuang  Created .
-------------------------------------------------------------------------------------------------*/

#ifndef __TEST_UTILS_H__
#define  __TEST_UTILS_H__

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

typedef void (*item_handler_f)(void);
typedef int (*init_handler_f)(void);
typedef int (*deinit_handler_f)(void);


#define T_ARRAY_SIZE(items) (sizeof(items)/sizeof(items[0]))

typedef struct
{
    const char *name;
    item_handler_f handle;
} t_item_t;

typedef struct
{
    const char *name;
    int item_len;
    t_item_t *item_list;
} t_module_t;

typedef struct
{
    const char *name;
    init_handler_f init_handle;
    deinit_handler_f deinit_handle;
} t_init_t;


/*-----------------------------------------------------------------------------------------------*/
/** 
  @brief Read a int value from stdin 
  @param[out] val, Return read data
  @return 
  0 - successful
  1 - read an enter 
  -1 - invalid input
  */
/*-----------------------------------------------------------------------------------------------*/
int t_get_int(int *val);

/*-----------------------------------------------------------------------------------------------*/
/** 
  @brief Read a uint32 value from stdin 
  @param[out] val, Return read data
  @return 
  0 - successful
  1 - read an enter 
  -1 - invalid input
  */
/*-----------------------------------------------------------------------------------------------*/
//int t_get_hex(uint32_t *val);

/*-----------------------------------------------------------------------------------------------*/
/** 
  @brief Read a char value from stdin 
  @param[out] val, Return read data
  @return 
  0 - successful
  1 - read an enter 
  -1 - invalid input
  */
/*-----------------------------------------------------------------------------------------------*/
//int t_get_char(int *val);

/*-----------------------------------------------------------------------------------------------*/
/** 
  @brief Read a string value from stdin 
  @param[out] val, Return read data
  @return 
  0 - successful
  1 - read an enter 
  -1 - invalid input
  */
/*-----------------------------------------------------------------------------------------------*/
//int t_get_string(char *str_buf, int str_len);

/*-----------------------------------------------------------------------------------------------*/
/** 
  @brief Read a list of int values from stdin 
  @param[out] val, Return read datas
  @param[out&in] val, Input buffer length, output the number of read
  @return 
  0 - successful
  1 - read an enter 
  -1 - invalid input
  */
/*-----------------------------------------------------------------------------------------------*/
//int t_get_int_list(int *dat_buf, int *dat_len);

/*-----------------------------------------------------------------------------------------------*/
/** 
  @brief Read a list of float values from stdin 
  @param[out] val, Return read datas
  @param[out&in] val, Input buffer length, output the number of read
  @return 
  0 - successful
  1 - read an enter 
  -1 - invalid input
  */
/*-----------------------------------------------------------------------------------------------*/
//int t_get_float_list(float *dat_buf, int *dat_len);


#ifdef __cplusplus
} 
#endif

#endif

