#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include "ql_voice.h"



void voice_call_cb(ql_voice_record_array_t *p_arr)
{

    printf("len1-voice_call_cb-id:%d, number:%s, state:%d, tech:%d, dir:%d, end_reason:%d\n", p_arr->records[0].id, p_arr->records[0].number, p_arr->records[0].state, p_arr->records[0].tech,
                     p_arr->records[0].dir, p_arr->records[0].end_reason);
    if(2 == p_arr->len)
    {
    printf("len2-id:%d, number:%s, state:%d, tech:%d, dir:%d, end_reason:%d\n", p_arr->records[1].id, p_arr->records[1].number, p_arr->records[1].state, p_arr->records[1].tech,
                                    p_arr->records[1].dir, p_arr->records[1].end_reason);
    }
}

void voice_servicie_error_cb(int error)
{
    printf("===== voice Service Abort =====\n");
}






int main(int argc, char *argv[])
{
    
    int opt;
    int ret;
    int voice;
    int direction;
    int value;
    int pullsel;

	mbtk_log_init("radio", "voice_TEST");

    printf("=========ql voice main=========\n"
        "\t0 exit\n"
        "\t1 voice init\n"
		"\t2 voice deinit\n"
        "\t3 voice set call cb\n"
        "\t4 voice set ser error cb\n"
        "\t5 voice dial\n"
        "\t6 voice hangup all\n"
        "\t7 voice answer\n"
        "\t8 voice get records\n"
        "\t9 voice send dtmf char\n"
        "\t10 voice set sim card\n"
        "operator: >> \n");

    while(1)
    {
        scanf("%d",&opt);
        switch (opt)
        {
        case 0:
            printf("main exit\n");
            return 0;
        case 1:
            {
                printf(">>>>>voice init\n");
				ret = ql_voice_init();
				if(ret != 0)
				{
					printf("ql_voice_init fail\n");
				}
				else
				{
					printf("ql_voice_init success\n");
				}
            }
            break;
        case 2:
            {
				printf(">>>>>voice uninit\n");

				ret = ql_voice_deinit();
				if(ret != 0)
				{
					printf("ql_voice_uninit fail\n");
					printf("ret=%d\n", ret);
				}
				else
				{
					printf("ql_voice_uninit success\n");

				}
            }
            break;
        case 3:
            {
                printf(">>>>>Input set recv cb<<<<<\n");

				ret = ql_voice_set_call_cb(voice_call_cb);
				if(ret != 0)
				{
					printf("ql_voice_set_msg_recv_cb fail\n");
				}
				else
				{
					printf("ql_voice_set_msg_recv_cb success\n");
				}

            }
            break;
        case 4:
            {
                printf(">>>>>Input set ser cb<<<<<\n");

			    ret = ql_voice_set_service_error_cb(voice_servicie_error_cb);
				if(ret < 0)
				{
					printf("ql_voice_set_service_error_cb fail\n");
				}
				else
				{
					printf("ql_voice_set_service_error_cb success\n");
				}

            }
            break;
        case 5:
            {
                printf(">>>>>Input ql_voice_dial<<<<<\n");

                uint32_t id = 0;
                char phone_num[16] = {0};
                printf("Please input dial number\n");
                scanf("%s",phone_num);
                ret = ql_voice_dial(phone_num,11, &id);
                printf("id:%d", id);
				if(ret < 0)
				{
					printf("ql_voice_dial fail\n");
				}
				else
				{
					printf("ql_voice_dial success\n");
				}
            }
            break;
        case 6:
            {
                printf(">>>>>Input ql_voice_hangup_all<<<<<\n");

                int id = 0;
                ret = ql_voice_hangup_all();
                if(ret < 0)
                {
                    printf("ql_voice_hangup_all fail\n");
                }
                else
                {
                    printf("ql_voice_hangup_all success\n");
                }
            }
            break;
        case 7:
            {
                printf(">>>>>Input ql_voice_answer<<<<<\n");

                int id = 0;
                ret = ql_voice_answer(1);
				if(ret < 0)
				{
					printf("ql_voice_answer fail\n");
				}
				else
				{
					printf("ql_voice_answer success\n");
				}
            }
            break;
        case 8:
            {
                printf(">>>>>Input ql_voice_get_records<<<<<\n");

                ql_voice_record_array_t arr;
                ret = ql_voice_get_records(&arr);
                printf("len1-id:%d, number:%s, state:%d, tech:%d, dir:%d, end_reason:%d\n", arr.records[0].id, arr.records[0].number, arr.records[0].state, arr.records[0].tech,
                            arr.records[0].dir, arr.records[0].end_reason);
                if(2 == arr.len)
                {
                    printf("len2-id:%d, number:%s, state:%d, tech:%d, dir:%d, end_reason:%d\n", arr.records[1].id, arr.records[1].number, arr.records[1].state, arr.records[1].tech,
                        arr.records[1].dir, arr.records[1].end_reason);
                }

                if(ret < 0)
                {
                    printf("ql_voice_get_records fail\n");
                }
                else
                {
                    printf("ql_voice_get_records success\n");
                }
            }
            break;
         case 9:
            {
                printf(">>>>>Input ql_voice_send_dtmf_char<<<<<\n");


                char inputChar;

                printf("Enter set dtmf\n");
                scanf(" %c", &inputChar);
                printf("inputChar is %c\n", inputChar);

                ret = ql_voice_send_dtmf_char(1, inputChar);
				if(ret < 0)
				{
					printf("ql_voice_send_dtmf_char fail\n");
				}
				else
				{
					printf("ql_voice_send_dtmf_char success\n");
				}
            }
            break;
         
        case 10:
        {
                 int ret = -1;
                 int choice = -1;
                 printf("1:sim card 1, 2:sim card 2\n");
                 while (1)
                 {
                     if (scanf("%d", &choice) == 1) 
                     {  
                         if (choice == 1 || choice == 2) 
                         {
                             break;  
                         }
                         else
                         {
                             printf("invlid input \n");
                         }
                     }
                     else
                     {
                         
                         int c;
                         while ((c = getchar()) != '\n' && c != EOF);
                         printf("invalid input \n");
                     }
                     
                 }
                 if (choice == 1)
                 {
                     ret = ql_set_sms_slot(QL_SIM_SLOT_1);
                     if(ret != 0)
                     {
                         printf("ql_set_sms_slot failed %d\n",ret);
                     }
                     else
                     {
                         printf("ql_set_sms_slot success \n");
                     }
                 } 
                 else if (choice == 2)
                 {
                     ret = ql_set_sms_slot(QL_SIM_SLOT_2);
                     if(ret != 0)
                     {
                         printf("ql_set_sms_slot failed %d\n",ret);
                     }
                     else
                     {
                         printf("ql_set_sms_slot success \n");
                     }
                 }
                 break;
        }
        default:
            break;
        }

    }

    return 0;

}
