/**
 *
 *  (C) Copyright 2009-2016 Marvell International Ltd. All Rights Reserved
 *
 *  MARVELL CONFIDENTIAL
 *  The source code contained or described herein and all documents related to
 *  the source code ("Material") are owned by Marvell International Ltd or its
 *  suppliers or licensors. Title to the Material remains with Marvell
 *  International Ltd or its suppliers and licensors. The Material contains
 *  trade secrets and proprietary and confidential information of Marvell or its
 *  suppliers and licensors. The Material is protected by worldwide copyright
 *  and trade secret laws and treaty provisions. No part of the Material may be
 *  used, copied, reproduced, modified, published, uploaded, posted,
 *  transmitted, distributed, or disclosed in any way without Marvell's prior
 *  express written permission.
 *
 *  No license under any patent, copyright, trade secret or other intellectual
 *  property right is granted to or conferred upon you by disclosure or delivery
 *  of the Materials, either expressly, by implication, inducement, estoppel or
 *  otherwise. Any license under such intellectual property rights must be
 *  express and approved by Marvell in writing.
 *
 */

#ifndef FP_COMMON_H
#define FP_COMMON_H

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/version.h>

#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/ip.h>
#include <linux/ipv6.h>
#include <linux/udp.h>
#include <linux/tcp.h>
#include <linux/proc_fs.h>

#include <net/netfilter/nf_conntrack.h>
#include <net/netfilter/nf_conntrack_core.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <net/netfilter/nf_conntrack_ecache.h>
#include <net/netfilter/nf_conntrack_l4proto.h>
#include <linux/netfilter/nfnetlink.h>
#include <linux/netfilter/nfnetlink_conntrack.h>
#include <net/netfilter/nf_conntrack_zones.h>
#include <linux/netfilter_ipv4.h>
#include <linux/netfilter_ipv6.h>
#include <linux/notifier.h>
#include <net/netevent.h>
#include <net/sock.h>
#include <net/arp.h>
#include <net/genetlink.h>
#include <linux/if_arp.h>
#include <net/ip_fib.h>
#include <net/ip6_route.h>
#include <net/ipv6.h>
#include <net/ip.h>

#include <asm/cacheflush.h>
#include <linux/timer.h>


#define FP_NO_DEBUG_LVL	(0)
#define FP_FATAL_LVL		(1)
#define FP_ERR_LVL		(2)
#define FP_WARNING_LVL		(3)
#define FP_INFO_LVL		(4)
#define FP_DEBUG_LVL		(5)

/* Set fastpath debug level */
#if !defined(FP_DEBUG_LEVEL)
#define FP_DEBUG_LEVEL		(FP_ERR_LVL)
#endif
#define MAX_DEBUG_PRINT_SIZE	(1000)

/* runtime debug levels */
enum {
	/* Warnings as Errors */
	DBG_WARN_AS_ERR_BIT = 0,
	DBG_WARN_AS_ERR = (1 << DBG_WARN_AS_ERR_BIT),
	/* Entry Debug Info */
	DBG_INFO_BIT = 1,
	DBG_INFO = (1 << DBG_INFO_BIT),
	/* Entry Extra Debug Info (for future use) */
	DBG_INFO_EXT_BIT = 2,
	DBG_INFO_EXT = (1 << DBG_INFO_EXT_BIT),
	/* Entry Trace Logging (may impact performance) */
	DBG_TRACE_LOG_BIT = 3,
	DBG_TRACE_LOG = (1 << DBG_TRACE_LOG_BIT),

	DBG_LEVEL_END_BIT = 4,
	DBG_LEVEL_END = (1 << DBG_LEVEL_END_BIT),
};

void fpdb_dump_tuple(char *msg, struct nf_conntrack_tuple *t);

#if FP_DEBUG_LEVEL >= FP_ERR_LVL
#define FP_ERR_DUMP_ENTRY(msg, el)                                     \
			fpdb_dump_entry(msg, el)
#define FP_ERR_DUMP_CONTRACK(msg, el)                                  \
			learner_nc_dump_conntrack_tuple(msg, el)
#define FP_ERR_DUMP_TUPLE(msg, el)                                     \
			fpdb_dump_tuple(msg, el)
#else
#define FP_ERR_DUMP_ENTRY(msg, el) do {} while (0)
#define FP_ERR_DUMP_CONTRACK(msg, el) do {} while (0)
#define FP_ERR_DUMP_TUPLE(msg, el) do {} while (0)
#endif

#if FP_DEBUG_LEVEL >= FP_DEBUG_LVL
#define FP_DEBUG_DUMP_ENTRY(msg, el)                                   \
			fpdb_dump_entry(msg, el)
#define FP_DEBUG_DUMP_TUPLE(msg, el)                                   \
			fpdb_dump_tuple(msg, el)
#define FP_DEBUG_DUMP_CONTRACK(msg, el)                                \
			learner_nc_dump_conntrack_tuple(msg, el)
#else
#define FP_DEBUG_DUMP_ENTRY(msg, el) do {} while (0)
#define FP_DEBUG_DUMP_TUPLE(msg, el) do {} while (0)
#define FP_DEBUG_DUMP_CONTRACK(msg, el) do {} while (0)
#endif

static const char *const tcp_conntrack_names[] = {
	"NONE",
	"SYN_SENT",
	"SYN_RECV",
	"ESTABLISHED",
	"FIN_WAIT",
	"CLOSE_WAIT",
	"LAST_ACK",
	"TIME_WAIT",
	"CLOSE",
	"SYN_SENT2",
};

#define SECS * HZ
#define MINS * 60 SECS
#define HOURS * 60 MINS
#define DAYS * 24 HOURS

#define TCP_DEFAULT_TIMEOUT (5 DAYS)
#define UDP_DEFAULT_TIMEOUT (5 SECS)
#define UDP_DEFAULT_TIMEOUT_STREAM (180 SECS)

#define IP_VER_4		4
#define IP_VER_6		6
#define IP_VERSION(pkt) (((struct iphdr *)(pkt))->version)
#define NF_CT_NAT(ct) ((ct)->status & IPS_NAT_DONE_MASK)

#ifdef SKB_P_SUPPORT
#define FP_IS_SKB_P(skb) ((skb)->shared_info_ptr)
#else
#define FP_IS_SKB_P(skb) 0
#endif
static inline
int fp_dump_tuple_ip(char *buf,const struct nf_conntrack_tuple *t, int verbose)
{
	int len = 0;
	if (buf) {
		if (verbose)
			len += sprintf(buf, "%s ", t->dst.protonum ==
				       IPPROTO_UDP ? "UDP" : "TCP");
		len += sprintf(buf + len, "src=%pI4 dst=%pI4 sport=%hu dport=%hu",
			       &t->src.u3.ip, &t->dst.u3.ip,
			       ntohs(t->src.u.all), ntohs(t->dst.u.all));
	}
	return len;
}

static inline
int fp_dump_tuple_ipv6(char *buf, const struct nf_conntrack_tuple *t, int verbose)
{
	int len = 0;
	if (buf) {
		if (verbose)
			len += sprintf(buf, "%s ", t->dst.protonum ==
				       IPPROTO_UDP ? "UDP" : "TCP");
		len += sprintf(buf + len, "src=%pI6c dst=%pI6c sport=%hu dport=%hu",
			       t->src.u3.all, t->dst.u3.all,
			       ntohs(t->src.u.all), ntohs(t->dst.u.all));
	}
	return len;
}

static inline int __fp_dump_tuple(char *buf, const struct nf_conntrack_tuple *t, int verbose)
{
	if (t->src.l3num == AF_INET)
		return fp_dump_tuple_ip(buf, t, verbose);
	if (t->src.l3num == AF_INET6)
		return fp_dump_tuple_ipv6(buf, t, verbose);

	return 0;
}

static inline int fp_dump_tuple(char *buf, const struct nf_conntrack_tuple *t)
{
	return __fp_dump_tuple(buf, t, 1);
}

static inline void fp_print_tuple(char *msg, const struct nf_conntrack_tuple *t)
{
	if (t->src.l3num == AF_INET) {
		pr_err("%s:%d(%s): %s %pI4:%hu -> %pI4:%hu\n",
		       __func__, __LINE__, msg,
		       t->dst.protonum ==
		       IPPROTO_UDP ? "UDP" : "TCP",
		       &t->src.u3.ip, ntohs(t->src.u.all),
		       &t->dst.u3.ip, ntohs(t->dst.u.all));
	}

	if (t->src.l3num == AF_INET6) {
		pr_err("%s:%d(%s): %s %pI6 %hu -> %pI6 %hu\n",
		       __func__, __LINE__, msg,
		       t->dst.protonum ==
		       IPPROTO_UDP ? "UDP" : "TCP",
		       t->src.u3.all, ntohs(t->src.u.all),
		       t->dst.u3.all, ntohs(t->dst.u.all));
	}
}

/* For debugging only */
static inline void fp_dump_pkt_data(void *data, int len)
{
	void *start, *end;

	start = data;
	end = start + len;

	while (start < end) {
		pr_info("0x%08x: 0x%08x 0x%08x 0x%08x 0x%08x\n",
			   (u32)((unsigned long)start - (unsigned long)data),
			   ntohl(readl(start)), ntohl(readl(start + 0x4)),
			   ntohl(readl(start + 0x8)), ntohl(readl(start + 0xc)));
		start += 0x10;
	}
}

void restore_ct(struct nf_conn *ct);

/**------------------------------------------------------------**/
/**			BACKWARD COMPATABILITY			**/
/**------------------------------------------------------------**/

#if LINUX_VERSION_CODE < KERNEL_VERSION(3, 8, 0)
static inline int __must_check kref_get_unless_zero(struct kref *kref)
{
	return atomic_add_unless(&kref->refcount, 1, 0);
}
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(3, 7, 0)
extern struct netdev_queue *dev_pick_tx(struct net_device *dev, struct sk_buff *skb);
static inline struct netdev_queue *
netdev_pick_tx(struct net_device *dev, struct sk_buff *skb)
{
	return dev_pick_tx(dev, skb);
}
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(3, 2, 0)
#define netif_xmit_frozen_or_stopped(txq) \
	(netif_tx_queue_stopped(txq) || netif_tx_queue_frozen(txq))
#endif

static inline struct dst_entry *rt6i_dst_get(struct rt6_info *rt)
{
#if LINUX_VERSION_CODE < KERNEL_VERSION(3, 0, 0)
	return &rt->u.dst;
#else
	return &rt->dst;
#endif
}

#if LINUX_VERSION_CODE < KERNEL_VERSION(3, 8, 0)
static inline void ip6_rt_put(struct rt6_info *rt)
{
	dst_release(rt6i_dst_get(rt));
}
#endif

static inline int
rt4_lookup(struct net *n, struct flowi *flp, struct fib_result *res)
{
	memset(res, 0, sizeof(*res));
#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 39)
	return fib_lookup(n, flp, res);
#else
	return fib_lookup(n, &flp->u.ip4, res, 0);
#endif
}

static inline void ip4_rt_put(struct fib_result *res)
{
#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 37)
	fib_res_put(res);
#endif
}

#endif /* FP_COMMON_H */
