/**
 *
 *  (C) Copyright 2009-2016 Marvell International Ltd. All Rights Reserved
 *
 *  MARVELL CONFIDENTIAL
 *  The source code contained or described herein and all documents related to
 *  the source code ("Material") are owned by Marvell International Ltd or its
 *  suppliers or licensors. Title to the Material remains with Marvell
 *  International Ltd or its suppliers and licensors. The Material contains
 *  trade secrets and proprietary and confidential information of Marvell or its
 *  suppliers and licensors. The Material is protected by worldwide copyright
 *  and trade secret laws and treaty provisions. No part of the Material may be
 *  used, copied, reproduced, modified, published, uploaded, posted,
 *  transmitted, distributed, or disclosed in any way without Marvell's prior
 *  express written permission.
 *
 *  No license under any patent, copyright, trade secret or other intellectual
 *  property right is granted to or conferred upon you by disclosure or delivery
 *  of the Materials, either expressly, by implication, inducement, estoppel or
 *  otherwise. Any license under such intellectual property rights must be
 *  express and approved by Marvell in writing.
 *
 */

#ifndef __FP_CORE_H__
#define __FP_CORE_H__

#define MAX_NAME_SZ 20

struct fastpath_module;

struct fastpath_driver {
	const char *version;
	struct kobject *kobj;
	struct fastpath_module **modules;
	int num_modules;
};

struct fastpath_module_ops {
	int (*probe)(struct fastpath_module *);
	int (*remove)(struct fastpath_module *);
	int (*ioctl)(struct fastpath_module *, unsigned int cmd, void *data);
};

struct fastpath_module {
	struct kobject			kobj;
	char				name[MAX_NAME_SZ];
	int				idx;
	void				*priv;
	struct fastpath_module_ops	*ops;
	const struct fastpath_driver	*fastpath;
};

struct fp_attr {
	struct attribute attr;
	ssize_t (*show)(struct fastpath_module *, char *);
	ssize_t (*store)(struct fastpath_module *, const char *, size_t count);
};

#define FP_ATTR(_name, _mode, _show, _store) \
	struct fp_attr fp_attr_##_name = __ATTR(_name, _mode, _show, _store)

#define to_fpmod(k) container_of(k, struct fastpath_module, kobj)

extern unsigned int debug_level; /* debug level bitmask - see fp_common.h */
extern const struct sysfs_ops fp_sysfs_ops;
extern struct fastpath_module_ops fp_device_ops;
extern struct fastpath_module_ops fp_learner_ops;
extern struct fastpath_module_ops fp_classifier_ops;
extern struct fastpath_module_ops fp_forward_ops;
extern struct fastpath_module_ops fp_database_ops;
extern struct fastpath_module_ops fp_netlink_ops;
extern struct fastpath_module_ops fp_cm_ops;

struct fastpath_module *fp_module_get_by_name(const char *name);
struct fastpath_module *fp_module_get_by_idx(int idx);
void fp_module_put(struct fastpath_module *m);

#endif
