#!/bin/sh
if [ -z "$1" -o -z "$2" ]; then
    echo "Usage: $0 [-d] file_name block_size [dict_size] [preset] [filter] [lc] [lp] [pb] [nice]"
    echo "The output is file_name.mxz if -d is not specified, or filename.dec if -d is specified"
    echo "Compression algorithm: LZMA2; Check algorithm: CRC32; Filter: empty string or arm"
else
    set -e
    if [ "$1" != "-d" ]; then
	FNAME="$1"
	split -b "$2" "$FNAME" "$FNAME.part"
	FILTER=
	OPT=
	if [ -n "$4" ]; then
	    OPT="$OPT,preset=$4"
	fi
	if [ -n "$3" ]; then
	    OPT="$OPT,dict=$3"
	fi
	if [ -n "$5" ]; then
	    FILTER=--$5
	fi
	if [ -n "$6" ]; then
	    OPT="$OPT,lc=$6"
	fi
	if [ -n "$7" ]; then
	    OPT="$OPT,lp=$7"
	fi
	if [ -n "$8" ]; then
	    OPT="$OPT,pb=$8"
	fi
	if [ -n "$9" ]; then
	    OPT="$OPT,nice=$9"
	fi
	(set -x; xz --check=crc32 $FILTER --lzma2=$OPT -vfk "$FNAME.part"?? || \
	    xz.exe --check=crc32 $FILTER --lzma2=$OPT -vfk "$FNAME.part"??)
	cat "$FNAME.part"??.xz > "$FNAME.mxz"
	rm -f "$FNAME.part"*
	du -sh "$FNAME" "$FNAME.mxz"
    else
	FNAME="$2"
	(xz -dc "$FNAME" || xz.exe -dc "$FNAME") > "$FNAME.dec"
	du -sh "$FNAME" "$FNAME.dec"
    fi
fi
