#!/bin/bash

TOPDIR=$1
STAGING_DIR_HOST=$2
squashfs=$3
dm_crypt_cfg=$4

SECTOR_SIZE=512
BLOCK_SIZE=4096

align_up() {
    local offset=$1
    local size=$2

    echo $(((($offset + ($size - 1)) / $size) * $size))
}

verity_get_meta() {
    local needle="$1"
    local haystack="$2"

    echo "$haystack" | grep "$needle" | cut -d: -f2 | tr -d '[ \t]'
}


if [[ "$dm_crypt_cfg" == "y" ]]; then
CRYPT_KEY_SIZE=32
FIXED_KEY=2f54e5b40c9de5e4700d52f5d3938c1fd19a1d5e05b9dcf74c34a653b4b73ff5
RANDOM_KEY=$(openssl rand -hex $CRYPT_KEY_SIZE)

openssl enc -aes-$(($CRYPT_KEY_SIZE * 8))-ecb -e -in $squashfs -out "$squashfs"_enc -K $RANDOM_KEY
mv "$squashfs"_enc $squashfs

ENCRYPTED_KEY=$(echo -ne $RANDOM_KEY | perl -ne 'print pack "H*", $_' | openssl enc \
                -aes-$(($CRYPT_KEY_SIZE * 8))-ecb -K $FIXED_KEY -nopad | perl -ne 'print unpack "H*", $_' | tr -d '\n')
fi

VERITY_HASH_OFFSET=$(align_up $(stat --format=%s $squashfs) $BLOCK_SIZE)
VERITY_HASH_BLOCKS=$(($VERITY_HASH_OFFSET / $BLOCK_SIZE))
#echo "hash-blocks:"${VERITY_HASH_BLOCKS}

VERITY_META="$(veritysetup format \
    --hash-offset=$VERITY_HASH_OFFSET \
    "$squashfs" "$squashfs")"

#echo "VERITY_META= :"${VERITY_META}

VERITY_SALT=$(verity_get_meta Salt "$VERITY_META")
VERITY_ROOT=$(verity_get_meta Root "$VERITY_META")

ROOT_SECTORS=$(($VERITY_HASH_OFFSET / $SECTOR_SIZE))

ROOT_VERITY="$VERITY_ROOT $VERITY_SALT"
SMASH_DM_MOD_CREATE="ROOT_SECTORS=$ROOT_SECTORS:HASH_BLOCKS=$VERITY_HASH_BLOCKS:HASHSALT=$ROOT_VERITY"
if [[ "$dm_crypt_cfg" == "y" ]]; then
SMASH_DM_MOD_CREATE="$SMASH_DM_MOD_CREATE:ENCRYPTED_KEY=$ENCRYPTED_KEY"
fi
DM_SIZE=`echo ${#SMASH_DM_MOD_CREATE}`

DM_ALIGN_SIZE=0x20000
ROOT_FS_SIZE=$(stat -c%s "$squashfs")

BLOCK_MUL_SIZE=$(($ROOT_FS_SIZE / $DM_ALIGN_SIZE))

if [ $(($ROOT_FS_SIZE % $DM_ALIGN_SIZE)) -eq 0 ]; then
    APPEND_POS=$ROOT_FS_SIZE
else
    APPEND_POS=$((($BLOCK_MUL_SIZE + 1) * $DM_ALIGN_SIZE))
fi

FILL_SIZE=$(($APPEND_POS - $ROOT_FS_SIZE))
dd if=/dev/zero of=$squashfs conv=notrunc bs=1 seek=$ROOT_FS_SIZE count=$FILL_SIZE
echo -n -e "DM_SIZE=$DM_SIZE:"${SMASH_DM_MOD_CREATE} | dd of=$squashfs conv=notrunc bs=1 seek=$APPEND_POS

