#!/bin/bash

function sa_set_param()
{
  if [ "$1" = "tel_ptk" ];then
    PARAM="-npro -kr -i8 -ts8 -sob -l120 -ss -ncs -cp1"
  else
    PARAM="-npro -kr -i8 -ts8 -sob -l120 -ss -ncs -cp1 -bl -bli0 -bls -nce -cli8"
  fi
  local RES=`indent --version`
  local V1=`echo $RES | cut -d' ' -f3 | cut -d'.' -f1`
  local V2=`echo $RES | cut -d' ' -f3 | cut -d'.' -f2`
  local V3=`echo $RES | cut -d' ' -f3 | cut -d'.' -f3`
  if [ $V1 -gt 2 ]; then
    PARAM="$PARAM -il0"
  elif [ $V1 -eq 2 ]; then
    if [ $V2 -gt 2 ]; then
      PARAM="$PARAM -il0";
    elif [ $V2 -eq 2 ]; then
      if [ $V3 -ge 10 ]; then
        PARAM="$PARAM -il0"
      fi
    fi
  fi
}

function sa_usage()
{
  echo "Simple code format utility inspired by \${android_root}/kernel/kernel/scripts/Lindent"
  echo "Usage  : `basename $0` [Options] <file1> <file2> ..."
  echo "Options:"
  echo "-h       - help"
  echo "-a       - apply format recursively on all *.[ch] files"
  echo "-o       - use old (non-default) format style"
  echo "Examples:"
  echo "         `basename $0` -a"
  echo "         `basename $0` code.c newcode.c newcode.h"
  echo "         `basename $0` -o code.c newcode.c newcode.h"
  exit 1
}

function sa_make_indent()
{
  export SIMPLE_BACKUP_SUFFIX=.INDENT_BAK
  echo files ${#@}
  if [ ${#@} -eq 0 ]; then
    echo "ABORT: no files supplied."
    sa_usage
  fi
  #echo indent $PARAM "$@"
  echo "################################"
  for i in "$@"; do
    fromdos "$i"
    indent $PARAM "$i"
    diff $i ${i}${SIMPLE_BACKUP_SUFFIX} 1>/dev/null 2>&1
    if [ $? -eq 1 ]; then
      echo Changed: ${i}
    fi
    rm ${i}${SIMPLE_BACKUP_SUFFIX} #2>&- || true
  done
}

sa_doall=0
sa_doold=0
sa_set_param tel_ptk
while getopts ":aoh" opt; do
  case $opt in
  a)sa_doall=1;;
  o)sa_set_param tel_ptk_old_style;;
  h)sa_usage;;
  \?)sa_usage;;
  esac
done

if [ $sa_doall -eq 1 ]; then
  sa_make_indent `find -type f -a -name \*.[ch]`
else
  sa_make_indent $@
fi

