#!/bin/bash
function echo_red()
{
	echo -e '\033[1;31m'"$@"'\033[0m'
}

function echo_purple()
{
	echo -e '\033[1;35m'"$@"'\033[0m'
}

function echo_blue()
{
	echo -e '\033[1;34m'"$@"'\033[0m'
}

function doset()
{
	local pkg
	if [ "$1" = "ALL" ];then
		shift
		echo_blue "Testing install of $@"
		yes | sudo apt-get --fix-missing install $@
		return 0
	fi
	for pkg in $@; do
		dpkg -l $pkg | grep "ii  ";
		[ $? -eq 0 ] && continue
		echo_blue "Testing install of $pkg"
		yes | sudo apt-get --fix-missing install $pkg
		echo_blue "==============="
	done
	return 0
}

function update_sources_list()
{
	local ptadd="$1"
	if sudo grep -q "$ptadd" /etc/apt/sources.list ; then
		echo_purple "==== \"$ptadd\" already updated ===="
	else
		echo_blue "Adding \"$ptadd\""
		sudo add-apt-repository "$ptadd"
	fi
}

function update_src_repositories()
{
	sudo apt-get clean
	doset python-software-properties
	if [ "$UBUNTU" = "10.04" ]; then
		for ptadd in "deb http://archive.canonical.com/ lucid partner" \
			     "deb http://security.ubuntu.com/ubuntu lucid-security multiverse" \
			     "deb http://us.archive.ubuntu.com/ubuntu/ lucid multiverse" \
			     "deb-src http://us.archive.ubuntu.com/ubuntu/ lucid multiverse" \
			     "deb http://us.archive.ubuntu.com/ubuntu/ lucid-updates multiverse" \
			     "deb-src http://us.archive.ubuntu.com/ubuntu/ lucid-updates multiverse" ;
		do
			update_sources_list "$ptadd"
		done
		if [ ! -f /etc/apt/sources.list.d/git-core-ppa-lucid.list ];then
			# get advanced GIT
			sudo add-apt-repository ppa:git-core/ppa
		else
			echo_purple "==== GIT repository already set to PPA ===="
		fi
	else # ubuntu 12.04
		for ptadd in "deb http://archive.canonical.com/ precise partner" \
			     "deb http://security.ubuntu.com/ubuntu precise-security multiverse" \
			     "deb http://us.archive.ubuntu.com/ubuntu/ precise multiverse" \
			     "deb-src http://us.archive.ubuntu.com/ubuntu/ precise multiverse" \
			     "deb http://us.archive.ubuntu.com/ubuntu/ precise-updates multiverse" \
			     "deb-src http://us.archive.ubuntu.com/ubuntu/ precise-updates multiverse" ;
		do
			update_sources_list "$ptadd"
		done
	fi
	sudo apt-get update
	yes | sudo apt-get upgrade
}

function update_openwrt_dev_utils()
{
	# open WRT requiered packages (based on http://wiki.openwrt.org/doc/howto/buildroot.exigence)
	doset build-essential subversion git-core
	doset libncurses5-dev zlib1g-dev gawk
	doset gcc-multilib flex gettext g++
	if [ "$(uname -m)" = "x86_64" ];then
		update_openwrt_dev_utils_64bit
	else # 32 bit environment
		update_openwrt_dev_utils_32bit
	fi
	#     GIT basics
	doset git-gui git-doc gitk qgit
	# perl help utilities for GIT activities
	echo_red "Update packages for gerrit wrappers"
	doset libconfig-inifiles-perl liblist-moreutils-perl

	# packages for kernel build
	doset bc make exuberant-ctags

	#packages for uboot build
	doset uboot-mkimage uuid-dev

	# Diff tools & Editors
	doset geany hexer vim xxdiff xxdiff-scripts meld
	# Emacs + indentation tool + directory viewer
	doset indent emacs ispell wamerican-large tree

	# Install Phabricator client packages
	doset php5-cli php5-curl
}

function update_openwrt_dev_utils_32bit()
{
	#open WRT 32 bit spesific packages
	# (based on http://wiki.openwrt.org/doc/howto/buildroot.exigence)
	doset patch bzip2 bison
	doset autoconf unzip
	doset ncurses-term
	doset libz-dev libssl-dev
	doset quilt libssl-dev xsltproc
	doset libxml-parser-perl mercurial bzr ecj cvs
}
function update_openwrt_dev_utils_64bit()
{
	#open WRT 64 bit spesific libraries.
	doset geany
}

#main code starts here:

if [ "$(uname -m)" = "x86_64" ];then
	echo_purple "You are working on 64bit Linux !"
else
	echo_purple "You are working on 32bit Linux !"
fi
#check ubuntu version, supported 10.04 and 12.04 only
grep DISTRIB_DESCRIPTION /etc/lsb-release | grep -q 12.04;
if [ $? -eq 0 ];then
	UBUNTU=12.04
else
	UBUNTU=10.04
fi
echo_purple "    UBUNTU version $UBUNTU"
update_src_repositories
update_openwrt_dev_utils
echo_purple "    UBUNTU version $UBUNTU RUN Phase 2"
update_openwrt_dev_utils

yes | sudo apt-get autoremove

echo_blue "  Done"
