/*
* gnss_utils.h
*
* GNSS utils header.
*
* Author : lb
* Date   : 2024/5/28 11:27:34
*/
#ifndef _GNSS_UTILS_H
#define _GNSS_UTILS_H
#include <libubus.h>

#include "mbtk_type.h"

#define MBTK_GNSS_PARAM_PARSE 1

#if MBTK_GNSS_PARAM_PARSE
typedef enum {
    LYNQ_TIME_TYPE_CELL = 0,  //NITZ
    LYNQ_TIME_TYPE_NTP,
    LYNQ_TIME_TYPE_GNSS,
    LYNQ_TIME_TYPE_USER,
    
    LYNQ_TIME_TYPE_UNUSE
} lynq_time_type_enum;
#endif

int uart_baud_get(int baud);

int gnss_port_open(const char *dev, int flag, int baud, bool tty);

int gnss_port_close(int fd);

int gnss_set_baudrate(int fd, int baudrate);

uint16 get_crc16 (const char *ptr, uint16 count);

int gnss_pty_open(int *master_fd, int *slave_fd, const char *dev);

int gnss_nmea_sscanf(const char *str, char *ret,...);

void gnssStartTimer(struct uloop_timeout *timeout, int timeVal);

void gnssStopTimer(struct uloop_timeout *timeout);

#if MBTK_GNSS_PARAM_PARSE
int gnss_ind_nmea_parse(const char *data, int data_len);
#endif

#endif /* _GNSS_UTILS_H */
