/*
* gnss_info.h
*
* GNSS informations header.
*
* Author : lb
* Date   : 2024/5/20 15:22:46
*/
#ifndef _GNSS_INFO_H
#define _GNSS_INFO_H
#include "mbtk_type.h"
#include "mbtk_gnss.h"

#define GNSS_ID_6228 "6228"
#define GNSS_ID_5311 "5311"
#define GNSS_ID_8122 "8122"
#define GNSS_ID_N50DB "N50DB"

#define GNSS_SET_SYSCFG_GPS (1)
#define GNSS_SET_SYSCFG_BDS (1<<1)
#define GNSS_SET_SYSCFG_GLO (1<<2)
#define GNSS_SET_SYSCFG_GAL (1<<3)
#define GNSS_SET_SYSCFG_QZSS (1<<4)
#define GNSS_SET_SYSCFG_SBAS (1<<5)

#define GNSS_SET_FREQCFG_1  (1)
#define GNSS_SET_FREQCFG_2  (2)
#define GNSS_SET_FREQCFG_5  (5)
#define GNSS_SET_FREQCFG_10 (10)

#define GNSS_SET_EVEL_5 (5)
#define GNSS_SET_EVEL_15 (15)

#define GNSS_SET_NMEAVER_3_01 (0)
#define GNSS_SET_NMEAVER_4_00 (1)
#define GNSS_SET_NMEAVER_4_10 (2)

#define GNSS_SET_MSGCFG_RMC (1)
#define GNSS_SET_MSGCFG_VTG (1<<1)
#define GNSS_SET_MSGCFG_GGA (1<<2)
#define GNSS_SET_MSGCFG_GSA (1<<3)
#define GNSS_SET_MSGCFG_GSV (1<<4)
#define GNSS_SET_MSGCFG_GLL (1<<5)
#define GNSS_SET_MSGCFG_ZDA (1<<6)
#define GNSS_SET_MSGCFG_GST (1<<7)
#define GNSS_SET_MSGCFG_GRS (1<<8)
#define GNSS_SET_MSGCFG_TXT (1<<9)
#define GNSS_SET_MSGCFG_DHV (1<<10)
#define GNSS_SET_MSGCFG_DTM (1<<11)
#define GNSS_SET_MSGCFG_NAVPOS (1<<12)
#define GNSS_SET_MSGCFG_NAVVEL (1<<13)
#define GNSS_SET_MSGCFG_NAVTIME (1<<14)
#define GNSS_SET_MSGCFG_NAVACC (1<<15)
#define GNSS_SET_MSGCFG_LSF (1<<16)
#define GNSS_SET_MSGCFG_ANTSTAT (1<<17)
#define GNSS_SET_MSGCFG_ANTSTAT1 (1<<18)
#define GNSS_SET_MSGCFG_NOTICE (1<<19)
#define GNSS_SET_MSGCFG_ABNORMAL (1<<20)
#define GNSS_SET_MSGCFG_EPHABNORMAL (1<<21)

#define GNSS_AGPS_LEN_MAX 128

typedef enum {
    GNSS_RESET_TYPE_HOT = 1,
    GNSS_RESET_TYPE_WARM,
    GNSS_RESET_TYPE_COLD
} gnss_reset_type_enum;

typedef enum {
    GNSS_MEMAVER_TYPE_3_0 = 0,
    GNSS_MEMAVER_TYPE_4_0,
    GNSS_MEMAVER_TYPE_4_1
} gnss_memaver_type_enum;

typedef int (*gnss_dev_open_func)();
typedef int (*gnss_dev_close_func)(int fd);
typedef int (*gnss_open_func)(const char *dev);
typedef int (*gnss_close_func)(int fd);
typedef int (*gnss_init_set_func)(int fd);
typedef int (*gnss_fw_dl_func)(int fd, const char *fw_name, const char *dev);
typedef void (*gnss_dl_read_cb_func)(const void *data, int data_len);
typedef gnss_err_enum (*gnss_set_func)(int fd, const char *cmd, void *cmd_rsp, int cmd_rsp_len);
typedef void (*gnss_set_cb_func)(const void *data, int data_len);
typedef gnss_err_enum (*gnss_agnss_get_eph_func)(const char *param);
typedef gnss_err_enum (*gnss_agnss_inject_func)(int fd);

typedef enum {
    GNSS_TYPE_6228 = 0,
    GNSS_TYPE_5311,
    GNSS_TYPE_8122,
    GNSS_TYPE_N50DB
} gnss_id_enum;

typedef enum {
    GNSS_EPH_GPS = 0,
    GNSS_EPH_BDS,
    GNSS_EPH_GLO,
    GNSS_EPH_GPS_BDS,
    GNSS_EPH_GPS_GLO,

    GNSS_EPH_CFG = 10, //get eph data by cfg parameters
} gnss_eph_data_enum;

typedef enum {
    GNSS_STATE_CLOSE,       // GNSS is closed.
    GNSS_STATE_CLOSING,       // GNSS is closing.
    GNSS_STATE_OPEN,        // GNSS is opened.
    GNSS_STATE_DOWNLOAD,    // GNSS is downloading.
    GNSS_STATE_READY,       // GNSS is ready.
} gnss_state_enum;

typedef struct
{
    char host[GNSS_AGPS_LEN_MAX];
    char id[GNSS_AGPS_LEN_MAX];
    char passwd[GNSS_AGPS_LEN_MAX];
}gnss_agps_info_t;

typedef struct {
    int cli_fd;
    uint32 ind_flag;
} gnss_ind_info_t;

typedef struct {
    gnss_id_enum gnss_id;
    char dev_name[32];
    bool auto_open;        // Should auto open gnss?
    bool auto_dl_fw;       // Should download firmware int the first?
    bool dl_befor_open;    // Should download firmware before open device?
    int fd;                // GNSS uart fd.
    int exit_fd[2];        // Use to exit thread.
    gnss_state_enum state;
    uint32 print_port;
    pthread_t read_pid;     // Read NMEA thread.

    // GNSS functions.
    gnss_dev_open_func gnss_dev_open;
    gnss_dev_close_func gnss_dev_close;
    gnss_open_func gnss_open;
    gnss_close_func gnss_close;
    gnss_init_set_func gnss_init_set;
    gnss_fw_dl_func gnss_fw_dl;
    gnss_dl_read_cb_func gnss_dl_read_cb;
    gnss_set_func gnss_set;
    gnss_set_cb_func gnss_set_cb;
    gnss_agnss_get_eph_func gnss_agnss_get_eph;
    gnss_agnss_inject_func  gnss_agnss_inject;
} gnss_info_t;

int gnss_init(uint32 print_port);

int gnss_deinit();

int gnss_set(const void* buf, unsigned int buf_len, void *cmd_rsp, int cmd_rsp_len);

int gnss_dl_fw(const char* fw_name, void *rsp, int rsp_len);

int gnss_agnss_get_ept(const void* param);

int gnss_agnss_inject(void);

int gnss_ind_set(int fd, int ind_type);

#endif /* _GNSS_INFO_H */
